/*
 * Decompiled with CFR 0.152.
 */
package com.noblemaster.lib.base.gui.swing.image;

import com.noblemaster.lib.base.gui.swing.image.c;
import com.noblemaster.lib.base.gui.swing.image.k;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class ImageConverter {
    private ImageConverter() {
    }

    public static byte[] a(Image image) {
        try {
            return k.a(image, true);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    public static byte[] b(Image image) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        try {
            int[] nArray = new int[n2 * n3];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n2, n3, nArray, 0, n2);
            pixelGrabber.grabPixels();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeShort(n2);
            objectOutputStream.writeShort(n3);
            objectOutputStream.writeObject(nArray);
            objectOutputStream.flush();
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new IOException("Error storing image in object: " + exception);
        }
    }

    public static Image a(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            short s2 = objectInputStream.readShort();
            short s3 = objectInputStream.readShort();
            int[] nArray = (int[])objectInputStream.readObject();
            objectInputStream.close();
            MemoryImageSource memoryImageSource = new MemoryImageSource(s2, s3, nArray, 0, s2);
            return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"file:C:\\temp\\Download\\toast.9.png", "C:\\temp\\Download\\toast.9.txt"};
        }
        Image image = c.a(stringArray[0]);
        byte[] byArray = ImageConverter.b(image);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1], false);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 % 8 == 0) {
                dataOutputStream.writeBytes("\n");
            }
            dataOutputStream.writeBytes("(byte)0x");
            String string = Integer.toHexString(byArray[i2]);
            if (string.length() == 1) {
                string = "0" + string;
            } else if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            }
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeBytes(", ");
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("Output has been generated.");
    }
}

