//
//  XLDWavpackOutputTask.h
//  XLDWavpackOutput
//
//  Created by tmkk on 08/05/20.
//  Copyright 2008 tmkk. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XLDOutputTask.h"
#import <wavpack/wavpack.h>
#import "md5_global.h"
#import "md5.h"

#define XLD_METADATA_TITLE		@"Title"
#define XLD_METADATA_ARTIST		@"Artist"
#define XLD_METADATA_ALBUM		@"Album"
#define XLD_METADATA_GENRE		@"Genre"
#define XLD_METADATA_TRACK		@"Track"
#define XLD_METADATA_DISC		@"Disc"
#define XLD_METADATA_YEAR		@"Year"
#define XLD_METADATA_DATE		@"Date"
#define XLD_METADATA_COMPOSER	@"Composer"
#define XLD_METADATA_CUESHEET	@"Cuesheet"
#define XLD_METADATA_COMMENT	@"Comment"
#define XLD_METADATA_TOTALTRACKS	@"Totaltracks"
#define XLD_METADATA_TOTALDISCS	@"Totaldiscs"
#define XLD_METADATA_LYRICS		@"Lyrics"
#define XLD_METADATA_ISRC		@"ISRC"
#define XLD_METADATA_COVER		@"Cover"
#define XLD_METADATA_ALBUMARTIST	@"AlbumArtist"

typedef struct
{
	FILE *fp;
	int initial_frame_size;
	char *path;
} fileID;

@interface XLDWavpackOutputTask : NSObject <XLDOutputTask> {
	WavpackContext *wpc;
	id delegate;
	BOOL addTag;
	BOOL tagAdded;
	XLDFormat format;
	fileID *fpwv;
	fileID *fpwvc;
	int *internalBuffer;
	int internalBufferSize;
	MD5_CTX context;
}

- (BOOL)setOutputFormat:(XLDFormat)fmt;
- (BOOL)openFileForOutput:(NSString *)str withTrackData:(id)track;
- (NSString *)extensionStr;
- (BOOL)writeBuffer:(int *)buffer frames:(int)counts;
- (void)finalize;
- (void)closeFile;
- (void)setEnableAddTag:(BOOL)flag;
- (id)initWithDelegate:(id)del;
@end
