//
//  XLDVorbisOutputTask.m
//  XLDVorbisOutput
//
//  Created by tmkk on 06/09/08.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDVorbisOutputTask.h"
#import "XLDVorbisOutput.h"

typedef int64_t xldoffset_t;

#import "XLDTrack.h"

@implementation XLDVorbisOutputTask

- (id)init
{
	[super init];
	eos = 0;
	fp = NULL;
	delegate = nil;
	return self;
}

- (id)initWithDelegate:(id)del
{
	[self init];
	delegate = [del retain];
	return self;
}

- (void)dealloc
{
	if(fp) fclose(fp);
	if(delegate) [delegate release];
	[super dealloc];
}

- (BOOL)setOutputFormat:(XLDFormat)fmt
{
	format = fmt;
	
	if(format.bps > 4) return NO;
	vorbis_info_init(&vi);
	int ret = vorbis_encode_init_vbr(&vi,format.channels,format.samplerate,[(XLDVorbisOutput *)delegate quality]);
	vorbis_info_clear(&vi);
	if(ret){
		return NO;
	}
	
	return YES;
}

- (BOOL)openFileForOutput:(NSString *)str withTrackData:(id)track
{
	int i;
	fp = fopen([str UTF8String], "wb");
	if(!fp) {
		return NO;
	}
	vorbis_info_init(&vi);
	int ret = vorbis_encode_init_vbr(&vi,format.channels,format.samplerate,[(XLDVorbisOutput *)delegate quality]);
	if(ret){
		return NO;
	}
	
	vorbis_comment_init(&vc);
	vorbis_comment_add_tag(&vc,"ENCODER","XLD Vorbis output");
	if(addTag) {
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE]) {
			vorbis_comment_add_tag(&vc,"TITLE",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST]) {
			vorbis_comment_add_tag(&vc,"ARTIST",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM]) {
			vorbis_comment_add_tag(&vc,"ALBUM",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST]) {
			vorbis_comment_add_tag(&vc,"ALBUMARTIST",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE]) {
			vorbis_comment_add_tag(&vc,"GENRE",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER]) {
			vorbis_comment_add_tag(&vc,"COMPOSER",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK]) {
			vorbis_comment_add_tag(&vc,"TRACKNUMBER",(char *)[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS]) {
			vorbis_comment_add_tag(&vc,"TRACKTOTAL",(char *)[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC]) {
			vorbis_comment_add_tag(&vc,"DISCNUMBER",(char *)[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS]) {
			vorbis_comment_add_tag(&vc,"DISCTOTAL",(char *)[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE]) {
			vorbis_comment_add_tag(&vc,"DATE",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE] UTF8String]);
		}
		else if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR]) {
			vorbis_comment_add_tag(&vc,"DATE",(char *)[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT]) {
			vorbis_comment_add_tag(&vc,"COMMENT",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ISRC]) {
			vorbis_comment_add_tag(&vc,"ISRC",(char *)[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ISRC] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION]) {
			vorbis_comment_add_tag(&vc,"COMPILATION",(char *)[[NSString stringWithFormat:@"%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION] intValue]] UTF8String]);
		}
		NSArray *keyArr = [[(XLDTrack *)track metadata] allKeys];
		for(i=[keyArr count]-1;i>=0;i--) {
			NSString *key = [keyArr objectAtIndex:i];
			NSRange range = [key rangeOfString:@"XLD_UNKNOWN_TEXT_METADATA_"];
			if(range.location != 0) continue;
			const char *idx = [[key substringFromIndex:range.length] UTF8String];
			const char *dat = [[[(XLDTrack *)track metadata] objectForKey:key] UTF8String];
			vorbis_comment_add_tag(&vc,(char *)idx,(char *)dat);
		}
	}
	vorbis_analysis_init(&vd,&vi);
	vorbis_block_init(&vd,&vb);
	ogg_stream_init(&os,rand());
	
	ogg_packet header;
	ogg_packet header_comm;
	ogg_packet header_code;
	
	vorbis_analysis_headerout(&vd,&vc,&header,&header_comm,&header_code);
	ogg_stream_packetin(&os,&header);
	ogg_stream_packetin(&os,&header_comm);
	ogg_stream_packetin(&os,&header_code);
	
	while(1){
		int result=ogg_stream_flush(&os,&og);
		if(result==0) break;
		fwrite(og.header,1,og.header_len,fp);
		fwrite(og.body,1,og.body_len,fp);
	}
	
	return YES;
}

- (NSString *)extensionStr
{
	return @"ogg";
}

- (BOOL)writeBuffer:(int *)buffer frames:(int)counts
{
	if(eos) return NO;
	float **buffer_converted;
	int i,j,k;
	buffer_converted = vorbis_analysis_buffer(&vd,counts);
	for(i=0,k=0;i<counts;i++){
		for(j=0;j<format.channels;j++) {
			switch(format.bps) {
				case 1:
					buffer_converted[j][i] = (buffer[k++] >> 24)/128.0f;
					break;
				case 2:
					buffer_converted[j][i] = (buffer[k++] >> 16)/32768.0f;
					break;
				case 3:
					buffer_converted[j][i] = (buffer[k++] >> 8)/16777216.0f;
					break;
				case 4:
					if(format.isFloat) buffer_converted[j][i] = *((float *)buffer+(k++));
					else buffer_converted[j][i] = buffer[k++]/2147483648.0f;
					break;
			}
		}
	}
	vorbis_analysis_wrote(&vd,counts);
	
	while(vorbis_analysis_blockout(&vd,&vb)==1){
		vorbis_analysis(&vb,NULL);
		vorbis_bitrate_addblock(&vb);
		while(vorbis_bitrate_flushpacket(&vd,&op)){
			ogg_stream_packetin(&os,&op);
			while(!eos){
				int result=ogg_stream_pageout(&os,&og);
				if(result==0)break;
				fwrite(og.header,1,og.header_len,fp);
				fwrite(og.body,1,og.body_len,fp);
				if(ogg_page_eos(&og))eos=1;
			}
		}
	}
	return YES;
}

- (void)finalize
{
	vorbis_analysis_wrote(&vd,0);
	while(vorbis_analysis_blockout(&vd,&vb)==1){
		vorbis_analysis(&vb,NULL);
		vorbis_bitrate_addblock(&vb);
		while(vorbis_bitrate_flushpacket(&vd,&op)){
			ogg_stream_packetin(&os,&op);
			while(!eos){
				int result=ogg_stream_pageout(&os,&og);
				if(result==0)break;
				fwrite(og.header,1,og.header_len,fp);
				fwrite(og.body,1,og.body_len,fp);
				if(ogg_page_eos(&og))eos=1;
			}
		}
	}
	
	ogg_stream_clear(&os);
	vorbis_block_clear(&vb);
	vorbis_dsp_clear(&vd);
	vorbis_comment_clear(&vc);
	vorbis_info_clear(&vi);
}

- (void)closeFile
{
	if(fp) fclose(fp);
	fp = NULL;
	eos = 0;
}

- (void)setEnableAddTag:(BOOL)flag
{
	addTag = flag;
}

@end
