//
//  XLDVorbisOutput.m
//  XLDVorbisOutput
//
//  Created by tmkk on 06/06/12.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDVorbisOutput.h"
#import "XLDVorbisOutputTask.h"
#import <time.h>

@implementation XLDVorbisOutput

+ (NSString *)pluginName
{
	return @"Ogg Vorbis";
}

+ (BOOL)canLoadThisBundle
{
	if (floor(NSAppKitVersionNumber) <= 620 ) {
		return NO;
	}
	else return YES;
}

- (id)init
{
	[super init];
	srand(time(NULL));
	[NSBundle loadNibNamed:@"XLDVorbisOutput" owner:self];
	return self;
}

- (NSView *)prefPane
{
	return o_prefView;
}

- (void)savePrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	[pref setFloat:[o_qValue floatValue] forKey:@"XLDVorbisOutput_Quality"];
	[pref synchronize];
}

- (void)loadPrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	id obj;
	if(obj=[pref objectForKey:@"XLDVorbisOutput_Quality"]) {
		[o_qValue setFloatValue:[obj floatValue]];
		[o_qValue sendAction:[o_qValue action] to:[o_qValue target]];
	}
}

- (id)createTaskForOutput
{
	return [[XLDVorbisOutputTask alloc] initWithDelegate:self];
}

- (float)quality
{
	return [o_qValue floatValue]/10.0f;
}

@end
