//
//  XLDLameOutputTask.m
//  XLDLameOutput
//
//  Created by tmkk on 06/09/08.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDLameOutputTask.h"
#import "XLDLameOutput.h"

typedef int64_t xldoffset_t;

#import "XLDTrack.h"

void swap_utf16(unsigned short *str)
{
	if(*str == 0xfffe) return;
	while(*str != 0) {
		*str = ((*str >> 8) & 0xff) | (*str << 8);
		str++;
	}
}

@implementation XLDLameOutputTask

- (id)init
{
	[super init];
	
	fp = NULL;
	lameflag = NULL;
	delegate = nil;
	return self;
}

- (id)initWithDelegate:(id)del
{
	[self init];
	delegate = [del retain];
	return self;
}

- (void)dealloc
{
	if(fp) fclose(fp);
	if(lameflag) lame_close(lameflag);
	if(delegate) [delegate release];
	[super dealloc];
}

- (BOOL)setOutputFormat:(XLDFormat)fmt
{
	format = fmt;
	
	if(format.bps > 4) return NO;
	if(format.channels > 2) return NO;
	
	return YES;
}

- (BOOL)openFileForOutput:(NSString *)str withTrackData:(id)track
{
	char *buffer;
	unsigned short desc[2];
	desc[0] = 0xfeff;
	desc[1] = 0;
	fp = fopen([str UTF8String],"w+b");
	if(!fp) return NO;
	
	lameflag = lame_init();
	if(!lameflag) return NO;
	
	lame_set_in_samplerate(lameflag, format.samplerate);
	lame_set_out_samplerate(lameflag,[delegate sampleRate]);
	lame_set_num_channels(lameflag, format.channels);
	if([delegate appendTLEN]) {
		if([track frames] != -1) lame_set_num_samples(lameflag,[track frames]);
		else lame_set_num_samples(lameflag,format.samplerate*[track seconds]);
	}
	int lame_quality = [(XLDLameOutput *)delegate quality];
				
	lame_set_quality(lameflag, lame_quality);
	lame_set_findReplayGain(lameflag, [(XLDLameOutput *)delegate useReplayGain]);
	
	if([(XLDLameOutput *)delegate encodeMode] == 0) {
		lame_set_VBR(lameflag, ([(XLDLameOutput *)delegate vbrMethod] == 0) ? vbr_mtrh : vbr_rh);
		lame_set_VBR_quality(lameflag,[(XLDLameOutput *)delegate vbrQuality]);
	}
	else if([(XLDLameOutput *)delegate encodeMode] == 2) {
		int bitrate = [(XLDLameOutput *)delegate bitrate];
		lame_set_brate(lameflag,bitrate);
	}
	else {
		if([(XLDLameOutput *)delegate abrBitrate] > 320) {
			lame_set_free_format(lameflag,1);
			lame_set_brate(lameflag,[(XLDLameOutput *)delegate abrBitrate]);
		}
		else {
			lame_set_VBR(lameflag, vbr_abr);
			lame_set_VBR_mean_bitrate_kbps(lameflag, [(XLDLameOutput *)delegate abrBitrate]);
		}
	}
	
	if(format.channels == 2 && [(XLDLameOutput *)delegate stereoMode] != XLDLameAutoStereoMode) {
		if([(XLDLameOutput *)delegate stereoMode] == XLDLameJointStereoMode)
			lame_set_mode(lameflag, 1);
		else if([(XLDLameOutput *)delegate stereoMode] == XLDLameSimpleStereoMode)
			lame_set_mode(lameflag, 0);
		else if([(XLDLameOutput *)delegate stereoMode] == XLDLameMonoStereoMode)
			lame_set_mode(lameflag, 3);
	}
	
	if(addTag) {
		id3tag_init(lameflag);
		id3tag_v2_only(lameflag);
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_textinfo_ucs2(lameflag,"TIT2",(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_textinfo_ucs2(lameflag,"TPE1",(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_textinfo_ucs2(lameflag,"TALB",(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE]) {
			//id3tag_set_genre(lameflag,[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE] UTF8String]);
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_textinfo_ucs2(lameflag,"TCON",(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_textinfo_ucs2(lameflag,"TCOM",(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK]) {
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS])
				id3tag_set_track(lameflag,[[NSString stringWithFormat:@"%d/%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] intValue],[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS] intValue]] UTF8String]);
			else
				id3tag_set_track(lameflag,[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC]) {
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS])
				id3tag_set_fieldvalue(lameflag,[[NSString stringWithFormat:@"TPOS=%d/%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] intValue],[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS] intValue]] UTF8String]);
			else
				id3tag_set_fieldvalue(lameflag,[[NSString stringWithFormat:@"TPOS=%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] intValue]] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR]) {
			id3tag_set_year(lameflag,[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_comment_ucs2(lameflag,"eng",desc,(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_textinfo_ucs2(lameflag,"TPE2",(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION]) {
			if([[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION] boolValue])
			   id3tag_set_fieldvalue(lameflag,"TCMP=1");
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer = (char *)malloc([dat length]+10);
			[dat getBytes:buffer];
			buffer[[dat length]] = 0;
			buffer[[dat length]+1] = 0;
			swap_utf16((unsigned short*)buffer);
			id3tag_set_textinfo_ucs2(lameflag,"TIT1",(unsigned short *)buffer);
			free(buffer);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ISRC]) {
			id3tag_set_fieldvalue(lameflag,[[NSString stringWithFormat:@"TSRC=%@",[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ISRC]] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER]) {
			NSData *imgDat = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER];
			id3tag_set_albumart(lameflag, [imgDat bytes], [imgDat length]);
		}
	}
	
	int ret = lame_init_params(lameflag);
	if(ret < 0) return NO;
	
	return YES;
}

- (NSString *)extensionStr
{
	return @"mp3";
}

- (BOOL)writeBuffer:(int *)buffer frames:(int)counts
{
	int sizeof_buffer = 1.25*counts*2 + 7200 + 1024*1024;
	unsigned char *mp3buffer = (unsigned char *)malloc(sizeof_buffer);
	int *buffer_l = (int *)malloc(counts*4+3);
	int *buffer_r = (int *)malloc(counts*4+3);
	int i;
	
	if(format.isFloat) {
		for(i=0;i<counts*format.channels;i++) {
			*((float *)buffer+i) *= 32768.0f;
		}
	}
	
	if(format.channels == 1) {
		memcpy(buffer_l,buffer,counts*4);
	}
	else {
		for(i=0;i<counts;i++) {
			buffer_l[i] = buffer[i*2];
			buffer_r[i] = buffer[i*2+1];
		}
	}
	
	int ret;
	if(format.isFloat) ret = lame_encode_buffer_float(lameflag,(float *)buffer_l,(float *)buffer_r,counts,mp3buffer,sizeof_buffer);
	else ret = lame_encode_buffer_int(lameflag,buffer_l,buffer_r,counts,mp3buffer,sizeof_buffer);
	
	if(ret < 0) {
		free(mp3buffer);
		free(buffer_l);
		free(buffer_r);
		return NO;
	}
	
	fwrite(mp3buffer,1,ret,fp);
	
	free(mp3buffer);
	free(buffer_l);
	free(buffer_r);
	
	return YES;
}

- (void)finalize
{
	unsigned char *mp3buffer = (unsigned char *)malloc(10000);
	int ret = lame_encode_flush(lameflag,mp3buffer,10000);
	
	fwrite(mp3buffer,1,ret,fp);
	lame_mp3_tags_fid(lameflag,fp);
	
	free(mp3buffer);
}

- (void)closeFile
{
	if(fp) fclose(fp);
	fp = NULL;
	if(lameflag) lame_close(lameflag);
	lameflag = NULL;
}

- (void)setEnableAddTag:(BOOL)flag
{
	addTag = flag;
}

@end
