//
//  XLDLameOutput.m
//  XLDLameOutput
//
//  Created by tmkk on 06/06/13.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDLameOutput.h"
#import "XLDLameOutputTask.h"

@implementation XLDLameOutput

+ (NSString *)pluginName
{
	return @"LAME MP3";
}

+ (BOOL)canLoadThisBundle
{
	if (floor(NSAppKitVersionNumber) <= 620 ) {
		return NO;
	}
	else return YES;
}

- (id)init
{
	[super init];
	[NSBundle loadNibNamed:@"XLDLameOutput" owner:self];
	
	[o_bitrate addItemWithTitle:@"16 kbps"];
	[o_bitrate addItemWithTitle:@"24 kbps"];
	[o_bitrate addItemWithTitle:@"32 kbps"];
	[o_bitrate addItemWithTitle:@"40 kbps"];
	[o_bitrate addItemWithTitle:@"48 kbps"];
	[o_bitrate addItemWithTitle:@"64 kbps"];
	[o_bitrate addItemWithTitle:@"80 kbps"];
	[o_bitrate addItemWithTitle:@"96 kbps"];
	[o_bitrate addItemWithTitle:@"112 kbps"];
	[o_bitrate addItemWithTitle:@"128 kbps"];
	[o_bitrate addItemWithTitle:@"160 kbps"];
	[o_bitrate addItemWithTitle:@"192 kbps"];
	[o_bitrate addItemWithTitle:@"224 kbps"];
	[o_bitrate addItemWithTitle:@"256 kbps"];
	[o_bitrate addItemWithTitle:@"320 kbps"];
	
	[o_bitrate selectItemAtIndex:10];
	
	return self;
}

- (NSView *)prefPane
{
	return o_prefPane;
}

- (void)savePrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	[pref setInteger:[o_bitrate indexOfSelectedItem] forKey:@"XLDLameOutput_Bitrate"];
	[pref setInteger:[o_quality indexOfSelectedItem] forKey:@"XLDLameOutput_Quality2"];
	[pref setInteger:[o_abrBitrate intValue] forKey:@"XLDLameOutput_ABRBitrate"];
	[pref setFloat:[o_vbrQuality floatValue] forKey:@"XLDLameOutput_VBRQuality_Float"];
	[pref setInteger:[o_vbrMethod indexOfSelectedItem] forKey:@"XLDLameOutput_VBRMethod"];
	[pref setInteger:[o_replayGain state] forKey:@"XLDLameOutput_ReplayGain"];
	[pref setInteger:[o_mode indexOfSelectedItem]  forKey:@"XLDLameOutput_EncodeMode"];
	[pref setInteger:[o_stereoMode indexOfSelectedItem] forKey:@"XLDLameOutput_StereoMode"];
	[pref setInteger:[o_sampleRate indexOfSelectedItem] forKey:@"XLDLameOutput_SampleRate"];
	[pref setInteger:[o_appendTLEN state] forKey:@"XLDLameOutput_AppendTLEN"];
	[pref synchronize];
}

- (void)loadPrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	id obj;
	if(obj=[pref objectForKey:@"XLDLameOutput_Bitrate"]) {
		if([obj intValue] < [o_bitrate numberOfItems]) [o_bitrate selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_Quality2"]) {
		if([obj intValue] < [o_quality numberOfItems]) [o_quality selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_ABRBitrate"]) {
		[o_abrBitrate setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_VBRQuality_Float"]) {
		[o_vbrQuality setDoubleValue:[obj floatValue]];
		[o_vbrQuality performClick:nil];
	}
	else if(obj=[pref objectForKey:@"XLDLameOutput_VBRQuality"]) {
		[o_vbrQuality setIntValue:[obj intValue]+1];
		[o_vbrQuality performClick:nil];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_VBRMethod"]) {
		if([obj intValue] < [o_vbrMethod numberOfItems]) [o_vbrMethod selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_ReplayGain"]) {
		[o_replayGain setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_EncodeMode"]) {
		if([obj intValue] < [o_mode numberOfItems]) [o_mode selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_StereoMode"]) {
		if([obj intValue] < [o_stereoMode numberOfItems]) [o_stereoMode selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_SampleRate"]) {
		if([obj intValue] < [o_sampleRate numberOfItems]) [o_sampleRate selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDLameOutput_AppendTLEN"]) {
		[o_appendTLEN setState:[obj intValue]];
	}
	[self modeChanged:nil];
}

- (id)createTaskForOutput
{
	return [[XLDLameOutputTask alloc] initWithDelegate:self];
}

- (int)quality
{
	switch([o_quality indexOfSelectedItem]) {
		case 0:
			return 2;
		case 1:
			return 3;
		case 2:
			return 5;
		case 3:
			return 7;
	}
	
	return 3;
}

- (float)vbrQuality
{
	return ([[o_vbrQualityValue stringValue] floatValue]) > 9.999f ? 9.999f : [[o_vbrQualityValue stringValue] floatValue];
}

- (int)bitrate
{
	return [[[[o_bitrate titleOfSelectedItem] componentsSeparatedByString:@" "] objectAtIndex:0] intValue];
}

- (int)abrBitrate
{
	return [o_abrBitrate intValue];
}

- (int)useReplayGain
{
	return ([o_replayGain state] == NSOnState) ? 1 : 0;
}

- (int)encodeMode
{
	return [o_mode indexOfSelectedItem];
}

- (int)vbrMethod
{
	return [o_vbrMethod indexOfSelectedItem];
}

- (XLDLameStereoMode)stereoMode
{
	return [[o_stereoMode selectedItem] tag];
}

- (int)sampleRate
{
	return [[o_sampleRate selectedItem] tag];
}

- (IBAction)setVbrQuality:(id)sender
{
	[o_vbrQualityValue setDoubleValue:10.0-[o_vbrQuality floatValue]];
	//NSLog(@"%f",[[o_vbrQualityValue stringValue] floatValue]);
}

- (IBAction)modeChanged:(id)sender
{
	int i;
	id abrBox = [o_abrBitrate superview];
	id cbrBox = [o_bitrate superview];
	id vbrBox = [o_vbrMethod superview];
	switch([o_mode indexOfSelectedItem]) {
		case 0:
			for(i=0;i<[[abrBox subviews] count];i++) {
				id subview = [[abrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:NO];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor lightGrayColor]];
				[o_abrBitrate setTextColor:[NSColor blackColor]];
			}
			for(i=0;i<[[cbrBox subviews] count];i++) {
				id subview = [[cbrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:NO];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor lightGrayColor]];
			}
			for(i=0;i<[[vbrBox subviews] count];i++) {
				id subview = [[vbrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:YES];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor blackColor]];
			}
			break;
		case 1:
			for(i=0;i<[[abrBox subviews] count];i++) {
				id subview = [[abrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:YES];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor blackColor]];
			}
			for(i=0;i<[[cbrBox subviews] count];i++) {
				id subview = [[cbrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:NO];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor lightGrayColor]];
			}
			for(i=0;i<[[vbrBox subviews] count];i++) {
				id subview = [[vbrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:NO];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor lightGrayColor]];
			}
			break;
		case 2:
			for(i=0;i<[[abrBox subviews] count];i++) {
				id subview = [[abrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:NO];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor lightGrayColor]];
				[o_abrBitrate setTextColor:[NSColor blackColor]];
			}
			for(i=0;i<[[cbrBox subviews] count];i++) {
				id subview = [[cbrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:YES];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor blackColor]];
			}
			for(i=0;i<[[vbrBox subviews] count];i++) {
				id subview = [[vbrBox subviews] objectAtIndex:i];
				if([subview respondsToSelector:@selector(setEnabled:)])
					[subview setEnabled:NO];
				if([subview respondsToSelector:@selector(setTextColor:)])
					[subview setTextColor:[NSColor lightGrayColor]];
			}
			break;
	}
}

- (BOOL)appendTLEN
{
	return ([o_appendTLEN state] == NSOnState);
}

@end
