//
//  XLDHEAACOutputTask.m
//  XLDHEAACOutput
//
//  Created by tmkk on 08/03/04.
//  Copyright 2008 tmkk. All rights reserved.
//

#import "XLDHEAACOutputTask.h"
#import "XLDHEAACOutput.h"

typedef int64_t xldoffset_t;

#import "XLDTrack.h"
#import <sys/stat.h>
#import <unistd.h>
#import <sys/types.h>

#ifdef _BIG_ENDIAN
#define SWAP32(n) (n)
#define SWAP16(n) (n)
#else
#define SWAP32(n) (((n>>24)&0xff) | ((n>>8)&0xff00) | ((n<<8)&0xff0000) | ((n<<24)&0xff000000))
#define SWAP16(n) (((n>>8)&0xff) | ((n<<8)&0xff00))
#endif

@implementation XLDHEAACOutputTask

- (id)init
{
	[super init];
	task = nil;
	delegate = nil;
	addTag = NO;
	tagData = [[NSMutableData alloc] init];
	path = nil;
	return self;
}

- (id)initWithDelegate:(id)del
{
	[self init];
	delegate = [del retain];
	return self;
}

- (void)dealloc
{
	if(delegate) [delegate release];
	if(task) [task release];
	if(path) [path release];
	[tagData release];
	[super dealloc];
}

- (BOOL)setOutputFormat:(XLDFormat)fmt
{
	if(fmt.isFloat) return NO;
	if(fmt.samplerate != 44100 && fmt.samplerate != 48000) return NO;
	
	if(fmt.channels > 2) return NO;
	if(fmt.channels == 1 && [delegate bitrate] > 44) return NO;
	
	format = fmt;
	return YES;
}

- (BOOL)openFileForOutput:(NSString *)str withTrackData:(id)track
{
	task = [[NSTask alloc] init];
	[task setStandardInput:[NSPipe pipe]];
	[task setLaunchPath:[[NSBundle bundleForClass:[self class]] pathForResource:@"aacplusenc" ofType:nil inDirectory:nil]];
	[task setCurrentDirectoryPath:[str stringByDeletingLastPathComponent]];
	NSMutableArray *args = [NSMutableArray arrayWithObjects:@"-",str,[NSString stringWithFormat:@"%d",[delegate bitrate]],@"--raw",[NSString stringWithFormat:@"%d",format.samplerate],[NSString stringWithFormat:@"%d",format.channels],[NSString stringWithFormat:@"%d",format.bps<<3],nil];
	[task setArguments:args];
	
	path = [str retain];
	
	if(addTag) {
		BOOL added = NO;
		int tmp;
		short tmp2;
		char atomID[4];
		
		/* udta atom */
		tmp = 0;
		memcpy(atomID,"udta",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		
		/* meta atom */
		tmp = 0;
		memcpy(atomID,"meta",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		[tagData appendBytes:&tmp length:4];
		
		/* hdlr atom */
		tmp = 0x22;
		tmp = SWAP32(tmp);
		memcpy(atomID,"hdlr",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		tmp = 0;
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:&tmp length:4];
		memcpy(atomID,"mdir",4);
		[tagData appendBytes:atomID length:4];
		memcpy(atomID,"appl",4);
		[tagData appendBytes:atomID length:4];
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:&tmp length:4];
		tmp2 = 0;
		tmp2 = SWAP16(tmp2);
		[tagData appendBytes:&tmp2 length:2];
		
		/* ilst atom */
		tmp = 0;
		memcpy(atomID,"ilst",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		
		/* nam atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"nam",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* ART atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"ART",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* aART atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"aART",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* alb atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"alb",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* gen atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"gen",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* wrt atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"wrt",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* trkn atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] || [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS]) {
			added = YES;
			tmp = 0x20;
			tmp = SWAP32(tmp);
			memcpy(atomID,"trkn",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0x18;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:&tmp length:4];
			tmp2 = 0;
			[tagData appendBytes:&tmp2 length:2];
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
			tmp2 = 0;
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
			tmp2 = 0;
			[tagData appendBytes:&tmp2 length:2];
		}
		
		/* disk atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] || [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS]) {
			added = YES;
			tmp = 0x1E;
			tmp = SWAP32(tmp);
			memcpy(atomID,"disk",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0x16;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:&tmp length:4];
			tmp2 = 0;
			[tagData appendBytes:&tmp2 length:2];
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
			tmp2 = 0;
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
		}
		
		/* day atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"day",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		else if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR]) {
			added = YES;
			NSString *str = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR] stringValue];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"day",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* cmt atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT];
			//NSString *str = @"Track 1";
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"cmt",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* lyr atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_LYRICS]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_LYRICS];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"lyr",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* cpil atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION]) {
			if([[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION] boolValue]) {
				added = YES;
				tmp = 0x19;
				tmp = SWAP32(tmp);
				memcpy(atomID,"cpil",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				tmp = 0x11;
				tmp = SWAP32(tmp);
				memcpy(atomID,"data",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				tmp = 0x15;
				tmp = SWAP32(tmp);
				[tagData appendBytes:&tmp length:4];
				tmp = 0;
				[tagData appendBytes:&tmp length:4];
				char tmp3 = 1;
				[tagData appendBytes:&tmp3 length:1];
			}
		}
		
		/* grp atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"grp",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* covr atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER]) {
			added = YES;
			NSData *imgData = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER];
			tmp = [imgData length]+24;
			tmp = SWAP32(tmp);
			memcpy(atomID,"covr",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = [imgData length]+16;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0xd;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendData:imgData];
		}
		
		/* version strings */
		long version;
		OSErr result;
		result = Gestalt(gestaltQuickTime,&version);
		if (result == noErr)
		{
			added = YES;
			NSString *str = @"X Lossless Decoder, aacplusenc 0.16.3";
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"too",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		if(added) {
			int freeSize = 0x800;
			/* update length of udta atom */
			tmp = [tagData length] + freeSize;
			tmp = SWAP32(tmp);
			[tagData replaceBytesInRange:NSMakeRange(0,4) withBytes:&tmp];
			
			/* update length of meta atom */
			tmp = [tagData length] - 8 + freeSize;
			tmp = SWAP32(tmp);
			[tagData replaceBytesInRange:NSMakeRange(8,4) withBytes:&tmp];
			
			/* update length of ilst atom */
			tmp = [tagData length] - 54;
			tmp = SWAP32(tmp);
			[tagData replaceBytesInRange:NSMakeRange(54,4) withBytes:&tmp];
			
			/* add free atom */
			if(freeSize) {
				tmp = freeSize;
				tmp = SWAP32(tmp);
				memcpy(atomID,"free",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				[tagData increaseLengthBy:freeSize-8];
			}
		}
		else [tagData setLength:0];
	}
	
	[task launch];
	
	return YES;
}

- (NSString *)extensionStr
{
	if([delegate useMP4]) return @"m4a";
	else return @"aac";
}

- (BOOL)writeBuffer:(int *)buffer frames:(int)counts
{
	if(![task isRunning]) return NO;
	[[[task standardInput] fileHandleForWriting] writeData:[NSData dataWithBytes:buffer length:counts*4*format.channels]];
	
	return YES;
}

- (void)finalize
{
	[[[task standardInput] fileHandleForWriting] closeFile];
	/*while([task isRunning]) {
		usleep(10000);
	}*/
	[task waitUntilExit];
	
	if(addTag && [tagData length]) {
		int tmp;
		int udatSize = [tagData length];
		int origSize;
		char atom[4];
		struct stat stbuf;
		
		stat([path UTF8String], &stbuf);
		origSize = stbuf.st_size;
		
		FILE *fp = fopen([path UTF8String], "r+b");
		if(!fp) return;
		int bufferSize = 1024*1024;
		char *tmpbuf = (char *)malloc(bufferSize);
		char *tmpbuf2 = (char *)malloc(bufferSize);
		char *read = tmpbuf;
		char *write = tmpbuf2;
		char *swap;
		BOOL moov_after_mdat = NO;
		
		while(1) { //skip until moov;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"moov",4)) break;
			if(!memcmp(atom,"mdat",4)) moov_after_mdat = YES;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		if(fseeko(fp,-8,SEEK_CUR) != 0) goto end;
		
		/* update moov atom size */
		if(fread(&tmp,4,1,fp) < 1) goto end;
		int moovSize = SWAP32(tmp);
		if(fseeko(fp,-4,SEEK_CUR) != 0) goto end;
		tmp = moovSize + udatSize;
		tmp = SWAP32(tmp);
		if(fwrite(&tmp,4,1,fp) < 1) goto end;
		
		off_t pos_moov = ftello(fp);
		
		if(fseeko(fp,4,SEEK_CUR) != 0) goto end;
		
		while(1) { //skip until trak;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"trak",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		if(moov_after_mdat) {
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
			goto beginWrite;
		}
		
		while(1) { //skip until mdia;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"mdia",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		while(1) { //skip until minf;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"minf",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		while(1) { //skip until stbl;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"stbl",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		while(1) { //skip until stco;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"stco",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		int *stco = (int *)malloc(tmp-8);
		if(fread(stco,1,tmp-8,fp) < tmp-8) goto end;
		int nElement = SWAP32(stco[1]);
		
		/* update stco atom */
		
		int i;
		for(i=0;i<nElement;i++) {
			stco[2+i] = SWAP32(SWAP32(stco[2+i])+udatSize);
		}
		if(fseeko(fp,8-tmp,SEEK_CUR) != 0) goto end;
		if(fwrite(stco,1,tmp-8,fp) < tmp-8) goto end;
		
		free(stco);
		
		/* write tags */
beginWrite:
		if(fseeko(fp,pos_moov,SEEK_SET) != 0) goto end;
		if(fseeko(fp,moovSize-4,SEEK_CUR) != 0) goto end;
		off_t pos_tag = ftello(fp);
		
		
		//if(fseek(fp,0-udatSize,SEEK_END) != 0) goto end;
		
		int bytesToMove = origSize-pos_tag;
		if(bytesToMove == 0) goto write;
		
		if(bytesToMove < udatSize) {
			if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
			if(fwrite(read,1,udatSize-bytesToMove,fp) < udatSize-bytesToMove) goto end;
			if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
		}
		else if(bytesToMove > bufferSize) {
			if(bufferSize < udatSize) {
				tmpbuf = (char *)realloc(tmpbuf,udatSize);
				tmpbuf2 = (char *)realloc(tmpbuf2,udatSize);
				read = tmpbuf;
				write = tmpbuf2;
				bufferSize = udatSize;
				if(bytesToMove <= bufferSize) goto moveBlock_is_smaller_than_buffer;
			}
			if(fread(write,1,bufferSize,fp) < bufferSize) goto end;
			bytesToMove -= bufferSize;
			while(bytesToMove > bufferSize) {
				if(fread(read,1,bufferSize,fp) < bufferSize) goto end;
				if(fseeko(fp,udatSize-2*bufferSize,SEEK_CUR) != 0) goto end;
				if(fwrite(write,1,bufferSize,fp) < bufferSize) goto end;
				if(fseeko(fp,bufferSize-udatSize,SEEK_CUR) != 0) goto end;
				swap = read;
				read = write;
				write = swap;
				bytesToMove -= bufferSize;
			}
			if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
			if(fseeko(fp,udatSize-bufferSize-bytesToMove,SEEK_CUR) != 0) goto end;
			if(fwrite(write,1,bufferSize,fp) < bufferSize) goto end;
			if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
		}
		else {
moveBlock_is_smaller_than_buffer:
			if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
			if(udatSize < bytesToMove) {
				if(fseeko(fp,udatSize-bytesToMove,SEEK_CUR) != 0) goto end;
			}
			else {
				if(fseeko(fp,0-bytesToMove,SEEK_CUR) != 0) goto end;
				if(fwrite([tagData bytes],1,udatSize,fp) < udatSize) goto end;
			}
			if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
		}
		
		if(fseeko(fp,pos_tag,SEEK_SET) != 0) goto end;
write:
		if(fwrite([tagData bytes],1,udatSize,fp) < udatSize) goto end;
		
end:
		free(tmpbuf);
		free(tmpbuf2);
		fclose(fp);
	}
}

- (void)closeFile
{
	if(task) [task release];
	task = nil;
	if(path) [path release];
	path = nil;
	[tagData setLength:0];
}

- (void)setEnableAddTag:(BOOL)flag
{
	if(![delegate useMP4]) addTag = NO;
	else addTag = flag;
}

@end
