//
//  XLDHEAACOutput.m
//  XLDHEAACOutput
//
//  Created by tmkk on 08/03/04.
//  Copyright 2008 tmkk. All rights reserved.
//

#import "XLDHEAACOutput.h"
#import "XLDHEAACOutputTask.h"

@implementation XLDHEAACOutput

+ (NSString *)pluginName
{
	return @"MPEG-4 HE-AAC";
}

+ (BOOL)canLoadThisBundle
{
	return YES;
}

- (id)init
{
	[super init];
	[NSBundle loadNibNamed:@"XLDHEAACOutput" owner:self];
	return self;
}

- (NSView *)prefPane
{
	return o_prefView;
}

- (void)savePrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	[pref setInteger:[o_bitrate intValue] forKey:@"XLDHEAACOutput_BitRate"];
	[pref setInteger:[o_useMP4 state] forKey:@"XLDHEAACOutput_UseMP4"];
	[pref synchronize];
}

- (void)loadPrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	id obj;
	if(obj=[pref objectForKey:@"XLDHEAACOutput_BitRate"]) {
		[o_bitrate setIntValue:[obj intValue]];
		[o_bitrate performClick:nil];
	}
	if(obj=[pref objectForKey:@"XLDHEAACOutput_UseMP4"]) {
		[o_useMP4 setState:[obj intValue]];
	}
}

- (id)createTaskForOutput
{
	return [[XLDHEAACOutputTask alloc] initWithDelegate:self];
}

- (int)bitrate
{
	return [o_bitrate intValue];
}

- (BOOL)useMP4
{
	return [o_useMP4 state] == NSOnState ? YES : NO;
}

@end
