//
//  XLDLameOutputTask.m
//  XLDLameOutput
//
//  Created by tmkk on 06/09/08.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDLameOutputTask.h"
#import "XLDLameOutput.h"
#import "XLDTrack.h"

@implementation XLDLameOutputTask

- (id)init
{
	[super init];
	
	fp = NULL;
	lameflag = NULL;
	delegate = nil;
	buffer4 = NULL;
	
	return self;
}

- (id)initWithDelegate:(id)del
{
	[self init];
	delegate = [del retain];
	return self;
}

- (void)dealloc
{
	if(fp) fclose(fp);
	if(lameflag) lame_close(lameflag);
	if(delegate) [delegate release];
	if(buffer4) free(buffer4);
	[super dealloc];
}

- (BOOL)setOutputFormat:(XLDFormat)fmt
{
	format = fmt;
	
	if(format.bps > 4) return NO;
	if(format.channels > 2) return NO;
	
	return YES;
}

- (BOOL)openFileForOutput:(NSString *)str withTrackData:(id)track
{
	
	fp = fopen([str UTF8String],"w+b");
	if(!fp) return NO;
	
	lameflag = lame_init();
	if(!lameflag) return NO;
	
	lame_set_in_samplerate(lameflag, format.samplerate);
	lame_set_num_channels(lameflag, format.channels);
	int lame_quality = [(XLDLameOutput *)delegate quality];
				
	lame_set_quality(lameflag, lame_quality);
	lame_set_findReplayGain(lameflag, [(XLDLameOutput *)delegate useReplayGain]);
	
	if([(XLDLameOutput *)delegate encodeMode] == 0) {
		lame_set_VBR(lameflag, ([(XLDLameOutput *)delegate vbrMethod] == 0) ? vbr_mtrh : vbr_rh);
		lame_set_VBR_q(lameflag,[(XLDLameOutput *)delegate vbrQuality]);
	}
	else if([(XLDLameOutput *)delegate encodeMode] == 2) {
		int bitrate = [(XLDLameOutput *)delegate bitrate];
		lame_set_brate(lameflag,bitrate);
	}
	else {
		lame_set_VBR(lameflag, vbr_abr);
		lame_set_VBR_mean_bitrate_kbps(lameflag, [(XLDLameOutput *)delegate abrBitrate]);
	}
	
	if(addTag) {
		id3tag_init(lameflag);
		id3tag_v2_only(lameflag);
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE] dataUsingEncoding:NSUnicodeStringEncoding];
			[dat getBytes:buffer1];
			buffer1[[dat length]] = 0;
			buffer1[[dat length]+1] = 0;
			id3tag_set_title(lameflag,buffer1);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST] dataUsingEncoding:NSUnicodeStringEncoding];
			[dat getBytes:buffer2];
			buffer2[[dat length]] = 0;
			buffer2[[dat length]+1] = 0;
			id3tag_set_artist(lameflag,buffer2);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM] dataUsingEncoding:NSUnicodeStringEncoding];
			[dat getBytes:buffer3];
			buffer3[[dat length]] = 0;
			buffer3[[dat length]+1] = 0;
			id3tag_set_album(lameflag,buffer3);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE]) {
			id3tag_set_genre(lameflag,[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK]) {
			id3tag_set_track(lameflag,[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR]) {
			id3tag_set_year(lameflag,[[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR] stringValue] UTF8String]);
		}
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT]) {
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT] dataUsingEncoding:NSUnicodeStringEncoding];
			buffer4 = (char *)malloc([dat length]+10);
			[dat getBytes:buffer4];
			buffer4[[dat length]] = 0;
			buffer4[[dat length]+1] = 0;
			id3tag_set_comment(lameflag,buffer4);
		}
	}
	
	int ret = lame_init_params(lameflag);
	if(ret < 0) return NO;
	
	return YES;
}

- (NSString *)extensionStr
{
	return @"mp3";
}

- (BOOL)writeBuffer:(int *)buffer frames:(int)counts
{
	int sizeof_buffer = 1.25*counts*2 + 7200;
	unsigned char *mp3buffer = (unsigned char *)malloc(sizeof_buffer);
	int *buffer_l = (int *)malloc(counts*4+3);
	int *buffer_r = (int *)malloc(counts*4+3);
	int i;
	
	if(format.isFloat) {
		for(i=0;i<counts*format.channels;i++) {
			*((float *)buffer+i) *= 32768.0f;
		}
	}
	
	if(format.channels == 1) {
		memcpy(buffer_l,buffer,counts*4);
	}
	else {
		for(i=0;i<counts;i++) {
			buffer_l[i] = buffer[i*2];
			buffer_r[i] = buffer[i*2+1];
		}
	}
	
	int ret;
	if(format.isFloat) ret = lame_encode_buffer_float(lameflag,(float *)buffer_l,(float *)buffer_r,counts,mp3buffer,sizeof_buffer);
	else ret = lame_encode_buffer_int(lameflag,buffer_l,buffer_r,counts,mp3buffer,sizeof_buffer);
	
	if(ret < 0) {
		free(mp3buffer);
		free(buffer_l);
		free(buffer_r);
		return NO;
	}
	
	fwrite(mp3buffer,1,ret,fp);
	
	free(mp3buffer);
	free(buffer_l);
	free(buffer_r);
	
	return YES;
}

- (void)finalize
{
	unsigned char *mp3buffer = (unsigned char *)malloc(10000);
	int ret = lame_encode_flush(lameflag,mp3buffer,10000);
	
	fwrite(mp3buffer,1,ret,fp);
	lame_mp3_tags_fid(lameflag,fp);
	
	free(mp3buffer);
}

- (void)closeFile
{
	if(fp) fclose(fp);
	fp = NULL;
	if(lameflag) lame_close(lameflag);
	if(buffer4) free(buffer4);
	buffer4 = NULL;
	lameflag = NULL;
}

- (void)setEnableAddTag:(BOOL)flag
{
	addTag = flag;
}

@end
