//
//  XLDFlacOutput.m
//  XLDFlacOutput
//
//  Created by tmkk on 06/09/15.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDFlacOutput.h"
#import "XLDFlacOutputTask.h"

@implementation XLDFlacOutput

+ (NSString *)pluginName
{
	return @"FLAC";
}

+ (BOOL)canLoadThisBundle
{
	if (floor(NSAppKitVersionNumber) <= 620 ) {
		return NO;
	}
	else return YES;
}

- (id)init
{
	[super init];
	[NSBundle loadNibNamed:@"XLDFlacOutput" owner:self];
	srand(time(NULL));
	return self;
}

- (NSView *)prefPane
{
	return o_prefView;
}

- (void)savePrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	[pref setInteger:[o_compressionLevel intValue] forKey:@"XLDFlacOutput_CompressionLevel"];
	[pref setInteger:[o_oggFlacCheckBox state] forKey:@"XLDFlacOutput_OggFLAC"];
	[pref setInteger:[o_padding intValue] forKey:@"XLDFlacOutput_Padding"];
	[pref setInteger:[o_allowEmbeddedCuesheet intValue] forKey:@"XLDFlacOutput_AllowEmbeddedCueSheet"];
	[pref setInteger:[o_setOggS intValue] forKey:@"XLDFlacOutput_SetOggS"];
	[pref synchronize];
}

- (void)loadPrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	id obj;
	if(obj=[pref objectForKey:@"XLDFlacOutput_CompressionLevel"]) {
		[o_compressionLevel setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDFlacOutput_OggFLAC"]) {
		[o_oggFlacCheckBox setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDFlacOutput_Padding"]) {
		[o_padding setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDFlacOutput_AllowEmbeddedCueSheet"]) {
		[o_allowEmbeddedCuesheet setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDFlacOutput_SetOggS"]) {
		[o_setOggS setIntValue:[obj intValue]];
	}
}

- (id)createTaskForOutput
{
	return [[XLDFlacOutputTask alloc] initWithDelegate:self];
}

- (int)compressionLevel
{
	return [o_compressionLevel intValue];
}

- (BOOL)oggFlac
{
	return [o_oggFlacCheckBox state] == NSOnState ? YES : NO;
}

- (int)padding
{
	if([o_padding intValue] < 1) return 1;
	return [o_padding intValue];
}

- (BOOL)allowEmbeddedCuesheet
{
	return ([o_allowEmbeddedCuesheet state] == NSOnState);
}

- (BOOL)setOggS
{
	return ([o_setOggS state] == NSOnState);
}

@end
