//
//  XLDAlacOutputTask.m
//  XLDAlacOutput
//
//  Created by tmkk on 06/09/08.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDAlacOutputTask.h"
#import "XLDAlacOutput.h"

typedef int64_t xldoffset_t;

#import "XLDTrack.h"
#import <sys/stat.h>
#import <unistd.h>
#import <sys/types.h>

#ifdef _BIG_ENDIAN
#define SWAP32(n) (n)
#define SWAP16(n) (n)
#else
#define SWAP32(n) (((n>>24)&0xff) | ((n>>8)&0xff00) | ((n<<8)&0xff0000) | ((n<<24)&0xff000000))
#define SWAP16(n) (((n>>8)&0xff) | ((n<<8)&0xff00))
#endif

int updateM4aFileInfo(FILE *fp)
{
	char atom[4];
	int tmp;
	off_t initPos = ftello(fp);
	int freq;
	short bits;
	char chan;
	
	if(fseeko(fp,0,SEEK_SET) != 0) goto end;
	
	while(1) { //skip until moov;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"moov",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until trak;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"trak",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until mdia;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"mdia",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until minf;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"minf",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until stbl;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"stbl",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until alac;
		if(fread(atom,1,4,fp) < 4) goto end;
		if(!memcmp(atom,"alac",4)) break;
		if(fseeko(fp,-3,SEEK_CUR) != 0) goto end;
	}
	
	off_t alacPos = ftello(fp);
	
	if(fseeko(fp,0x1c,SEEK_CUR) != 0) goto end;
	if(fread(&tmp,4,1,fp) < 1) goto end;
	tmp = SWAP32(tmp);
	if(tmp != 0x24) goto end;
	if(fread(atom,1,4,fp) < 4) goto end;
	if(memcmp(atom,"alac",4)) goto end;
	
	if(fseeko(fp,8,SEEK_CUR) != 0) goto end;
	if(fread(&bits,2,1,fp) < 1) goto end;
	if(fseeko(fp,3,SEEK_CUR) != 0) goto end;
	if(fread(&chan,1,1,fp) < 1) goto end;
	if(fseeko(fp,10,SEEK_CUR) != 0) goto end;
	if(fread(&freq,4,1,fp) < 1) goto end;
	
	if(fseeko(fp,alacPos+17,SEEK_SET) != 0) goto end;
	if(fwrite(&chan,1,1,fp) < 1) goto end;
	if(fwrite(&bits,2,1,fp) < 1) goto end;
	if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
	if(fwrite(&freq,4,1,fp) < 1) goto end;
	
end:
		fseeko(fp,initPos,SEEK_SET);
	return freq;
}

@implementation XLDAlacOutputTask

- (id)init
{
	[super init];
	file = NULL;
	addTag = NO;
	tagData = [[NSMutableData alloc] init];
	path = nil;
	encodebuf = malloc(8192*4*2);
	encodebufSize = 8192*4*2;
	return self;
}

- (id)initWithDelegate:(id)del
{
	[self init];
	delegate = [del retain];
	return self;
}

- (void)dealloc
{
	if(path) [path release];
	if(file) ExtAudioFileDispose(file);
	free(encodebuf);
	[tagData release];
	[super dealloc];
}

- (BOOL)setOutputFormat:(XLDFormat)fmt
{
	format = fmt;
	
	if(format.bps < 2 || format.bps > 4) return NO;
	if(format.isFloat) return NO;
	
	inputFormat.mSampleRate = (Float64)format.samplerate;
	inputFormat.mFormatID = kAudioFormatLinearPCM;
	
#ifdef _BIG_ENDIAN
	inputFormat.mFormatFlags = kAudioFormatFlagIsSignedInteger|kAudioFormatFlagIsBigEndian|kAudioFormatFlagIsPacked;
#else
	inputFormat.mFormatFlags = kAudioFormatFlagIsSignedInteger|kAudioFormatFlagIsPacked;
#endif
	inputFormat.mFramesPerPacket = 1;
	inputFormat.mBytesPerFrame = format.bps * format.channels;
	inputFormat.mBytesPerPacket = inputFormat.mBytesPerFrame;
	inputFormat.mChannelsPerFrame =  format.channels;
	inputFormat.mBitsPerChannel = format.bps*8;
	
	memset(&outputFormat,0,sizeof(AudioStreamBasicDescription));
	
	outputFormat.mFormatID = kAudioFormatAppleLossless;
	switch(format.bps) {
		case 2:
			outputFormat.mFormatFlags = 1;
			break;
		case 3:
			outputFormat.mFormatFlags = 3;
			break;
		case 4:
			outputFormat.mFormatFlags = 4;
			break;
	}
	outputFormat.mBitsPerChannel = format.bps*8;
	if([delegate samplerate])
		outputFormat.mSampleRate = [delegate samplerate];
	else
		outputFormat.mSampleRate = format.samplerate;
	outputFormat.mChannelsPerFrame = format.channels;
	return YES;
}

- (BOOL)openFileForOutput:(NSString *)str withTrackData:(id)track
{
	FSRef dirFSRef;
	FSPathMakeRef((UInt8 *)[[str stringByDeletingLastPathComponent] UTF8String] ,&dirFSRef,NULL);
	
	if([[NSFileManager defaultManager] fileExistsAtPath:str]) {
		if(![[NSFileManager defaultManager] removeFileAtPath:str handler:nil]) return NO;
	}
	
	if(ExtAudioFileCreateNew(&dirFSRef, (CFStringRef)[str lastPathComponent], kAudioFileM4AType, &outputFormat, NULL, &file) != noErr)
	{
		file = NULL;
		return NO;
	}
	
	if(ExtAudioFileSetProperty(file, kExtAudioFileProperty_ClientDataFormat, sizeof(AudioStreamBasicDescription), &inputFormat) != noErr) {
		ExtAudioFileDispose(file);
		file = NULL;
		return NO;
	}
	
	
	path = [str retain];
	
	if(addTag) {
		BOOL added = NO;
		int tmp;
		short tmp2;
		char atomID[4];
		
		/* udta atom */
		tmp = 0;
		memcpy(atomID,"udta",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		
		/* meta atom */
		tmp = 0;
		memcpy(atomID,"meta",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		[tagData appendBytes:&tmp length:4];
		
		/* hdlr atom */
		tmp = 0x22;
		tmp = SWAP32(tmp);
		memcpy(atomID,"hdlr",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		tmp = 0;
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:&tmp length:4];
		memcpy(atomID,"mdir",4);
		[tagData appendBytes:atomID length:4];
		memcpy(atomID,"appl",4);
		[tagData appendBytes:atomID length:4];
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:&tmp length:4];
		tmp2 = 0;
		tmp2 = SWAP16(tmp2);
		[tagData appendBytes:&tmp2 length:2];
		
		/* ilst atom */
		tmp = 0;
		memcpy(atomID,"ilst",4);
		[tagData appendBytes:&tmp length:4];
		[tagData appendBytes:atomID length:4];
		
		/* nam atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"nam",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* ART atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"ART",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* aART atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"aART",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* alb atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"alb",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* gen atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"gen",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* wrt atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"wrt",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* trkn atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] || [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS]) {
			added = YES;
			tmp = 0x20;
			tmp = SWAP32(tmp);
			memcpy(atomID,"trkn",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0x18;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:&tmp length:4];
			tmp2 = 0;
			[tagData appendBytes:&tmp2 length:2];
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
			tmp2 = 0;
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
			tmp2 = 0;
			[tagData appendBytes:&tmp2 length:2];
		}
		
		/* disk atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] || [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS]) {
			added = YES;
			tmp = 0x1E;
			tmp = SWAP32(tmp);
			memcpy(atomID,"disk",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0x16;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:&tmp length:4];
			tmp2 = 0;
			[tagData appendBytes:&tmp2 length:2];
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
			tmp2 = 0;
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS]) {
				tmp2 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS] shortValue];
				tmp2 = SWAP16(tmp2);
			}
			[tagData appendBytes:&tmp2 length:2];
		}
		
		/* day atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"day",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		else if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR]) {
			added = YES;
			NSString *str = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR] stringValue];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"day",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* cmt atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT];
			//NSString *str = @"Track 1";
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"cmt",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* lyr atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_LYRICS]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_LYRICS];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"lyr",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* cpil atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION]) {
			if([[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION] boolValue]) {
				added = YES;
				tmp = 0x19;
				tmp = SWAP32(tmp);
				memcpy(atomID,"cpil",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				tmp = 0x11;
				tmp = SWAP32(tmp);
				memcpy(atomID,"data",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				tmp = 0x15;
				tmp = SWAP32(tmp);
				[tagData appendBytes:&tmp length:4];
				tmp = 0;
				[tagData appendBytes:&tmp length:4];
				char tmp3 = 1;
				[tagData appendBytes:&tmp3 length:1];
			}
		}
		
		/* grp atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"grp",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* Gracenote CDDB information */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GRACENOTE]) {
			added = YES;
			NSData *cddbData = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GRACENOTE] dataUsingEncoding:NSUTF8StringEncoding];
			tmp = 0x4F + [cddbData length];
			tmp = SWAP32(tmp);
			memcpy(atomID,"----",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0x1C;
			tmp = SWAP32(tmp);
			memcpy(atomID,"mean",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:"com.apple.iTunes" length:16];
			tmp = 0x1B;
			tmp = SWAP32(tmp);
			memcpy(atomID,"name",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:"iTunes_CDDB_IDs" length:15];
			tmp = [cddbData length] + 0x10;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendData:cddbData];
		}
		
		/* tmpo atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_BPM]) {
			added = YES;
			tmp = 0x1A;
			tmp = SWAP32(tmp);
			memcpy(atomID,"tmpo",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0x12;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 0x15;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			unsigned short tmp3 = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_BPM] unsignedShortValue];
			[tagData appendBytes:&tmp3 length:2];
		}
		
		/* cprt atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COPYRIGHT]) {
			added = YES;
			NSString *str = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COPYRIGHT];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"cprt",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		/* pgap atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GAPLESSALBUM]) {
			if([[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GAPLESSALBUM] boolValue]) {
				added = YES;
				tmp = 0x19;
				tmp = SWAP32(tmp);
				memcpy(atomID,"pgap",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				tmp = 0x11;
				tmp = SWAP32(tmp);
				memcpy(atomID,"data",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				tmp = 0x15;
				tmp = SWAP32(tmp);
				[tagData appendBytes:&tmp length:4];
				tmp = 0;
				[tagData appendBytes:&tmp length:4];
				char tmp3 = 1;
				[tagData appendBytes:&tmp3 length:1];
			}
		}
		
		/* covr atom */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER]) {
			added = YES;
			NSData *imgData = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER];
			tmp = [imgData length]+24;
			tmp = SWAP32(tmp);
			memcpy(atomID,"covr",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = [imgData length]+16;
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			if([imgData length] >= 8 && 0 == memcmp([imgData bytes], "\x89PNG\x0d\x0a\x1a\x0a", 8))
				tmp = 0xe;
			else if([imgData length] >= 2 && 0 == memcmp([imgData bytes], "BM", 2))
				tmp = 0x1b;
			else if([imgData length] >= 3 && 0 == memcmp([imgData bytes], "GIF", 3))
				tmp = 0xc;
			else tmp = 0xd;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendData:imgData];
		}
		
		/* version strings */
		long version;
		OSErr result;
		result = Gestalt(gestaltQuickTime,&version);
		if (result == noErr)
		{
			added = YES;
			NSString *str = [NSString stringWithFormat:@"X Lossless Decoder %@, QuickTime %d.%d.%d",[[NSBundle mainBundle] objectForInfoDictionaryKey: @"CFBundleShortVersionString"],(version>>24)&0xF,(version>>20)&0xF,(version>>16)&0xF];
			tmp = 24 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			atomID[0] = 0xa9;
			memcpy(atomID+1,"too",3);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 16 + strlen([str UTF8String]);
			tmp = SWAP32(tmp);
			memcpy(atomID,"data",4);
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:atomID length:4];
			tmp = 1;
			tmp = SWAP32(tmp);
			[tagData appendBytes:&tmp length:4];
			tmp = 0;
			[tagData appendBytes:&tmp length:4];
			[tagData appendBytes:[str UTF8String] length:strlen([str UTF8String])];
		}
		
		if(added) {
			int freeSize = 0x800;
			/* update length of udta atom */
			tmp = [tagData length] + freeSize;
			tmp = SWAP32(tmp);
			[tagData replaceBytesInRange:NSMakeRange(0,4) withBytes:&tmp];
			
			/* update length of meta atom */
			tmp = [tagData length] - 8 + freeSize;
			tmp = SWAP32(tmp);
			[tagData replaceBytesInRange:NSMakeRange(8,4) withBytes:&tmp];
			
			/* update length of ilst atom */
			tmp = [tagData length] - 54;
			tmp = SWAP32(tmp);
			[tagData replaceBytesInRange:NSMakeRange(54,4) withBytes:&tmp];
			
			/* add free atom */
			if(freeSize) {
				tmp = freeSize;
				tmp = SWAP32(tmp);
				memcpy(atomID,"free",4);
				[tagData appendBytes:&tmp length:4];
				[tagData appendBytes:atomID length:4];
				[tagData increaseLengthBy:freeSize-8];
			}
		}
		else [tagData setLength:0];
	}
			
	
	return YES;
}

- (NSString *)extensionStr
{
	return @"m4a";
}

- (BOOL)writeBuffer:(int *)buffer frames:(int)counts
{
	fillBufList.mNumberBuffers = 1;
	fillBufList.mBuffers[0].mNumberChannels = format.channels;
	fillBufList.mBuffers[0].mDataByteSize = counts*format.bps*format.channels;
	
	if(format.bps != 4 && encodebufSize < fillBufList.mBuffers[0].mDataByteSize) {
		encodebuf = realloc(encodebuf,fillBufList.mBuffers[0].mDataByteSize);
		encodebufSize = fillBufList.mBuffers[0].mDataByteSize;
	}
	
	fillBufList.mBuffers[0].mData = encodebuf;
	
	int i;
	switch(format.bps) {
		case 2:
			for(i=0;i<counts*format.channels;i++) {
				*((short *)encodebuf+i) = *(buffer+i) >> 16;
			}
			break;
		case 3:
#ifdef _BIG_ENDIAN
			for(i=0;i<counts*format.channels;i++) {
				*((char *)encodebuf+i*3) = *((char *)buffer+i*4);
				*((char *)encodebuf+i*3+1) = *((char *)buffer+i*4+1);
				*((char *)encodebuf+i*3+2) = *((char *)buffer+i*4+2);
			}
#else
			for(i=0;i<counts*format.channels;i++) {
				*((char *)encodebuf+i*3) = *((char *)buffer+i*4+1);
				*((char *)encodebuf+i*3+1) = *((char *)buffer+i*4+2);
				*((char *)encodebuf+i*3+2) = *((char *)buffer+i*4+3);
			}
#endif
			break;
		case 4:
			fillBufList.mBuffers[0].mData = buffer;
	}
	
	if(ExtAudioFileWrite(file, counts, &fillBufList) != noErr) {
		return NO;
	}
	
	return YES;
}

- (void)optimizeAtoms
{
	int tmp;
	int moovSize;
	off_t origSize;
	char atom[4];
	struct stat stbuf;
	
	stat([path UTF8String], &stbuf);
	origSize = stbuf.st_size;
	
	FILE *fp = fopen([path UTF8String], "r+b");
	if(!fp) return;
	
	updateM4aFileInfo(fp);
	
	int bufferSize = 1024*1024;
	char *tmpbuf = (char *)malloc(bufferSize);
	char *tmpbuf2 = (char *)malloc(bufferSize);
	char *read = tmpbuf;
	char *write = tmpbuf2;
	char *swap;
	char *moovbuf = NULL;
	int i;
	BOOL moov_after_mdat = NO;
	
	while(1) { //skip until moov;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"moov",4)) break;
		if(!memcmp(atom,"mdat",4)) moov_after_mdat = YES;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	if(!moov_after_mdat) goto end;
	
	off_t pos_moov = ftello(fp) - 8;
	moovSize = origSize - pos_moov;
	
	while(1) { //skip until trak;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"trak",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until mdia;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"mdia",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until minf;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"minf",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until stbl;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"stbl",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until stco;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"stco",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	int *stco = (int *)malloc(tmp-8);
	if(fread(stco,1,tmp-8,fp) < tmp-8) goto end;
	int nElement = SWAP32(stco[1]);
	
	/* update stco atom */
	
	for(i=0;i<nElement;i++) {
		stco[2+i] = SWAP32(SWAP32(stco[2+i])+moovSize);
	}
	if(fseeko(fp,8-tmp,SEEK_CUR) != 0) goto end;
	if(fwrite(stco,1,tmp-8,fp) < tmp-8) goto end;
	
	free(stco);
	
	rewind(fp);
	
	/* save moov atom */
	
	moovbuf = (char *)malloc(moovSize);
	if(fseeko(fp,pos_moov,SEEK_SET) != 0) goto end;
	if(fread(moovbuf,1,moovSize,fp) < moovSize) goto end;
	rewind(fp);
	
	while(1) { //skip until ftyp;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"ftyp",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	/* position after ftyp atom is the inserting point */
	if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	pos_moov = ftello(fp);
	
	/* optimize */
	
	long long bytesToMove = origSize-pos_moov-moovSize;
	
	if(bytesToMove < moovSize) {
		if(bufferSize < bytesToMove) {
			tmpbuf = (char *)realloc(tmpbuf,bytesToMove);
			read = tmpbuf;
		}
		if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
		if(fseeko(fp,moovSize-bytesToMove,SEEK_CUR) != 0) goto end;
		if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
	}
	else if(bytesToMove > bufferSize) {
		if(bufferSize < moovSize) {
			tmpbuf = (char *)realloc(tmpbuf,moovSize);
			tmpbuf2 = (char *)realloc(tmpbuf2,moovSize);
			read = tmpbuf;
			write = tmpbuf2;
			bufferSize = moovSize;
			if(bytesToMove <= bufferSize) goto moveBlock_is_smaller_than_buffer;
		}
		if(fread(write,1,bufferSize,fp) < bufferSize) goto end;
		bytesToMove -= bufferSize;
		while(bytesToMove > bufferSize) {
			if(fread(read,1,bufferSize,fp) < bufferSize) goto end;
			if(fseeko(fp,moovSize-2*bufferSize,SEEK_CUR) != 0) goto end;
			if(fwrite(write,1,bufferSize,fp) < bufferSize) goto end;
			if(fseeko(fp,bufferSize-moovSize,SEEK_CUR) != 0) goto end;
			swap = read;
			read = write;
			write = swap;
			bytesToMove -= bufferSize;
			//NSLog(@"DEBUG: %d bytes left",bytesToMove);
		}
		if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
		if(fseeko(fp,moovSize-bufferSize-bytesToMove,SEEK_CUR) != 0) goto end;
		if(fwrite(write,1,bufferSize,fp) < bufferSize) goto end;
		if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
	}
	else {
moveBlock_is_smaller_than_buffer:
		if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
		if(moovSize < bytesToMove) {
			if(fseeko(fp,moovSize-bytesToMove,SEEK_CUR) != 0) goto end;
		}
		else {
			if(fseeko(fp,0-bytesToMove,SEEK_CUR) != 0) goto end;
			if(fwrite(moovbuf,1,moovSize,fp) < moovSize) goto end;
		}
		if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
	}
	
	if(fseeko(fp,pos_moov,SEEK_SET) != 0) goto end;
	if(fwrite(moovbuf,1,moovSize,fp) < moovSize) goto end;
	
end:
	if(moovbuf) free(moovbuf);
	free(tmpbuf);
	free(tmpbuf2);
	fclose(fp);
}

- (void)finalize
{
	if(file) ExtAudioFileDispose(file);
	file = NULL;
	if(addTag && [tagData length]) {
		
		int tmp;
		int udatSize = [tagData length];
		off_t origSize;
		char atom[4];
		struct stat stbuf;
		
		stat([path UTF8String], &stbuf);
		origSize = stbuf.st_size;
		
		FILE *fp = fopen([path UTF8String], "r+b");
		if(!fp) return;
		int bufferSize = 1024*1024;
		char *tmpbuf = (char *)malloc(bufferSize);
		char *tmpbuf2 = (char *)malloc(bufferSize);
		char *read = tmpbuf;
		char *write = tmpbuf2;
		char *swap;
		BOOL moov_after_mdat = NO;
		
		while(1) { //skip until moov;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"moov",4)) break;
			if(!memcmp(atom,"mdat",4)) moov_after_mdat = YES;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		if(fseeko(fp,-8,SEEK_CUR) != 0) goto end;
		
		/* update moov atom size */
		if(fread(&tmp,4,1,fp) < 1) goto end;
		int moovSize = SWAP32(tmp);
		if(fseeko(fp,-4,SEEK_CUR) != 0) goto end;
		tmp = moovSize + udatSize;
		tmp = SWAP32(tmp);
		if(fwrite(&tmp,4,1,fp) < 1) goto end;
		
		off_t pos_moov = ftello(fp);
		
		if(fseeko(fp,4,SEEK_CUR) != 0) goto end;
		
		int rest = moovSize - 8;
		while(rest > 0) { //skip until udta; find existing udta
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"udta",4)) {
				if((udatSize >= tmp) && ((ftello(fp)+tmp-8) == (pos_moov+moovSize-4))) {
					if(fseeko(fp,-8,SEEK_CUR) != 0) goto end;
					if(fwrite([tagData bytes],1,tmp,fp) < tmp) goto end;
					[tagData replaceBytesInRange:NSMakeRange(0,tmp) withBytes:NULL length:0];
					udatSize = [tagData length];
					if(fseeko(fp,pos_moov-4,SEEK_SET) != 0) goto end;
					tmp = moovSize + udatSize;
					tmp = SWAP32(tmp);
					if(fwrite(&tmp,4,1,fp) < 1) goto end;
				}
				else {
					char tmp2 = 0;
					int i;
					if(fseeko(fp,-4,SEEK_CUR) != 0) goto end;
					if(fwrite("free",1,4,fp) < 4) goto end;
					for(i=0;i<tmp-8;i++) {
						if(fwrite(&tmp2,1,1,fp) < 1) goto end;
					}
				}
				break;
			}
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
			rest -= tmp;
		}
		
		if(fseeko(fp,pos_moov+4,SEEK_SET) != 0) goto end;
		
		if(moov_after_mdat) {
			goto beginWrite;
		}
		
		while(1) { //skip until trak;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"trak",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		while(1) { //skip until mdia;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"mdia",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		while(1) { //skip until minf;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"minf",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		while(1) { //skip until stbl;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"stbl",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		while(1) { //skip until stco;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			if(fread(atom,1,4,fp) < 4) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"stco",4)) break;
			if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
		}
		
		int *stco = (int *)malloc(tmp-8);
		if(fread(stco,1,tmp-8,fp) < tmp-8) goto end;
		int nElement = SWAP32(stco[1]);
		
		/* update stco atom */
		
		int i;
		for(i=0;i<nElement;i++) {
			stco[2+i] = SWAP32(SWAP32(stco[2+i])+udatSize);
		}
		if(fseeko(fp,8-tmp,SEEK_CUR) != 0) goto end;
		if(fwrite(stco,1,tmp-8,fp) < tmp-8) goto end;
		
		free(stco);
		
		/* write tags */
beginWrite:
		if(fseeko(fp,pos_moov,SEEK_SET) != 0) goto end;
		if(fseeko(fp,moovSize-4,SEEK_CUR) != 0) goto end;
		off_t pos_tag = ftello(fp);
		
		
		//if(fseek(fp,0-udatSize,SEEK_END) != 0) goto end;
		
		long long bytesToMove = origSize-pos_tag;
		if(bytesToMove == 0) goto write;
		
		if(bytesToMove < udatSize) {
			if(bufferSize < udatSize) {
				tmpbuf = (char *)realloc(tmpbuf,udatSize);
				read = tmpbuf;
			}
			if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
			if(fwrite(read,1,udatSize-bytesToMove,fp) < udatSize-bytesToMove) goto end;
			if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
		}
		else if(bytesToMove > bufferSize) {
			if(bufferSize < udatSize) {
				tmpbuf = (char *)realloc(tmpbuf,udatSize);
				tmpbuf2 = (char *)realloc(tmpbuf2,udatSize);
				read = tmpbuf;
				write = tmpbuf2;
				bufferSize = udatSize;
				if(bytesToMove <= bufferSize) goto moveBlock_is_smaller_than_buffer;
			}
			if(fread(write,1,bufferSize,fp) < bufferSize) goto end;
			bytesToMove -= bufferSize;
			while(bytesToMove > bufferSize) {
				if(fread(read,1,bufferSize,fp) < bufferSize) goto end;
				if(fseeko(fp,udatSize-2*bufferSize,SEEK_CUR) != 0) goto end;
				if(fwrite(write,1,bufferSize,fp) < bufferSize) goto end;
				if(fseeko(fp,bufferSize-udatSize,SEEK_CUR) != 0) goto end;
				swap = read;
				read = write;
				write = swap;
				bytesToMove -= bufferSize;
			}
			if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
			if(fseeko(fp,udatSize-bufferSize-bytesToMove,SEEK_CUR) != 0) goto end;
			if(fwrite(write,1,bufferSize,fp) < bufferSize) goto end;
			if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
		}
		else {
moveBlock_is_smaller_than_buffer:
			if(fread(read,1,bytesToMove,fp) < bytesToMove) goto end;
			if(udatSize < bytesToMove) {
				if(fseeko(fp,udatSize-bytesToMove,SEEK_CUR) != 0) goto end;
			}
			else {
				if(fseeko(fp,0-bytesToMove,SEEK_CUR) != 0) goto end;
				if(fwrite([tagData bytes],1,udatSize,fp) < udatSize) goto end;
			}
			if(fwrite(read,1,bytesToMove,fp) < bytesToMove) goto end;
		}
		
		if(fseeko(fp,pos_tag,SEEK_SET) != 0) goto end;
write:
		if(fwrite([tagData bytes],1,udatSize,fp) < udatSize) goto end;
		
end:
		free(tmpbuf);
		free(tmpbuf2);
		fclose(fp);
	}
	[self optimizeAtoms];
}

- (void)closeFile
{
	if(file) ExtAudioFileDispose(file);
	file = NULL;
	if(path) [path release];
	path = nil;
	[tagData setLength:0];
}

- (void)setEnableAddTag:(BOOL)flag
{
	addTag = flag;
}


@end
