//
//  XLDAlacOutput.m
//  XLDAlacOutput
//
//  Created by tmkk on 06/06/23.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDAlacOutput.h"
#import "XLDAlacOutputTask.h"

APPKIT_EXTERN const double NSAppKitVersionNumber;
#define NSAppKitVersionNumber10_0 577
#define NSAppKitVersionNumber10_1 620
#define NSAppKitVersionNumber10_2 663
#define NSAppKitVersionNumber10_3 743

@implementation XLDAlacOutput

+ (NSString *)pluginName
{
	return @"Apple Lossless";
}

+ (BOOL)canLoadThisBundle
{
	if (floor(NSAppKitVersionNumber) <= NSAppKitVersionNumber10_3 ) {
		return NO;
	}
	else return YES;
}

- (id)init
{
	[super init];
	[NSBundle loadNibNamed:@"XLDAlacOutput" owner:self];
	return self;
}

- (NSView *)prefPane
{
	return o_prefPane;
}

- (void)savePrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	[pref setInteger:[o_samplerate indexOfSelectedItem]  forKey:@"XLDAlacOutput_Samplerate"];
	[pref synchronize];
}

- (void)loadPrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	id obj;
	if(obj=[pref objectForKey:@"XLDAlacOutput_Samplerate"]) {
		if([obj intValue] < [o_samplerate numberOfItems]) [o_samplerate selectItemAtIndex:[obj intValue]];
	}
}

- (id)createTaskForOutput
{
	return [[XLDAlacOutputTask alloc] initWithDelegate:self];
}

- (int)samplerate
{
	return [[o_samplerate selectedItem] tag];
}

@end
