#import <Foundation/Foundation.h>
#import <CoreFoundation/CoreFoundation.h>
#import "XLDAlacDecoder.h"

#define XLD_METADATA_TITLE		@"Title"
#define XLD_METADATA_ARTIST		@"Artist"
#define XLD_METADATA_ALBUM		@"Album"
#define XLD_METADATA_GENRE		@"Genre"
#define XLD_METADATA_TRACK		@"Track"
#define XLD_METADATA_DISC		@"Disc"
#define XLD_METADATA_YEAR		@"Year"
#define XLD_METADATA_DATE		@"Date"
#define XLD_METADATA_COMPOSER	@"Composer"
#define XLD_METADATA_CUESHEET	@"Cuesheet"
#define XLD_METADATA_COMMENT	@"Comment"
#define XLD_METADATA_TOTALTRACKS	@"Totaltracks"
#define XLD_METADATA_TOTALDISCS	@"Totaldiscs"
#define XLD_METADATA_LYRICS		@"Lyrics"
#define XLD_METADATA_COVER		@"Cover"
#define XLD_METADATA_ALBUMARTIST	@"AlbumArtist"
#define XLD_METADATA_COMPILATION	@"Compilation"
#define XLD_METADATA_GROUP		@"Group"
#define XLD_METADATA_BPM		@"BPM"
#define XLD_METADATA_COPYRIGHT	@"Copyright"
#define XLD_METADATA_GAPLESSALBUM	@"GaplessAlbum"

#ifdef _BIG_ENDIAN
#define SWAP32(n) (n)
#define SWAP16(n) (n)
#else
#define SWAP32(n) (((n>>24)&0xff) | ((n>>8)&0xff00) | ((n<<8)&0xff0000) | ((n<<24)&0xff000000))
#define SWAP16(n) (((n>>8)&0xff) | ((n<<8)&0xff00))
#endif

static const char* ID3v1GenreList[] = {
    "Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk",
    "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies",
    "Other", "Pop", "R&B", "Rap", "Reggae", "Rock",
    "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks",
    "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk",
    "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House",
    "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass",
    "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock",
    "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk",
    "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta",
    "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret",
    "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi",
    "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical",
    "Rock & Roll", "Hard Rock", "Folk", "Folk/Rock", "National Folk", "Swing",
    "Fast-Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde",
    "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band",
    "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson",
    "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus",
    "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba",
    "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet",
    "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall",
    "Goa", "Drum & Bass", "Club House", "Hardcore", "Terror",
    "Indie", "BritPop", "NegerPunk", "Polsk Punk", "Beat",
    "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary C",
    "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop",
    "SynthPop",
};

@implementation XLDAlacDecoder
		

+ (BOOL)canHandleFile:(char *)path
{
	ExtAudioFileRef infile;
	FSRef inputFSRef;
	FSPathMakeRef((UInt8 *)path,&inputFSRef,NULL);
	if(ExtAudioFileOpen(&inputFSRef, &infile) != noErr) return NO;
	AudioStreamBasicDescription fmt;
	UInt32 size = sizeof(fmt);
	if(ExtAudioFileGetProperty(infile, kExtAudioFileProperty_FileDataFormat, &size, &fmt) != noErr) {
		ExtAudioFileDispose(infile);
		return NO;
	}
	if(fmt.mFormatID != 'alac') {
		ExtAudioFileDispose(infile);
		return NO;
	}
	ExtAudioFileDispose(infile);
	return YES;
}

+ (BOOL)canLoadThisBundle
{
	if (floor(NSAppKitVersionNumber) <= NSAppKitVersionNumber10_3 ) {
		return NO;
	}
	else return YES;
}

- (id)init
{
	[super init];
	file = NULL;
	error = NO;
	metadataDic = [[NSMutableDictionary alloc] init];
	srcPath = nil;
	return self;
}

- (BOOL)openFile:(char *)path
{
	FSRef inputFSRef;
	FSPathMakeRef((UInt8 *)path,&inputFSRef,NULL);
	if(ExtAudioFileOpen(&inputFSRef, &file) != noErr) return nil;
	AudioStreamBasicDescription inputFormat,outputFormat;
	UInt32 size = sizeof(inputFormat);
	if(ExtAudioFileGetProperty(file, kExtAudioFileProperty_FileDataFormat, &size, &inputFormat) != noErr) {
		ExtAudioFileDispose(file);
		file = NULL;
		error = YES;
		return NO;
	}
	SInt64 frames;
	size = sizeof(frames);
	if(ExtAudioFileGetProperty(file, kExtAudioFileProperty_FileLengthFrames, &size, &frames) != noErr) {
		ExtAudioFileDispose(file);
		file = NULL;
		error = YES;
		return NO;
	}
	if(inputFormat.mFormatID != 'alac') {
		ExtAudioFileDispose(file);
		file = NULL;
		error = YES;
		return NO;
	}
	
	switch(inputFormat.mFormatFlags) {
	  case 1:
		bps = 2;
		break;
	  case 2:
		bps = 3;
		break;
	  case 3:
		bps = 3;
		break;
	  case 4:
		bps = 4;
		break;
	  default:
		ExtAudioFileDispose(file);
		file = NULL;
		error = YES;
		return NO;
	}
	
	channels = inputFormat.mChannelsPerFrame;
	samplerate = inputFormat.mSampleRate;
	totalFrames = frames;
	
	outputFormat = inputFormat;
	outputFormat.mFormatID = 'lpcm';
#ifdef _BIG_ENDIAN
	outputFormat.mFormatFlags = kAudioFormatFlagIsSignedInteger|kAudioFormatFlagIsBigEndian|kAudioFormatFlagIsPacked;
#else
	outputFormat.mFormatFlags = kAudioFormatFlagIsSignedInteger|kAudioFormatFlagIsPacked;
#endif
	outputFormat.mBytesPerPacket = 4 * inputFormat.mChannelsPerFrame;
	outputFormat.mFramesPerPacket = 1;
	outputFormat.mBytesPerFrame = outputFormat.mBytesPerPacket;
	outputFormat.mChannelsPerFrame = inputFormat.mChannelsPerFrame;
	outputFormat.mBitsPerChannel = 32;
	
	size = sizeof(outputFormat);
	if(ExtAudioFileSetProperty(file, kExtAudioFileProperty_ClientDataFormat, size, &outputFormat) != noErr) {
		ExtAudioFileDispose(file);
		file = NULL;
		error = YES;
		return NO;
	}
	
	/* try to read total frame count and tags... */
	FILE *fp = fopen(path,"rb");
	int tmp,tmp2;
	char atom[4];
	xldoffset_t totalFramesFromFile = 0;
	
	while(1) { //skip until moov;
		if(fread(&tmp,4,1,fp) < 1) goto tag;
		if(fread(atom,1,4,fp) < 4) goto tag;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"moov",4)) break;
		if(fseek(fp,tmp-8,SEEK_CUR) != 0) goto tag;
	}
	
	while(1) { //skip until trak;
		if(fread(&tmp,4,1,fp) < 1) goto tag;
		if(fread(atom,1,4,fp) < 4) goto tag;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"trak",4)) break;
		if(fseek(fp,tmp-8,SEEK_CUR) != 0) goto tag;
	}
	
	while(1) { //skip until mdia;
		if(fread(&tmp,4,1,fp) < 1) goto tag;
		if(fread(atom,1,4,fp) < 4) goto tag;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"mdia",4)) break;
		if(fseek(fp,tmp-8,SEEK_CUR) != 0) goto tag;
	}
	
	while(1) { //skip until minf;
		if(fread(&tmp,4,1,fp) < 1) goto tag;
		if(fread(atom,1,4,fp) < 4) goto tag;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"minf",4)) break;
		if(fseek(fp,tmp-8,SEEK_CUR) != 0) goto tag;
	}
	
	while(1) { //skip until stbl;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"stbl",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	while(1) { //skip until stts;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"stts",4)) break;
		if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	if(fseek(fp,4,SEEK_CUR) != 0) goto tag;
	if(fread(&tmp,4,1,fp) < 1) goto end;
	int numEntry = SWAP32(tmp);
	int i;
	for(i=0;i<numEntry;i++) {
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(&tmp2,4,1,fp) < 1) goto end;
		tmp = SWAP32(tmp);
		tmp2 = SWAP32(tmp2);
		totalFramesFromFile += tmp * tmp2;
	}
	
	
	/*
	if(fseek(fp,4,SEEK_CUR) != 0) goto tag;
	if(fread(atom,1,4,fp) < 4) goto tag;
	if(!memcmp(atom,"mdhd",4)) {
		if(fseek(fp,16,SEEK_CUR) != 0) goto tag;
		if(fread(&tmp,4,1,fp) < 1) goto tag;
		totalFramesFromFile = SWAP32(tmp);
	}*/
	
tag:
	fclose(fp);
	fp = fopen(path,"rb");
	
	while(1) { //skip until moov;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"moov",4)) break;
		if(fseek(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	int moovSize = tmp;
	int read = 8;
	
	while(read < moovSize) { //skip until udta;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"udta",4)) goto tagExist;
		if(fseek(fp,tmp-8,SEEK_CUR) != 0) goto end;
		read += tmp;
	}
	goto end;
	
tagExist:
	
	if(fseek(fp,12,SEEK_CUR) != 0) goto end; //skip until hdlr;
	
	while(1) { //skip until ilst;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		if(fread(atom,1,4,fp) < 4) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"ilst",4)) break;
		if(fseek(fp,tmp-8,SEEK_CUR) != 0) goto end;
	}
	
	void *buf = malloc(tmp-8);
	if(fread(buf,1,tmp-8,fp) < tmp-8) goto end;
	
	NSData *dat = [NSData dataWithBytesNoCopy:buf length:tmp-8];
	
	int len = [dat length];
	int current = 0;
	int atomLength;
	int flag;
	while(current < len) {
		[dat getBytes:&atomLength range:NSMakeRange(current,4)];
		[dat getBytes:atom range:NSMakeRange(current+4,4)];
		atomLength = SWAP32(atomLength);
		
		if(!memcmp("\251nam",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_TITLE];
			[str release];
		}
		else if(!memcmp("\251ART",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_ARTIST];
			[str release];
		}
		else if(!memcmp("aART",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_ALBUMARTIST];
			[str release];
		}
		else if(!memcmp("\251alb",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_ALBUM];
			[str release];
		}
		else if(!memcmp("\251cmt",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_COMMENT];
			[str release];
		}
		else if(!memcmp("\251lyr",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_LYRICS];
			[str release];
		}
		else if(!memcmp("\251wrt",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_COMPOSER];
			[str release];
		}
		else if(!memcmp("\251day",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_DATE];
			if([str length] > 3) {
				int year = [[str substringWithRange:NSMakeRange(0,4)] intValue];
				if(year >= 1000 && year < 3000) [metadataDic setObject:[NSNumber numberWithInt:year] forKey:XLD_METADATA_YEAR];
			}
			[str release];
		}
		else if(!memcmp("\251gen",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_GENRE];
			[str release];
		}
		else if(!memcmp("gnre",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 0) goto last;
			short genreCode;
			[dat getBytes:&genreCode range:NSMakeRange(current+24,2)];
			genreCode = SWAP16(genreCode);
			if(genreCode <= sizeof(ID3v1GenreList)/sizeof(*ID3v1GenreList)) {
				[metadataDic setObject:[NSString stringWithUTF8String:ID3v1GenreList[genreCode-1]] forKey:XLD_METADATA_GENRE];
			}
		}
		else if(!memcmp("trkn",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 0) goto last;
			short track;
			short totaltracks;
			[dat getBytes:&track range:NSMakeRange(current+26,2)];
			[dat getBytes:&totaltracks range:NSMakeRange(current+28,2)];
			track = SWAP16(track);
			totaltracks = SWAP16(totaltracks);
			if(track > 0) [metadataDic setObject:[NSNumber numberWithInt:track] forKey:XLD_METADATA_TRACK];
			if(totaltracks > 0) [metadataDic setObject:[NSNumber numberWithInt:totaltracks] forKey:XLD_METADATA_TOTALTRACKS];
		}
		else if(!memcmp("disk",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 0) goto last;
			short disc;
			short totaldiscs;
			[dat getBytes:&disc range:NSMakeRange(current+26,2)];
			[dat getBytes:&totaldiscs range:NSMakeRange(current+28,2)];
			disc = SWAP16(disc);
			totaldiscs = SWAP16(totaldiscs);
			if(disc > 0) [metadataDic setObject:[NSNumber numberWithInt:disc] forKey:XLD_METADATA_DISC];
			if(totaldiscs > 0) [metadataDic setObject:[NSNumber numberWithInt:totaldiscs] forKey:XLD_METADATA_TOTALDISCS];
		}
		else if(!memcmp("covr",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 0xd && flag != 0xe) goto last;
			if(tmp <= 16) goto last;
			tmp = tmp - 16;
			NSData *imgData = [dat subdataWithRange:NSMakeRange(current+24,tmp)];
			[metadataDic setObject:imgData forKey:XLD_METADATA_COVER];
		}
		else if(!memcmp("cpil",atom,4)) {
			if(atomLength != 0x19) goto last;
			char tmp3;
			[dat getBytes:&tmp3 range:NSMakeRange(current+24,1)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			flag = SWAP32(flag);
			if(flag != 0x15) goto last;
			if(tmp3 != 0) [metadataDic setObject:[NSNumber numberWithBool:YES] forKey:XLD_METADATA_COMPILATION];
		}
		else if(!memcmp("\251grp",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_GROUP];
			[str release];
		}
		else if(!memcmp("tmpo",atom,4)) {
			if(atomLength != 0x1a) goto last;
			unsigned short tmp2;
			[dat getBytes:&tmp2 range:NSMakeRange(current+24,2)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			flag = SWAP32(flag);
			if(flag != 0x15) goto last;
			[metadataDic setObject:[NSNumber numberWithUnsignedShort:tmp2] forKey:XLD_METADATA_BPM];
		}
		else if(!memcmp("cprt",atom,4)) {
			[dat getBytes:&tmp range:NSMakeRange(current+8,4)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			tmp = SWAP32(tmp);
			flag = SWAP32(flag);
			if(flag != 1) goto last;
			if(tmp <= 16) goto last;
			NSString *str = [[NSString alloc] initWithData:[dat subdataWithRange:NSMakeRange(current+24,tmp-16)] encoding:NSUTF8StringEncoding];
			if(!str) goto last;
			[metadataDic setObject:str forKey:XLD_METADATA_COPYRIGHT];
			[str release];
		}
		else if(!memcmp("pgap",atom,4)) {
			if(atomLength != 0x19) goto last;
			char tmp3;
			[dat getBytes:&tmp3 range:NSMakeRange(current+24,1)];
			[dat getBytes:&flag range:NSMakeRange(current+16,4)];
			flag = SWAP32(flag);
			if(flag != 0x15) goto last;
			if(tmp3 != 0) [metadataDic setObject:[NSNumber numberWithBool:YES] forKey:XLD_METADATA_GAPLESSALBUM];
		}
last:
		current += atomLength;
	}
	
end:
	fclose(fp);
	
	if(totalFramesFromFile > 0) totalFrames = totalFramesFromFile;
	
	if(srcPath) [srcPath release];
	srcPath = [[NSString alloc] initWithUTF8String:path];
	return YES;
}

- (void)dealloc
{
	if(file) ExtAudioFileDispose(file);
	[metadataDic release];
	if(srcPath) [srcPath release];
	[super dealloc];
}

- (int)samplerate
{
	return samplerate;
}

- (int)bytesPerSample
{
	return bps;
}

- (int)channels
{
	return channels;
}

- (xldoffset_t)totalFrames
{
	return totalFrames;
}

- (int)isFloat
{
	return 0;
}

- (int)decodeToBuffer:(int *)buffer frames:(int)count
{
	int ret;
	fillBufList.mNumberBuffers = 1;
	fillBufList.mBuffers[0].mNumberChannels = channels;
	fillBufList.mBuffers[0].mDataByteSize = count*4*channels;
	fillBufList.mBuffers[0].mData = buffer;
	if(ExtAudioFileRead (file, (UInt32 *)&ret, &fillBufList) != noErr) {
		error = YES;
		return 0;
	}
	/*if(count > ret) {
		fillBufList.mBuffers[0].mDataByteSize = (count-ret)*4*channels;
		fillBufList.mBuffers[0].mData = buffer+ret*channels;
		if(ExtAudioFileRead (file, (UInt32 *)&ret2, &fillBufList) != noErr) {
			error = YES;
			return 0;
		}
		ret += ret2;
	}*/
	//NSLog(@"returned %d",ret);
	return ret;
}

- (xldoffset_t)seekToFrame:(xldoffset_t)count
{
	if(ExtAudioFileSeek(file,count) != noErr) {
		error = YES;
		return 0;
	}
	return count;
}

- (void)closeFile
{
	if(file) ExtAudioFileDispose(file);
	file = NULL;
	[metadataDic removeAllObjects];
	error = NO;
}

- (BOOL)error
{
	return error;
}

- (XLDEmbeddedCueSheetType)hasCueSheet
{
	return XLDNoCueSheet;
}

- (id)cueSheet
{
	return nil;
}

- (id)metadata
{
	return metadataDic;
}

- (NSString *)srcPath
{
	return srcPath;
}

@end