#import "XLDDragImageView.h"
#import "XLDController.h"

@implementation XLDDragImageView

- (id)init
{
	[super init];
	imgData = nil;
	acceptDrag = YES;
	autoResize = YES;
	//NSArray* array = [NSArray arrayWithObject:NSFilenamesPboardType];
	//[self registerForDraggedTypes:array];
	return self;
}

- (void)dealloc
{
	if(imgData) [imgData release];
	[super dealloc];
}

- (void)drawRect:(NSRect)aRect
{
	NSGraphicsContext *gc = [NSGraphicsContext currentContext];
	[gc setImageInterpolation:NSImageInterpolationHigh];
	[super drawRect:aRect];
}

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)info
{
	if(!acceptDrag) return NSDragOperationNone;
	NSPasteboard *pboard = [info draggingPasteboard];
	if([[pboard types] containsObject:NSFilenamesPboardType]) {
		NSArray *fileArr = [[info draggingPasteboard] propertyListForType:NSFilenamesPboardType];
		if([fileArr count] != 1) return NSDragOperationNone;
		BOOL isDir;
		[[NSFileManager defaultManager] fileExistsAtPath:[fileArr objectAtIndex:0] isDirectory:&isDir];
		if(isDir) return NSDragOperationNone;
		
		[[NSCursor _copyDragCursor] set];
		return NSDragOperationGeneric;
	}
	else if([[pboard types] containsObject:NSURLPboardType]) {
		[[NSCursor _copyDragCursor] set];
		return NSDragOperationGeneric;
	}
	return NSDragOperationNone;
}

- (void)draggingExited:(id <NSDraggingInfo>)info
{
	[[NSCursor arrowCursor] set];
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)info
{
	NSImage *img;
	NSData *dat;
	NSPasteboard *pboard = [info draggingPasteboard];
	if([[pboard types] containsObject:NSFilenamesPboardType]) {
		NSString *path = [[[info draggingPasteboard] propertyListForType:NSFilenamesPboardType] objectAtIndex:0];
		img = [[NSImage alloc] initByReferencingFile:path];
		dat = [[NSData alloc] initWithContentsOfFile:path];
	}
	else if([[pboard types] containsObject:NSURLPboardType]) {
		img = [[NSImage alloc] initByReferencingURL:[NSURL URLFromPasteboard:pboard]];
		dat = [[NSData alloc] initWithContentsOfURL:[NSURL URLFromPasteboard:pboard]];
	}
	if([img isValid]) {
		if(autoResize) [self setImageWithResize:img];
		else [self setImage:img];
		[img release];
		if(imgData) [imgData release];
		imgData = dat;
		return YES;
	}
	else {
		[img release];
		[dat release];
		if(imgData) [imgData release];
		imgData = nil;
		return NO;
	}
}

- (void)concludeDragOperation:(id <NSDraggingInfo>)info
{
	[delegate imageLoadedFromOutside:YES];
}

- (void)clearData
{
	if(imgData) [imgData release];
	imgData = nil;
}

- (NSData *)imgData
{
	return imgData;
}

- (void)setImgData:(NSData *)data
{
	if(imgData) [imgData release];
	imgData = [data retain];
}

- (void)setAcceptDrag:(BOOL)flag
{
	acceptDrag = flag;
}

- (void)setAutoResize:(BOOL)flag
{
	autoResize = flag;
}

- (void)setImageWithResize:(NSImage *)img
{
	int beforeX,beforeY,afterX,afterY;
	NSImage *targetImage=nil,*newImage=img;
	[img setCacheMode:NSImageCacheNever];
	NSImageRep *rep = [img bestRepresentationForDevice:nil];
	
	beforeX = [rep pixelsWide];
	beforeY = [rep pixelsHigh];
	afterX = beforeX;
	afterY = beforeY;
	if(beforeX > beforeY && beforeY > 500) {
		afterX = round((double)beforeX * 500/beforeY);
		afterY = 500;
	}
	if(beforeX < beforeY && beforeX > 500) {
		afterY = round((double)beforeY * 500/beforeX);
		afterX = 500;
	}
	if(beforeX != afterX || beforeY != afterY) {
		NSRect targetImageFrame = NSMakeRect(0,0,afterX,afterY);
		targetImage = [[NSImage alloc] initWithSize:targetImageFrame.size];
		[targetImage setCacheMode:NSImageCacheNever];
		[targetImage lockFocus];
		[[NSGraphicsContext currentContext] setImageInterpolation:NSImageInterpolationHigh];
		[rep drawInRect: targetImageFrame];
		[targetImage unlockFocus];
		newImage = [[NSImage alloc] initWithData:[targetImage TIFFRepresentation]];
		[targetImage release];
		targetImage = newImage;
		//[[targetImage TIFFRepresentation] writeToFile: @"/Users/tmkk/test3.tiff" atomically: NO];
	}
	//rep = [newImage bestRepresentationForDevice:nil];
	int width = afterX;
	int height = afterY;
	if(width>height) {
		[self setFrameSize:NSMakeSize(170,170*height/(double)width)];
		[self setFrameOrigin:NSMakePoint(20,[self frame].origin.y)];
	}
	else {
		[self setFrameSize:NSMakeSize(170*width/(double)height,170)];
		[self setFrameOrigin:NSMakePoint(20+(170-170*width/(double)height)/2,[self frame].origin.y)];
	}
	[[self window] display];
	[newImage setSize:NSMakeSize(width,height)];
	[newImage setCacheMode:NSImageCacheNever];
	[self setImage:newImage];
	if(targetImage) [targetImage release];
}

@end
