//
//  XLDDefaultOutputTask.m
//  XLD
//
//  Created by tmkk on 06/09/08.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDDefaultOutputTask.h"
#import "XLDDefaultOutput.h"
#import "XLDTrack.h"

#ifdef _BIG_ENDIAN
#define SWAP32(n) (n)
#define SWAP16(n) (n)
#else
#define SWAP32(n) (((n>>24)&0xff) | ((n>>8)&0xff00) | ((n<<8)&0xff0000) | ((n<<24)&0xff000000))
#define SWAP16(n) (((n>>8)&0xff) | ((n<<8)&0xff00))
#endif

@implementation XLDDefaultOutputTask


- (id)init
{
	[super init];
	memset(&sfinfo,0,sizeof(SF_INFO));
	sf_w = NULL;
	addTag = YES;
	path = NULL;
	tagData = [[NSMutableData alloc] init];
	return self;
}

- (id)initWithDelegate:(id)del
{
	[self init];
	delegate = del;
	return self;
}

- (void)dealloc
{
	if(sf_w) sf_close(sf_w);
	if(path) [path release];
	[tagData release];
	[super dealloc];
}

- (BOOL)setOutputFormat:(XLDFormat)fmt
{
	inFormat = fmt;
	sfinfo.samplerate = fmt.samplerate;
	sfinfo.channels = fmt.channels;
	
	XLDFormat outFmt = [delegate outFormat];
	int bps = outFmt.bps ? outFmt.bps : fmt.bps;
	int isFloat = outFmt.bps ? outFmt.isFloat : fmt.isFloat;
	
	switch(bps) {
		case 1:
			if((sfinfo.format&SF_FORMAT_TYPEMASK) == SF_FORMAT_WAV) sfinfo.format |= SF_FORMAT_PCM_U8;
			else sfinfo.format |= SF_FORMAT_PCM_S8;
			break;
		case 2:
			sfinfo.format |= SF_FORMAT_PCM_16;
			break;
		case 3:
			sfinfo.format |= SF_FORMAT_PCM_24;
			break;
		case 4:
			if(isFloat) sfinfo.format |= SF_FORMAT_FLOAT;
			else sfinfo.format |= SF_FORMAT_PCM_32;
			break;
		default:
			return NO;
	}
	
	return YES;
}

- (BOOL)openFileForOutput:(NSString *)str withTrackData:(id)track
{
	sf_w = sf_open([str UTF8String], SFM_WRITE, &sfinfo);
	if(!sf_w) {
		return NO;
	}
	if(sf_error(sf_w)) {
		return NO;
	}
	sf_command(sf_w, SFC_SET_SCALE_INT_FLOAT_WRITE, NULL, SF_TRUE) ;
	path = [str retain];
	
	[tagData setLength:0];
	if(addTag && ((sfinfo.format&SF_FORMAT_TYPEMASK) == SF_FORMAT_AIFF)) {
		int tmp;
		short tmp2;
		char tmp3;
		char atomID[4];
		BOOL added = NO;
		
		/* ID3  atom */
		tmp = 0;
		memcpy(atomID,"ID3 ",4);
		[tagData appendBytes:atomID length:4];
		[tagData appendBytes:&tmp length:4];
		
		/* id3 header */
		tmp = 0;
		tmp3 = 3; // version 2.3
		memcpy(atomID,"ID3",3);
		[tagData appendBytes:atomID length:3];
		[tagData appendBytes:&tmp3 length:1];
		tmp3 = 0;
		[tagData appendBytes:&tmp3 length:1];
		[tagData appendBytes:&tmp3 length:1];
		[tagData appendBytes:&tmp length:4];
		
		/* TIT2 */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TITLE] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+3;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"TIT2",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* TPE1 */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ARTIST] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+3;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"TPE1",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* TPE2 */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUMARTIST] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+3;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"TPE2",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* TALB */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_ALBUM] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+3;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"TALB",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* TCON */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GENRE] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+3;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"TCON",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* TCOM */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPOSER] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+3;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"TCOM",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* TRCK */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK]) {
			added = YES;
			NSString *str;
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS])
				str = [NSString stringWithFormat:@"%d/%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] intValue],[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALTRACKS] intValue]];
			else
				str = [NSString stringWithFormat:@"%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TRACK] intValue]];
			NSData *dat = [str dataUsingEncoding:NSISOLatin1StringEncoding];
			tmp = [dat length]+2;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 0;
			memcpy(atomID,"TRCK",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (ISO-8859-1)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp3 length:1]; //termination
		}
		
		/* TPOS */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] || [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS]) {
			added = YES;
			NSString *str;
			if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS])
				str = [NSString stringWithFormat:@"%d/%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] intValue],[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_TOTALDISCS] intValue]];
			else
				str = [NSString stringWithFormat:@"%d",[[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DISC] intValue]];
			NSData *dat = [str dataUsingEncoding:NSISOLatin1StringEncoding];
			tmp = [dat length]+2;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 0;
			memcpy(atomID,"TPOS",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (ISO-8859-1)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp3 length:1]; //termination
		}
		
		/* TYER */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_DATE] dataUsingEncoding:NSISOLatin1StringEncoding];
			tmp = [dat length]+2;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 0;
			memcpy(atomID,"TYER",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (ISO-8859-1)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp3 length:1]; //termination
		}
		else if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR]) {
			added = YES;
			NSString *str = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_YEAR] stringValue];
			NSData *dat = [str dataUsingEncoding:NSISOLatin1StringEncoding];
			tmp = [dat length]+2;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 0;
			memcpy(atomID,"TYER",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (ISO-8859-1)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp3 length:1]; //termination
		}
		
		/* COMM */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMMENT] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+8;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"COMM",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			memcpy(atomID,"eng",3);
			[tagData appendBytes:atomID length:3]; //language
			[tagData appendBytes:&tmp2 length:2]; //description
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* TCMP */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION]) {
			if([[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COMPILATION] boolValue]) {
				added = YES;
				tmp = 3;
				tmp = SWAP32(tmp);
				tmp2 = 0;
				tmp3 = 0;
				memcpy(atomID,"TCMP",4);
				[tagData appendBytes:atomID length:4]; //ID
				[tagData appendBytes:&tmp length:4]; //length
				[tagData appendBytes:&tmp2 length:2]; //flag
				[tagData appendBytes:&tmp3 length:1]; //char code (ISO-8859-1)
				tmp3 = 0x31;
				[tagData appendBytes:&tmp3 length:1];
				tmp3 = 0;
				[tagData appendBytes:&tmp3 length:1]; //termination
			}
		}
		
		/* TIT1 */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP]) {
			added = YES;
			NSData *dat = [[[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_GROUP] dataUsingEncoding:NSUnicodeStringEncoding];
			tmp = [dat length]+3;
			tmp = SWAP32(tmp);
			tmp2 = 0;
			tmp3 = 1;
			memcpy(atomID,"TIT1",4);
			[tagData appendBytes:atomID length:4]; //ID
			[tagData appendBytes:&tmp length:4]; //length
			[tagData appendBytes:&tmp2 length:2]; //flag
			[tagData appendBytes:&tmp3 length:1]; //char code (UTF-16)
			[tagData appendData:dat];
			[tagData appendBytes:&tmp2 length:2]; //termination
		}
		
		/* APIC */
		if([[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER]) {
			NSData *imgData = [[(XLDTrack *)track metadata] objectForKey:XLD_METADATA_COVER];
			char *mime = NULL;
			int size = [imgData length];
			const unsigned char *data = [imgData bytes];
			if (2 < size && data[0] == 0xFF && data[1] == 0xD8) {
				mime = "image/jpeg";
			}
			else if (4 < size && data[0] == 0x89 && strncmp((const char *) &data[1], "PNG", 3) == 0) {
				mime = "image/png";
			}
			else if (4 < size && strncmp((const char *) data, "GIF8", 4) == 0) {
				mime = "image/gif";
			}
			if(mime) {
				added = YES;
				tmp = [imgData length] + strlen(mime) + 4;
				tmp = SWAP32(tmp);
				tmp2 = 0;
				tmp3 = 0;
				memcpy(atomID,"APIC",4);
				[tagData appendBytes:atomID length:4]; //ID
				[tagData appendBytes:&tmp length:4]; //length
				[tagData appendBytes:&tmp2 length:2]; //flag
				[tagData appendBytes:&tmp3 length:1]; //char code (ISO-8859-1)
				[tagData appendBytes:mime length:strlen(mime)+1];
				tmp3 = 3;
				[tagData appendBytes:&tmp3 length:1]; //picture type
				tmp3 = 0;
				[tagData appendBytes:&tmp3 length:1]; //description
				[tagData appendData:imgData];
			}
		}
		
		if(added) {
			/* update length of ID3  atom */
			tmp = [tagData length] - 8;
			tmp = SWAP32(tmp);
			[tagData replaceBytesInRange:NSMakeRange(4,4) withBytes:&tmp];
			
			/* update length of ID3 header */
			tmp = [tagData length] - 18;
			tmp3 = tmp & 0x7f;
			[tagData replaceBytesInRange:NSMakeRange(17,1) withBytes:&tmp3];
			tmp3 = (tmp >> 7) & 0x7f;
			[tagData replaceBytesInRange:NSMakeRange(16,1) withBytes:&tmp3];
			tmp3 = (tmp >> 14) & 0x7f;
			[tagData replaceBytesInRange:NSMakeRange(15,1) withBytes:&tmp3];
			tmp3 = (tmp >> 21) & 0x7f;
			[tagData replaceBytesInRange:NSMakeRange(14,1) withBytes:&tmp3];
		}
		else [tagData setLength:0];
	}
	
	return YES;
}

- (NSString *)extensionStr
{
	switch(sfinfo.format&SF_FORMAT_TYPEMASK) {
		case SF_FORMAT_AIFF:
			return @"aiff";
		case SF_FORMAT_WAV:
			return @"wav";
		case SF_FORMAT_RAW:
			return @"pcm";
		case SF_FORMAT_W64:
			return @"w64";
	}
	return nil;
}

- (BOOL)writeBuffer:(int *)buffer frames:(int)counts
{
	if(inFormat.isFloat)
		sf_writef_float(sf_w,(float *)buffer,counts);
	else sf_writef_int(sf_w,buffer,counts);
	
	if(sf_error(sf_w)) {
		return NO;
	}
	return YES;
}

- (void)finalize
{
	if(!addTag || ![tagData length]) return;
	if(sf_w) sf_close(sf_w);
	sf_w = NULL;
	
	FILE *fp = fopen([path UTF8String], "r+");
	int tmp;
	char atom[4];
	
	while(1) { //skip until FORM;
		if(fread(atom,1,4,fp) < 4) goto end;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		tmp = SWAP32(tmp);
		if(!memcmp(atom,"FORM",4)) break;
		if(fseeko(fp,tmp,SEEK_CUR) != 0) goto end;
	}
	if(fseeko(fp,-4,SEEK_CUR) != 0) goto end;
	tmp = tmp + [tagData length];
	tmp = SWAP32(tmp);
	if(fwrite(&tmp,4,1,fp) < 1) goto end;
	
	tmp = SWAP32(tmp);
	tmp = tmp - [tagData length];
	if(fseeko(fp,tmp,SEEK_CUR) != 0) goto end;
	if(fwrite([tagData bytes],1,[tagData length],fp) < [tagData length]) goto end;
	
end:
		
	fclose(fp);
}

- (void)closeFile
{
	if(sf_w) sf_close(sf_w);
	sf_w = NULL;
	if(path) [path release];
	path = NULL;
	[tagData setLength:0];
}

- (void)setEnableAddTag:(BOOL)flag
{
	addTag = flag;
}

//privates

- (void)initOutputFormat
{
	memset(&sfinfo,0,sizeof(SF_INFO));
}

- (void)setOutputFormatAIFF
{
	sfinfo.format = SF_FORMAT_AIFF;
}

- (void)setOutputFormatWAV
{
	sfinfo.format = SF_FORMAT_WAV;
}

- (void)setOutputFormatW64
{
	sfinfo.format = SF_FORMAT_W64;
}

- (void)setOutputFormatBigEndianLPCM
{
	sfinfo.format = SF_FORMAT_RAW|SF_ENDIAN_BIG;
}

- (void)setOutputFormatLittleEndianLPCM
{
	sfinfo.format = SF_FORMAT_RAW|SF_ENDIAN_LITTLE;
}

@end
