//
//  XLDDefaultOutput.m
//  XLD
//
//  Created by tmkk on 06/06/08.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDDefaultOutput.h"
#import "XLDDefaultOutputTask.h"

@implementation XLDDefaultOutput

+ (NSString *)pluginName
{
	return @"Default PCM Output";
}

+ (BOOL)canLoadThisBundle
{
	if (floor(NSAppKitVersionNumber) <= 620 ) {
		return NO;
	}
	else return YES;
}

- (id)init
{
	[super init];
	[NSBundle loadNibNamed:@"XLDDefaultOutput" owner:self];
	[self statusChanged:nil];
	return self;
}

- (NSView *)prefPane
{
	return o_view;
}

- (void)savePrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	[pref setInteger:[o_bitDepth indexOfSelectedItem] forKey:@"XLDDefaultOutput_BitDepth"];
	[pref setInteger:[o_isFloat state] forKey:@"XLDDefaultOutput_IsFloat"];
	[pref synchronize];
}

- (void)loadPrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	id obj;
	if(obj=[pref objectForKey:@"XLDDefaultOutput_BitDepth"]) {
		[o_bitDepth selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"XLDDefaultOutput_IsFloat"]) {
		[o_isFloat setState:[obj intValue]];
	}
	[self statusChanged:nil];
}

- (id)createTaskForOutput
{
	return [[XLDDefaultOutputTask alloc] initWithDelegate:self];
}

- (IBAction)statusChanged:(id)target
{
	if([[o_bitDepth selectedItem] tag] == 4) {
		[o_isFloat setEnabled:YES];
	}
	else {
		[o_isFloat setEnabled:NO];
		[o_isFloat setState:NSOffState];
	}
}

- (XLDFormat)outFormat;
{
	XLDFormat fmt;
	fmt.bps = [[o_bitDepth selectedItem] tag];
	fmt.isFloat = ([o_isFloat state] == NSOnState);
	return fmt;
}

@end
