//
//  XLDView.m
//  XLD
//
//  Created by tmkk on 09/02/14.
//  Copyright 2009 tmkk. All rights reserved.
//

#import "XLDCustomClasses.h"


@implementation XLDView

- (int)tag
{
	return tag;
}

- (void)setTag:(int)t
{
	tag = t;
}

@end

@implementation XLDTextView

- (void)dealloc
{
	if(actionTarget) [actionTarget release];
	[super dealloc];
}

- (void)setActionTarget:(id)target
{
	if(actionTarget) [actionTarget release];
	actionTarget = [target retain];
}

- (NSMenu *)menuForEvent:(NSEvent *)event
{
	NSMenu *menu = [super menuForEvent:event];
	NSMenuItem *item = [[NSMenuItem alloc] initWithTitle:LS(@"Apply This Item for All Files") action:@selector(applyForAll:) keyEquivalent:@""];
	[item setTarget:actionTarget];
	[item setTag:[[self delegate] tag]];
	[menu insertItem:item atIndex:0];
	[menu insertItem:[NSMenuItem separatorItem] atIndex:1];
	[item release];
	
	return menu;
}

@end

@implementation NSImage (String)
+ (NSImage *)imageWithString:(NSString *)string withFont:(NSFont *)font withColor:(NSColor *)color
{
	NSGlyph glyph;
	NSBezierPath *path = [NSBezierPath bezierPath];
	[path moveToPoint:NSMakePoint(0, [font pointSize])];
	int i;
	for(i=0;i<[string length];i++) {
		glyph = [font glyphWithName:[string substringWithRange:NSMakeRange(i,1)]];
		if(glyph == 0xffff || [string characterAtIndex:i] == ' ') [path relativeMoveToPoint:NSMakePoint([font pointSize]/2,0)];
		else [path appendBezierPathWithGlyph:glyph inFont:font];
	}
	NSShadow *shadow = [[NSShadow alloc] init];
	[shadow setShadowOffset:NSMakeSize(3,-3)];
	[shadow setShadowBlurRadius:3];
	[shadow setShadowColor:[NSColor lightGrayColor]];
	NSImage *img = [[NSImage alloc] initWithSize:NSMakeSize([path currentPoint].x,[font pointSize]*2)];
	[img lockFocus];
	[color set];
	[shadow set];
	[path fill];
	[img unlockFocus];
	[shadow release];
	
	NSRect targetImageFrame = NSMakeRect(0,0,170,170);
	NSImage *targetImage = [[NSImage alloc] initWithSize:targetImageFrame.size];
	[targetImage lockFocus];
	[[NSColor whiteColor] set];
	NSRectFill(targetImageFrame);
	[img compositeToPoint:NSMakePoint((170-[img size].width)/2,(170-[img size].height)/2) operation:NSCompositeSourceOver];
	[targetImage unlockFocus];
	[img release];
	return [targetImage autorelease];
}
@end

@implementation XLDButton

- (void)mouseDown:(NSEvent *)theEvent 
{
	modifierFlags = [theEvent modifierFlags];
	[super mouseDown:theEvent];
}

- (BOOL)commandKeyPressed
{
	return ((modifierFlags & NSCommandKeyMask) != 0);
}

- (BOOL)optionKeyPressed
{
	return ((modifierFlags & NSAlternateKeyMask) != 0);
}

- (BOOL)shiftKeyPressed
{
	return ((modifierFlags & NSShiftKeyMask) != 0);
}

@end