//
//  XLDCueParser.h
//  XLD
//
//  Created by tmkk on 06/06/10.
//  Copyright 2006 tmkk. All rights reserved.
//
// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import <Cocoa/Cocoa.h>

@interface XLDCueParser : NSObject {
	NSMutableArray *trackList;
	NSMutableArray *checkList;
	id delegate;
	NSString *fileToDecode;
	xldoffset_t totalFrames;
	int samplerate;
	NSString *title;
	XLDFormat format;
	XLDEndian endian;
	BOOL rawMode;
	int rawOffset;
	NSData *cover;
	NSRange rangeForCuesheet;
	NSString *driveStr;
}

- (id)initWithDelegate:(id)del;
- (void)clean;
- (XLDErr)openFile:(NSString *)file;
- (XLDErr)openFile:(NSString *)file withRawFormat:(XLDFormat)fmt endian:(XLDEndian)e;
- (XLDErr)openFile:(NSString *)file withCueData:(NSString *)cueData decoder:(id)decoder;
- (void)openFile:(NSString *)file withTrackData:(NSMutableArray *)arr decoder:(id)decoder;
- (void)openRawFile:(NSString *)file withTrackData:(NSMutableArray *)arr decoder:(id)decoder;
- (id)decoderForCueSheet:(NSString *)file isRaw:(BOOL)raw promptIfNotFound:(BOOL)prompt error:(XLDErr *)error;
- (NSArray *)trackList;
- (NSString *)lengthOfTrack:(int)track;
- (NSString *)gapOfTrack:(int)track;
- (NSString *)fileToDecode;
- (NSString *)title;
- (NSString *)artist;
- (void)checkAtIndex:(int)idx;
- (void)uncheckAtIndex:(int)idx;
- (xldoffset_t)totalFrames;
- (XLDFormat)rawFormat;
- (XLDEndian)rawEndian;
- (int)rawOffset;
- (BOOL)rawMode;
- (NSData *)coverData;
- (void)setCoverData:(NSData *)data;
- (NSMutableData *)cueData;
- (NSMutableData *)cueDataForSeparatedFiles:(BOOL)HTOA;
- (NSRange)rangeForCuesheet;
- (void)enableAllChecks;
- (void)disableAllChecks;
- (NSArray *)trackListForSingleFile;
- (void)setTitle:(NSString *)str;
- (void)setDriveStr:(NSString *)str;
- (NSString *)driveStr;
- (NSData *)accurateRipData;
- (xldoffset_t)firstAudioFrame;
- (xldoffset_t)lastAudioFrame;
- (BOOL)isCompilation;
- (NSArray *)trackListForDecoder:(id)decoder withEmbeddedCueData:(NSString *)cueData;
- (NSArray *)trackListForDecoder:(id)decoder withEmbeddedTrackList:(NSArray *)tracks;
- (NSArray *)trackListForExternalCueSheet:(NSString *)file;
- (NSString *)artistForTracks:(NSArray *)tracks;
@end
