//
//  XLDConverterTask.h
//  XLD
//
//  Created by tmkk on 07/11/14.
//  Copyright 2007 tmkk. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XLDTrack.h"
#import "XLDCustomClasses.h"

@interface XLDConverterTask : NSObject {
	id encoder;
	Class decoderClass;
	id encoderTask;
	id decoder;
	NSMutableArray *encoderArray;
	NSMutableArray *encoderTaskArray;
	XLDTrack *track;
	NSString *inFile;
	NSString *outDir;
	xldoffset_t index;
	xldoffset_t totalFrame;
	BOOL fixOffset;
	int pcmType;
	BOOL tagWritable;
	XLDFormat rawFmt;
	XLDEndian rawEndian;
	int rawOffset;
	int processOfExistingFiles;
	BOOL embedImages;
	
	BOOL running;
	BOOL stopConvert;
	
	NSProgressIndicator *progress;
	NSButton *stopButton;
	NSTextField *nameField;
	NSTextField *statusField;
	NSTextField *speedField;
	
	id queue;
	XLDScaleType scaleType;
	float compressionQuality;
	int scaleSize;
	NSString *iTunesLib;
	//BOOL mountOnEnd;
	BOOL useParanoiaMode;
	int offsetCorrectionValue;
	int retryCount;
	NSMutableData *cueData;
	NSRange cueRange;
	id resultObj;
	int defeatPower;
	BOOL testMode;
	int offsetFixupValue;
	BOOL detectOffset;
	unsigned int *negativeSideSample;
	unsigned int *positiveSideSample;
	//float *replayGainSampleBuffer;
	//int replayGainSampleCount;
	//NSMutableArray *replayGainArray;
	int currentTrack;
	int totalTrack;
	
	double percent;
	double speed;
	double remainingSec;
	double remainingMin;
	BOOL useOldEngine;
	NSMutableArray *outputPathStrArray;
	xldoffset_t firstAudioFrame;
	xldoffset_t lastAudioFrame;
	BOOL useC2Pointer;
	XLDView *superview;
	int position;
	
	BOOL appendBOM;
	BOOL moveAfterFinish;
	NSString *tmpPathStr;
	NSString *dstPathStr;
	NSMutableArray *tmpPathStrArray;
}

- (id)initWithQueue:(id)q;
- (void)beginConvert;
- (void)stopConvert:(id)sender;
- (void)showProgressInView:(NSTableView *)view row:(int)row;
- (void)hideProgress;
- (void)setFixOffset:(BOOL)flag;
- (void)setIndex:(xldoffset_t)idx;
- (void)setTotalFrame:(xldoffset_t)frame;
- (void)setDecoderClass:(Class)dec;
- (void)setEncoder:(id)enc;
- (void)setEncoders:(id)enc;
- (void)setPCMType:(int)type;
- (void)setRawFormat:(XLDFormat)fmt;
- (void)setRawEndian:(XLDEndian)e;
- (void)setRawOffset:(int)offset;
- (void)setInputPath:(NSString *)path;
- (NSString *)outputDir;
- (void)setOutputDir:(NSString *)path;
- (void)setTagWritable:(BOOL)flag;
- (void)setTrack:(XLDTrack *)t;
- (void)setScaleType:(XLDScaleType)type;
- (void)setCompressionQuality:(float)quality;
- (void)setScaleSize:(int)pixel;
- (BOOL)isActive;
- (void)setiTunesLib:(NSString *)lib;
- (BOOL)isAtomic;
//- (void)setMountOnEnd;
- (void)useParanoiaMode:(BOOL)flag;
- (void)setOffsetCorrectionValue:(int)value;
- (void)setRetryCount:(int)value;
- (void)setCuesheet:(NSMutableData *)dat withNameRange:(NSRange)range;
- (void)setResultObj:(id)obj;
- (id)resultObj;
- (void)setTestMode;
- (void)setOffsetFixupValue:(int)value;
- (void)setUseOldEngine:(BOOL)flag;
- (void)setFirstAudioFrame:(xldoffset_t)frame;
- (void)setLastAudioFrame:(xldoffset_t)frame;
- (void)setUseC2Pointer:(BOOL)flag;
- (NSView *)progressView;
- (int)position;
- (void)setAppendBOM:(BOOL)flag;
- (void)setProcessOfExistingFiles:(int)value;
- (void)setEmbedImages:(BOOL)flag;
- (void)setMoveAfterFinish:(BOOL)flag;
@end
