// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import <sys/stat.h>
#import <fcntl.h>
#import <IOKit/scsi/IOSCSIMultimediaCommandsDevice.h>
#import <IOKit/storage/IOCDTypes.h>
#import <IOkit/storage/IOCDMediaBSDClient.h>
#import <DiskArbitration/DiskArbitration.h>
#import <cdio/cdio.h>
#import <cdio/cdda.h>
#import <cdio/paranoia.h>
#import "XLDController.h"
#import "XLDecoderCenter.h"
#import "XLDDecoder.h"
#import "XLDDefaultOutput.h"
#import "XLDDefaultOutputTask.h"
#import "XLDCueParser.h"
#import "XLDTrack.h"
#import "XLDOutput.h"
#import "XLDPlayer.h"
#import "XLDQueue.h"
#import "XLDConverterTask.h"
#import "XLDRawDecoder.h"
#import "XLDDragImageView.h"
#import "XLDMetadataEditor.h"
#import "XLDCDDARipper.h"
#import "XLDAccurateRipDB.h"
#import "XLDAccurateRipChecker.h"
#import "XLDDDPParser.h"
#import "XLDCustomClasses.h"

static NSString*    GeneralIdentifier = @"General";
static NSString*    BatchIdentifier = @"Batch";
static NSString*    CDDBIdentifier = @"CDDB";
static NSString*    MetadataIdentifier = @"Metadata";
static NSString*    CDRipIdentifier = @"CD Rip";

static void DADoneCallback(DADiskRef DiskRef, DADissenterRef DissenterRef, void *pvContext) 
{ 
    CFRunLoopStop(CFRunLoopGetCurrent()); 
}

static void diskAppeared(DADiskRef disk, void *context)
{
	//NSLog(@"%s",DADiskGetBSDName(disk));
	[(id)context performSelector:@selector(updateCDDAListAndMount:) withObject:[NSString stringWithUTF8String:(const char*)DADiskGetBSDName(disk)] afterDelay:1.0];
}

static void diskDisappeared(DADiskRef disk, void *context)
{
	[(id)context updateCDDAList:nil];
}

static int intSort(id num1, id num2, void *context)
{
    int v1 = [num1 intValue];
    int v2 = [num2 intValue];
	
    if (v1 < v2)
        return NSOrderedDescending;
    else if (v1 > v2)
        return NSOrderedAscending;
    else
        return NSOrderedSame;
}

static void myMkdir(NSString *base, NSString *dir)
{
	NSString *parent = [dir stringByDeletingLastPathComponent];
	if([parent isEqualToString:@""])
		mkdir([[base stringByAppendingPathComponent:dir] UTF8String], 0755);
	else {
		myMkdir(base, parent);
		mkdir([[base stringByAppendingPathComponent:dir] UTF8String], 0755);
	}
}

#define kAudioCDFilesystemID			(UInt16)(('J' << 8) | 'H' ) // 'JH'; this avoids compiler warning
#define CRCPOLY  0x1021U

#ifdef _BIG_ENDIAN
#define SWAP32(n) (n)
#define SWAP16(n) (n)
#else
#define SWAP32(n) (((n>>24)&0xff) | ((n>>8)&0xff00) | ((n<<8)&0xff0000) | ((n<<24)&0xff000000))
#define SWAP16(n) (((n>>8)&0xff) | ((n<<8)&0xff00))
#endif

#define MAX_SERVICE_NAME 1000

static unsigned int calc_crc(int n, unsigned char c[])
{
    unsigned int i, j, r;
	
    r = 0x0000U;
	for (i = 0; i < n; i++) {
		r ^= (unsigned short)c[i] << 8;
		for (j = 0; j < 8; j++) {
            if (r & 0x8000U) r = (r << 1) ^ CRCPOLY;
			else             r <<= 1;
		}
    }
    return ~r & 0xFFFFU;
}

static char isrc2Ascii(unsigned char c)
{
	if (c <= 9)
		return '0' + c;
	
	if (c >= 17 && c <= 42)
		return 'A' + (c - 17);
	
	return 0;
}

@implementation XLDController

- (NSArray *)coverArtFileListArray;
{
	NSCharacterSet* chSet;
    NSString* scannedName;
    NSScanner* scanner;
	NSMutableArray *arr = [NSMutableArray array];
    
    chSet = [NSCharacterSet characterSetWithCharactersInString:@" "];
    scanner = [NSScanner scannerWithString:[o_autoLoadCoverArtName stringValue]];
    while(![scanner isAtEnd]) {
        if([scanner scanUpToCharactersFromSet:chSet intoString:&scannedName]) {
			[arr addObject:scannedName];
        }
        [scanner scanCharactersFromSet:chSet intoString:nil];
    }
	return arr;
}

- (NSData *)dataForAutoloadCoverArtForFile:(NSString *)file fileListArray:(NSArray *)arr
{
	int i;
	NSData *imgData;
	for(i=0;i<[arr count];i++) {
		imgData = [NSData dataWithContentsOfFile:[[file stringByDeletingLastPathComponent] stringByAppendingPathComponent:[arr objectAtIndex:i]]];
		if(imgData) {
			NSImage *img = [[NSImage alloc] initWithData:imgData];
			if(img) {
				[img release];
				return imgData;
			}
		}
	}
	imgData = [NSData dataWithContentsOfFile:[[file stringByDeletingPathExtension] stringByAppendingPathExtension:@"jpg"]];
	if(imgData) {
		NSImage *img = [[NSImage alloc] initWithData:imgData];
		if(img) {
			[img release];
			return imgData;
		}
	}
	imgData = [NSData dataWithContentsOfFile:[[file stringByDeletingPathExtension] stringByAppendingPathExtension:@"png"]];
	if(imgData) {
		NSImage *img = [[NSImage alloc] initWithData:imgData];
		if(img) {
			[img release];
			return imgData;
		}
	}
	return nil;
}

- (NSString *)currentOutputFormatString
{
	if([[o_formatList selectedItem] tag] == 1) return @"";
	if([o_formatList indexOfSelectedItem] < 5) {
		switch([o_formatList indexOfSelectedItem]) {
			case 0:
				return @"WAV";
			case 1:
				return @"AIFF";
			case 2:
				return @"PCM (little endian)";
			case 3:
				return @"PCM (big endian)";
			case 4:
				return @"WAVE64";
			default:
				return @"";
		}
	}
	else return [[[outputArr objectAtIndex:[o_formatList indexOfSelectedItem]-5] class] pluginName];
}

- (NSString *)formatStringForOutput:(id)obj
{
	int i;
	if([NSStringFromClass([obj class]) isEqualToString:@"XLDDefaultOutput"]) {
		for(i=0;i<5;i++) {
			if([[multipleOutputFormatMatrix cellAtRow:i column:0] state] == NSOnState) {
				switch(i) {
					case 0:
						return @"WAV";
					case 1:
						return @"AIFF";
					case 2:
						return @"PCM (little endian)";
					case 3:
						return @"PCM (big endian)";
					case 4:
						return @"WAVE64";
					default:
						return @"";
				}
			}
		}
	}
	return [[obj class] pluginName];
}

- (id)currentOutputTask
{
	id output;
	if([o_formatList indexOfSelectedItem] < 5) {
		output = [defaultOutput createTaskForOutput];
		[output initOutputFormat];
		switch([o_formatList indexOfSelectedItem]) {
			case 0:
				[output setOutputFormatWAV];
				break;
			case 1:
				[output setOutputFormatAIFF];
				break;
			case 2:
				[output setOutputFormatLittleEndianLPCM];
				break;
			case 3:
				[output setOutputFormatBigEndianLPCM];
				break;
			case 4:
				[output setOutputFormatW64];
				break;
		}
	}
	else output = [[outputArr objectAtIndex:[o_formatList indexOfSelectedItem]-5] createTaskForOutput];
	
	return output;
}

- (id)currentOutputArray;
{
	int i;
	NSMutableArray *out = [[NSMutableArray alloc] init];
	for(i=0;i<[multipleOutputFormatMatrix numberOfRows];i++) {
		if([[multipleOutputFormatMatrix cellAtRow:i column:0] state] == NSOnState) {
			if(i<5) [out addObject:defaultOutput];
			else [out addObject:[outputArr objectAtIndex:i-5]];
		}
	}
	return [out autorelease];
}

- (NSString *)preferredFilenameForTrack:(id)trk index:(int)idx baseDir:(NSString *)outputDir createSubDir:(BOOL)createSubDir singleImageMode:(BOOL)singleImageMode albumArtist:aartist
{
	int j;
	NSString *outputSubDir = [NSString stringWithString:@""];
	NSMutableString *str;
	
	NSMutableString *name,*artist,*album,*albumartist,*composer,*genre;
	name = [[trk metadata] objectForKey:XLD_METADATA_TITLE];
	artist = [[trk metadata] objectForKey:XLD_METADATA_ARTIST];
	album = [[trk metadata] objectForKey:XLD_METADATA_ALBUM];
	composer = [[trk metadata] objectForKey:XLD_METADATA_COMPOSER];
	genre = [[trk metadata] objectForKey:XLD_METADATA_GENRE];
	if(aartist == nil) albumartist = artist;
	else albumartist = [aartist isEqualToString:@""] ? nil : aartist;
	if([[trk metadata] objectForKey:XLD_METADATA_COMPILATION] && ![[trk metadata] objectForKey:XLD_METADATA_ALBUMARTIST]) {
		if([[[trk metadata] objectForKey:XLD_METADATA_COMPILATION] boolValue])
			albumartist = (NSMutableString *)@"Compilations";
	}
	if(singleImageMode) {
		name = album;
		artist = albumartist;
	}
	
	if(name) {
		name = [NSMutableString stringWithString:name];
		[name replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [name length])];
		[name replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [name length])];
	}
	if(artist) {
		artist = [NSMutableString stringWithString:artist];
		[artist replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [artist length])];
		[artist replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [artist length])];
	}
	if(album) {
		album = [NSMutableString stringWithString:album];
		[album replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [album length])];
		[album replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [album length])];
	}
	if(albumartist) {
		albumartist = [NSMutableString stringWithString:albumartist];
		[albumartist replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [albumartist length])];
		[albumartist replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [albumartist length])];
	}
	if(composer) {
		composer = [NSMutableString stringWithString:composer];
		[composer replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [composer length])];
		[composer replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [composer length])];
	}
	if(genre) {
		genre = [NSMutableString stringWithString:genre];
		[genre replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [genre length])];
		[genre replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [genre length])];
	}
	
	if([[o_filenameFormatRadio selectedCell] tag] == 0) {
		if([[o_pregapRadio selectedItem] tag] == 2) {
			str = [NSMutableString stringWithString:[o_titleText stringValue]];
			[str replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [str length])];
			[str replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [str length])];
		}
		else {
			if(name && artist && ![name isEqualToString:@""] && ![artist isEqualToString:@""])
				str = [NSMutableString stringWithFormat:@"%02d %@ - %@",idx,artist,name];
			else if(name && ![name isEqualToString:@""])
				str = [NSMutableString stringWithFormat:@"%02d %@",idx,name];
			else if(artist && ![artist isEqualToString:@""])
				str = [NSMutableString stringWithFormat:@"%02d %@ - Track %02d",idx,artist,idx];
			else
				str = [NSMutableString stringWithFormat:@"%02d Track %02d",idx,idx];
		}
	}
	else {
		NSString *pattern = [[o_filenameFormat stringValue] stringByStandardizingPath];
		if([pattern characterAtIndex:[pattern length]-1] == '/') pattern = [pattern substringToIndex:[pattern length]-2];
		if([pattern characterAtIndex:0] == '/') pattern = [pattern substringFromIndex:1];
		str = [[[NSMutableString alloc] init] autorelease];
		for(j=0;j<[pattern length]-1;j++) {
			/* track number */
			if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%n"]) {
				[str appendFormat: @"%02d",idx];
				j++;
			}
			/* disc number */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%D"]) {
				if([[trk metadata] objectForKey:XLD_METADATA_DISC]) {
					[str appendFormat: @"%02d",[[[trk metadata] objectForKey:XLD_METADATA_DISC] intValue]];
				}
				else [str appendString:@"01"];
				j++;
			}
			/* title */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%t"]) {
				if(name && ![name isEqualToString:@""]) [str appendString: name];
				else [str appendString: @"Unknown Title"];
				j++;
			}
			/* artist */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%a"]) {
				if(artist && ![artist isEqualToString:@""]) [str appendString: artist];
				else [str appendString: @"Unknown Artist"];
				j++;
			}
			/* album title */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%T"]) {
				if(album && ![album isEqualToString:@""]) [str appendString: album];
				else [str appendString: @"Unknown Album"];
				j++;
			}
			/* album artist */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%A"]) {
				if(albumartist && ![albumartist isEqualToString:@""]) [str appendString: albumartist];
				else [str appendString: @"Unknown Artist"];
				j++;
			}
			/* composer */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%c"]) {
				if(composer && ![composer isEqualToString:@""]) [str appendString: composer];
				else [str appendString: @"Unknown Composer"];
				j++;
			}
			/* year */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%y"]) {
				NSNumber *year = [[trk metadata] objectForKey:XLD_METADATA_YEAR];
				if(year) [str appendString: [year stringValue]];
				else [str appendString: @"Unknown Year"];
				j++;
			}
			/* genre */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%g"]) {
				if(genre && ![genre isEqualToString:@""]) [str appendString: genre];
				else [str appendString: @"Unknown Genre"];
				j++;
			}
			/* isrc */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%i"]) {
				NSString *isrc = [[trk metadata] objectForKey:XLD_METADATA_ISRC];
				if(isrc && ![isrc isEqualToString:@""]) [str appendString: isrc];
				else [str appendString: @"NO_ISRC"];
				j++;
			}
			/* mcn */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%m"]) {
				NSString *mcn = [[trk metadata] objectForKey:XLD_METADATA_CATALOG];
				if(mcn && ![mcn isEqualToString:@""]) [str appendString: mcn];
				else [str appendString: @"NO_MCN"];
				j++;
			}
			/* discid */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%I"]) {
				NSNumber *discid = [[trk metadata] objectForKey:XLD_METADATA_FREEDBDISCID];
				if(discid) [str appendString: [NSString stringWithFormat:@"%08X", [discid unsignedIntValue]]];
				else [str appendString: @"NO_DISCID"];
				j++;
			}
			/* format */
			else if([[pattern substringWithRange:NSMakeRange(j,2)] isEqualToString:@"%f"]) {
				if([[o_formatList selectedItem] tag] == 1)
					[str appendString: @"[[[XLD_FORMAT_INDICATOR]]]"];
				else [str appendString: [self currentOutputFormatString]];
				j++;
			}
			else if(createSubDir && [[pattern substringWithRange:NSMakeRange(j,1)] isEqualToString:@"/"]) {
				if([[o_formatList selectedItem] tag] == 1) {
					outputSubDir = [outputSubDir stringByAppendingPathComponent:str];
					NSRange formatIndicatorRange = [outputSubDir rangeOfString:@"[[[XLD_FORMAT_INDICATOR]]]"];
					if(formatIndicatorRange.location != NSNotFound) {
						int k;
						for(k=0;k<[[self currentOutputArray] count];k++) {
							NSMutableString *replacedStr = [NSMutableString stringWithString:outputSubDir];
							[replacedStr replaceOccurrencesOfString:@"[[[XLD_FORMAT_INDICATOR]]]" withString:[self formatStringForOutput:[[self currentOutputArray] objectAtIndex:k]] options:0 range:NSMakeRange(0, [replacedStr length])];
							mkdir([[outputDir stringByAppendingPathComponent:replacedStr] UTF8String], 0755);
						}
					}
					else mkdir([[outputDir stringByAppendingPathComponent:outputSubDir] UTF8String], 0755);
					[str setString:@""];
				}
				else {
					outputSubDir = [outputSubDir stringByAppendingPathComponent:str];
					mkdir([[outputDir stringByAppendingPathComponent:outputSubDir] UTF8String], 0755);
					[str setString:@""];
				}
			}
			else {
				[str appendString: [pattern substringWithRange:NSMakeRange(j,1)]];
			}
		}
		if(j==[pattern length]-1) [str appendString: [pattern substringWithRange:NSMakeRange(j,1)]];
		if(!createSubDir || [[o_formatList selectedItem] tag] != 1)
			[str replaceOccurrencesOfString:@"[[[XLD_FORMAT_INDICATOR]]]" withString:[self currentOutputFormatString] options:0 range:NSMakeRange(0, [str length])];
		//NSLog(@"%@",outputSubDir);
	}
	
	return [outputSubDir stringByAppendingPathComponent:str];
}

- (BOOL)canHandleOutputForDecoder:(id)decoder
{
	int i;
	XLDFormat fmt;
	fmt.bps = [decoder bytesPerSample];
	fmt.channels = [decoder channels];
	fmt.samplerate = [decoder samplerate];
	fmt.isFloat = [decoder isFloat];
	
	if([[o_formatList selectedItem] tag] == 1) {
		BOOL fail = NO;
		id selectedOutputs = [self currentOutputArray];
		for(i=0;i<[selectedOutputs count];i++) {
			id outputTask = [[selectedOutputs objectAtIndex:i] createTaskForOutput];
			if(![(id <XLDOutputTask> )outputTask setOutputFormat:fmt]) fail = YES;
			[outputTask release];
		}
		if(fail) return NO;
	}
	else {
		id outputTask = [self currentOutputTask];
		if(![(id <XLDOutputTask> )outputTask setOutputFormat:fmt]) {
			[outputTask release];
			return NO;
		}
		[outputTask release];
	}
	return YES;
}

- (void)setOutputForTask:(XLDConverterTask *)task
{
	int i;
	if([[o_formatList selectedItem] tag] == 1) {
		[task setEncoders:[self currentOutputArray]];
		for(i=0;i<5;i++) {
			if([[multipleOutputFormatMatrix cellAtRow:i column:0] state] == NSOnState) [task setPCMType:i];
		}
	}
	else {
		if([o_formatList indexOfSelectedItem] < 5) {
			[task setEncoder:defaultOutput];
			[task setPCMType:[o_formatList indexOfSelectedItem]];
		}
		else [task setEncoder:[outputArr objectAtIndex:[o_formatList indexOfSelectedItem]-5]];
	}
}

- (void)imageLoadedFromOutside:(BOOL)flag
{
	if(flag) {
		[cueParser setCoverData:[o_cover imgData]];
		[o_saveImageMenu setEnabled:YES];
	}
	int i,j,k;
	NSBitmapImageRep *newRep = [NSBitmapImageRep imageRepWithData:[[o_cover image] TIFFRepresentation]];
	if([newRep bitsPerPixel] != 24 || [newRep samplesPerPixel] != 3) {
		[o_coverShadow setImage:nil];
		return;
	}
	int x = [newRep pixelsWide];
	int y = [newRep pixelsHigh];
	double alpha = 0.4;
	double step = (1-alpha)*3.0/y;
	unsigned char *after = (unsigned char*)malloc(x*y*4);
	unsigned char *src = [newRep bitmapData];
	for(i=0;i<y;i++) {
		for(j=0;j<x;j++) {
			for(k=0;k<3;k++) {
				int tmp = src[3*(x*(y-i-1)+j)+k]*(1-alpha)+255*alpha;
				if(tmp>255) tmp = 255;
				if(alpha >= 0.9) after[4*(x*i+j)+k] = 0;
				else after[4*(x*i+j)+k] = tmp;
			}
			if(alpha < 0.9) after[4*(x*i+j)+k] = 255;
			else after[4*(x*i+j)+k] = 0;
		}
		if(alpha<1) alpha += step;
		alpha = alpha > 1 ? 1 : alpha;
	}
	
	unsigned char *planes[1];
	planes[0] = after;
	NSBitmapImageRep *imgRep = [[NSBitmapImageRep alloc]
			initWithBitmapDataPlanes: planes
						  pixelsWide: x
						  pixelsHigh: y
					   bitsPerSample: 8
					 samplesPerPixel: 4
							hasAlpha: YES
							isPlanar: NO
					  colorSpaceName: @"NSCalibratedRGBColorSpace"
						 bytesPerRow: x*4
						bitsPerPixel: 32];
	NSImage *img = [[NSImage alloc] initWithData:[imgRep TIFFRepresentationUsingCompression:NSTIFFCompressionLZW factor:0]];
	//[img addRepresentation:imgRep];
	[img setBackgroundColor:[NSColor controlColor]];
	[img setCacheMode:NSImageCacheNever];
	[imgRep release];
	free(after);
	NSRect rect1 = [o_cover frame];
	//NSLog(@"%f,%f,%f,%f",rect2.origin.x,rect2.origin.y,rect1.origin.y,rect1.size.height);
	if(x>y) [o_coverShadow setFrameOrigin:NSMakePoint(21,rect1.origin.y-rect1.size.height+3-(rect1.size.width-rect1.size.height)/2)];
	else [o_coverShadow setFrameOrigin:NSMakePoint(21,rect1.origin.y-rect1.size.height+4)];
	
	[o_coverShadow setImage:img];
	[img release];
}

#pragma mark IBActions

- (IBAction)beginDecode:(id)sender
{
	int i,j;
	NSArray *trackList;
	id resultObj = nil;
	BOOL singleImageMode = NO;
	if([[o_pregapRadio selectedItem] tag] == 2) {
		trackList = [cueParser trackListForSingleFile];
		singleImageMode = YES;
	}
	else {
		trackList = [cueParser trackList];
		for(i=0;i<[trackList count];i++) {
			if([[trackList objectAtIndex:i] enabled]) break;
		}
		if(i==[trackList count]) return;
	}
	
	NSString *outputDir;
	if(tempOutputDir) {
		outputDir = [tempOutputDir autorelease];
		tempOutputDir = nil;
	}
	else if([[o_outputSelectRadio selectedCell] tag] == 0)
		outputDir = [[cueParser fileToDecode] stringByDeletingLastPathComponent];
	else
		outputDir = [o_outputDir stringValue];
	
	if(![[NSFileManager defaultManager] isWritableFileAtPath:outputDir]) {
		NSOpenPanel *op = [NSOpenPanel openPanel];
		[op setTitle:LS(@"Specify the output directory")];
		[op setCanChooseDirectories:YES];
		[op setCanChooseFiles:NO];
		[op setAllowsMultipleSelection:NO];
		if([op respondsToSelector:@selector(_setIncludeNewFolderButton:)])
			[op _setIncludeNewFolderButton:YES];
		else if([op respondsToSelector:@selector(setIncludeNewFolderButton:)] )
			[op setIncludeNewFolderButton:YES];
		
		int ret = [op runModalForDirectory:nil file:nil types:nil];
		if((ret != NSOKButton) || ![[NSFileManager defaultManager] isWritableFileAtPath:[op filename]]) 
		{
			NSRunCriticalAlertPanel(LS(@"error"), LS(@"no write permission"), @"OK", nil, nil);
			return;
		}
		outputDir = [op filename];
	}
	
	if(!strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9)) {
		if(!ejected) {
			tempOutputDir = [outputDir retain];
			[o_detectPregapPane setTitle:LS(@"Waiting")];
			[o_detectPregapMessage setStringValue:LS(@"Waiting for Drive...")];
			[o_detectPregapProgress setIndeterminate:YES];
			[o_detectPregapProgress startAnimation:self];
			[o_detectPregapPaneButton setHidden:YES];
			[o_detectPregapPane center];
			[o_detectPregapPane makeKeyAndOrderFront:nil];
			[NSThread detachNewThreadSelector:@selector(unmountDisc:) toTarget:self withObject:[cueParser fileToDecode]];
			return;
		}
		else {
			ejected = NO;
			//[o_detectPregapProgress stopAnimation:self];
			//[o_detectPregapPane close];
		}
	}
	
	id decoder;
	if([cueParser rawMode])
		decoder = [[[XLDRawDecoder alloc] initWithFormat:[cueParser rawFormat] endian:[cueParser rawEndian] offset:[cueParser rawOffset]] autorelease];
	else
		decoder = [decoderCenter preferredDecoderForFile:[cueParser fileToDecode]];
	
	if([NSStringFromClass([decoder class]) isEqualToString:@"XLDCDDARipper"]) {
		/*DASessionRef session = DASessionCreate(NULL);
		DASessionScheduleWithRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
		DADiskRef disk = DADiskCreateFromBSDName(NULL,session,[[cueParser fileToDecode] UTF8String]);
		DADiskUnmount(disk,kDADiskUnmountOptionDefault,DADoneCallback,NULL);
		int ret = CFRunLoopRunInMode(MY_RUN_LOOP_MODE, 120.0, false);
		if (ret == kCFRunLoopRunStopped) {
			DASessionUnscheduleFromRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
		}
		CFRelease(disk);
		CFRelease(session);
		CFRunLoopRunInMode(kCFRunLoopDefaultMode, 0, false);*/
		
		int fd = open([[cueParser fileToDecode] UTF8String],O_RDONLY);
		if(fd != -1) close(fd);
		else {
			NSRunCriticalAlertPanel(LS(@"error"), LS(@"Device is busy"), @"OK", nil, nil);
			return;
		}
		
		resultObj = [[XLDCDDAResult alloc] initWithTrackNumber:[[cueParser trackList] count]]; // warning!! this object is not freed in this method;
		[resultObj setDeviceStr:[cueParser fileToDecode]];
		[resultObj setDriveStr:[cueParser driveStr]];
		[resultObj setUseParanoia:([o_useParanoiaMode state] == NSOnState) ? YES : NO
				 offsetCorrention:[o_offsetCorrectionValue intValue]
					   retryCount:[o_maxRetryCount intValue]
				 useAccurateRipDB:(([o_queryAccurateRip state] == NSOnState) && ([[o_pregapRadio selectedItem] tag] != 1))
			   checkInconsistency:([o_verifySuspiciousSector state] == NSOnState)
					trustARResult:([o_arLogControl state] == NSOnState)
				   scanReplayGain:([o_scanReplayGain state] == NSOnState)
					 useOldEngine:([o_useOldEngine state] == NSOnState)
					 useC2Pointer:([o_useC2Pointer state] == NSOnState) && ([o_useParanoiaMode state] == NSOnState)
						gapStatus:([o_dontReadSubchannel state] << 16) | ([[o_pregapRadio selectedItem] tag]&0xffff)];
		[resultObj setDate:[NSDate date]];
		[resultObj setIncludeHTOA:([[o_pregapRadio selectedItem] tag] == 0 || [[o_pregapRadio selectedItem] tag] == 2) ? YES : NO];
		[resultObj setTOC:[cueParser trackList]];
		[resultObj setTitle:[o_titleText stringValue] andArtist:[cueParser artist]];
		[resultObj setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
		if(([o_saveLog state] == NSOnState) && (([[o_saveLogType selectedCell] tag] == 0) || ([[o_pregapRadio selectedItem] tag] == 2))) {
			NSMutableString *str = [NSMutableString stringWithString:[o_titleText stringValue]];
			[str replaceOccurrencesOfString:@"/" withString:LS(@"slash") options:0 range:NSMakeRange(0, [str length])];
			[str replaceOccurrencesOfString:@":" withString:LS(@"colon") options:0 range:NSMakeRange(0, [str length])];
			if([str length] > 240) {
				str = [NSMutableString stringWithString:[str substringToIndex:239]];
			}
			[resultObj setLogFileName:[str stringByAppendingPathExtension:@"log"]];
		}
		if([[o_pregapRadio selectedItem] tag] != 1) {
			[o_detectPregapMessage setStringValue:LS(@"Connecting to AccurateRip")];
			[o_detectPregapMessage display];
			//sleep(1);
			NSData *dbData = [cueParser accurateRipData];
			if(dbData) {
				//NSLog(@"db found");
				id db = [[XLDAccurateRipDB alloc] initWithData:dbData];
				[resultObj setAccurateRipDB:db];
				[db release];
			}
		}
		[o_detectPregapProgress stopAnimation:self];
		[o_detectPregapPane close];
	}
	
	[(id <XLDDecoder>)decoder openFile:(char *)[[cueParser fileToDecode] UTF8String]];
	
	
	if(![self canHandleOutputForDecoder:decoder]) {
		NSRunCriticalAlertPanel(LS(@"error"), LS(@"output does not support input format"), @"OK", nil, nil);
		return;
	}
	
	NSMutableArray *taskArray = [[NSMutableArray alloc] init];
	
	for(i=0;i<[trackList count];i++) {
		XLDTrack *trk = [trackList objectAtIndex:i];
		if(![trk enabled]) continue; 
		
		XLDConverterTask *task = [[XLDConverterTask alloc] initWithQueue:taskQueue];
		
		NSString *filename = [self preferredFilenameForTrack:trk index:i+1 baseDir:outputDir createSubDir:YES singleImageMode:singleImageMode albumArtist:[cueParser artist]];
		[trk setDesiredFileName:[filename lastPathComponent]];
		NSString *outputSubDir = [filename stringByDeletingLastPathComponent];
		
		xldoffset_t actualLength;
		xldoffset_t actualIndex;
		if((i==0) && ([trk gap] != 0) && ([[o_pregapRadio selectedItem] tag] == 0 || [[o_pregapRadio selectedItem] tag] == 2)) {
			if([trk frames] != -1) actualLength = [trk index] + [trk frames];
			else actualLength = [trk frames];
			actualIndex = 0;
		}
		else {
			actualLength = [trk frames];
			actualIndex = [trk index];
		}
		
		if(i<[trackList count]-1) actualLength += ([[o_pregapRadio selectedItem] tag] == 0 || [[o_pregapRadio selectedItem] tag] == 3) ? [[trackList objectAtIndex:i+1] gap] : 0;
		if(![NSStringFromClass([decoder class]) isEqualToString:@"XLDCDDARipper"]) {
			if(([o_correctOffset state] == NSOnState) && actualIndex < 30) {
				[task setFixOffset:YES];
				if(i == [trackList count]-1) actualLength = [decoder totalFrames] - actualIndex;
				actualLength -= (30 - actualIndex);
			}
			else if([o_correctOffset state] == NSOnState) {
				if(i == [trackList count]-1) actualLength = [decoder totalFrames] - actualIndex;
				actualIndex -= 30;
			}
		}
		
		[task setScaleType:([o_scaleImage state] == NSOffState) ? XLDNoScale : ([[o_scaleType selectedCell] tag] | (([o_expandImage state] == NSOnState) ? 0x10 : 0))];
		[task setScaleSize:[o_scalePixel intValue]];
		[task setCompressionQuality:[o_compressionQuality intValue]/100.0f];
		[task setIndex:actualIndex];
		[task setTotalFrame:actualLength];
		[task setDecoderClass:[decoder class]];
		if([cueParser rawMode]) {
			[task setRawFormat:[cueParser rawFormat]];
			[task setRawEndian:[cueParser rawEndian]];
			[task setRawOffset:[cueParser rawOffset]];
		}
		[self setOutputForTask:task];
		[task setInputPath:[cueParser fileToDecode]];
		if([outputSubDir length]) [task setOutputDir:[outputDir stringByAppendingPathComponent:outputSubDir]];
		else [task setOutputDir:outputDir];
		[task setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
		[task setTagWritable:([o_autoTagging state] == NSOnState) ? YES : NO];
		[task setEmbedImages:([o_embedCoverArts state] == NSOnState) ? YES : NO];
		[task setMoveAfterFinish:([o_moveAfterFinish state] == NSOnState) ? YES : NO];
		[task setTrack:trk];
		if([o_addiTunes state] == NSOnState)
			[task setiTunesLib:(![[o_libraryType selectedCell] tag]) ? @"library playlist 1" : [o_libraryName stringValue]];
		
		if([NSStringFromClass([decoder class]) isEqualToString:@"XLDCDDARipper"]) {
			driveIsBusy = YES;
			[task useParanoiaMode:([o_useParanoiaMode state] == NSOnState) ? YES : NO];
			[task setOffsetCorrectionValue:[o_offsetCorrectionValue intValue]];
			[task setRetryCount:[o_maxRetryCount intValue]];
			[task setResultObj:resultObj];
			[task setUseOldEngine:([o_useOldEngine state] == NSOnState)];
			[task setFirstAudioFrame:[cueParser firstAudioFrame]];
			[task setLastAudioFrame:[cueParser lastAudioFrame]];
			[task setUseC2Pointer:([o_useC2Pointer state] == NSOnState) && ([o_useParanoiaMode state] == NSOnState)];
			if(([o_testBeforeCopy state] == NSOnState) && (([[o_testType selectedCell] tag] == 0) || ![resultObj accurateRipDB] || ![[resultObj accurateRipDB] hasValidDataForTrack:i+1])) {
				BOOL testFlag = NO;
				if([[o_testType selectedCell] tag] == 0) testFlag = YES;
				else if(![resultObj accurateRipDB]) testFlag = YES;
				else if(([[o_pregapRadio selectedItem] tag] == 0 || [[o_pregapRadio selectedItem] tag] == 3) && ![[resultObj accurateRipDB] hasValidDataForTrack:i+1]) testFlag = YES;
				else if([[o_pregapRadio selectedItem] tag] == 2) {
					for(j=0;j<[[cueParser trackList] count];j++) {
						if(![[resultObj accurateRipDB] hasValidDataForTrack:j+1]) {
							testFlag = YES;
							break;
						}
					}
				}
				if(testFlag) {
					XLDConverterTask *testTask = [[XLDConverterTask alloc] initWithQueue:taskQueue];
					[testTask setTestMode]; //this should be earliar than setTrack
					[testTask setScaleType:XLDNoScale];
					[testTask setIndex:actualIndex];
					[testTask setTotalFrame:actualLength];
					[testTask setDecoderClass:[decoder class]];
					if([cueParser rawMode]) {
						[testTask setRawFormat:[cueParser rawFormat]];
						[testTask setRawEndian:[cueParser rawEndian]];
						[testTask setRawOffset:[cueParser rawOffset]];
					}
					[testTask setInputPath:[cueParser fileToDecode]];
					if([outputSubDir length]) [testTask setOutputDir:[outputDir stringByAppendingPathComponent:outputSubDir]];
					else [testTask setOutputDir:outputDir];
					[testTask setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
					[testTask setTagWritable:([o_autoTagging state] == NSOnState) ? YES : NO];
					[testTask setEmbedImages:([o_embedCoverArts state] == NSOnState) ? YES : NO];
					[testTask setTrack:trk]; //this should be later than setTestMode
					[testTask setEncoder:defaultOutput];
					[testTask setPCMType:0];
					[testTask setiTunesLib:nil];
					[testTask useParanoiaMode:([o_useParanoiaMode state] == NSOnState) ? YES : NO];
					[testTask setOffsetCorrectionValue:[o_offsetCorrectionValue intValue]];
					[testTask setRetryCount:[o_maxRetryCount intValue]];
					[testTask setResultObj:resultObj];
					[testTask setUseOldEngine:([o_useOldEngine state] == NSOnState)];
					[testTask setFirstAudioFrame:[cueParser firstAudioFrame]];
					[testTask setLastAudioFrame:[cueParser lastAudioFrame]];
					[testTask setUseC2Pointer:([o_useC2Pointer state] == NSOnState) && ([o_useParanoiaMode state] == NSOnState)];
					[taskArray addObject:testTask];
					[testTask release];
				}
			}
		}
		
		if([[o_pregapRadio selectedItem] tag] == 2) {
			[task setCuesheet:[cueParser cueData] withNameRange:[cueParser rangeForCuesheet]];
			[task setAppendBOM:([o_appendBOM state] == NSOnState) ? YES : NO];
		}
		
		[taskArray addObject:task];
		[task release];
	}
	[decoder closeFile];
	/*if([NSStringFromClass([decoder class]) isEqualToString:@"XLDCDDARipper"]) {
		[[taskArray objectAtIndex:[taskArray count]-1] setMountOnEnd];
	}*/
	[taskQueue addTasks:taskArray];
	[taskArray release];
	//decoding = YES;
}

- (IBAction)cancelDecode:(id)sender
{
	
}

- (IBAction)setOutputDir:(id)sender
{
	NSOpenPanel *op = [NSOpenPanel openPanel];
	[op setCanChooseDirectories:YES];
	[op setCanChooseFiles:NO];
	[op setAllowsMultipleSelection:NO];
	if([op respondsToSelector:@selector(_setIncludeNewFolderButton:)])
		[op _setIncludeNewFolderButton:YES];
	else if([op respondsToSelector:@selector(setIncludeNewFolderButton:)] )
		[op setIncludeNewFolderButton:YES];
	
	int ret = [op runModalForDirectory:nil file:nil types:nil];
	if(ret != NSOKButton) return;
	
	[o_outputDir setStringValue:[op filename]];
}

- (IBAction)openFile:(id)sender
{
	//if(decoding) return;
	NSOpenPanel *op = [NSOpenPanel openPanel];
	[op setCanChooseDirectories:YES];
	[op setCanChooseFiles:YES];
	[op setAllowsMultipleSelection:YES];
	
	int ret = [op runModalForDirectory:nil file:nil types:nil];
	if(ret != NSOKButton) return;
	
	[queue removeAllObjects];
	[queue addObjectsFromArray:[op filenames]];
	[self processQueue];
}

- (void)openRawFileWithDefaultPath:(NSString *)path
{
	NSOpenPanel *op = [NSOpenPanel openPanel];
	[op setCanChooseDirectories:NO];
	[op setCanChooseFiles:YES];
	[op setAllowsMultipleSelection:NO];
	NSRect origFrame = [o_rawFormatView frame];
	[op setAccessoryView:o_rawFormatView];
	
	int ret;
	if(path) ret = [op runModalForDirectory:[path stringByDeletingLastPathComponent] file:[path lastPathComponent] types:nil];
	else ret = [op runModalForDirectory:nil file:nil types:nil];
	[op setAccessoryView:nil];
	[o_rawFormatView setFrame:origFrame];
	if(ret != NSOKButton) return;
	
	XLDFormat fmt;
	fmt.samplerate = [o_rawSamplerate intValue];
	switch([o_rawBitDepth indexOfSelectedItem]) {
		case 0:
			fmt.bps = 1;
			break;
		case 1:
			fmt.bps = 2;
			break;
		case 2:
			fmt.bps = 3;
			break;
		case 3:
			fmt.bps = 4;
			break;
		default:
			fmt.bps = 2;
			break;
	}
	
	switch([o_rawChannels indexOfSelectedItem]) {
		case 0:
			fmt.channels = 2;
			break;
		case 1:
			fmt.channels = 1;
			break;
		default:
			fmt.channels = 2;
			break;
	}
	
	fmt.isFloat = 0;
	int endian;
	switch([o_rawEndian indexOfSelectedItem]) {
		case 0:
			endian = XLDBigEndian;
			break;
		case 1:
			endian = XLDLittleEndian;
			break;
		default:
			endian = XLDLittleEndian;
			break;
	}
	
	[self processRawFile:[op filename] withFormat:fmt endian:endian];
}

- (IBAction)openRawFile:(id)sender
{
	//if(decoding) return;
	[self openRawFileWithDefaultPath:nil];
}

- (IBAction)formatChanged:(id)sender
{
	if([[o_formatList selectedItem] tag] == 1) [o_formatOptionButton setEnabled:YES];
	else if([o_formatList indexOfSelectedItem] < 5) {
		[o_formatOptionButton setEnabled:YES];
	}
	else {
		if([[outputArr objectAtIndex:[o_formatList indexOfSelectedItem]-5] prefPane])
			[o_formatOptionButton setEnabled:YES];
		else [o_formatOptionButton setEnabled:NO];
	}
}

- (IBAction)showOption:(id)sender
{
	if([[o_formatList selectedItem] tag] == 1) {
		[NSApp beginSheet:o_multipleOutputFormatPanel
		   modalForWindow:o_prefPane
			modalDelegate:self
		   didEndSelector:@selector(sheetDidEnd:returnCode:contextInfo:)
			  contextInfo:@"PluginOption"];
	}
	else {
		NSView *view;
		if([o_formatList indexOfSelectedItem] < 5) {
			view = [defaultOutput prefPane];
		}
		else if(![[outputArr objectAtIndex:[o_formatList indexOfSelectedItem]-5] prefPane]) return;
		else view = [[outputArr objectAtIndex:[o_formatList indexOfSelectedItem]-5] prefPane];
		NSRect frame = [view frame];
		frame.size.height += 50;
		[o_pluginPrefPane setContentSize:frame.size];
		if([[o_pluginOptionContentView subviews] count])
			[[[o_pluginOptionContentView subviews] objectAtIndex:0] removeFromSuperview];
		[o_pluginOptionContentView addSubview:view];
		[NSApp beginSheet:o_pluginPrefPane
		   modalForWindow:o_prefPane
			modalDelegate:self
		   didEndSelector:@selector(sheetDidEnd:returnCode:contextInfo:)
			  contextInfo:@"PluginOption"];
	}
}

- (IBAction)hideOption:(id)sender
{
	[NSApp endSheet:[sender window] returnCode:0];
	[[sender window] close];
	[o_prefPane makeKeyAndOrderFront:self];
}

- (IBAction)checkSelected:(id)sender
{
	int i;
	id trackList = [cueParser trackList];
	if([sender tag] == 0) {
		for(i=0;i<[trackList count];i++) {
			if([o_tableView isRowSelected:i]) [cueParser checkAtIndex:i];
		}
	}
	else {
		for(i=0;i<[trackList count];i++) {
			[cueParser checkAtIndex:i];
		}
	}
}

- (IBAction)uncheckSelected:(id)sender
{
	int i;
	id trackList = [cueParser trackList];
	if([sender tag] == 0) {
		for(i=0;i<[trackList count];i++) {
			if([o_tableView isRowSelected:i]) [cueParser uncheckAtIndex:i];
		}
	}
	else {
		for(i=0;i<[trackList count];i++) {
			[cueParser uncheckAtIndex:i];
		}
	}
}

- (void)cddbGetTracksWithAutoStart:(BOOL)start
{
	[self addServerList:self];
	if(util) [util release];
	util = [[XLDCDDBUtil alloc] initWithDelegate:self];
	[util setTracks:[cueParser trackList] totalFrame:[cueParser totalFrames]];
	BOOL useProxy = ([o_cddbProxyEnabled state] == NSOnState) ? YES : NO;
	BOOL useCache = ([o_cddbUseCache state] == NSOnState) ? YES : NO;
	[util setUseProxy:useProxy];
	[util setUseCache:useCache];
	[util setServer:[o_cddbServer stringValue] port:[o_cddbServerPort intValue] path:[o_cddbServerPath stringValue]];
	if(useProxy) [util setProxyServer:[o_cddbProxyServer stringValue] port:[o_cddbProxyServerPort intValue] user:[o_cddbProxyUser stringValue] passwd:[o_cddbProxyPassword stringValue]];
	int ret = [util query];
	//NSLog(@"%d",ret);
	if(ret == 0) {
		if(start) [self performSelectorOnMainThread:@selector(beginDecode:) withObject:nil waitUntilDone:NO];
		else NSBeginInformationalAlertSheet(LS(@"CDDB connection"), @"OK", nil, nil, o_trackWindow, nil, nil, nil, NULL, LS(@"CDDB not found"));
		[util release];
		util = nil;
	}
	else if(ret == -1) {
		if(start) [self performSelectorOnMainThread:@selector(beginDecode:) withObject:nil waitUntilDone:NO];
		else NSBeginCriticalAlertSheet(LS(@"CDDB connection"), @"OK", nil, nil, o_trackWindow, nil, nil, nil, NULL, LS(@"CDDB connection failure"));
		[util release];
		util = nil;
	}
	else if(ret == 1 || (start && [o_dontPromptForCDDB state] == NSOnState)) {
		[util readCDDBWithInfo:[[util queryResult] objectAtIndex:0]];
		NSString *album = [[[[cueParser trackList] objectAtIndex:0] metadata] objectForKey:XLD_METADATA_ALBUM];
		if(album) {
			if([[[o_trackWindow title] substringWithRange:NSMakeRange(0,4)] isEqualToString:@"[AR]"])
				[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",album]]; 
			else [o_trackWindow setTitle:album];
			[o_titleText setStringValue:album];
		}
		[o_artistText setStringValue:[cueParser artist]];
		[o_tableView reloadData];
		if([util coverImg]) {
			[o_cover setImageWithResize:[util coverImg]];
			[cueParser setCoverData:[util coverData]];
			[self imageLoadedFromOutside:NO];
			[o_saveImageMenu setEnabled:YES];
		}
		
		if([self canSetCompilationFlag] && [cueParser isCompilation]) {
			int i;
			for(i=0;i<[[cueParser trackList] count];i++) [[[[cueParser trackList] objectAtIndex:i] metadata] setObject:[NSNumber numberWithBool:YES] forKey:XLD_METADATA_COMPILATION];
		}
		
		[util release];
		util = nil;
		if(start) {
			[self performSelectorOnMainThread:@selector(beginDecode:) withObject:nil waitUntilDone:NO];
		}
	}
	else {
		int i;
		NSArray *result = [util queryResult];
		[o_queryResultList removeAllItems];
		for(i=0;i<ret;i++) {
			if([[result objectAtIndex:i] count] == 5)
				[o_queryResultList addItemWithTitle:[NSString stringWithFormat:@"%d: %@ - %@ (%@)",i+1,[[result objectAtIndex:i] objectAtIndex:3],[[result objectAtIndex:i] objectAtIndex:4],[[result objectAtIndex:i] objectAtIndex:0]]];
			else
				[o_queryResultList addItemWithTitle:[NSString stringWithFormat:@"%d: %@ (%@)",i+1,[[result objectAtIndex:i] objectAtIndex:3],[[result objectAtIndex:i] objectAtIndex:0]]];
		}
		if(start) {
			[NSApp beginSheet:o_queryResultPane
			   modalForWindow:o_trackWindow
				modalDelegate:self
			   didEndSelector:@selector(sheetDidEnd:returnCode:contextInfo:)
				  contextInfo:@"CDDBQueryWithStart"];
		}
		else {
			[NSApp beginSheet:o_queryResultPane
			   modalForWindow:o_trackWindow
				modalDelegate:self
			   didEndSelector:@selector(sheetDidEnd:returnCode:contextInfo:)
				  contextInfo:@"CDDBQuery"];
		}
	}
}

- (IBAction)cddbGetTracks:(id)sender
{
	[self cddbGetTracksWithAutoStart:NO];
}

- (IBAction)closeQueryResult:(id)sender
{
	[NSApp endSheet:o_queryResultPane returnCode:[sender tag]];
	[o_queryResultPane close];
}

- (IBAction)addServerList:(id)sender
{
	NSString *server = [o_cddbServer stringValue];
	if([server isEqualToString:@""]) return;
	if([serverList containsObject:server]) [serverList removeObject:server];
	[serverList insertObject:server atIndex:0];
	if([serverList count] > 5) [serverList removeObjectAtIndex:5];
	[o_cddbServer setNumberOfVisibleItems:[serverList count]];
	[o_cddbServer reloadData];
}

- (IBAction)rawFormatSelected:(id)sender
{
	[NSApp stopModal];
	[o_rawFormatPane close];
}

- (IBAction)toggleSenderItem:(id)sender
{
	if([sender state] == NSOnState) [sender setState:NSOffState];
	else [sender setState:NSOnState];
}

- (IBAction)showWindow:(id)sender
{
	if([sender tag] == 0) [player showPlayer];
	else if([sender tag] == 1) [taskQueue showProgress];
	else if([sender tag] == 2) [o_logWindow makeKeyAndOrderFront:nil];
}

- (IBAction)saveImage:(id)sender
{
	if(![cueParser coverData]) return;
	NSSavePanel *sv = [NSSavePanel savePanel];
	NSString *defaultLocation = nil;
	if(strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9))
		defaultLocation = [[cueParser fileToDecode] stringByDeletingLastPathComponent];
	
	NSString *extensionStr;
	unsigned char *tmp = (unsigned char *)[[cueParser coverData] bytes];
	if (tmp[0] == 0xFF && tmp[1] == 0xD8) {
        extensionStr = @"jpg";
    } else if (tmp[0] == 0x89 && strncmp((const char *)&tmp[1], "PNG", 3) == 0) {
        extensionStr = @"png";
    } else if (strncmp((const char *)tmp, "GIF8", 4) == 0) { 
        extensionStr = @"gif";
    } else {
        extensionStr = @"";
    }
	if(![extensionStr isEqualToString:@""]) [sv setAllowedFileTypes:[NSArray arrayWithObject:extensionStr]];
	
	NSString *filename = [o_titleText stringValue];
	if([[[filename pathExtension] lowercaseString] isEqualToString:@"cue"])
		filename = [[cueParser title] stringByDeletingPathExtension];
	int ret = [sv runModalForDirectory:defaultLocation file:[filename stringByAppendingPathExtension:extensionStr]];
	if(ret != NSOKButton) return;
	
	[[cueParser coverData] writeToFile:[sv filename] atomically:YES];
}

- (IBAction)statusChanged:(id)sender
{
	if([o_addiTunes state] == NSOnState) {
		[o_libraryType setEnabled:YES];
		if([[o_libraryType selectedCell] tag]) [o_libraryName setEnabled:YES];
		else [o_libraryName setEnabled:NO];
	}
	else {
		[o_libraryType setEnabled:NO];
		[o_libraryName setEnabled:NO];
	}
	
	if([o_saveLog state] == NSOnState) {
		[o_saveLogType setEnabled:YES];
	}
	else {
		[o_saveLogType setEnabled:NO];
	}
	
	if([o_testBeforeCopy state] == NSOnState) {
		[o_testType setEnabled:YES];
	}
	else {
		[o_testType setEnabled:NO];
	}
	
	if([o_queryAccurateRip state] == NSOnState) {
		[o_arLogControl setEnabled:YES];
	}
	else {
		[o_arLogControl setEnabled:NO];
	}
	
	if([o_useParanoiaMode state] == NSOnState) {
		[o_useC2Pointer setEnabled:YES];
	}
	else {
		[o_useC2Pointer setEnabled:NO];
	}
	
	if([o_autoMountDisc state] == NSOnState) {
		[o_autoStartRipping setEnabled:YES];
	}
	else {
		[o_autoStartRipping setEnabled:NO];
	}
	
	if([o_limitExtension state] == NSOnState) {
		[o_extensionFilter setEnabled:YES];
	}
	else {
		[o_extensionFilter setEnabled:NO];
	}
	
	if([o_autoQueryCDDB state] == NSOnState) {
		[o_dontPromptForCDDB setEnabled:YES];
	}
	else {
		[o_dontPromptForCDDB setEnabled:NO];
	}
	
	if([o_embedCoverArts state] == NSOnState) {
		[o_scaleImage setEnabled:YES];
		[o_autoLoadCoverArt setEnabled:YES];
	}
	else {
		[o_scaleImage setEnabled:NO];
		[o_autoLoadCoverArt setEnabled:NO];
	}
	
	if([o_scaleImage state] == NSOnState && [o_embedCoverArts state] == NSOnState) {
		[o_scaleType setEnabled:YES];
		[o_scalePixel setEnabled:YES];
		[o_compressionQuality setEnabled:YES];
		[o_expandImage setEnabled:YES];
		[o_textGroup_1_1 setTextColor:[NSColor blackColor]];
		[o_textGroup_1_2 setTextColor:[NSColor blackColor]];
		[o_textGroup_1_3 setTextColor:[NSColor blackColor]];
		[o_textGroup_1_4 setTextColor:[NSColor blackColor]];
		[o_textGroup_1_5 setTextColor:[NSColor blackColor]];
	}
	else {
		[o_scaleType setEnabled:NO];
		[o_scalePixel setEnabled:NO];
		[o_compressionQuality setEnabled:NO];
		[o_expandImage setEnabled:NO];
		[o_textGroup_1_1 setTextColor:[NSColor grayColor]];
		[o_textGroup_1_2 setTextColor:[NSColor grayColor]];
		[o_textGroup_1_3 setTextColor:[NSColor grayColor]];
		[o_textGroup_1_4 setTextColor:[NSColor grayColor]];
		[o_textGroup_1_5 setTextColor:[NSColor grayColor]];
	}
	
	if([[o_filenameFormatRadio selectedCell] tag] == 0) {
		[o_filenameFormat setEnabled:NO];
	}
	else [o_filenameFormat setEnabled:YES];
	
	if([o_autoLoadCoverArt state] == NSOnState && [o_embedCoverArts state] == NSOnState) {
		[o_autoLoadCoverArtName setEnabled:YES];
		[o_autoLoadCoverArtDontOverwrite setEnabled:YES];
	}
	else {
		[o_autoLoadCoverArtName setEnabled:NO];
		[o_autoLoadCoverArtDontOverwrite setEnabled:NO];
	}
}

- (IBAction)multipleFormatSelectionChanged:(id)sender
{
	int selected=0,i,idx;
	if([multipleOutputFormatMatrix selectedRow] < 5) {
		for(i=0;i<5;i++) {
			if(i != [multipleOutputFormatMatrix selectedRow]) [[multipleOutputFormatMatrix cellAtRow:i column:0] setState:NSOffState];
		}
	}
	
	for(i=0;i<[multipleOutputFormatMatrix numberOfRows];i++) {
		if([[multipleOutputFormatMatrix cellAtRow:i column:0] state] == NSOnState) {
			selected++;
			idx = i;
		}
	}
	if(selected == 1) {
		for(i=0;i<[multipleOutputFormatMatrix numberOfRows];i++) {
			if(i == idx) [[multipleOutputFormatMatrix cellAtRow:i column:0] setEnabled:NO];
			else [[multipleOutputFormatMatrix cellAtRow:i column:0] setEnabled:YES];
		}
	}
	else if(selected == 2) {
		for(i=0;i<[multipleOutputFormatMatrix numberOfRows];i++) {
			if([[multipleOutputFormatMatrix cellAtRow:i column:0] state] == NSOnState) {
				[[multipleOutputFormatMatrix cellAtRow:i column:0] setEnabled:YES];
			}
		}
	}
}

- (IBAction)editMetadata:(id)sender
{
	int i;
	id trackList = [cueParser trackList];
	if([o_tableView numberOfSelectedRows] == 1) {
		[metadataEditor editTracks:trackList atIndex:[o_tableView selectedRow]];
	}
	else if([o_tableView numberOfSelectedRows] > 1) {
		NSMutableArray *arr = [[NSMutableArray alloc] init];
		for(i=0;i<[trackList count];i++) {
			if([o_tableView isRowSelected:i]) [arr addObject:[trackList objectAtIndex:i]];
		}
		[metadataEditor editAllTracks:arr];
		[arr release];
	}
	else return;
	
	[self tagsUpdated];
}

- (IBAction)readCDDA:(id)sender
{
	[o_detectPregapPane setTitle:LS(@"Detect Pregap")];
	[o_detectPregapMessage setStringValue:LS(@"Detecting Pregap...")];
	[o_detectPregapProgress setIndeterminate:NO];
	[o_detectPregapProgress setDoubleValue:0];
	[o_detectPregapPaneButton setHidden:YES];
	[o_detectPregapPane center];
	[o_detectPregapPane makeKeyAndOrderFront:nil];
	[NSThread detachNewThreadSelector:@selector(readPreGapOfDisc:) toTarget:self withObject:[sender title]];
}

- (void)updateCDDAListAndMount:(NSString *)device
{
	//NSLog(@"updateCDDAListAndMount called with %@",device);
	BOOL automount = NO;
	NSMenuItem *discToMount = nil;
	if(device && !driveIsBusy && !openingFiles && ([o_autoMountDisc state] == NSOnState)) automount = YES;
	OSErr	result = noErr;
    ItemCount	volumeIndex;
    long	systemVersion;
	
	int i,n=0;
	for(i=[o_openCDDA numberOfItems]-3;i>=0;i--) {
		[o_openCDDA removeItemAtIndex:i];
	}
	
    if (Gestalt(gestaltSystemVersion, &systemVersion) != noErr)
        systemVersion = 0;
    
    for (volumeIndex = 1; result == noErr || result != nsvErr; volumeIndex++)
	{
        FSVolumeRefNum	actualVolume;
        HFSUniStr255	volumeName;
        FSVolumeInfo	volumeInfo;
        
        bzero((void *) &volumeInfo, sizeof(volumeInfo));
        
        result = FSGetVolumeInfo(kFSInvalidVolumeRefNum,
                                 volumeIndex,
                                 &actualVolume,
                                 kFSVolInfoFSInfo,
                                 &volumeInfo,
                                 &volumeName,
                                 NULL); 
		
        if (result == noErr)
		{
            if ((systemVersion >= 0x00001000 && systemVersion < 0x00001010 &&
				 volumeInfo.signature == kAudioCDFilesystemID) ||
                volumeInfo.filesystemID == kAudioCDFilesystemID) // It's an audio CD
            {
				NSMenuItem *item = [[NSMenuItem alloc]initWithTitle:[NSString stringWithCharacters:volumeName.unicode length:volumeName.length] action:@selector(readCDDA:) keyEquivalent:@""];
				[item setTarget:self];
				if(n==0) [item setKeyEquivalent:@"O"];
				[o_openCDDA insertItem:item atIndex:n++];
				if(automount) {
					const char *devicePath = [[NSString stringWithFormat:@"/dev/%@",device] UTF8String];
					//NSLog(@"%s",devicePath);
					struct statfs fsstat;
					NSMutableString *tmpStr = [NSMutableString stringWithString:[item title]];
					[tmpStr replaceOccurrencesOfString:@"/" withString:@":" options:0 range:NSMakeRange(0, [tmpStr length])];
					statfs([[@"/Volumes" stringByAppendingPathComponent:tmpStr] UTF8String], &fsstat);
					if(!strcmp(devicePath, fsstat.f_mntfromname)) {
						struct stat st;
						stat([[@"/Volumes" stringByAppendingPathComponent:tmpStr] UTF8String], &st);
						//NSLog(@"%f",st.st_mtimespec.tv_sec - launchDate);
						if((st.st_mtimespec.tv_sec - launchDate) > -30) discToMount = item;
					}
					//NSLog(@"%s",fsstat.f_mntfromname);
				}
				[item release];
			}
        }
    }
	if(n==0) {
		NSMenuItem *item = [[NSMenuItem alloc]initWithTitle:LS(@"Audio CD Not Found") action:nil keyEquivalent:@""];
		[item setEnabled:NO];
		[o_openCDDA insertItem:item atIndex:0];
		[item release];
	}
	if(discToMount) [self readCDDA:discToMount];
}

- (IBAction)updateCDDAList:(id)sender
{
	[self updateCDDAListAndMount:nil];
}

- (IBAction)saveCuesheet:(id)sender
{
	NSSavePanel *sv = [NSSavePanel savePanel];
	NSString *defaultLocation = nil;
	if(strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9))
		defaultLocation = [[cueParser fileToDecode] stringByDeletingLastPathComponent];
	
	if([sender tag] == 0) {
		[sv setAllowedFileTypes:[NSArray arrayWithObject:@"cue"]];
		NSMutableData *data;
		[sv setAccessoryView:o_cuesheetTypeView];
		NSString *filename = [o_titleText stringValue];
		if([[[filename pathExtension] lowercaseString] isEqualToString:@"cue"])
			filename = [[cueParser title] stringByDeletingPathExtension];
		int ret = [sv runModalForDirectory:defaultLocation file:[filename stringByAppendingPathExtension:@"cue"]];
		if(ret != NSOKButton) return;
		
		unsigned char bom[] = {0xEF,0xBB,0xBF};
		if([[o_cuesheetType selectedCell] tag] == 0) {
			data = [cueParser cueData];
			NSRange range = [cueParser rangeForCuesheet];
			NSString *name;
			if(!strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9)) name = @"CDImage.wav";
			else name = [[cueParser fileToDecode] lastPathComponent];
			[data replaceBytesInRange:range withBytes:[[name dataUsingEncoding:NSUTF8StringEncoding] bytes] length:[[name dataUsingEncoding:NSUTF8StringEncoding] length]];
		}
		else data = [cueParser cueDataForSeparatedFiles:([[o_pregapRadio selectedItem] tag] != 3)];
		if([o_appendBOM state] == NSOnState) [data replaceBytesInRange:NSMakeRange(0,0) withBytes:bom length:3];
		[data writeToFile:[sv filename] atomically:YES];
	}
	else {
		[sv setAllowedFileTypes:[NSArray arrayWithObject:@"log"]];
		NSString *filename = [o_titleText stringValue];
		if([[[filename pathExtension] lowercaseString] isEqualToString:@"cue"])
			filename = [[cueParser title] stringByDeletingPathExtension];
		int ret = [sv runModalForDirectory:defaultLocation file:[filename stringByAppendingPathExtension:@"log"]];
		if(ret != NSOKButton) return;
		NSData *data = [[[o_logView textStorage] mutableString] dataUsingEncoding:NSUTF8StringEncoding];
		[data writeToFile:[sv filename] atomically:YES];
	}
	
}

- (IBAction)readModeChanged:(id)sender
{
	if([[sender selectedItem] tag] == 2) [cueParser disableAllChecks];
	else [cueParser enableAllChecks];
}

- (IBAction)checkAccurateRip:(id)sender
{
	id checker;
	NSData *dbData = [cueParser accurateRipData];
	if([sender tag] != 2) {
		if(!dbData) {
			NSBeginInformationalAlertSheet(@"AccurateRip", @"OK", nil, nil, o_trackWindow, nil, nil, nil, NULL, LS(@"AccurateRip hash not found"));
			return;
		}
	}
	checker = [[XLDAccurateRipChecker alloc] initWithTracks:[cueParser trackList] totalFrames:[cueParser totalFrames]];
	[checker setDelegate:self];
	if([sender tag] != 2) {
		id db = [[XLDAccurateRipDB alloc] initWithData:dbData];
		[checker setAccurateRipDB:db];
		[db release];
	}
	
	id decoder;
	if([cueParser rawMode])
		decoder = [[[XLDRawDecoder alloc] initWithFormat:[cueParser rawFormat] endian:[cueParser rawEndian] offset:[cueParser rawOffset]] autorelease];
	else
		decoder = [decoderCenter preferredDecoderForFile:[cueParser fileToDecode]];
	
	if([sender tag] == 0) [checker startCheckingForFile:[cueParser fileToDecode] withDecoder:decoder];
	else if([sender tag] == 1) [checker startOffsetCheckingForFile:[cueParser fileToDecode] withDecoder:decoder];
	else if([sender tag] == 2) [checker startReplayGainScanningForFile:[cueParser fileToDecode] withDecoder:decoder];
}

- (IBAction)saveOffsetCorrectedFile:(id)sender
{
	id decoder = [decoderCenter preferredDecoderForFile:[cueParser fileToDecode]];
	if(!decoder) return;
	
	[(id <XLDDecoder>)decoder openFile:(char *)[[cueParser fileToDecode] UTF8String]];
	
	if(![self canHandleOutputForDecoder:decoder]) {
		NSRunCriticalAlertPanel(LS(@"error"), LS(@"output does not support input format"), @"OK", nil, nil);
		[decoder closeFile];
		return;
	}
	
	NSString *outputDir;
	NSSavePanel *sv = [NSSavePanel savePanel];
	[sv setAccessoryView:o_offsetView];
	[sv setAllowedFileTypes:[NSArray arrayWithObject:[[cueParser fileToDecode] pathExtension]]];
	
	int ret = [sv runModalForDirectory:[[cueParser fileToDecode] stringByDeletingLastPathComponent] file:[NSString stringWithFormat:@"%@(offset fix)",[[[cueParser fileToDecode] lastPathComponent] stringByDeletingPathExtension]]];
	[o_offsetValue validateEditing];
	[o_offsetValue abortEditing];
	if(ret != NSOKButton) 
	{
		[decoder closeFile];
		return;
	}
	outputDir = [[sv filename] stringByDeletingLastPathComponent];
	
	XLDConverterTask *task = [[XLDConverterTask alloc] initWithQueue:taskQueue];
	XLDTrack *track = [[XLDTrack alloc] init];
	[track setSeconds:[decoder totalFrames]/[decoder samplerate]];
	[track setDesiredFileName:[[[sv filename] lastPathComponent] stringByDeletingPathExtension]];
	[track setMetadata:[decoder metadata]];
	if([decoder hasCueSheet] == XLDTrackTypeCueSheet) {
		[[track metadata] removeObjectForKey:XLD_METADATA_CUESHEET];
	}
	
	[task setScaleType:([o_scaleImage state] == NSOffState) ? XLDNoScale : ([[o_scaleType selectedCell] tag] | (([o_expandImage state] == NSOnState) ? 0x10 : 0))];
	[task setScaleSize:[o_scalePixel intValue]];
	[task setCompressionQuality:[o_compressionQuality intValue]/100.0f];
	[task setIndex:[track index]];
	[task setTotalFrame:[cueParser totalFrames]];
	[task setDecoderClass:[decoder class]];
	[self setOutputForTask:task];
	[task setInputPath:[cueParser fileToDecode]];
	[task setOutputDir:outputDir];
	[task setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
	[task setTagWritable:([o_autoTagging state] == NSOnState) ? YES : NO];
	[task setTrack:track];
	[task setOffsetFixupValue:[o_offsetValue intValue]];
	if([o_addiTunes state] == NSOnState)
		[task setiTunesLib:(![[o_libraryType selectedCell] tag]) ? @"library playlist 1" : [o_libraryName stringValue]];
	
	[decoder closeFile];
	
	[taskQueue addTask:task];
end:
		[track release];
	[task release];
}

- (IBAction)checkForUpdates:(id)sender
{
	if(updater) [updater checkForUpdates:sender];
}

- (IBAction)stopModal:(id)sender
{
	[NSApp stopModalWithCode:[sender tag]];
	[[NSApp modalWindow] close];
}

- (IBAction)analyzeCache:(id)sender
{
	[o_detectPregapMessage setStringValue:LS(@"Analyzing caching ability... (this may take a few minutes)")];
	[o_detectPregapProgress setIndeterminate:YES];
	[o_detectPregapProgress startAnimation:nil];
	[o_detectPregapPaneButton setHidden:YES];
	[NSApp beginSheet:o_detectPregapPane
	   modalForWindow:o_trackWindow
		modalDelegate:self
	   didEndSelector:@selector(sheetDidEnd:returnCode:contextInfo:)
		  contextInfo:@"AnalyzeCache"];
	[NSThread detachNewThreadSelector:@selector(analyzeCacheForDrive:) toTarget:self withObject:[cueParser fileToDecode]];
}

- (IBAction)cancelScan:(id)sender
{
	cancelScan = YES;
}

- (IBAction)openCoverImage:(id)sender
{
	NSOpenPanel *op = [NSOpenPanel openPanel];
	[op setCanChooseDirectories:NO];
	[op setCanChooseFiles:YES];
	[op setAllowsMultipleSelection:NO];
	
	int ret;
	ret = [op runModalForDirectory:nil file:nil types:nil];
	if(ret != NSOKButton) return;
	NSImage *img = [[NSImage alloc] initWithData:[NSData dataWithContentsOfFile:[op filename]]];
	if(!img) return;
	[o_cover setImageWithResize:img];
	[o_cover setImgData:[NSData dataWithContentsOfFile:[op filename]]];
	[self imageLoadedFromOutside:YES];
	[img release];
	[o_saveImageMenu setEnabled:YES];
}

- (IBAction)inputTagsFromText:(id)sender
{
	[metadataEditor inputTagsFromText];
}

- (IBAction)donate:(id)sender
{
	NSWorkspace* ws = [NSWorkspace sharedWorkspace];
	NSString *url;
	NSUserDefaults* defs = [NSUserDefaults standardUserDefaults];
	NSArray* languages = [defs objectForKey:@"AppleLanguages"];
	if([[languages objectAtIndex:0] isEqualToString:@"ja"]) {
		url = @"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=tmkk%40smoug%2enet&item_name=X%20Lossless%20Decoder&no_shipping=0&no_note=1&tax=0&currency_code=JPY&lc=JP&bn=PP%2dDonationsBF&charset=UTF%2d8";
	}
	else if([[languages objectAtIndex:0] isEqualToString:@"de"]
			|| [[languages objectAtIndex:0] isEqualToString:@"fr"]
			|| [[languages objectAtIndex:0] isEqualToString:@"nl"]
			|| [[languages objectAtIndex:0] isEqualToString:@"it"]
			|| [[languages objectAtIndex:0] isEqualToString:@"el"]) {
		url = @"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=tmkk%40smoug%2enet&item_name=X%20Lossless%20Decoder&no_shipping=0&no_note=1&tax=0&currency_code=EUR&lc=US&bn=PP%2dDonationsBF&charset=UTF%2d8";
	}
	else {
		url = @"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=tmkk%40smoug%2enet&item_name=X%20Lossless%20Decoder&no_shipping=0&no_note=1&tax=0&currency_code=USD&lc=US&bn=PP%2dDonationsBF&charset=UTF%2d8";
	}
	[ws openURL:[NSURL URLWithString:url]];
}

#pragma mark Normal Methods

- (id)init
{
	[super init];
	decoderCenter = [[XLDecoderCenter alloc] init];
	defaultOutput = [[XLDDefaultOutput alloc] init];
	cueParser = [[XLDCueParser alloc] initWithDelegate:self];
	player = [[XLDPlayer alloc] initWithDelegate:self];
	taskQueue = [[XLDQueue alloc] initWithDelegate:self];
	metadataEditor = [[XLDMetadataEditor alloc] initWithDelegate:self];
	//decoding = NO;
	util = nil;
	
	outputArr = [[NSMutableArray alloc] init];
	serverList = [[NSMutableArray alloc] initWithObjects:@"freedb.freedb.org",@"freedbtest.dyndns.org",nil];
	queue = [[NSMutableArray alloc] init];
	NSArray *bundleArr = [[NSBundle mainBundle] pathsForResourcesOfType:@"bundle" inDirectory:@"../PlugIns"];
	
	int i;
	NSBundle *bundle = nil;
	id output;
	for(i=0;i<[bundleArr count];i++) {
		bundle = [NSBundle bundleWithPath:[bundleArr objectAtIndex:i]];
		if(bundle) {
			if([bundle load]) {
				if([[bundle principalClass] conformsToProtocol:@protocol(XLDOutput)] && [[bundle principalClass] canLoadThisBundle]) {
					output = [[[bundle principalClass] alloc] init];
					[outputArr addObject:output];
					[output release];
				}
			}
		}
	}
	ejected = NO;
	launched = NO;
	firstDrag = YES;
	tempOutputDir = nil;
	driveIsBusy = NO;
	openingFiles = NO;
	launchDate = [[NSDate date] timeIntervalSince1970];
	
	updater = nil;
	bundle = [NSBundle bundleWithPath:[[NSBundle mainBundle] pathForResource:@"XLDSparkleUpdater" ofType:@"bundle" inDirectory:@"../PlugIns"]];
	if(bundle && [bundle load]) {
		if([[bundle principalClass] canLoadThisBundle]) {
			updater = [[[bundle principalClass] alloc] init];
		}
	}
	
	daSession = DASessionCreate(kCFAllocatorDefault);
	NSDictionary *matchedCD = [NSDictionary dictionaryWithObjects:[NSArray arrayWithObjects:@"IOCDMedia", [NSNumber numberWithBool:YES], nil]
														  forKeys:[NSArray arrayWithObjects:(NSString *)kDADiskDescriptionMediaKindKey, kDADiskDescriptionMediaWholeKey, nil]];

	DASessionScheduleWithRunLoop(daSession, CFRunLoopGetCurrent(), kCFRunLoopDefaultMode);
    DARegisterDiskAppearedCallback(daSession, (CFDictionaryRef)matchedCD, diskAppeared, self);
    DARegisterDiskDisappearedCallback(daSession, (CFDictionaryRef)matchedCD, diskDisappeared, self);
	
	return self;
}

- (id)table
{
	return o_tableView;
}

- (id)decoderCenter
{
	return decoderCenter;
}

/*- (BOOL)ignoreGap
{
	if([[o_pregapRadio selectedCell] tag] == 0) return NO;
	return YES;
}

- (BOOL)canOverwriteFile
{
	return ([o_overwriteButton state] == NSOnState) ? YES : NO;
}

- (BOOL)tagging
{
	return ([o_autoTagging state] == NSOnState) ? YES : NO;
}
*/

- (void)savePrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	[pref setObject:[o_outputDir stringValue] forKey:@"OutputDir"];
	[pref setInteger:[[o_pregapRadio selectedItem] tag] forKey:@"Pregap"];
	//[pref setInteger:[o_overwriteButton state] forKey:@"Overwrite"];
	//[pref setInteger:[o_formatList indexOfSelectedItem] forKey:@"OutputFormat"];
	[pref setObject:[o_formatList titleOfSelectedItem] forKey:@"OutputFormatName"];
	[pref setInteger:[[o_outputSelectRadio selectedCell] tag] forKey:@"SelectOutput"];
	[pref setInteger:[o_autoTagging state] forKey:@"Tagging"];
	[pref setInteger:[[o_filenameFormatRadio selectedCell] tag] forKey:@"FilenameFormatRadio"];
	[pref setObject:[o_filenameFormat stringValue] forKey:@"FilenameFormat"];
	[pref setObject:[o_cddbServer stringValue] forKey:@"CDDBServer"];
	[pref setObject:[o_cddbServerPath stringValue] forKey:@"CDDBServerPath"];
	[pref setObject:[o_cddbServerPort stringValue] forKey:@"CDDBServerPort"];
	[pref setObject:[o_cddbProxyServer stringValue] forKey:@"CDDBProxyServer"];
	[pref setObject:[o_cddbProxyUser stringValue] forKey:@"CDDBProxyUser"];
	[pref setObject:[o_cddbProxyPassword stringValue] forKey:@"CDDBProxyPasswd"];
	[pref setObject:[o_cddbProxyServerPort stringValue] forKey:@"CDDBProxyServerPort"];
	[pref setInteger:[o_cddbProxyEnabled state] forKey:@"CDDBUseProxy"];
	[pref setInteger:[o_cddbUseCache state] forKey:@"CDDBUseCache"];
	[pref setObject:serverList forKey:@"CDDBServerList"];
	[pref setInteger:[o_rawBitDepth indexOfSelectedItem] forKey:@"RawBitDepth"];
	[pref setInteger:[o_rawChannels indexOfSelectedItem] forKey:@"RawChannels"];
	[pref setInteger:[o_rawEndian indexOfSelectedItem] forKey:@"RawEndian"];
	[pref setObject:[o_rawSamplerate stringValue] forKey:@"RawSamplerate"];
	[pref setInteger:[o_correctOffset state] forKey:@"CorrectOffset"];
	//[pref setInteger:[o_cuesheetEncodings indexOfSelectedItem] forKey:@"CuesheetEncodings"];
	[pref setInteger:[[o_cuesheetEncodings selectedItem] tag] forKey:@"CuesheetEncodings2"];
	[pref setInteger:[self cddbQueryFlag] forKey:@"CDDBQueryFlag"];
	[pref setInteger:[o_maxThreads intValue] forKey:@"MaxThreads"];
	[pref setInteger:[o_scaleImage state] forKey:@"ScaleImage"];
	[pref setInteger:[[o_scaleType selectedCell] tag] forKey:@"ScaleType"];
	[pref setInteger:[o_scalePixel intValue] forKey:@"ScalePixel"];
	[pref setInteger:[o_compressionQuality intValue] forKey:@"CompressionQuality"];
	[pref setInteger:[o_editTags state] forKey:@"EditTags"];
	[pref setInteger:[o_addiTunes state] forKey:@"AddiTunes"];
	[pref setInteger:[[o_libraryType selectedCell] tag] forKey:@"LibraryType"];
	[pref setObject:[o_libraryName stringValue] forKey:@"LibraryName"];
	[pref setInteger:[o_useParanoiaMode state] forKey:@"UseParanoiaMode"];
	[pref setInteger:[o_maxRetryCount intValue] forKey:@"RetryCount"];
	[pref setInteger:[o_offsetCorrectionValue intValue] forKey:@"OffsetCorrectionValue"];
	[pref setInteger:[o_queryAccurateRip state] forKey:@"QueryAccurateRip"];
	[pref setInteger:[o_saveLog state] forKey:@"SaveLog"];
	[pref setInteger:[[o_saveLogType selectedCell] tag] forKey:@"SaveLogType"];
	[pref setInteger:[o_verifySuspiciousSector state] forKey:@"VerifySector"];
	[pref setInteger:[o_testBeforeCopy state] forKey:@"TestAndCopy"];
	[pref setInteger:[[o_testType selectedCell] tag] forKey:@"TestType"];
	[pref setInteger:[[o_cuesheetType selectedCell] tag] forKey:@"CuesheetType"];
	[pref setInteger:[o_arLogControl state] forKey:@"LogControl"];
	[pref setInteger:[o_scanReplayGain state] forKey:@"ScanReplayGain"];
	[pref setInteger:[o_useOldEngine state] forKey:@"UseOldEngine"];
	[pref setInteger:[o_useC2Pointer state] forKey:@"UseC2Pointer"];
	[pref setInteger:[o_autoSetOffsetValue state] forKey:@"AutoSetOffset"];
	[pref setInteger:[o_subdirectoryDepth intValue] forKey:@"SubdirectoryDepth"];
	[pref setInteger:[o_autoMountDisc state] forKey:@"AutoMountDisc"];
	[pref setInteger:[o_autoStartRipping state] forKey:@"AutoStartRipping"];
	[pref setInteger:[o_ejectWhenDone state] forKey:@"EjectWhenDone"];
	[pref setInteger:[o_quitWhenDone state] forKey:@"QuitWhenDone"];
	[pref setInteger:[o_autoQueryCDDB state] forKey:@"AutoQueryCDDB"];
	[pref setInteger:[o_limitExtension state] forKey:@"LimitExtension"];
	[pref setObject:[o_extensionFilter stringValue] forKey:@"ExtensionFilter"];
	[pref setInteger:[o_preserveDirectoryStructure state] forKey:@"PreserveDirectory"];
	[pref setInteger:[o_dontPromptForCDDB state] forKey:@"DontPrompt"];
	[pref setInteger:[o_forceReadCuesheet state] forKey:@"ForceReadCuesheet"];
	[pref setInteger:[o_appendBOM state] forKey:@"AppendBOM"];
	[pref setInteger:[[o_existingFile selectedCell] tag] forKey:@"ExistingFile"];
	[pref setInteger:[o_expandImage state] forKey:@"ExpandImage"];
	[pref setInteger:[o_autoLoadCoverArt state] forKey:@"AutoLoadCover"];
	[pref setObject:[o_autoLoadCoverArtName stringValue] forKey:@"AutoLoadCoverName"];
	[pref setInteger:[o_autoLoadCoverArtDontOverwrite state] forKey:@"AutoLoadCoverDontOverwrite"];
	[pref setInteger:[o_embedCoverArts state] forKey:@"EmbedImages"];
	[pref setInteger:[o_dontReadSubchannel state] forKey:@"DontReadSubchannel"];
	[pref setInteger:[o_moveAfterFinish state] forKey:@"MoveAfterFinish"];
	[pref setInteger:[o_autoSetCompilation state] forKey:@"AutoSetCompilation"];
	[pref setInteger:[o_preserveUnknownMetadata state] forKey:@"PreserveUnknownMetadata"];
	[pref setInteger:[o_keepTimeStamp state] forKey:@"KeepTimeStamp"];
	[pref setBool:[o_prefPane isVisible] forKey:@"PrefPaneVisible"];
	{
		int i;
		NSMutableArray *arr = [NSMutableArray array];
		for(i=0;i<[multipleOutputFormatMatrix numberOfRows];i++) {
			if([[multipleOutputFormatMatrix cellAtRow:i column:0] state] == NSOnState) {
				[arr addObject:[[multipleOutputFormatMatrix cellAtRow:i column:0] title]];
			}
		}
		[pref setObject:arr forKey:@"OutputFormatList"];
	}
	[pref synchronize];
}

- (void)loadPrefs
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	id obj;
	if(obj=[pref objectForKey:@"Pregap"]) {
		[o_pregapRadio selectItemAtIndex:[o_pregapRadio indexOfItemWithTag:[obj intValue]]];
	}
	if(obj=[pref objectForKey:@"OutputDir"]) {
		[o_outputDir setStringValue:obj];
	}
	else [o_outputDir setStringValue:[@"~/Music" stringByExpandingTildeInPath]];
	if(obj=[pref objectForKey:@"OutputFormatName"]) {
		if([o_formatList itemWithTitle:obj]) [o_formatList selectItemWithTitle:obj];
		[self formatChanged:self];
	}
	else if(obj=[pref objectForKey:@"OutputFormat"]) {
		if([obj intValue] < [o_formatList numberOfItems]-1) {
			if([obj intValue] < 4) [o_formatList selectItemAtIndex:[obj intValue]];
			else [o_formatList selectItemAtIndex:[obj intValue]+1];
		}
		[pref removeObjectForKey:@"OutputFormat"];
		[pref synchronize];
		[self formatChanged:self];
	}
	/*if(obj=[pref objectForKey:@"OutputFormat"]) {
		if([obj intValue] < [o_formatList numberOfItems]) {
			[o_formatList selectItemAtIndex:[obj intValue]];
		}
		[self formatChanged:self];
	}*/
	if(obj=[pref objectForKey:@"SelectOutput"]) {
		[o_outputSelectRadio selectCellWithTag:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"Tagging"]) {
		[o_autoTagging setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"FilenameFormatRadio"]) {
		[o_filenameFormatRadio selectCellWithTag:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"FilenameFormat"]) {
		[o_filenameFormat setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBServer"]) {
		[o_cddbServer setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBServerPath"]) {
		[o_cddbServerPath setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBServerPort"]) {
		[o_cddbServerPort setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBProxyServer"]) {
		[o_cddbProxyServer setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBProxyServerPort"]) {
		[o_cddbProxyServerPort setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBProxyUser"]) {
		[o_cddbProxyUser setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBProxyPasswd"]) {
		[o_cddbProxyPassword setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CDDBUseProxy"]) {
		[o_cddbProxyEnabled setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"CDDBUseCache"]) {
		[o_cddbUseCache setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"CDDBServerList"]) {
		[serverList removeAllObjects];
		[serverList addObjectsFromArray:obj];
		[o_cddbServer setNumberOfVisibleItems:[obj count]];
		[o_cddbServer reloadData];
	}
	if(obj=[pref objectForKey:@"RawBitDepth"]) {
		if([obj intValue] < [o_rawBitDepth numberOfItems]) [o_rawBitDepth selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"RawChannels"]) {
		if([obj intValue] < [o_rawChannels numberOfItems]) [o_rawChannels selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"RawEndian"]) {
		if([obj intValue] < [o_rawEndian numberOfItems]) [o_rawEndian selectItemAtIndex:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"RawSamplerate"]) {
		[o_rawSamplerate setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"CorrectOffset"]) {
		[o_correctOffset setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"CuesheetEncodings2"]) {
		int i;
		for(i=[o_cuesheetEncodings numberOfItems]-1;i>=0;i--) {
			if([[o_cuesheetEncodings itemAtIndex:i] tag] == [obj intValue]) {
				[o_cuesheetEncodings selectItemAtIndex:i];
				break;
			}
		}
	}
	else if(obj=[pref objectForKey:@"CuesheetEncodings"]) {
		if([obj intValue] == 0) {
			[o_cuesheetEncodings selectItemAtIndex:0];
		}
		else {
			const NSStringEncoding *encodingsArr = [NSString availableStringEncodings];
			int count = 0;
			while(*(encodingsArr+count)) count++;
			if([obj intValue]-2 < count) [o_cuesheetEncodings selectItemWithTitle:[NSString localizedNameOfStringEncoding:*(encodingsArr+[obj intValue]-2)]];
		}
	}
	if(obj=[pref objectForKey:@"CDDBQueryFlag"]) {
		int flag = [obj intValue];
		NSMenu *submenu = [o_cddbQueryItem submenu];
		if(flag & XLDCDDBQueryEmptyOnlyMask) [[submenu itemAtIndex:0] setState:NSOnState];
		else [[submenu itemAtIndex:0] setState:NSOffState];
		if(flag & XLDCDDBQueryDiscTitleMask) [[submenu itemAtIndex:2] setState:NSOnState];
		else [[submenu itemAtIndex:2] setState:NSOffState];
		if(flag & XLDCDDBQueryTrackTitleMask) [[submenu itemAtIndex:3] setState:NSOnState];
		else [[submenu itemAtIndex:3] setState:NSOffState];
		if(flag & XLDCDDBQueryArtistMask) [[submenu itemAtIndex:4] setState:NSOnState];
		else [[submenu itemAtIndex:4] setState:NSOffState];
		if(flag & XLDCDDBQueryGenreMask) [[submenu itemAtIndex:5] setState:NSOnState];
		else [[submenu itemAtIndex:5] setState:NSOffState];
		if(flag & XLDCDDBQueryYearMask) [[submenu itemAtIndex:6] setState:NSOnState];
		else [[submenu itemAtIndex:6] setState:NSOffState];
		if(flag & XLDCDDBQueryCoverArtMask) [[submenu itemAtIndex:7] setState:NSOnState];
		else [[submenu itemAtIndex:7] setState:NSOffState];
	}
	if(obj=[pref objectForKey:@"MaxThreads"]) {
		[o_maxThreads setIntValue:[obj intValue]];
		[o_maxThreads sendAction:[o_maxThreads action] to:[o_maxThreads target]];
	}
	else {
		int numThread;
		int size = sizeof(int);
		sysctlbyname("hw.activecpu",&numThread,&size,NULL,NULL);
		[o_maxThreads setIntValue:numThread];
		[o_maxThreads sendAction:[o_maxThreads action] to:[o_maxThreads target]];
	}
	if(obj=[pref objectForKey:@"ScaleImage"]) {
		[o_scaleImage setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"ScaleType"]) {
		[o_scaleType selectCellWithTag:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"ScalePixel"]) {
		[o_scalePixel setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"CompressionQuality"]) {
		[o_compressionQuality setIntValue:[obj intValue]];
		[o_compressionQuality performClick:nil];
	}
	if(obj=[pref objectForKey:@"EditTags"]) {
		[o_editTags setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AddiTunes"]) {
		[o_addiTunes setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"LibraryType"]) {
		[o_libraryType selectCellWithTag:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"LibraryName"]) {
		[o_libraryName setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"UseParanoiaMode"]) {
		[o_useParanoiaMode setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"RetryCount"]) {
		[o_maxRetryCount setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"OffsetCorrectionValue"]) {
		[o_offsetCorrectionValue setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"QueryAccurateRip"]) {
		[o_queryAccurateRip setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"SaveLog"]) {
		[o_saveLog setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"SaveLogType"]) {
		[o_saveLogType selectCellWithTag:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"VerifySector"]) {
		[o_verifySuspiciousSector setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"TestAndCopy"]) {
		[o_testBeforeCopy setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"TestType"]) {
		[o_testType selectCellWithTag:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"CuesheetType"]) {
		[o_cuesheetType selectCellWithTag:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"LogControl"]) {
		[o_arLogControl setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"ScanReplayGain"]) {
		[o_scanReplayGain setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"UseOldEngine"]) {
		[o_useOldEngine setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"UseC2Pointer"]) {
		[o_useC2Pointer setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AutoSetOffset"]) {
		[o_autoSetOffsetValue setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"SubdirectoryDepth"]) {
		[o_subdirectoryDepth setIntValue:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AutoMountDisc"]) {
		[o_autoMountDisc setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AutoStartRipping"]) {
		[o_autoStartRipping setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"EjectWhenDone"]) {
		[o_ejectWhenDone setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"QuitWhenDone"]) {
		[o_quitWhenDone setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AutoQueryCDDB"]) {
		[o_autoQueryCDDB setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"LimitExtension"]) {
		[o_limitExtension setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"ExtensionFilter"]) {
		[o_extensionFilter setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"PreserveDirectory"]) {
		[o_preserveDirectoryStructure setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"DontPrompt"]) {
		[o_dontPromptForCDDB setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"ForceReadCuesheet"]) {
		[o_forceReadCuesheet setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AppendBOM"]) {
		[o_appendBOM setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"ExistingFile"]) {
		[o_existingFile selectCellWithTag:[obj intValue]];
	}
	else if(obj=[pref objectForKey:@"Overwrite"]) {
		if([obj intValue] == NSOnState) [o_existingFile selectCellWithTag:2];
		else [o_existingFile selectCellWithTag:0];
	}
	if(obj=[pref objectForKey:@"ExpandImage"]) {
		[o_expandImage setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AutoLoadCover"]) {
		[o_autoLoadCoverArt setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AutoLoadCoverName"]) {
		[o_autoLoadCoverArtName setStringValue:obj];
	}
	if(obj=[pref objectForKey:@"AutoLoadCoverDontOverwrite"]) {
		[o_autoLoadCoverArtDontOverwrite setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"EmbedImages"]) {
		[o_embedCoverArts setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"DontReadSubchannel"]) {
		[o_dontReadSubchannel setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"MoveAfterFinish"]) {
		[o_moveAfterFinish setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"AutoSetCompilation"]) {
		[o_autoSetCompilation setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"PreserveUnknownMetadata"]) {
		[o_preserveUnknownMetadata setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"KeepTimeStamp"]) {
		[o_keepTimeStamp setState:[obj intValue]];
	}
	if(obj=[pref objectForKey:@"PrefPaneVisible"]) {
		if([obj boolValue]) [o_prefPane makeKeyAndOrderFront:nil];
	}
	else {
		NSFileManager *fm = [NSFileManager defaultManager];
		if(![fm fileExistsAtPath:[@"~/Library/Preferences/jp.tmkk.XLD.plist" stringByExpandingTildeInPath]]) {
			[o_prefPane center];
			[o_prefPane makeKeyAndOrderFront:nil];
		}
	}
	if(obj=[pref objectForKey:@"OutputFormatList"]) {
		int i,j;
		[[multipleOutputFormatMatrix cellAtRow:0 column:0] setEnabled:YES];
		[[multipleOutputFormatMatrix cellAtRow:0 column:0] setState:NSOffState];
		for(i=0;i<[multipleOutputFormatMatrix numberOfRows];i++) {
			for(j=0;j<[obj count];j++) {
				if([[[multipleOutputFormatMatrix cellAtRow:i column:0] title] isEqualToString:[obj objectAtIndex:j]]) {
					[multipleOutputFormatMatrix selectCellAtRow:i column:0];
					[self multipleFormatSelectionChanged:nil];
				}
			}
		}
	}
	
	if(updater) {
		if(![pref objectForKey:@"SUEnableAutomaticChecks"]) {
			[pref setBool:YES forKey:@"SUEnableAutomaticChecks"];
			[pref synchronize];
		}
		else if([pref objectForKey:@"TempUpdateKey"]) {
			[pref setBool:YES forKey:@"SUEnableAutomaticChecks"];
			[pref removeObjectForKey:@"TempUpdateKey"];
			[pref synchronize];
		}
	}
	else {
		[pref setBool:NO forKey:@"SUEnableAutomaticChecks"];
		[pref synchronize];
	}
}

- (void)playTrack
{
	if([o_tableView clickedRow] >= [[cueParser trackList] count]) return;
	if(!strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9)) return;
	if([cueParser rawMode])
		[player playRawFile:[cueParser fileToDecode]
				  withTrack:[cueParser trackList]
				  fromIndex:[o_tableView clickedRow]
				 withFormat:[cueParser rawFormat]
					 endian:[cueParser rawEndian]
					 offset:[cueParser rawOffset]];
	else
		[player playFile:[cueParser fileToDecode]
			   withTrack:[cueParser trackList]
			   fromIndex:[o_tableView clickedRow]];
	[player showPlayer];
}

- (NSString *)makeSubdirInDir:(NSString *)dir baseDir:(NSString *)base file:(NSString *)file
{
	if(!base || !file) return nil;
	NSRange range = [file rangeOfString:base options:NSCaseInsensitiveSearch];
	if(range.location != 0) return nil;
	NSString *subdir = [[base lastPathComponent] stringByAppendingPathComponent:[[file substringFromIndex:range.length] stringByDeletingLastPathComponent]];
	myMkdir(dir, subdir);
	//NSLog(subdir);
	return subdir;
}

- (void)processMultipleFilesInThread
{
	NSAutoreleasePool *pool2 = [[NSAutoreleasePool alloc] init];
	NSArray *coverArtFileListArray = [self coverArtFileListArray];
	int i,j;
	NSString *baseDir = nil;
	BOOL isDir;
	if(![queue count]) {
		[pool2 release];
		[o_detectPregapPane close];
		openingFiles = NO;
		return;
	}
	NSArray *sortedQueue = [queue sortedArrayUsingSelector:@selector(compare:)];
	//NSLog([sortedQueue description]);
	NSMutableArray *taskArray = [[NSMutableArray alloc] init];
	NSMutableArray *trackArray = [[NSMutableArray alloc] init];
	NSMutableArray *rangeArray = [[NSMutableArray alloc] init];
	int albumRangeIdx = 0;
	for(i=0;i<[sortedQueue count];i++) {
		if(cancelScan) {
			goto end;
		}
		[o_detectPregapProgress setDoubleValue:i];
		NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
		NSFileManager *fm = [NSFileManager defaultManager];
		NSString *file = [sortedQueue objectAtIndex:i];
		[fm fileExistsAtPath:file isDirectory:&isDir];
		if(isDir) {
			if([o_preserveDirectoryStructure state] == NSOffState) goto next;
			if(!baseDir) baseDir = [file retain];
			else {
				NSRange range = [file rangeOfString:baseDir options:NSCaseInsensitiveSearch];
				if(range.location != 0) {
					[baseDir release];
					baseDir = [file retain];
				}
			}
			goto next;
		}
		
		id decoder = [decoderCenter preferredDecoderForFile:file];
		BOOL externalCueMode = NO;
		if(!decoder) {
			XLDErr error;
			decoder = [cueParser decoderForCueSheet:file isRaw:NO promptIfNotFound:NO error:&error];
			if(!decoder) goto next;
			else {
				if(![self canHandleOutputForDecoder:decoder]) goto next;
				externalCueMode = YES;
			}
		}
		else {
			if(![(id <XLDDecoder>)decoder openFile:(char *)[file UTF8String]]) goto next;
			if(![self canHandleOutputForDecoder:decoder]) goto next;
		}
		
		NSString *outputDir;
		if([[o_outputSelectRadio selectedCell] tag] == 0)
			outputDir = [file stringByDeletingLastPathComponent];
		else {
			NSString *subDir = nil;
			if(baseDir) subDir = [self makeSubdirInDir:[o_outputDir stringValue] baseDir:baseDir file:file];
			if(subDir)
				outputDir = [[o_outputDir stringValue] stringByAppendingPathComponent:subDir];
			else {
				outputDir = [o_outputDir stringValue];
				if(baseDir) {
					[baseDir release];
					baseDir = nil;
				}
			}
		}
		
		if(![fm isWritableFileAtPath:outputDir]) {
			NSRunCriticalAlertPanel(LS(@"error"), LS(@"no write permission"), @"OK", nil, nil);
			[pool release];
			goto end;
		}
		
		NSMutableArray *trackList;
		if(externalCueMode) {
			trackList = (NSMutableArray *)[cueParser trackListForExternalCueSheet:file];
			[rangeArray addObject:[NSValue valueWithRange:NSMakeRange([trackArray count],[trackList count])]];
			for(j=0;j<[trackList count];j++) {
				[[trackList objectAtIndex:j] setDesiredFileName:[NSString stringWithFormat:@"%@ - Track %d",[file lastPathComponent],j+1]];
				[[[trackList objectAtIndex:j] metadata] setObject:[file lastPathComponent] forKey:XLD_METADATA_ORIGINALFILENAME];
			}
		}
		else if([decoder hasCueSheet] && [o_forceReadCuesheet state] == NSOnState) {
			if([decoder hasCueSheet] == XLDTextTypeCueSheet)
				trackList = (NSMutableArray *)[cueParser trackListForDecoder:decoder withEmbeddedCueData:[decoder cueSheet]];
			else
				trackList = (NSMutableArray *)[cueParser trackListForDecoder:decoder withEmbeddedTrackList:[decoder cueSheet]];
			[rangeArray addObject:[NSValue valueWithRange:NSMakeRange([trackArray count],[trackList count])]];
			for(j=0;j<[trackList count];j++) {
				[[trackList objectAtIndex:j] setDesiredFileName:[NSString stringWithFormat:@"%@ - Track %d",[file lastPathComponent],j+1]];
				[[[trackList objectAtIndex:j] metadata] setObject:[file lastPathComponent] forKey:XLD_METADATA_ORIGINALFILENAME];
			}
		}
		else {
			trackList = [[[NSMutableArray alloc] init] autorelease];
			XLDTrack *track = [[XLDTrack alloc] init];
			[track setSeconds:[decoder totalFrames]/[decoder samplerate]];
			if(![NSStringFromClass([decoder class]) isEqualToString:@"XLDMP3Decoder"])
				[track setFrames:[decoder totalFrames]];
			[track setDesiredFileName:[[file lastPathComponent] stringByDeletingPathExtension]];
			[track setMetadata:[decoder metadata]];
			if([decoder hasCueSheet] == XLDTrackTypeCueSheet) {
				[[track metadata] removeObjectForKey:XLD_METADATA_CUESHEET];
			}
			if([o_keepTimeStamp state] == NSOnState) {
				NSDictionary *attrDic = [fm fileAttributesAtPath:file traverseLink:YES];
				if(attrDic) {
					[[track metadata] setObject:[attrDic fileCreationDate] forKey:XLD_METADATA_CREATIONDATE];
					[[track metadata] setObject:[attrDic fileModificationDate] forKey:XLD_METADATA_MODIFICATIONDATE];
				}
			}
			[[track metadata] setObject:[file lastPathComponent] forKey:XLD_METADATA_ORIGINALFILENAME];
			[trackList addObject:track];
			[track release];
		}
		
		NSData *imgData = nil;
		if([o_autoLoadCoverArt state] == NSOnState) {
			imgData = [self dataForAutoloadCoverArtForFile:file fileListArray:coverArtFileListArray];
		}
		
		for(j=0;j<[trackList count];j++) {
			XLDTrack *track = [trackList objectAtIndex:j];
			if(imgData && (![[track metadata] objectForKey:XLD_METADATA_COVER] || ([o_autoLoadCoverArtDontOverwrite state] == NSOffState))) {
				[[track metadata] setObject:imgData forKey:XLD_METADATA_COVER];
			}
			if([o_preserveUnknownMetadata state] == NSOffState) {
				int k;
				NSArray *keyArr = [[(XLDTrack *)track metadata] allKeys];
				for(k=[keyArr count]-1;k>=0;k--) {
					NSString *key = [keyArr objectAtIndex:k];
					NSRange range = [key rangeOfString:@"XLD_UNKNOWN_TEXT_METADATA_"];
					if(range.location != 0) continue;
					[[(XLDTrack *)track metadata] removeObjectForKey:key];
				}
			}
			XLDConverterTask *task = [[XLDConverterTask alloc] initWithQueue:taskQueue];
			[task setScaleType:([o_scaleImage state] == NSOffState) ? XLDNoScale : ([[o_scaleType selectedCell] tag] | (([o_expandImage state] == NSOnState) ? 0x10 : 0))];
			[task setScaleSize:[o_scalePixel intValue]];
			[task setCompressionQuality:[o_compressionQuality intValue]/100.0f];
			[task setIndex:[track index]];
			[task setTotalFrame:[track frames]];
			[task setDecoderClass:[decoder class]];
			[self setOutputForTask:task];
			if(externalCueMode) [task setInputPath:[decoder srcPath]];
			else [task setInputPath:file];
			[task setOutputDir:outputDir];
			[task setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
			[task setTagWritable:([o_autoTagging state] == NSOnState) ? YES : NO];
			[task setEmbedImages:([o_embedCoverArts state] == NSOnState) ? YES : NO];
			[task setMoveAfterFinish:([o_moveAfterFinish state] == NSOnState) ? YES : NO];
			//[task setTrack:track]; // not here, because the filename may be changed by tag editing
			if([o_addiTunes state] == NSOnState)
				[task setiTunesLib:(![[o_libraryType selectedCell] tag]) ? @"library playlist 1" : [o_libraryName stringValue]];
			[taskArray addObject:task];
			[task release];
		}
		[trackArray addObjectsFromArray:trackList];
		[decoder closeFile];
next:
		[pool release];
	}
	
	[o_detectPregapPane close];
	
	if(![trackArray count]) goto end;
	
	if([o_editTags state] == NSOnState) {
#if 0
		BOOL ret = [metadataEditor editSingleTracks:trackArray atIndex:0];
		if(!ret) goto end;
#else
		SEL selector = @selector(editSingleTracks:withAlbumRanges:andDispatchTasks:);
		NSMethodSignature* signature = [metadataEditor methodSignatureForSelector:selector];
		NSInvocation* invocation = [NSInvocation invocationWithMethodSignature:signature];
		[invocation setTarget:metadataEditor];
		[invocation setSelector:selector];
		[invocation setArgument:(void *)&trackArray atIndex:2];
		[invocation setArgument:(void *)&rangeArray atIndex:3];
		[invocation setArgument:(void *)&taskArray atIndex:4];
		[invocation retainArguments];
		[invocation performSelectorOnMainThread:@selector(invoke) withObject:nil waitUntilDone:YES];
		goto end;
#endif
	}
	
	for(i=0;i<[trackArray count];i++) {
		XLDTrack *track = [trackArray objectAtIndex:i];
		XLDConverterTask *task = [taskArray objectAtIndex:i];
		NSArray *albumArray = nil;
		if([[o_filenameFormatRadio selectedCell] tag] == 0 && [track enabled]) {
			[task setTrack:track];
			continue;
		}
		if([rangeArray count] && albumRangeIdx < [rangeArray count]) {
			NSRange range = [[rangeArray objectAtIndex:albumRangeIdx] rangeValue];
			if(i >= range.location && i < range.location+range.length) {
				albumArray = [trackArray subarrayWithRange:range];
				if(i == range.location+range.length-1) albumRangeIdx++;
			}
		}
		int trackNum = [[track metadata] objectForKey:XLD_METADATA_TRACK] ? [[[track metadata] objectForKey:XLD_METADATA_TRACK] intValue] : 1;
		NSString *filename = [self preferredFilenameForTrack:track index:trackNum baseDir:[task outputDir] createSubDir:YES singleImageMode:NO albumArtist:(albumArray?[cueParser artistForTracks:albumArray]:nil)];
		[track setDesiredFileName:[filename lastPathComponent]];
		NSString *subDir = [filename stringByDeletingLastPathComponent];
		if(![subDir isEqualToString:@""]) {
			[task setOutputDir:[[task outputDir] stringByAppendingPathComponent:subDir]];
		}
		[track setEnabled:YES];
		[task setTrack:track];
	}
	
	[taskQueue performSelectorOnMainThread:@selector(addTasks:) withObject:taskArray waitUntilDone:YES];
end:
	[taskArray release];
	[trackArray release];
	[rangeArray release];
	if(baseDir) [baseDir release];
	[queue removeAllObjects];
	[o_detectPregapPane close];
	[pool2 release];
	openingFiles = NO;
}

- (void)processMultipleFiles
{
	if([queue count] > 100) {
		openingFiles = YES;
		cancelScan = NO;
		[o_detectPregapPane setTitle:LS(@"Scanning")];
		[o_detectPregapMessage setStringValue:LS(@"Scanning Files...")];
		[o_detectPregapProgress setIndeterminate:NO];
		[o_detectPregapProgress setMaxValue:[queue count]-1];
		[o_detectPregapPaneButton setHidden:NO];
		[o_detectPregapPane center];
		[o_detectPregapPane makeKeyAndOrderFront:nil];
		[NSThread detachNewThreadSelector:@selector(processMultipleFilesInThread) toTarget:self withObject:nil];
	}
	else [self processMultipleFilesInThread];
}

- (void)processSingleFile:(NSString *)filename
{
	NSArray *coverArtFileListArray = [self coverArtFileListArray];
	id decoder = [decoderCenter preferredDecoderForFile:filename];
	if(decoder && [(id <XLDDecoder>)decoder openFile:(char *)[filename UTF8String]]) {
		if(([decoder hasCueSheet] == XLDTrackTypeCueSheet) || ([decoder hasCueSheet] == XLDTextTypeCueSheet)) {
			int ret = NSRunAlertPanel(LS(@"embedded cue sheet"), LS(@"read embedded cuesheet?"), @"OK", @"Cancel", nil);
			if(ret == NSAlertDefaultReturn) {
				if([decoder hasCueSheet] == XLDTrackTypeCueSheet) [cueParser openFile:filename withTrackData:[decoder cueSheet] decoder:decoder];
				else [cueParser openFile:filename withCueData:[decoder cueSheet] decoder:decoder];
				[o_tableView reloadData];
				[o_tableView deselectAll:nil];
				if([cueParser accurateRipData])
					[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",[cueParser title]]]; 
				else [o_trackWindow setTitle:[cueParser title]];
				[o_titleText setStringValue:[cueParser title]];
				[o_artistText setStringValue:[cueParser artist]];
				NSData *imgData = nil;
				if([o_autoLoadCoverArt state] == NSOnState) {
					imgData = [self dataForAutoloadCoverArtForFile:filename fileListArray:coverArtFileListArray];
				}
				if([cueParser coverData]) {
					if(imgData && ([o_autoLoadCoverArtDontOverwrite state] == NSOffState)) {
						NSImage *img = [[NSImage alloc] initWithData:imgData];
						[o_cover setImageWithResize:img];
						[img release];
						[cueParser setCoverData:imgData];
						[self imageLoadedFromOutside:NO];
						[o_saveImageMenu setEnabled:YES];
					}
					else {
						NSImage *img = [[NSImage alloc] initWithData:[cueParser coverData]];
						[o_cover setImageWithResize:img];
						[self imageLoadedFromOutside:NO];
						[img release];
						[o_saveImageMenu setEnabled:YES];
					}
				}
				else {
					if(imgData) {
						NSImage *img = [[NSImage alloc] initWithData:imgData];
						[o_cover setImageWithResize:img];
						[img release];
						[cueParser setCoverData:imgData];
						[self imageLoadedFromOutside:NO];
						[o_saveImageMenu setEnabled:YES];
					}
					else {
						NSImage *imgStr = [NSImage imageWithString:@"No Image" withFont:[NSFont boldSystemFontOfSize:30] withColor:[NSColor grayColor]];
						[o_cover setFrameSize:NSMakeSize([o_cover frame].size.width,[o_cover frame].size.width)];
						[o_cover setImage:imgStr];
						[o_coverShadow setImage:nil];
						[o_saveImageMenu setEnabled:NO];
					}
				}
				[self readModeChanged:o_pregapRadio];
				[o_trackWindow makeKeyAndOrderFront: self];
				[o_cddbGetTrackMenu setEnabled:YES];
				[decoder closeFile];
				if([o_autoQueryCDDB state] == NSOnState) {
					[self cddbGetTracks:nil];
				}
				return;
			}
		}
		if(![self canHandleOutputForDecoder:decoder]) {
			NSRunCriticalAlertPanel(LS(@"error"), LS(@"output does not support input format"), @"OK", nil, nil);
			[decoder closeFile];
			return;
		}
		
		NSString *outputDir;
		if([[o_outputSelectRadio selectedCell] tag] == 0)
			outputDir = [filename stringByDeletingLastPathComponent];
		else
			outputDir = [o_outputDir stringValue];
		if(![[NSFileManager defaultManager] isWritableFileAtPath:outputDir]) {
			NSOpenPanel *op = [NSOpenPanel openPanel];
			[op setTitle:LS(@"Specify the output directory")];
			[op setCanChooseDirectories:YES];
			[op setCanChooseFiles:NO];
			[op setAllowsMultipleSelection:NO];
			if([op respondsToSelector:@selector(_setIncludeNewFolderButton:)])
				[op _setIncludeNewFolderButton:YES];
			else if([op respondsToSelector:@selector(setIncludeNewFolderButton:)] )
				[op setIncludeNewFolderButton:YES];
			
			int ret = [op runModalForDirectory:nil file:nil types:nil];
			if((ret != NSOKButton) || ![[NSFileManager defaultManager] isWritableFileAtPath:[op filename]]) 
			{
				NSRunCriticalAlertPanel(LS(@"error"), LS(@"no write permission"), @"OK", nil, nil);
				[decoder closeFile];
				return;
			}
			outputDir = [op filename];
		}
		
		XLDConverterTask *task = [[XLDConverterTask alloc] initWithQueue:taskQueue];
		XLDTrack *track = [[XLDTrack alloc] init];
		[track setSeconds:[decoder totalFrames]/[decoder samplerate]];
		if(![NSStringFromClass([decoder class]) isEqualToString:@"XLDMP3Decoder"])
			[track setFrames:[decoder totalFrames]];
		[track setDesiredFileName:[[filename lastPathComponent] stringByDeletingPathExtension]];
		[track setMetadata:[decoder metadata]];
		if([decoder hasCueSheet] == XLDTrackTypeCueSheet) {
			[[track metadata] removeObjectForKey:XLD_METADATA_CUESHEET];
		}
		if([o_keepTimeStamp state] == NSOnState) {
			NSFileManager *fm = [NSFileManager defaultManager];
			NSDictionary *attrDic = [fm fileAttributesAtPath:filename traverseLink:YES];
			if(attrDic) {
				[[track metadata] setObject:[attrDic fileCreationDate] forKey:XLD_METADATA_CREATIONDATE];
				[[track metadata] setObject:[attrDic fileModificationDate] forKey:XLD_METADATA_MODIFICATIONDATE];
			}
		}
		[[track metadata] setObject:[filename lastPathComponent] forKey:XLD_METADATA_ORIGINALFILENAME];
		
		if(([o_autoLoadCoverArt state] == NSOnState) && (![[track metadata] objectForKey:XLD_METADATA_COVER] || ([o_autoLoadCoverArtDontOverwrite state] == NSOffState))) {
			NSData *imgData = [self dataForAutoloadCoverArtForFile:filename fileListArray:coverArtFileListArray];
			if(imgData) {
				[[track metadata] setObject:imgData forKey:XLD_METADATA_COVER];
			}
		}
		
		if([o_preserveUnknownMetadata state] == NSOffState) {
			int i;
			NSArray *keyArr = [[(XLDTrack *)track metadata] allKeys];
			for(i=[keyArr count]-1;i>=0;i--) {
				NSString *key = [keyArr objectAtIndex:i];
				NSRange range = [key rangeOfString:@"XLD_UNKNOWN_TEXT_METADATA_"];
				if(range.location != 0) continue;
				[[(XLDTrack *)track metadata] removeObjectForKey:key];
			}
		}
		
		[task setScaleType:([o_scaleImage state] == NSOffState) ? XLDNoScale : ([[o_scaleType selectedCell] tag] | (([o_expandImage state] == NSOnState) ? 0x10 : 0))];
		[task setScaleSize:[o_scalePixel intValue]];
		[task setCompressionQuality:[o_compressionQuality intValue]/100.0f];
		[task setIndex:[track index]];
		[task setTotalFrame:[track frames]];
		[task setDecoderClass:[decoder class]];
		[self setOutputForTask:task];
		[task setInputPath:filename];
		[task setOutputDir:outputDir];
		[task setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
		[task setTagWritable:([o_autoTagging state] == NSOnState) ? YES : NO];
		[task setEmbedImages:([o_embedCoverArts state] == NSOnState) ? YES : NO];
		[task setMoveAfterFinish:([o_moveAfterFinish state] == NSOnState) ? YES : NO];
		//[task setTrack:track]; //not here...
		if([o_addiTunes state] == NSOnState)
			[task setiTunesLib:(![[o_libraryType selectedCell] tag]) ? @"library playlist 1" : [o_libraryName stringValue]];
		
		[decoder closeFile];
		
		if([o_editTags state] == NSOnState) {
#if 0
			BOOL ret = [metadataEditor editSingleTracks:[NSArray arrayWithObject:track] atIndex:0];
			if(!ret) goto end;
#else
			id tracks = [NSArray arrayWithObject:track];
			id tasks = [NSArray arrayWithObject:task];
			SEL selector = @selector(editSingleTracks:withAlbumRanges:andDispatchTasks:);
			NSMethodSignature* signature = [metadataEditor methodSignatureForSelector:selector];
			NSInvocation* invocation = [NSInvocation invocationWithMethodSignature:signature];
			[invocation setTarget:metadataEditor];
			[invocation setSelector:selector];
			[invocation setArgument:(void *)&tracks atIndex:2];
			[invocation setArgument:(void *)&tasks atIndex:4];
			[invocation retainArguments];
			[invocation performSelectorOnMainThread:@selector(invoke) withObject:nil waitUntilDone:YES];
			goto end;
#endif
		}
		
		if([[o_filenameFormatRadio selectedCell] tag] == 0) {
			[task setTrack:track];
		}
		else {
			int trackNum = [[track metadata] objectForKey:XLD_METADATA_TRACK] ? [[[track metadata] objectForKey:XLD_METADATA_TRACK] intValue] : 1;
			NSString *filename = [self preferredFilenameForTrack:track index:trackNum baseDir:outputDir createSubDir:YES singleImageMode:NO albumArtist:nil];
			[track setDesiredFileName:[filename lastPathComponent]];
			NSString *subDir = [filename stringByDeletingLastPathComponent];
			if(![subDir isEqualToString:@""]) {
				[task setOutputDir:[outputDir stringByAppendingPathComponent:subDir]];
			}
			[task setTrack:track];
		}
		
		[taskQueue addTask:task];
end:
		[track release];
		[task release];
		return;
	}
	[decoder closeFile];
	XLDErr err = [(XLDCueParser *)cueParser openFile:filename];
	if(err == XLDNoErr) {
		[o_tableView reloadData];
		[o_tableView deselectAll:nil];
		if([cueParser accurateRipData])
			[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",[cueParser title]]]; 
		else [o_trackWindow setTitle:[cueParser title]];
		[o_titleText setStringValue:[cueParser title]];
		[o_artistText setStringValue:[cueParser artist]];
		NSData *imgData = nil;
		if([o_autoLoadCoverArt state] == NSOnState) {
			imgData = [self dataForAutoloadCoverArtForFile:filename fileListArray:coverArtFileListArray];
		}
		if([cueParser coverData]) {
			if(imgData && ([o_autoLoadCoverArtDontOverwrite state] == NSOffState)) {
				NSImage *img = [[NSImage alloc] initWithData:imgData];
				[o_cover setImageWithResize:img];
				[img release];
				[cueParser setCoverData:imgData];
				[self imageLoadedFromOutside:NO];
				[o_saveImageMenu setEnabled:YES];
			}
			else {
				NSImage *img = [[NSImage alloc] initWithData:[cueParser coverData]];
				[o_cover setImageWithResize:img];
				[self imageLoadedFromOutside:NO];
				[img release];
				[o_saveImageMenu setEnabled:YES];
			}
		}
		else {
			if(imgData) {
				NSImage *img = [[NSImage alloc] initWithData:imgData];
				[o_cover setImageWithResize:img];
				[img release];
				[cueParser setCoverData:imgData];
				[self imageLoadedFromOutside:NO];
				[o_saveImageMenu setEnabled:YES];
			}
			else {
				NSImage *imgStr = [NSImage imageWithString:@"No Image" withFont:[NSFont boldSystemFontOfSize:30] withColor:[NSColor grayColor]];
				[o_cover setFrameSize:NSMakeSize([o_cover frame].size.width,[o_cover frame].size.width)];
				[o_cover setImage:imgStr];
				[o_coverShadow setImage:nil];
				[o_saveImageMenu setEnabled:NO];
			}
		}
		[self readModeChanged:o_pregapRadio];
		[o_trackWindow makeKeyAndOrderFront: self];
		[o_cddbGetTrackMenu setEnabled:YES];
		if([o_autoQueryCDDB state] == NSOnState) {
			[self cddbGetTracks:nil];
		}
		
		return;
	}
	else if(err != XLDCancelErr) {
		XLDDDPParser *ddpParser = [[XLDDDPParser alloc] init];
		BOOL result = [ddpParser openDDPMS:filename];
		if(result) {
			NSMutableArray *arr = [ddpParser trackListArray];
			XLDFormat fmt;
			fmt.bps = 2;
			fmt.channels = 2;
			fmt.isFloat = 0;
			fmt.samplerate = 44100;
			XLDRawDecoder *decoder = [[XLDRawDecoder alloc] initWithFormat:fmt endian:XLDLittleEndian offset:[ddpParser offsetBytes]];
			[(id <XLDDecoder>)decoder openFile:(char *)[[ddpParser pcmFile] UTF8String]];
			[(XLDCueParser *)cueParser openRawFile:[ddpParser pcmFile] withTrackData:arr decoder:decoder];
			[decoder closeFile];
			[decoder release];
			
			[o_tableView reloadData];
			[o_tableView deselectAll:nil];
			if([cueParser accurateRipData])
				[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",[cueParser title]]]; 
			else [o_trackWindow setTitle:[cueParser title]];
			[o_titleText setStringValue:[cueParser title]];
			[o_artistText setStringValue:[cueParser artist]];
			NSImage *imgStr = [NSImage imageWithString:@"No Image" withFont:[NSFont boldSystemFontOfSize:30] withColor:[NSColor grayColor]];
			[o_cover setFrameSize:NSMakeSize([o_cover frame].size.width,[o_cover frame].size.width)];
			[o_cover setImage:imgStr];
			[o_coverShadow setImage:nil];
			[o_saveImageMenu setEnabled:NO];
			[self readModeChanged:o_pregapRadio];
			[o_trackWindow makeKeyAndOrderFront: self];
			[o_cddbGetTrackMenu setEnabled:YES];
			if([o_autoQueryCDDB state] == NSOnState) {
				[self cddbGetTracks:nil];
			}
			[ddpParser release];
			return;
		}
		[ddpParser release];
		int ret = NSRunCriticalAlertPanel(LS(@"error"), LS(@"unsupported input file"), @"OK", LS(@"Open as Raw PCM"), nil);
		if(ret == NSAlertAlternateReturn) {
			//[self openRawFileWithDefaultPath:filename];
			[o_rawFormatPaneContent addSubview:o_rawFormatView];
			[NSApp runModalForWindow: o_rawFormatPane];
			[o_rawFormatView removeFromSuperview];
			XLDFormat fmt;
			fmt.samplerate = [o_rawSamplerate intValue];
			switch([o_rawBitDepth indexOfSelectedItem]) {
				case 0:
					fmt.bps = 1;
					break;
				case 1:
					fmt.bps = 2;
					break;
				case 2:
					fmt.bps = 3;
					break;
				case 3:
					fmt.bps = 4;
					break;
				default:
					fmt.bps = 2;
					break;
			}
			
			switch([o_rawChannels indexOfSelectedItem]) {
				case 0:
					fmt.channels = 2;
					break;
				case 1:
					fmt.channels = 1;
					break;
				default:
					fmt.channels = 2;
					break;
			}
			
			fmt.isFloat = 0;
			int endian;
			switch([o_rawEndian indexOfSelectedItem]) {
				case 0:
					endian = XLDBigEndian;
					break;
				case 1:
					endian = XLDLittleEndian;
					break;
				default:
					endian = XLDLittleEndian;
					break;
			}
			[self processRawFile:filename withFormat:fmt endian:endian];
		}
	}
}

- (void)processRawFile:(NSString *)filename withFormat:(XLDFormat)fmt endian:(XLDEndian)e
{
	NSArray *coverArtFileListArray = [self coverArtFileListArray];
	if([[[filename pathExtension] lowercaseString] isEqualToString:@"cue"]) {
		XLDErr err = [(XLDCueParser *)cueParser openFile:filename withRawFormat:fmt endian:e];
		if(err == XLDNoErr) {
			[o_tableView reloadData];
			[o_tableView deselectAll:nil];
			if([cueParser accurateRipData])
				[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",[cueParser title]]]; 
			else [o_trackWindow setTitle:[cueParser title]];
			[o_titleText setStringValue:[cueParser title]];
			[o_artistText setStringValue:[cueParser artist]];
			if([cueParser coverData]) {
				NSImage *img = [[NSImage alloc] initWithData:[cueParser coverData]];
				[o_cover setImageWithResize:img];
				[self imageLoadedFromOutside:NO];
				[img release];
				[o_saveImageMenu setEnabled:YES];
			}
			else {
				NSData *imgData = [self dataForAutoloadCoverArtForFile:filename fileListArray:coverArtFileListArray];
				if(([o_autoLoadCoverArt state] == NSOnState) && imgData) {
					NSImage *img = [[NSImage alloc] initWithData:imgData];
					[o_cover setImageWithResize:img];
					[img release];
					[cueParser setCoverData:imgData];
					[self imageLoadedFromOutside:NO];
					[o_saveImageMenu setEnabled:YES];
				}
				else {
					NSImage *imgStr = [NSImage imageWithString:@"No Image" withFont:[NSFont boldSystemFontOfSize:30] withColor:[NSColor grayColor]];
					[o_cover setFrameSize:NSMakeSize([o_cover frame].size.width,[o_cover frame].size.width)];
					[o_cover setImage:imgStr];
					[o_coverShadow setImage:nil];
					[o_saveImageMenu setEnabled:NO];
				}
			}
			[self readModeChanged:o_pregapRadio];
			[o_trackWindow makeKeyAndOrderFront: self];
			[o_cddbGetTrackMenu setEnabled:YES];
			if([o_autoQueryCDDB state] == NSOnState) {
				[self cddbGetTracks:nil];
			}
			return;
		}
		else if(err != XLDCancelErr)
			NSRunCriticalAlertPanel(LS(@"error"), LS(@"unsupported input file"), @"OK", nil, nil);
		return;
	}
	XLDRawDecoder *decoder = [[XLDRawDecoder alloc] initWithFormat:fmt endian:e];
	if([(id <XLDDecoder>)decoder openFile:(char *)[filename UTF8String]]) {
		if(![self canHandleOutputForDecoder:decoder]) {
			NSRunCriticalAlertPanel(LS(@"error"), LS(@"output does not support input format"), @"OK", nil, nil);
			[decoder closeFile];
			[decoder release];
			return;
		}
		
		NSString *outputDir;
		if([[o_outputSelectRadio selectedCell] tag] == 0)
			outputDir = [filename stringByDeletingLastPathComponent];
		else
			outputDir = [o_outputDir stringValue];
		if(![[NSFileManager defaultManager] isWritableFileAtPath:outputDir]) {
			NSOpenPanel *op = [NSOpenPanel openPanel];
			[op setTitle:LS(@"Specify the output directory")];
			[op setCanChooseDirectories:YES];
			[op setCanChooseFiles:NO];
			[op setAllowsMultipleSelection:NO];
			if([op respondsToSelector:@selector(_setIncludeNewFolderButton:)])
				[op _setIncludeNewFolderButton:YES];
			else if([op respondsToSelector:@selector(setIncludeNewFolderButton:)] )
				[op setIncludeNewFolderButton:YES];
			
			int ret = [op runModalForDirectory:nil file:nil types:nil];
			if((ret != NSOKButton) || ![[NSFileManager defaultManager] isWritableFileAtPath:[op filename]]) 
			{
				NSRunCriticalAlertPanel(LS(@"error"), LS(@"no write permission"), @"OK", nil, nil);
				[decoder closeFile];
				[decoder release];
				return;
			}
			outputDir = [op filename];
		}
		
		XLDConverterTask *task = [[XLDConverterTask alloc] initWithQueue:taskQueue];
		XLDTrack *track = [[XLDTrack alloc] init];
		[track setSeconds:[decoder totalFrames]/[decoder samplerate]];
		[track setFrames:[decoder totalFrames]];
		[track setDesiredFileName:[[filename lastPathComponent] stringByDeletingPathExtension]];
		
		if([o_autoLoadCoverArt state] == NSOnState) {
			NSData *imgData = [self dataForAutoloadCoverArtForFile:filename fileListArray:coverArtFileListArray];
			if(imgData) {
				[[track metadata] setObject:imgData forKey:XLD_METADATA_COVER];
			}
		}
		
		[task setScaleType:([o_scaleImage state] == NSOffState) ? XLDNoScale : ([[o_scaleType selectedCell] tag] | (([o_expandImage state] == NSOnState) ? 0x10 : 0))];
		[task setScaleSize:[o_scalePixel intValue]];
		[task setCompressionQuality:[o_compressionQuality intValue]/100.0f];
		[task setIndex:[track index]];
		[task setTotalFrame:[track frames]];
		[task setDecoderClass:[decoder class]];
		[self setOutputForTask:task];
		[task setInputPath:filename];
		[task setOutputDir:outputDir];
		[task setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
		[task setTagWritable:([o_autoTagging state] == NSOnState) ? YES : NO];
		[task setEmbedImages:([o_embedCoverArts state] == NSOnState) ? YES : NO];
		[task setMoveAfterFinish:([o_moveAfterFinish state] == NSOnState) ? YES : NO];
		//[task setTrack:track]; //not here...
		[task setRawFormat:fmt];
		[task setRawEndian:e];
		[task setRawOffset:0];
		if([o_addiTunes state] == NSOnState)
			[task setiTunesLib:(![[o_libraryType selectedCell] tag]) ? @"library playlist 1" : [o_libraryName stringValue]];
		
		[decoder closeFile];
		
		if([o_editTags state] == NSOnState) {
			BOOL ret = [metadataEditor editSingleTracks:[NSArray arrayWithObject:track] atIndex:0];
			if(!ret) goto end;
		}
		
		if([[o_filenameFormatRadio selectedCell] tag] == 0) {
			[task setTrack:track];
		}
		else {
			int trackNum = [[track metadata] objectForKey:XLD_METADATA_TRACK] ? [[[track metadata] objectForKey:XLD_METADATA_TRACK] intValue] : 1;
			NSString *filename = [self preferredFilenameForTrack:track index:trackNum baseDir:outputDir createSubDir:YES singleImageMode:NO albumArtist:nil];
			[track setDesiredFileName:[filename lastPathComponent]];
			NSString *subDir = [filename stringByDeletingLastPathComponent];
			if(![subDir isEqualToString:@""]) {
				[task setOutputDir:[outputDir stringByAppendingPathComponent:subDir]];
			}
			[task setTrack:track];
		}
		
		[taskQueue addTask:task];
end:
		[track release];
		[task release];
	}
	[decoder release];
}

- (void)scanDirectory:(NSString *)dirPath depth:(int)depth manager:(NSFileManager *)mgr filter:(NSString *)filter
{
	int i;
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	NSArray *arr = [mgr directoryContentsAtPath:dirPath];
	for(i=0;i<[arr count];i++) {
		NSAutoreleasePool *pool2 = [[NSAutoreleasePool alloc] init];
		NSString *file = [arr objectAtIndex:i];
		BOOL isDir;
		[mgr fileExistsAtPath:[dirPath stringByAppendingPathComponent:file] isDirectory:&isDir];
		if(isDir) {
			if(![o_subdirectoryDepth intValue] || (depth < [o_subdirectoryDepth intValue]))
				[self scanDirectory:[dirPath stringByAppendingPathComponent:file] depth:depth+1 manager:mgr filter:filter];
			[pool2 release];
			continue;
		}
		if(filter) {
			NSRange formatIndicatorRange = [filter rangeOfString:[[file pathExtension] lowercaseString]];
			if(formatIndicatorRange.location != NSNotFound) {
				[queue addObject:[dirPath stringByAppendingPathComponent:file]];
			}
		}
		else {
			if([file characterAtIndex:0] != '.')
				[queue addObject:[dirPath stringByAppendingPathComponent:file]];
		}
		[pool2 release];
	}
	[pool release];
}

- (void)processQueue
{
	BOOL isDir;
	NSFileManager *mgr = [NSFileManager defaultManager];
	NSString *filter = ([o_limitExtension state] == NSOnState) ? [[o_extensionFilter stringValue] lowercaseString] : nil;
	[mgr fileExistsAtPath:[queue objectAtIndex:0] isDirectory:&isDir];
	firstDrag = YES;
	if(([queue count] == 1) && !isDir) {
		id obj = [[queue objectAtIndex:0] retain];
		[queue removeAllObjects];
		[self processSingleFile:obj];
		[obj release];
	}
	else {
		int i;
		int n = [queue count];
		for(i=0;i<n;i++) {
			[mgr fileExistsAtPath:[queue objectAtIndex:i] isDirectory:&isDir];
			if(isDir) {
				[queue replaceObjectAtIndex:i withObject:[[queue objectAtIndex:i] stringByAppendingString:@"/"]];
				[self scanDirectory:[queue objectAtIndex:i] depth:1 manager:mgr filter:filter];
			}
		}
		[self processMultipleFiles];
	}
}

- (int)offset
{
	return ([o_correctOffset state] == NSOnState) ? 30 : 0;
}

- (int)cddbQueryFlag
{
	int flag = 0;
	NSMenu *submenu = [o_cddbQueryItem submenu];
	if([[submenu itemAtIndex:0] state] == NSOnState) flag |= XLDCDDBQueryEmptyOnlyMask;
	if([[submenu itemAtIndex:2] state] == NSOnState) flag |= XLDCDDBQueryDiscTitleMask;
	if([[submenu itemAtIndex:3] state] == NSOnState) flag |= XLDCDDBQueryTrackTitleMask;
	if([[submenu itemAtIndex:4] state] == NSOnState) flag |= XLDCDDBQueryArtistMask;
	if([[submenu itemAtIndex:5] state] == NSOnState) flag |= XLDCDDBQueryGenreMask;
	if([[submenu itemAtIndex:6] state] == NSOnState) flag |= XLDCDDBQueryYearMask;
	if([[submenu itemAtIndex:7] state] == NSOnState) flag |= XLDCDDBQueryCoverArtMask;
	
	return flag;
}

#define READ_ISRC_MANUALLY 1

- (void)readPreGapOfDisc:(NSString *)volume
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	NSMutableString *tmpStr = [NSMutableString stringWithString:volume];
	[tmpStr replaceOccurrencesOfString:@"/" withString:@":" options:0 range:NSMakeRange(0, [tmpStr length])];
	//NSLog(@"%s",[[@"/Volumes" stringByAppendingPathComponent:tmpStr] UTF8String]);
	statfs([[@"/Volumes" stringByAppendingPathComponent:tmpStr] UTF8String], &statDisc);
	//NSLog(@"%s",stat.f_mntfromname);
	
	DASessionRef session = DASessionCreate(NULL);
	DASessionScheduleWithRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
	DADiskRef disk = DADiskCreateFromBSDName(NULL,session,statDisc.f_mntfromname);
	DADiskUnmount(disk,kDADiskUnmountOptionDefault,DADoneCallback,NULL);
	int ret = CFRunLoopRunInMode(MY_RUN_LOOP_MODE, 120.0, false);
	if (ret == kCFRunLoopRunStopped) {
		DASessionUnscheduleFromRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
	}
	CFRelease(disk);
	CFRelease(session);
	
	int i=0,frame=0,state=0;
	int errorCount = 0;
	int totalErrorCount = 0;
	BOOL success = NO;
#ifdef READ_ISRC_MANUALLY
	BOOL isrcRead;
	BOOL catalogRead = NO;
	char mcn[14];
	mcn[13] = 0;
#endif
	
	CdIo_t *p_cdio = cdio_open_osx(statDisc.f_mntfromname);
	//cdrom_drive_t* p_drive = cdio_cddap_identify_cdio(p_cdio,0,NULL);
	//NSLog(@"endian: %d",p_drive->bigendianp);
	//cdio_cddap_close_no_free_cdio(p_drive);
	if (p_cdio) {
		driveIsBusy = YES;
		cdio_hwinfo_t hw_info;
		NSString *driveStr = nil;
		if(cdio_get_hwinfo(p_cdio,&hw_info)) {
			driveStr = [NSString stringWithFormat:@"%s %s (revision %s)",hw_info.psz_vendor,hw_info.psz_model,hw_info.psz_revision];
			if([o_autoSetOffsetValue state] == NSOnState) {
				NSDictionary *dic = [NSDictionary dictionaryWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"offsetlist" ofType:@"plist"]];
				NSString *product = [NSString stringWithUTF8String:hw_info.psz_model];
				if([dic objectForKey:product]) {
					[o_offsetCorrectionValue setIntValue:[[dic objectForKey:product] intValue]];
				}
				else if([dic objectForKey:[product substringToIndex:[product length]-1]]) {
					[o_offsetCorrectionValue setIntValue:[[dic objectForKey:[product substringToIndex:[product length]-1]] intValue]];
				}
			}
		}
		NSMutableArray *trackArr = [[NSMutableArray alloc] init];
		track_t i_tracks = cdio_get_num_tracks(p_cdio);
		[o_detectPregapProgress setMaxValue:i_tracks-1];
		for(i=1;i<=i_tracks;i++) {
			//if(cdio_get_track_format(p_cdio,i) != TRACK_FORMAT_AUDIO) continue;
			XLDTrack *track = [[XLDTrack alloc] init];
			[track setIndex:cdio_get_track_lsn(p_cdio,i)*588];
			if((i==1) && ([track index] != 0)) [track setGap:[track index]];
			else [track setGap:0];
			[track setFrames:588*(1+cdio_get_track_last_lsn(p_cdio,i)-cdio_get_track_lsn(p_cdio,i))];
			[track setSeconds:[track frames]/44100];
			if(cdio_get_track_format(p_cdio,i) != TRACK_FORMAT_AUDIO) {
				[track setEnabled:NO];
				if(i != 1) {
					if(cdio_get_track_format(p_cdio,i-1) == TRACK_FORMAT_AUDIO) {
						[[trackArr objectAtIndex:i-2] setFrames:[[trackArr objectAtIndex:i-2] frames] - 11400*588];
						[[trackArr objectAtIndex:i-2] setSeconds:[[trackArr objectAtIndex:i-2] frames]/44100];
					}
				}
			}
			else {
				if(cdio_get_track_preemphasis(p_cdio,i) == 1) {
					//NSLog(@"pre emphasis");
					[[track metadata] setObject:[NSNumber numberWithBool:YES] forKey:XLD_METADATA_PREEMPHASIS];
				}
			}
			/*char *isrc = cdio_get_track_isrc(p_cdio,i-1);
			if(isrc) NSLog(@"isrc is %s",isrc);
			else NSLog(@"isrc undefined");*/
			/*
			cdtext_t* p_cdtext = cdio_get_cdtext(p_cdio,i);
			if(p_cdtext) {
				const char *isrcStr = cdtext_get_const(CDTEXT_ISRC,p_cdtext);
				if(isrcStr) {
					[[track metadata] setObject:[NSString stringWithUTF8String:isrcStr] forKey:XLD_METADATA_ISRC];
					NSLog(@"%s",isrcStr);
				}
			}
			 */
			[trackArr addObject:track];
			[track release];
			//NSLog(@"%d",cdio_get_track_sec_count(p_cdio,i));
		}
		
		cdio_destroy(p_cdio);
		
		int fd = open(statDisc.f_mntfromname, O_RDONLY);
		dk_cd_read_t sector;
		UInt8 buffer[2352+16];
		
		//sector.offset = ([disc startFrameAtTrack:1]-300)*(2352+16);
		sector.sectorArea = 0xf8 + kCDSectorAreaSubChannelQ;
		sector.sectorType = kCDSectorTypeCDDA;
		sector.reserved0080[0] = 0;
		sector.reserved0080[1] = 0;
		sector.reserved0080[2] = 0;
		sector.reserved0080[3] = 0;
		sector.reserved0080[4] = 0;
		sector.reserved0080[5] = 0;
		sector.bufferLength = sizeof(buffer);
		sector.buffer = buffer;
		
		/* read MCN and ISRC */
#if !defined(READ_ISRC_MANUALLY)
		dk_cd_read_isrc_t isrcbuf;
		dk_cd_read_mcn_t mcnbuf;
		isrcbuf.reserved0112[0] = 0;
		isrcbuf.reserved0112[1] = 0;
		mcnbuf.reserved0112[0] = 0;
		mcnbuf.reserved0112[1] = 0;
		{
			int result = ioctl(fd, DKIOCCDREADMCN, &mcnbuf);
			if(result != -1) {
				//NSLog(@"mcn: %s",mcnbuf.mcn);
				if(memcmp(mcnbuf.mcn,"0000000000000",13)) {
					for(i=0;i<[trackArr count];i++)
						[[[trackArr objectAtIndex:i] metadata] setObject:[NSString stringWithUTF8String:mcnbuf.mcn] forKey:XLD_METADATA_CATALOG];
				}
			}
		}
		for(i=0;i<[trackArr count];i++) {
			if(![[trackArr objectAtIndex:i] enabled]) continue;
			isrcbuf.track = i+1;
			int result = ioctl(fd, DKIOCCDREADISRC, &isrcbuf);
			if(result != -1) {
				//NSLog(@"isrc: %s",isrcbuf.isrc);
				if(strlen(isrcbuf.isrc)==12) [[[trackArr objectAtIndex:i] metadata] setObject:[NSString stringWithUTF8String:isrcbuf.isrc] forKey:XLD_METADATA_ISRC];
			}
		}
#endif
		if([o_dontReadSubchannel state] == NSOnState) goto readPregapLast;
		
		/*
		 state
		 0 : not a pregap
		 1 : suspicious
		 2 : pregap
		*/
#if 1
		for(i=1;i<[trackArr count];i++) {
			if(![[trackArr objectAtIndex:i-1] enabled]) continue;
			if(![[trackArr objectAtIndex:i] enabled]) continue;
			state = 0;
			frame = 0;
			BOOL firstQchannelRead = YES;
#ifdef READ_ISRC_MANUALLY
			isrcRead = NO;
#endif
			int beginOffset = 300;
			if([(XLDTrack *)[trackArr objectAtIndex:i-1] frames]/588 <= 300) {
				beginOffset = [(XLDTrack *)[trackArr objectAtIndex:i-1] frames]/588 - 1;
				firstQchannelRead = NO;
			}
			sector.offset = ([(XLDTrack *)[trackArr objectAtIndex:i] index]/588-beginOffset)*(2352+16);
			while(1) {
				int result = ioctl(fd, DKIOCCDREAD, &sector);
				if(result != -1) {
					if((buffer[2362]<<8 | buffer[2363]) == calc_crc(10, buffer+2352)) {
						errorCount = 0;
						
						if((buffer[2352] & 0xf) == 0x1) {
							if(firstQchannelRead) {
								if(buffer[2354] == 0) { // we are already in the pregap area at the 1st read!
									beginOffset += 75; // begin with 1 more seconds before the current position
									if([(XLDTrack *)[trackArr objectAtIndex:i-1] frames]/588 <= beginOffset) {
										beginOffset = [(XLDTrack *)[trackArr objectAtIndex:i-1] frames]/588 - 1;
										firstQchannelRead = NO;
									}
									sector.offset = ([(XLDTrack *)[trackArr objectAtIndex:i] index]/588-beginOffset)*(2352+16);
									continue;
								}
								else firstQchannelRead = NO;
							}
							if(state == 0) {
								if(buffer[2354] == 0) state = 1;
							}
							else if(state == 1) {
								if(buffer[2354] == 0) state = 2;
								else state = 0;
							}
							/*else {
							if(buffer[2354] != 0) break;
							}*/
							//if(i==14 || i==21) NSLog(@"%d",buffer[2354]);
						}
#ifdef READ_ISRC_MANUALLY
						else if((buffer[2352] & 0xf) == 0x3 && !isrcRead) {
							isrcRead = YES;
							char isrc[13];
							isrc[12] = 0;
							//NSLog(@"found ISRC at offset %d",sector.offset/(2352+16));
							isrc[0]  = isrc2Ascii((buffer[2353] >> 2) & 0x3f);
							isrc[1]  = isrc2Ascii(((buffer[2353] & 0x03) << 4) | ((buffer[2354] >> 4) & 0x0f));
							isrc[2]  = isrc2Ascii(((buffer[2354] & 0x0f) << 2) | ((buffer[2355] >> 6) & 0x03));
							isrc[3]  = isrc2Ascii(buffer[2355] & 0x3f);
							isrc[4]  = isrc2Ascii((buffer[2356] >> 2) & 0x3f);
							isrc[5]  = ((buffer[2357] >> 4) & 0x0f) + '0';
							isrc[6]  = (buffer[2357] & 0x0f) + '0';
							isrc[7]  = ((buffer[2358] >> 4) & 0x0f) + '0';
							isrc[8]  = (buffer[2358] & 0x0f) + '0';
							isrc[9]  = ((buffer[2359] >> 4) & 0x0f) + '0';
							isrc[10] = (buffer[2359] & 0x0f) + '0';
							isrc[11] = ((buffer[2360] >> 4) & 0x0f) + '0';
							//NSLog(@"isrc is: %s",isrc);
							if(strlen(isrc)==12) [[[trackArr objectAtIndex:i-1] metadata] setObject:[NSString stringWithUTF8String:isrc] forKey:XLD_METADATA_ISRC];
						}
						else if((buffer[2352] & 0xf) == 0x2 && !catalogRead) {
							catalogRead = YES;
							mcn[0]  = ((buffer[2353] >> 4) & 0x0f) + '0';
							mcn[1]  = (buffer[2353] & 0x0f) + '0';
							mcn[2]  = ((buffer[2354] >> 4) & 0x0f) + '0';
							mcn[3]  = (buffer[2354] & 0x0f) + '0';
							mcn[4]  = ((buffer[2355] >> 4) & 0x0f) + '0';
							mcn[5]  = (buffer[2355] & 0x0f) + '0';
							mcn[6]  = ((buffer[2356] >> 4) & 0x0f) + '0';
							mcn[7]  = (buffer[2356] & 0x0f) + '0';
							mcn[8]  = ((buffer[2357] >> 4) & 0x0f) + '0';
							mcn[9]  = (buffer[2357] & 0x0f) + '0';
							mcn[10] = ((buffer[2358] >> 4) & 0x0f) + '0';
							mcn[11] = (buffer[2358] & 0x0f) + '0';
							mcn[12] = ((buffer[2359] >> 4) & 0x0f) + '0';
							//NSLog(@"mcn is: %s",mcn);
						}
#endif
						success = YES;
					}
					else {
						if(!success) {
							totalErrorCount++;
							if(totalErrorCount == 100) goto readPregapLast;
						}
						errorCount++;
						//fprintf(stderr,"q-channel crc error at LBA %lld(%d)\n",sector.offset/(2352+16),errorCount);
						if(errorCount < 5) continue;
						else errorCount = 0;
					}
				}
				//else fprintf(stderr, "read error at LBA %lld\n",sector.offset/(2352+16));
				sector.offset+=2352+16;
				if(sector.offset > [(XLDTrack *)[trackArr objectAtIndex:i] index]/588*(2352+16)) {
					//if(i==14 || i==21) NSLog(@"end of track");
					/*if(state == 0) frame = -1;
					else frame = 0;*/
					break;
				}
				if(state > 0) frame++;
				else frame = 0;
			}
			[[trackArr objectAtIndex:i] setGap:frame*588];
			[[trackArr objectAtIndex:i-1] setFrames:[[trackArr objectAtIndex:i-1] frames] - frame*588];
			[o_detectPregapProgress setDoubleValue:i];
		}
#endif
#ifdef READ_ISRC_MANUALLY
		// read ISRC of the last audio track
		errorCount = 0;
		totalErrorCount = 0;
		for(i=[trackArr count]-1;i>=0;i--) {
			if([[trackArr objectAtIndex:i] enabled]) break;
		}
		if(i>=0) {
			sector.offset = ([(XLDTrack *)[trackArr objectAtIndex:i] index]/588)*(2352+16);
			while(1) {
				int result = ioctl(fd, DKIOCCDREAD, &sector);
				if(result != -1) {
					if((buffer[2362]<<8 | buffer[2363]) == calc_crc(10, buffer+2352)) {
						errorCount = 0;
						if((buffer[2352] & 0xf) == 0x3) {
							char isrc[13];
							isrc[12] = 0;
							//NSLog(@"found ISRC at offset %d",sector.offset/(2352+16));
							isrc[0]  = isrc2Ascii((buffer[2353] >> 2) & 0x3f);
							isrc[1]  = isrc2Ascii(((buffer[2353] & 0x03) << 4) | ((buffer[2354] >> 4) & 0x0f));
							isrc[2]  = isrc2Ascii(((buffer[2354] & 0x0f) << 2) | ((buffer[2355] >> 6) & 0x03));
							isrc[3]  = isrc2Ascii(buffer[2355] & 0x3f);
							isrc[4]  = isrc2Ascii((buffer[2356] >> 2) & 0x3f);
							isrc[5]  = ((buffer[2357] >> 4) & 0x0f) + '0';
							isrc[6]  = (buffer[2357] & 0x0f) + '0';
							isrc[7]  = ((buffer[2358] >> 4) & 0x0f) + '0';
							isrc[8]  = (buffer[2358] & 0x0f) + '0';
							isrc[9]  = ((buffer[2359] >> 4) & 0x0f) + '0';
							isrc[10] = (buffer[2359] & 0x0f) + '0';
							isrc[11] = ((buffer[2360] >> 4) & 0x0f) + '0';
							//NSLog(@"isrc is: %s",isrc);
							if(strlen(isrc)==12) [[[trackArr objectAtIndex:i] metadata] setObject:[NSString stringWithUTF8String:isrc] forKey:XLD_METADATA_ISRC];
						}
						else if((buffer[2352] & 0xf) == 0x2 && !catalogRead) {
							catalogRead = YES;
							mcn[0]  = ((buffer[2353] >> 4) & 0x0f) + '0';
							mcn[1]  = (buffer[2353] & 0x0f) + '0';
							mcn[2]  = ((buffer[2354] >> 4) & 0x0f) + '0';
							mcn[3]  = (buffer[2354] & 0x0f) + '0';
							mcn[4]  = ((buffer[2355] >> 4) & 0x0f) + '0';
							mcn[5]  = (buffer[2355] & 0x0f) + '0';
							mcn[6]  = ((buffer[2356] >> 4) & 0x0f) + '0';
							mcn[7]  = (buffer[2356] & 0x0f) + '0';
							mcn[8]  = ((buffer[2357] >> 4) & 0x0f) + '0';
							mcn[9]  = (buffer[2357] & 0x0f) + '0';
							mcn[10] = ((buffer[2358] >> 4) & 0x0f) + '0';
							mcn[11] = (buffer[2358] & 0x0f) + '0';
							mcn[12] = ((buffer[2359] >> 4) & 0x0f) + '0';
							//NSLog(@"mcn is: %s",mcn);
						}
						success = YES;
					}
					else {
						if(!success) {
							totalErrorCount++;
							if(totalErrorCount == 100) goto readPregapLast;
						}
						errorCount++;
						//fprintf(stderr,"q-channel crc error at LBA %lld(%d)\n",sector.offset/(2352+16),errorCount);
						if(errorCount < 5) continue;
						else errorCount = 0;
					}
				}
				//else fprintf(stderr, "read error at LBA %lld\n",sector.offset/(2352+16));
				sector.offset+=2352+16;
				if(sector.offset > ([(XLDTrack *)[trackArr objectAtIndex:i] index]/588 + 150)*(2352+16)) {
					//if(i==14 || i==21) NSLog(@"end of track");
					/*if(state == 0) frame = -1;
					else frame = 0;*/
					break;
				}
			}
		}
#endif
readPregapLast:
		close(fd);
		[o_detectPregapProgress setDoubleValue:i_tracks-1];
		[o_detectPregapPane close];
		driveIsBusy = NO;
#if READ_ISRC_MANUALLY
		if(catalogRead && memcmp(mcn,"0000000000000",13)) {
			for(i=0;i<[trackArr count];i++)
				[[[trackArr objectAtIndex:i] metadata] setObject:[NSString stringWithUTF8String:mcn] forKey:XLD_METADATA_CATALOG];
		}
#endif
		[self performSelectorOnMainThread:@selector(finishedReadingPregapWithTrackData:) withObject:trackArr waitUntilDone:YES];
		if(driveStr) [cueParser setDriveStr:driveStr];
		
		session = DASessionCreate(NULL);
		disk = DADiskCreateFromBSDName(NULL,session,statDisc.f_mntfromname);
		DADiskMount(disk,NULL,kDADiskMountOptionDefault,NULL,NULL);
		CFRelease(disk);
		CFRelease(session);
		
		[trackArr release];
		
	}
	else {
		[o_detectPregapPane close];
		NSRunCriticalAlertPanel(LS(@"error"), LS(@"Device is busy"), @"OK", nil, nil);
	}
	[pool release];
}

- (void)unmountDisc:(NSString *)dev
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	DASessionRef session = DASessionCreate(NULL);
	DASessionScheduleWithRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
	DADiskRef disk = DADiskCreateFromBSDName(NULL,session,[dev UTF8String]);
	DADiskUnmount(disk,kDADiskUnmountOptionDefault,DADoneCallback,NULL);
	int ret = CFRunLoopRunInMode(MY_RUN_LOOP_MODE, 120.0, false);
	if (ret == kCFRunLoopRunStopped) {
		DASessionUnscheduleFromRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
	}
	CFRelease(disk);
	CFRelease(session);
	
	ejected = YES;
	[self performSelectorOnMainThread:@selector(beginDecode:) withObject:nil waitUntilDone:NO];
	[pool release];
}

- (void)mountDisc:(NSString *)dev
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	[dev retain];
	
	DASessionRef session = DASessionCreate(NULL);
	DADiskRef disk = DADiskCreateFromBSDName(NULL,session,[dev UTF8String]);
	DADiskMount(disk,NULL,kDADiskMountOptionDefault,NULL,NULL);
	CFRelease(disk);
	CFRelease(session);
	
	[dev release];
	[pool release];
}

- (void)ejectDisc:(NSString *)dev
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	[dev retain];
	
	DASessionRef session = DASessionCreate(NULL);
	DADiskRef disk = DADiskCreateFromBSDName(NULL,session,[dev UTF8String]);
	DADiskEject(disk,kDADiskEjectOptionDefault,NULL,NULL);
	CFRelease(disk);
	CFRelease(session);
	
	[dev release];
	[pool release];
}

- (void)analyzeCacheForDrive:(NSString *)dev
{
	driveIsBusy = YES;
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	
	DASessionRef session = DASessionCreate(NULL);
	DASessionScheduleWithRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
	DADiskRef disk = DADiskCreateFromBSDName(NULL,session,[dev UTF8String]);
	DADiskUnmount(disk,kDADiskUnmountOptionDefault,DADoneCallback,NULL);
	int ret = CFRunLoopRunInMode(MY_RUN_LOOP_MODE, 120.0, false);
	if (ret == kCFRunLoopRunStopped) {
		DASessionUnscheduleFromRunLoop(session, CFRunLoopGetCurrent(), MY_RUN_LOOP_MODE);
	}
	CFRelease(disk);
	CFRelease(session);
	
	cache_analysis_t result;
	result.cache_sector_size = -1;
	result.backseek_flush_capable = -1;
	ret = [XLDCDDARipper analyzeCacheForDrive:dev result:&result delegate:self];
	
	[o_detectPregapProgress stopAnimation:nil];
	[NSApp endSheet:o_detectPregapPane returnCode:0];
	[o_detectPregapPane close];
	
	NSMutableString *out =[[NSMutableString alloc] init];
	[out setString:@""];
	[out appendString:[NSString stringWithFormat:@"X Lossless Decoder version %@ (%@)\n\n",[[[NSBundle mainBundle] infoDictionary] valueForKey:@"CFBundleShortVersionString"],[[[NSBundle mainBundle] infoDictionary] valueForKey:@"CFBundleVersion"]]];
	[out appendString:@"XLD drive cache analysis logfile\n\n"];
	
	[out appendString:[NSString stringWithFormat:@"Used drive : %@\n\n",[cueParser driveStr]]];
	
	if((ret < 0) || (result.cache_sector_size < 0)) {
		[out appendString:LS(@"Some errors occured during analysis.\n\n")];
	}
	else {
		[out appendString:[NSString stringWithFormat:LS(@"Your drive seems to have a cache of %d sectors (%d Kbytes).\n"),result.cache_sector_size,result.cache_sector_size*2352/1024]];
		if(result.have_cache && (result.cache_sector_size > 1200))
			[out appendString:LS(@"Your drive has a too large cache to defeat. :(\n\n")];
		else {
			if(result.backseek_flush_capable == 0)
				[out appendString:LS(@"The cache size is small enough for cdparanoia III 10.2 engine, but backseeking doesn't seem to work for flushing cache. Please be careful with this drive.\n\n")];
			else
				[out appendString:LS(@"The cache size is small enough for cdparanoia III 10.2 engine. :)\n\n")];
		}
		/*
		if(result.have_cache && (result.cache_sector_size >= 150)) {
			int defeatPower = 1;
			for(;defeatPower<15;defeatPower++) {
				if(result.cache_sector_size < 550+50*(defeatPower-1)) break;
			}
			if(defeatPower<15) [out appendString:[NSString stringWithFormat:LS(@"Recommended cache defeating strength is: %d (1-14)\n\n"),defeatPower]];
			else [out appendString:LS(@"Your drive has a too large cache to defeat. :(\n\n")];
		}
		else {
			[out appendString:LS(@"The cache size is too small to have an effect.\n")];
			[out appendString:LS(@"You may be able to turn off \"Disable cache\" option, but I recommend you to disable cache with the minimum strength.\n\n")];
		}
		 */
	}
	[out appendString:@"End of status report\n"];
	[[[o_logView textStorage] mutableString] setString:out];
	[o_logWindow makeKeyAndOrderFront:self];
	
	[out release];
	
	session = DASessionCreate(NULL);
	disk = DADiskCreateFromBSDName(NULL,session,[dev UTF8String]);
	DADiskMount(disk,NULL,kDADiskMountOptionDefault,NULL,NULL);
	CFRelease(disk);
	CFRelease(session);
	
	[pool release];
	driveIsBusy = NO;
}

- (NSString *)setTrackMetadata:(NSMutableArray *)trackArr forDisc:(NSString *)disc alternativeName:(NSString *)altDisc
{
    FILE *fp = fopen([[@"~/Library/Preferences/CD Info.cidb" stringByExpandingTildeInPath] UTF8String],"rb");
    if(!fp) return nil;
    int tmp, actualTotalTrack = [trackArr count];
    char atom[4];
	NSString *albumTitle = nil;
	NSString *albumArtist = nil;
	NSString *albumGenre = nil;
	NSString *albumComposer = nil;
	NSString *albumGroup = nil;
	NSString *albumMEID = nil;
	NSString *albumMUID = nil;
	if(![[trackArr objectAtIndex:actualTotalTrack-1] enabled]) 
		actualTotalTrack--;
	
	while(1) {
		int nextIdx, trakPos, lastTrakPos;
		char *buf;
		int totalTrack = 0;
		int albumYear = 0;
		int discNumber = 0;
		int totalDisc = 0;
		int compilation = 0;
		
		while(1) { //skip until albm;
			if(fread(atom,1,4,fp) < 4) goto end;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"albm",4)) break;
			else if(!memcmp(atom,"cidb",4)) {
				if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
			}
			else if(!memcmp(atom,"hole",4)) {
				if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
			}
			else { // out of sync??
				if(fseeko(fp,-8,SEEK_CUR) != 0) goto end;
				while(1) {
					if(fread(atom,1,4,fp) < 4) goto end;
					if(!memcmp(atom,"albm",4)) break;
					if(!memcmp(atom,"hole",4)) break;
					if(!memcmp(atom,"cidb",4)) break;
					if(fseeko(fp,-3,SEEK_CUR) != 0) goto end;
				}
				if(fseeko(fp,-4,SEEK_CUR) != 0) goto end;
			}
		}
		nextIdx = ftell(fp) - 8 + tmp;
		trakPos = 0;
		lastTrakPos = 0;
		if(fread(&tmp,4,1,fp) < 1) goto end;
		tmp = SWAP32(tmp);
		int rest = tmp-12;
		while(rest > 0) { //skip until trak;
			if(fread(atom,1,4,fp) < 4) goto end;
			if(fread(&tmp,4,1,fp) < 1) goto end;
			tmp = SWAP32(tmp);
			if(!memcmp(atom,"trak",4)) {
				if(!trakPos) trakPos = ftell(fp);
				lastTrakPos = ftell(fp);
				if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
			}
			else if(!memcmp(atom,"anam",4)) {
				if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
				buf = malloc(tmp-8);
				buf[0] = 0xfe;
				buf[1] = 0xff;
				if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
				if(albumTitle) [albumTitle release];
				albumTitle = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
				free(buf);
			}
			else if(!memcmp(atom,"auth",4)) {
				if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
				buf = malloc(tmp-8);
				buf[0] = 0xfe;
				buf[1] = 0xff;
				if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
				if(albumArtist) [albumArtist release];
				albumArtist = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
				free(buf);
			}
			else if(!memcmp(atom,"gnre",4)) {
				if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
				buf = malloc(tmp-8);
				buf[0] = 0xfe;
				buf[1] = 0xff;
				if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
				if(albumGenre) [albumGenre release];
				albumGenre = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
				free(buf);
			}
			else if(!memcmp(atom,"comp",4)) {
				if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
				buf = malloc(tmp-8);
				buf[0] = 0xfe;
				buf[1] = 0xff;
				if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
				if(albumComposer) [albumComposer release];
				albumComposer = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
				free(buf);
			}
			else if(!memcmp(atom,"grup",4)) {
				if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
				buf = malloc(tmp-8);
				buf[0] = 0xfe;
				buf[1] = 0xff;
				if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
				if(albumGroup) [albumGroup release];
				albumGroup = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
				free(buf);
			}
			else if(!memcmp(atom,"meid",4)) {
				if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
				buf = malloc(tmp-8);
				buf[0] = 0xfe;
				buf[1] = 0xff;
				if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
				if(albumMEID) [albumMEID release];
				albumMEID = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
				free(buf);
			}
			else if(!memcmp(atom,"muid",4)) {
				if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
				buf = malloc(tmp-8);
				buf[0] = 0xfe;
				buf[1] = 0xff;
				if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
				if(albumMUID) [albumMUID release];
				albumMUID = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
				free(buf);
			}
			else if(!memcmp(atom,"year",4)) {
				if(fread(&albumYear,4,1,fp) < 1) goto end;
				albumYear = SWAP32(albumYear);
			}
			else if(!memcmp(atom,"dnum",4)) {
				if(fread(&discNumber,4,1,fp) < 1) goto end;
				discNumber = SWAP32(discNumber);
			}
			else if(!memcmp(atom,"dcnt",4)) {
				if(fread(&totalDisc,4,1,fp) < 1) goto end;
				totalDisc = SWAP32(totalDisc);
			}
			else if(!memcmp(atom,"cmpl",4)) {
				if(fread(&compilation,4,1,fp) < 1) goto end;
				compilation = SWAP32(compilation);
			}
			else if(!memcmp(atom,"prog",4)) {
				totalTrack = (tmp-8)/2;
				if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
			}
			else {
				if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
			}
			/*else {
				NSLog(@"unknown chunk (rest:%d)",rest);
				int i;
				for(i=0;i<4;i++) putchar(atom[i]);
				break;
			}*/
			rest -= tmp;
		}
		
		if(!trakPos) goto end;
		
		if(fseeko(fp,trakPos-8,SEEK_SET) != 0) goto end;
		
		//if(albumTitle) NSLog(albumTitle);
		if(albumTitle && ([disc isEqualToString:albumTitle] || [altDisc isEqualToString:albumTitle]) && (totalTrack == actualTotalTrack)) {
			int i;
			for(i=0;i<actualTotalTrack;i++) {
				if(albumTitle) [[[trackArr objectAtIndex:i] metadata] setObject:albumTitle forKey:XLD_METADATA_ALBUM];
				if(albumArtist) [[[trackArr objectAtIndex:i] metadata] setObject:albumArtist forKey:XLD_METADATA_ARTIST];
				if(albumGenre) [[[trackArr objectAtIndex:i] metadata] setObject:albumGenre forKey:XLD_METADATA_GENRE];
				if(albumComposer) [[[trackArr objectAtIndex:i] metadata] setObject:albumComposer forKey:XLD_METADATA_COMPOSER];
				if(albumGroup) [[[trackArr objectAtIndex:i] metadata] setObject:albumGroup forKey:XLD_METADATA_GROUP];
				if(albumYear > 0) [[[trackArr objectAtIndex:i] metadata] setObject:[NSNumber numberWithInt:albumYear] forKey:XLD_METADATA_YEAR];
				if(discNumber > 0) [[[trackArr objectAtIndex:i] metadata] setObject:[NSNumber numberWithInt:discNumber] forKey:XLD_METADATA_DISC];
				if(totalDisc > 0) [[[trackArr objectAtIndex:i] metadata] setObject:[NSNumber numberWithInt:totalDisc] forKey:XLD_METADATA_TOTALDISCS];
				if(compilation) [[[trackArr objectAtIndex:i] metadata] setObject:[NSNumber numberWithBool:YES] forKey:XLD_METADATA_COMPILATION];
				if(albumMEID && albumMUID) {
					[[[trackArr objectAtIndex:i] metadata] setObject:[NSString stringWithFormat:@"%d+%@+%@",actualTotalTrack,albumMEID,albumMUID] forKey:XLD_METADATA_GRACENOTE];
				}
			}
			while(1) {
				int trackIdx,trackSize,read=12;
				if(fread(atom,1,4,fp) < 4) goto end;
				if(fread(&tmp,4,1,fp) < 1) goto end;
				trackSize = SWAP32(tmp);
				if(memcmp(atom,"trak",4)) {
					if(ftell(fp) > lastTrakPos) break;
					else {
						if(fseeko(fp,trackSize-8,SEEK_CUR) != 0) goto end;
						continue;
					}
				}
				
				if(fread(&tmp,4,1,fp) < 1) goto end;
				trackIdx = SWAP32(tmp);
				
				while(read<trackSize) {
					if(fread(atom,1,4,fp) < 4) goto end;
					if(fread(&tmp,4,1,fp) < 1) goto end;
					tmp = SWAP32(tmp);
					if(!memcmp(atom,"tnam",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *title = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(title) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:title forKey:XLD_METADATA_TITLE];
							[title release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"auth",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *artist = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(artist) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:artist forKey:XLD_METADATA_ARTIST];
							[artist release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"comp",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *composer = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(composer) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:composer forKey:XLD_METADATA_COMPOSER];
							[composer release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"gnre",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *genre = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(genre) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:genre forKey:XLD_METADATA_GENRE];
							[genre release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"cmnt",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *comment = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(comment) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:comment forKey:XLD_METADATA_COMMENT];
							[comment release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"aaut",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *aArtist = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(aArtist) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:aArtist forKey:XLD_METADATA_ALBUMARTIST];
							[aArtist release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"anam",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *album = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(album) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:album forKey:XLD_METADATA_ALBUM];
							[album release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"grup",4) && (trackIdx <= actualTotalTrack) && (tmp > 0xa)) {
						if(fseeko(fp,2,SEEK_CUR) != 0) goto end;
						buf = malloc(tmp-8);
						buf[0] = 0xfe;
						buf[1] = 0xff;
						if(fread(buf+2,1,tmp-10,fp) < tmp-10) goto end;
						NSString *group = [[NSString alloc] initWithBytes:buf length:tmp-8 encoding:NSUnicodeStringEncoding];
						if(group) {
							[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:group forKey:XLD_METADATA_GROUP];
							[group release];
						}
						free(buf);
					}
					else if(!memcmp(atom,"year",4) && (trackIdx <= actualTotalTrack)) {
						int year;
						if(fread(&year,4,1,fp) < 1) goto end;
						year = SWAP32(year);
						[[[trackArr objectAtIndex:trackIdx-1] metadata] setObject:[NSNumber numberWithInt:year] forKey:XLD_METADATA_YEAR];
					}
					else {
						if(fseeko(fp,tmp-8,SEEK_CUR) != 0) goto end;
					}
					read += tmp;
				}
				
			}
			if(albumArtist) [albumArtist release];
			if(albumGenre) [albumGenre release];
			if(albumComposer) [albumComposer release];
			if(albumGroup) [albumGroup release];
			if(albumMEID) [albumMEID release];
			if(albumMUID) [albumMUID release];
			fclose(fp);
			return [albumTitle autorelease];
		}
		
		if(albumTitle) [albumTitle release];
		if(albumArtist) [albumArtist release];
		if(albumGenre) [albumGenre release];
		if(albumComposer) [albumComposer release];
		if(albumGroup) [albumGroup release];
		if(albumMEID) [albumMEID release];
		if(albumMUID) [albumMUID release];
		albumTitle = nil;
		albumArtist = nil;
		albumGenre = nil;
		albumComposer = nil;
		albumGroup = nil;
		albumMEID = nil;
		albumMUID = nil;
		
		if(fseeko(fp,nextIdx,SEEK_SET) != 0) goto end;
	}
end:
		
	if(albumTitle) [albumTitle release];
	if(albumArtist) [albumArtist release];
	if(albumGenre) [albumGenre release];
	if(albumComposer) [albumComposer release];
	if(albumGroup) [albumGroup release];
	if(albumMEID) [albumMEID release];
	if(albumMUID) [albumMUID release];
	fclose(fp);
    return nil;
}

- (void)finishedReadingPregapWithTrackData:(NSMutableArray *)trackArr
{
	XLDCDDARipper *decoder = [[XLDCDDARipper alloc] init];
	if(![decoder openFile:statDisc.f_mntfromname]) {
		NSLog(@"device open failure");
	}
	
	NSString *volumeName = [[[NSFileManager defaultManager] displayNameAtPath: [NSString stringWithUTF8String:statDisc.f_mntonname]] precomposedStringWithCanonicalMapping];
	NSString *volumeName2 = [[[NSMutableString stringWithUTF8String:statDisc.f_mntonname] lastPathComponent] precomposedStringWithCanonicalMapping];
	//NSLog(volumeName);
	NSString *title = [self setTrackMetadata:trackArr forDisc:volumeName alternativeName:volumeName2];
	
	[cueParser openFile:[NSString stringWithUTF8String:statDisc.f_mntfromname] withTrackData:trackArr decoder:decoder];
	if(title) [cueParser setTitle:title];
	else [cueParser setTitle:volumeName];
	
	[o_tableView reloadData];
	[o_tableView deselectAll:nil];
	if([cueParser accurateRipData])
		[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",[cueParser title]]]; 
	else [o_trackWindow setTitle:[cueParser title]];
	[o_titleText setStringValue:[cueParser title]];
	[o_artistText setStringValue:[cueParser artist]];
	if([cueParser coverData]) {
		NSImage *img = [[NSImage alloc] initWithData:[cueParser coverData]];
		[o_cover setImageWithResize:img];
		[self imageLoadedFromOutside:NO];
		[img release];
		[o_saveImageMenu setEnabled:YES];
	}
	else {
		NSImage *imgStr = [NSImage imageWithString:@"No Image" withFont:[NSFont boldSystemFontOfSize:30] withColor:[NSColor grayColor]];
		[o_cover setFrameSize:NSMakeSize([o_cover frame].size.width,[o_cover frame].size.width)];
		[o_cover setImage:imgStr];
		[o_coverShadow setImage:nil];
		[o_saveImageMenu setEnabled:NO];
	}
	[self readModeChanged:o_pregapRadio];
	[o_trackWindow makeKeyAndOrderFront: self];
	[o_cddbGetTrackMenu setEnabled:YES];
	[decoder closeFile];
	[decoder release];
	if([o_autoQueryCDDB state] == NSOnState) {
		[self cddbGetTracksWithAutoStart:(([o_autoMountDisc state] == NSOnState) && ([o_autoStartRipping state] == NSOnState)) ? YES : NO];
	}
	else if(([o_autoMountDisc state] == NSOnState) && ([o_autoStartRipping state] == NSOnState)) {
		[self performSelectorOnMainThread:@selector(beginDecode:) withObject:nil waitUntilDone:NO];
	}
}

/* delegate methods */

- (void)sheetDidEnd:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if([(NSString *)contextInfo isEqualToString:@"CDDBQuery"] || [(NSString *)contextInfo isEqualToString:@"CDDBQueryWithStart"]) {
		if(returnCode != 0) {
			[util release];
			util = nil;
			return;
		}
		[util readCDDBWithInfo:[[util queryResult] objectAtIndex:[o_queryResultList indexOfSelectedItem]]];
		NSString *album = [[[[cueParser trackList] objectAtIndex:0] metadata] objectForKey:XLD_METADATA_ALBUM];
		if(album) {
			if([[[o_trackWindow title] substringWithRange:NSMakeRange(0,4)] isEqualToString:@"[AR]"])
				[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",album]]; 
			else [o_trackWindow setTitle:album];
			[o_titleText setStringValue:album];
		}
		[o_artistText setStringValue:[cueParser artist]];
		[o_tableView reloadData];
		if([util coverImg]) {
			[o_cover setImageWithResize:[util coverImg]];
			[cueParser setCoverData:[util coverData]];
			[self imageLoadedFromOutside:NO];
			[o_saveImageMenu setEnabled:YES];
		}
		if([self canSetCompilationFlag] && [cueParser isCompilation]) {
			int i;
			for(i=0;i<[[cueParser trackList] count];i++) [[[[cueParser trackList] objectAtIndex:i] metadata] setObject:[NSNumber numberWithBool:YES] forKey:XLD_METADATA_COMPILATION];
		}
		[util release];
		util = nil;
		if([(NSString *)contextInfo isEqualToString:@"CDDBQueryWithStart"]) {
			[self performSelectorOnMainThread:@selector(beginDecode:) withObject:nil waitUntilDone:NO];
		}
	}
	else if([(NSString *)contextInfo isEqualToString:@"Start"]) {
		[self performSelectorOnMainThread:@selector(beginDecode:) withObject:nil waitUntilDone:NO];
	}
}

- (IBAction)offsetSelected:(id)sender
{
	[o_offsetCorrectionValue setIntValue:[[sender selectedItem] tag]];
}

- (void)makeDriveOffsetList
{
	int found = 0;
	NSDictionary *dic = [NSDictionary dictionaryWithContentsOfFile:[[NSBundle mainBundle] pathForResource:@"offsetlist" ofType:@"plist"]];
	io_service_t  service;
    io_iterator_t service_iterator;
	
	[o_offsetList removeItemAtIndex:1];
	[o_offsetList setAutoenablesItems:NO];
    
	IOServiceGetMatchingServices(kIOMasterPortDefault, IOServiceMatching("IOCDBlockStorageDevice"), &service_iterator);
    
    while((service = IOIteratorNext(service_iterator)) != 0) {
        CFMutableDictionaryRef properties;
        IORegistryEntryCreateCFProperties (service, &properties, kCFAllocatorDefault, 0);
        CFDictionaryRef deviceDict = (CFDictionaryRef)CFDictionaryGetValue(properties, CFSTR(kIOPropertyDeviceCharacteristicsKey));
        CFStringRef      vendor      = NULL;
        CFStringRef      product     = NULL;
        vendor = (CFStringRef)CFDictionaryGetValue(deviceDict, CFSTR(kIOPropertyVendorNameKey));
        product = (CFStringRef)CFDictionaryGetValue(deviceDict, CFSTR(kIOPropertyProductNameKey));
        
        if([dic objectForKey:(NSString *)product]) {
			found++;
			int offsetValue = [[dic objectForKey:(NSString *)product] intValue];
			NSString *title = [NSString stringWithFormat:@"%d (%@ %@)",offsetValue,(NSString *)vendor,(NSString *)product];
			[o_offsetList addItemWithTitle:title];
			[[o_offsetList itemWithTitle:title] setTag:offsetValue];
        }
		else if([dic objectForKey:[(NSString *)product substringToIndex:[(NSString *)product length]-1]]) {
			found++;
			int offsetValue = [[dic objectForKey:[(NSString *)product substringToIndex:[(NSString *)product length]-1]] intValue];
			NSString *title = [NSString stringWithFormat:@"%d (%@ %@)",offsetValue,(NSString *)vendor,(NSString *)product];
			[o_offsetList addItemWithTitle:title];
			[[o_offsetList itemWithTitle:title] setTag:offsetValue];
        }
        
        CFRelease(properties);
        IOObjectRelease( service );
        
    }
    
    IOObjectRelease( service_iterator );
	
	if(!found) {
		[o_offsetList addItemWithTitle:LS(@"No registered drive found")];
		[[o_offsetList itemWithTitle:LS(@"No registered drive found")] setEnabled:NO];
	}
	else {
		if(found == 1) [o_offsetCorrectionValue setIntValue:[[o_offsetList itemAtIndex:1] tag]];
		[o_offsetList setTarget:self];
		[o_offsetList setAction:@selector(offsetSelected:)];
	}
}

- (void)launchOK
{
	launched = YES;
	if([queue count]) [self processQueue];
}

- (NSStringEncoding)encoding
{
	//NSLog([NSString localizedNameOfStringEncoding:[[o_cuesheetEncodings selectedItem] tag]]);
	if([o_cuesheetEncodings indexOfSelectedItem] == 0) return 0xFFFFFFFF;
	else return (NSStringEncoding)[[o_cuesheetEncodings selectedItem] tag];
}

- (int)maxThreads
{
	return [o_maxThreads intValue];
}

- (BOOL)canSetCompilationFlag
{
	return ([o_autoSetCompilation state] == NSOnState);
}

- (void)discRippedWithResult:(id)result
{
	/*int i;
	for(i=0;i<[result numberOfTracks]+1;i++) {
		cddaRipResult *resultp = [result resultForIndex:i];
		NSLog(@"%@:%d,%d,%d,%d,%d,%d,%d,%d",
			  resultp->filename,
			  resultp->enabled,
			  resultp->finished,
			  resultp->errorCount,
			  resultp->skipCount,
			  resultp->atomJitterCount,
			  resultp->edgeJitterCount,
			  resultp->droppedCount,
			  resultp->duplicatedCount);
	}*/
	if([result logStr]) {
		//NSLog([result logStr]);
		[[[o_logView textStorage] mutableString] setString:[result logStr]];
		[o_logWindow makeKeyAndOrderFront:self];
	}
	[result saveLog];
	[result saveCuesheetIfNeeded];
	if([result isGoodRip] && ([o_ejectWhenDone state] == NSOnState))
		[NSThread detachNewThreadSelector:@selector(ejectDisc:) toTarget:self withObject:[result deviceStr]];
	else
		[NSThread detachNewThreadSelector:@selector(mountDisc:) toTarget:self withObject:[result deviceStr]];
	if([result isGoodRip] && ([o_quitWhenDone state] == NSOnState)) {
		[NSApp terminate:self];
	}
	[NSApp requestUserAttention:NSInformationalRequest];
	NSBeep();
	[result release];
	driveIsBusy = NO;
}

- (void)accurateRipCheckDidFinish:(id)result
{
	if([result logStr]) {
		[[[o_logView textStorage] mutableString] setString:[result logStr]];
		[o_logWindow makeKeyAndOrderFront:self];
	}
	[result release];
}

- (void)offsetCheckDidFinish:(id)result
{
	int offset,i,j;
	NSArray *offsetList = nil;
	if([[[result detectedOffset] allKeys] count])
		offsetList = [[result detectedOffset] allKeys];
	int ret = NSAlertDefaultReturn;
	if(![result cancelled]) {
		if(!offsetList)
			ret = NSRunAlertPanel(LS(@"detection failure"),LS(@"Can't detect the offset of this file."),@"OK",nil,nil);
		else if([offsetList count] > 1) {
			[o_offsetCorrectionPopup removeAllItems];
			
			for(i=0;i<[offsetList count];i++) {
				if([[offsetList objectAtIndex:i] intValue] == 0) {
					NSString *title = [NSString stringWithFormat:LS(@"%d (confidence %d)"),0,[[[result detectedOffset] objectForKey:[offsetList objectAtIndex:i]] intValue]];
					[o_offsetCorrectionPopup addItemWithTitle:title];
					id item = [o_offsetCorrectionPopup itemWithTitle:title];
					if(item) [item setTag:0];
				}
			}
			
			NSArray *confidenceList = [[[result detectedOffset] allValues] sortedArrayUsingFunction:intSort context:NULL];
			int previousConfidence = -1;
			for(j=0;j<[confidenceList count];j++) {
				int confidence = [[confidenceList objectAtIndex:j] intValue];
				if(confidence == previousConfidence) continue;
				for(i=0;i<[offsetList count];i++) {
					if([[offsetList objectAtIndex:i] intValue] == 0) continue;
					int value = [[[result detectedOffset] objectForKey:[offsetList objectAtIndex:i]] intValue];
					if(value == confidence) {
						NSString *title = [NSString stringWithFormat:LS(@"%d (confidence %d)"),[[offsetList objectAtIndex:i] intValue],confidence];
						[o_offsetCorrectionPopup addItemWithTitle:title];
						id item = [o_offsetCorrectionPopup itemWithTitle:title];
						if(item) [item setTag:[[offsetList objectAtIndex:i] intValue]];
					}
				}
				previousConfidence = confidence;
			}
			
			ret = [NSApp runModalForWindow:o_offsetCorrectionPanel];
			offset = [[o_offsetCorrectionPopup selectedItem] tag];
		}
		else {
			offset = [[offsetList objectAtIndex:0] intValue];
			int confidence = [[[result detectedOffset] objectForKey:[offsetList objectAtIndex:0]] intValue];
			if(offset)
				ret = NSRunAlertPanel(LS(@"detection success"),[NSString stringWithFormat:LS(@"The offset of this file is wrong in %d samples (confidence %d)."),offset,confidence],@"OK",LS(@"Fix and Save"),nil);
			else
				ret = NSRunAlertPanel(LS(@"detection success"),LS(@"This file has a correct offset."),@"OK",nil,nil);
		}
	}
	[result release];
	
	if(ret == NSAlertDefaultReturn) return;
	
	[o_offsetValue setIntValue:offset];
	[self saveOffsetCorrectedFile:nil];
	
}

- (void)replayGainScanningDidFinish:(id)result
{
	if([result logStrForReplayGainScanner]) {
		[[[o_logView textStorage] mutableString] setString:[result logStrForReplayGainScanner]];
		[o_logWindow makeKeyAndOrderFront:self];
	}
	[result release];
}

- (void)tagEditDidFinishForTracks:(NSArray *)tracks albumRanges:(NSArray *)ranges tasks:(NSArray *)tasks
{
	int i;
	int albumRangeIdx = 0;
	for(i=0;i<[tracks count];i++) {
		XLDTrack *track = [tracks objectAtIndex:i];
		XLDConverterTask *task = [tasks objectAtIndex:i];
		[task setScaleType:([o_scaleImage state] == NSOffState) ? XLDNoScale : ([[o_scaleType selectedCell] tag] | (([o_expandImage state] == NSOnState) ? 0x10 : 0))];
		[task setScaleSize:[o_scalePixel intValue]];
		[task setCompressionQuality:[o_compressionQuality intValue]/100.0f];
		[self setOutputForTask:task];
		[task setProcessOfExistingFiles:[[o_existingFile selectedCell] tag]];
		[task setTagWritable:([o_autoTagging state] == NSOnState) ? YES : NO];
		[task setEmbedImages:([o_embedCoverArts state] == NSOnState) ? YES : NO];
		[task setMoveAfterFinish:([o_moveAfterFinish state] == NSOnState) ? YES : NO];
		if([o_addiTunes state] == NSOnState)
			[task setiTunesLib:(![[o_libraryType selectedCell] tag]) ? @"library playlist 1" : [o_libraryName stringValue]];
		
		NSArray *albumArray = nil;
		if([[o_filenameFormatRadio selectedCell] tag] == 0 && [track enabled]) {
			[task setTrack:track];
			continue;
		}
		if([ranges count] && albumRangeIdx < [ranges count]) {
			NSRange range = [[ranges objectAtIndex:albumRangeIdx] rangeValue];
			if(i >= range.location && i < range.location+range.length) {
				albumArray = [tracks subarrayWithRange:range];
				if(i == range.location+range.length-1) albumRangeIdx++;
			}
		}
		int trackNum = [[track metadata] objectForKey:XLD_METADATA_TRACK] ? [[[track metadata] objectForKey:XLD_METADATA_TRACK] intValue] : 1;
		NSString *filename = [self preferredFilenameForTrack:track index:trackNum baseDir:[task outputDir] createSubDir:YES singleImageMode:NO albumArtist:(albumArray?[cueParser artistForTracks:albumArray]:nil)];
		[track setDesiredFileName:[filename lastPathComponent]];
		NSString *subDir = [filename stringByDeletingLastPathComponent];
		if(![subDir isEqualToString:@""]) {
			[task setOutputDir:[[task outputDir] stringByAppendingPathComponent:subDir]];
		}
		[track setEnabled:YES];
		[task setTrack:track];
	}
	
	[taskQueue performSelectorOnMainThread:@selector(addTasks:) withObject:tasks waitUntilDone:YES];
}

- (void)tagsUpdated
{
	NSString *album = [[[[cueParser trackList] objectAtIndex:0] metadata] objectForKey:XLD_METADATA_ALBUM];
	if(album) {
		if([[[o_trackWindow title] substringWithRange:NSMakeRange(0,4)] isEqualToString:@"[AR]"])
			[o_trackWindow setTitle:[NSString stringWithFormat:@"[AR] %@",album]]; 
		else [o_trackWindow setTitle:album];
		[o_titleText setStringValue:album];
	}
	[o_artistText setStringValue:[cueParser artist]];
	[o_tableView reloadData];
}

- (NSArray *)currentTrackList
{
	return [cueParser trackList];
}

- (BOOL)checkUpdateStatus
{
	NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
	return [pref boolForKey:@"SUEnableAutomaticChecks"];
}

- (void)setCheckUpdateStatus:(BOOL)flag
{
	if(updater) {
		NSUserDefaults *pref = [NSUserDefaults standardUserDefaults];
		[pref setBool:flag forKey:@"SUEnableAutomaticChecks"];
		if(!flag) [pref setBool:YES forKey:@"TempUpdateKey"];
		else [pref removeObjectForKey:@"TempUpdateKey"];
		[pref synchronize];
	}
}

#pragma mark Delegate Methods

- (void)awakeFromNib
{
    NSToolbar*  toolbar;
    toolbar = [[[NSToolbar alloc] initWithIdentifier:@"ToolbarForTabView"] autorelease];
    
    [toolbar setDelegate:self];
    [o_prefPane setToolbar:toolbar];
	[toolbar setSelectedItemIdentifier:GeneralIdentifier];
}

- (void)applicationDidFinishLaunching: (NSNotification *)notification
{
	int i;
	NSRect matrixRect = [[o_multipleOutputFormatPanel contentView] frame];
	matrixRect.origin.x = 10;
	matrixRect.size.height = 20*([outputArr count]+5)+10;
	matrixRect.origin.y = [[o_multipleOutputFormatPanel contentView] frame].size.height - matrixRect.size.height - 10;
	multipleOutputFormatMatrix = [[NSMatrix alloc] initWithFrame:matrixRect mode:NSTrackModeMatrix cellClass:[NSButtonCell class] numberOfRows:[outputArr count]+5 numberOfColumns:1];
	[multipleOutputFormatMatrix setCellSize:NSMakeSize(matrixRect.size.width,20)];
	[multipleOutputFormatMatrix setAction:@selector(multipleFormatSelectionChanged:)];
	[multipleOutputFormatMatrix setTarget:self];
	for(i=0;i<5;i++) {
		[[multipleOutputFormatMatrix cellAtRow:i column:0] setButtonType:NSSwitchButton];
		[[multipleOutputFormatMatrix cellAtRow:i column:0] setFont:[NSFont systemFontOfSize:13]];
		[[multipleOutputFormatMatrix cellAtRow:i column:0] setTitle:[o_formatList itemTitleAtIndex:i]];
	}
	
	for(i=0;i<[outputArr count];i++) {
		NSString *pluginName = [[[outputArr objectAtIndex:i] class] pluginName];
		[o_formatList addItemWithTitle:pluginName];
		[[multipleOutputFormatMatrix cellAtRow:i+5 column:0] setButtonType:NSSwitchButton];
		[[multipleOutputFormatMatrix cellAtRow:i+5 column:0] setFont:[NSFont systemFontOfSize:13]];
		[[multipleOutputFormatMatrix cellAtRow:i+5 column:0] setTitle:pluginName];
		[[outputArr objectAtIndex:i] loadPrefs];
	}
	[defaultOutput loadPrefs];
	[multipleOutputFormatMatrix selectCellAtRow:0 column:0];
	[[o_multipleOutputFormatPanel contentView] addSubview:multipleOutputFormatMatrix];
	[[o_formatList menu] addItem:[NSMenuItem separatorItem]];
	[o_formatList addItemWithTitle:LS(@"Multiple Formats")];
	id item = [o_formatList itemWithTitle:LS(@"Multiple Formats")];
	if(item) [item setTag:1];
	
	[o_cddbServer setNumberOfVisibleItems:2];
	
	[[o_cuesheetEncodings itemAtIndex:0] setTag:0xFFFFFFFF];
	const NSStringEncoding *encodingsArr = [NSString availableStringEncodings];
	NSMutableDictionary *dic = [[NSMutableDictionary alloc] init];
	for(i=0;*(encodingsArr+i);i++) {
		[dic setObject:[NSNumber numberWithUnsignedInt:*(encodingsArr+i)] forKey:[NSString localizedNameOfStringEncoding:*(encodingsArr+i)]];
	}
	NSArray *arr = [[dic allKeys] sortedArrayUsingSelector:@selector(compare:)];
	for(i=0;i<[arr count];i++) {
		[o_cuesheetEncodings addItemWithTitle:[arr objectAtIndex:i]];
		id item = [o_cuesheetEncodings itemWithTitle:[arr objectAtIndex:i]];
		if(item) [item setTag:[[dic objectForKey:[arr objectAtIndex:i]] unsignedIntValue]];
	}
	[dic release];
	/*
	 for(i=0;*(encodingsArr+i);i++) {
	 [o_cuesheetEncodings addItemWithTitle:[NSString localizedNameOfStringEncoding:*(encodingsArr+i)]];
	 id item = [o_cuesheetEncodings itemWithTitle:[NSString localizedNameOfStringEncoding:*(encodingsArr+i)]];
	 if(item) [item setTag:*(encodingsArr+i)];
	 }
	 */
	
	[o_filenameFormat setToolTip:LS(@"formatTooltipStr")];
	
	NSUserDefaults* defs = [NSUserDefaults standardUserDefaults];
	NSArray* languages = [defs objectForKey:@"AppleLanguages"];
	if([[languages objectAtIndex:0] isEqualToString:@"ja"]) {
		[o_cuesheetEncodings selectItemAtIndex:0];
	}
	else {
		[o_cuesheetEncodings selectItemWithTitle:[NSString localizedNameOfStringEncoding:[NSString defaultCStringEncoding]]];
	}
	
	[self makeDriveOffsetList];
	[self loadPrefs];
	[o_tableView setDoubleAction:@selector(playTrack)];
	[o_cddbGetTrackMenu setEnabled:NO];
	[o_cover setImageFrameStyle:NSImageFramePhoto];
	[o_cover setAcceptDrag:YES];
	[o_cover setAutoResize:YES];
	[o_coverShadow setAcceptDrag:NO];
	[self statusChanged:nil];
	[self multipleFormatSelectionChanged:nil];
	[self updateCDDAList:nil];
	
	[self performSelector:@selector(launchOK) withObject:nil afterDelay:0.5];
	/*if(queuedFile) {
	 [self application:NSApp openFile:queuedFile];
	 [queuedFile release];
	 queuedFile = nil;
	 }*/
	//[[NSUserDefaults standardUserDefaults] setObject: @"http://hoge.com/hoge.xml" forKey:@"SUFeedURL"];

}

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	if([taskQueue hasActiveTask]) {
		int ret = NSRunCriticalAlertPanel(LS(@"Quit XLD"), LS(@"You have some active tasks. Are you sure you want to quit?"), @"OK", LS(@"Cancel"), nil);
		if(ret == NSAlertAlternateReturn) return NO;
	}
	[(XLDPlayer *)player releaseDecoder];
	int i;
	for(i=0;i<[outputArr count];i++) {
		[[outputArr objectAtIndex:i] savePrefs];
	}
	[defaultOutput savePrefs];
	[self savePrefs];
	return YES;
}

- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename
{
	if(openingFiles) return NO;
	[queue addObject:filename];
	if(firstDrag && launched) {
		firstDrag = NO;
		[self performSelector:@selector(processQueue) withObject:nil afterDelay:0.2];
	}
	return YES;
}

- (void)windowWillClose:(NSNotification *)aNotification
{
	[o_cddbGetTrackMenu setEnabled:NO];
}

- (int)numberOfRowsInTableView:(NSTableView *)tableView
{
	return [[cueParser trackList] count];
}

- (id)tableView:(NSTableView *)tableView
objectValueForTableColumn:(NSTableColumn *)tableColumn
			row:(int)row
{
	if(row >= [[cueParser trackList] count]) return nil;
	if([[tableColumn identifier] isEqual:@"Track"]) {
		return [NSNumber numberWithInt: row+1];
	}
	else if([[tableColumn identifier] isEqual:@"Title"]) {
		NSString *title = [[[[cueParser trackList] objectAtIndex:row] metadata] objectForKey:XLD_METADATA_TITLE];
		if(title) return title;
		else return [NSString stringWithFormat:@"Track %02d",row+1];
	}
	else if([[tableColumn identifier] isEqual:@"Artist"]) {
		return [[[[cueParser trackList] objectAtIndex:row] metadata] objectForKey:XLD_METADATA_ARTIST];
	}
	else if([[tableColumn identifier] isEqual:@"Length"]) {
		return [cueParser lengthOfTrack:row];
	}
	else if([[tableColumn identifier] isEqual:@"Pregap"]) {
		return [cueParser gapOfTrack:row];
	}
	return nil;
}

- (void)tableViewColumnDidResize:(NSNotification *)aNotification
{
	NSArray *columnArr = [o_tableView tableColumns];
	float wholeWidth = 0;
	int i;
	for(i=0;i<[columnArr count];i++) {
		wholeWidth += [[columnArr objectAtIndex:i] width];
	}
	float maxWidth = wholeWidth - [[columnArr objectAtIndex:0] width] - [[columnArr objectAtIndex:1] width]
	- [[columnArr objectAtIndex:4] width] - [[columnArr objectAtIndex:5] width] - 75.0f;
	[[columnArr objectAtIndex:2] setMaxWidth:maxWidth];
}

- (int)numberOfItemsInComboBox:(NSComboBox *)aComboBox
{
	return [serverList count];
}

- (id)comboBox:(NSComboBox *)aComboBox objectValueForItemAtIndex:(int)index
{
	return [serverList objectAtIndex:index];
}

- (NSArray*)toolbarDefaultItemIdentifiers:(NSToolbar*)toolbar
{
    return [NSArray arrayWithObjects:GeneralIdentifier, 
			BatchIdentifier, 
			CDDBIdentifier, 
			MetadataIdentifier, 
			CDRipIdentifier, 
			nil];
}

- (NSArray*)toolbarAllowedItemIdentifiers:(NSToolbar*)toolbar
{
    return [self toolbarDefaultItemIdentifiers:toolbar];
}

- (NSArray*)toolbarSelectableItemIdentifiers:(NSToolbar*)toolbar
{
    return [self toolbarDefaultItemIdentifiers:toolbar];
}

- (NSToolbarItem*)toolbar:(NSToolbar*)toolbar 
	itemForItemIdentifier:(NSString*)itemId 
willBeInsertedIntoToolbar:(BOOL)willBeInserted
{
    NSToolbarItem*  toolbarItem;
    toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemId] autorelease];
	[toolbarItem setTarget:self];
	[toolbarItem setAction:@selector(showTab:)];
    
    if ([itemId isEqualToString:GeneralIdentifier]) {
        [toolbarItem setLabel:LS(@"General")];
        [toolbarItem setImage:[NSImage imageNamed:@"general"]];
        
        return toolbarItem;
    }
    else if ([itemId isEqualToString:BatchIdentifier]) {
        [toolbarItem setLabel:LS(@"Batch")];
        [toolbarItem setImage:[NSImage imageNamed:@"batch"]];
        
        return toolbarItem;
    }
    else if ([itemId isEqualToString:CDDBIdentifier]) {
        [toolbarItem setLabel:LS(@"CDDB")];
        [toolbarItem setImage:[NSImage imageNamed:@"cddb"]];
        
        return toolbarItem;
    }
    else if ([itemId isEqualToString:MetadataIdentifier]) {
        [toolbarItem setLabel:LS(@"Metadata")];
        [toolbarItem setImage:[NSImage imageNamed:@"metadata"]];
        
        return toolbarItem;
    }
    else if ([itemId isEqualToString:CDRipIdentifier]) {
        [toolbarItem setLabel:LS(@"CD Rip")];
        [toolbarItem setImage:[NSImage imageNamed:@"cdrip"]];
        
        return toolbarItem;
    }
	
    return nil;
}

-(float)toolbarHeightForWindow:(NSWindow *)window
{
    NSToolbar *toolbar;
    float toolbarHeight = 0.0;
    NSRect windowFrame;
    
    toolbar = [window toolbar];
    
    if(toolbar && [toolbar isVisible])
    {
        windowFrame = [NSWindow contentRectForFrameRect:[window frame]
											  styleMask:[window styleMask]];
        toolbarHeight = NSHeight(windowFrame)
		- NSHeight([[window contentView] frame]);
    }
    
    return toolbarHeight;
}

-(void)resizePrefPane
{
	NSArray *subviews = [[[o_preferencesTab selectedTabViewItem] view] subviews];
	NSEnumerator *enumerator = [subviews objectEnumerator];
	NSRect windowRect = NSZeroRect;
	NSView *subview = nil;
	while((subview = [enumerator nextObject]))
	{
		windowRect = NSUnionRect(windowRect, [subview frame]);
	}
	windowRect.origin.y = [[o_preferencesTab window] frame].origin.y;
	windowRect.size.height += [self toolbarHeightForWindow:[o_preferencesTab window]]; //toolbar height
	windowRect.size.height += 22; //title bar height
	windowRect.size.height += 32; //border
	
	NSRect r = NSMakeRect([[o_preferencesTab window] frame].origin.x, [[o_preferencesTab window] frame].origin.y - 
						  (windowRect.size.height - [[o_preferencesTab window] frame].size.height), [[o_preferencesTab window] frame].size.width, windowRect.size.height);
	[[o_preferencesTab window] setFrame:r display:YES animate:YES];
	//[[o_preferencesTab window] makeFirstResponder:[[o_preferencesTab selectedTabViewItem] view]];
}


- (void)showTab:(id)sender
{
	NSString *newId = [sender itemIdentifier];
	[[[o_preferencesTab tabViewItemAtIndex:[o_preferencesTab indexOfTabViewItemWithIdentifier:newId]] view] setHidden:YES];
	[o_preferencesTab selectTabViewItemWithIdentifier:newId];
	//[[[o_preferencesTab selectedTabViewItem] view] setHidden:YES];
	[self resizePrefPane];
	[[[o_preferencesTab selectedTabViewItem] view] setHidden:NO];
	[o_prefPane makeFirstResponder:[[o_preferencesTab selectedTabViewItem] initialFirstResponder]];
}


- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
    if([menuItem action] == @selector(editMetadata:))
        return [o_trackWindow isVisible];
	else if([menuItem action] == @selector(saveCuesheet:))
        return [o_trackWindow isVisible];
	else if([menuItem action] == @selector(checkAccurateRip:))
		return [o_trackWindow isVisible] && strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9);
	else if([menuItem action] == @selector(saveOffsetCorrectedFile:))
		return [o_trackWindow isVisible] && strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9);
	else if([menuItem action] == @selector(checkForUpdates:))
		return (updater != nil);
	else if([menuItem action] == @selector(analyzeCache:))
		return [o_trackWindow isVisible] && !strncmp("/dev/disk",[[cueParser fileToDecode] UTF8String],9);
	else if([menuItem action] == @selector(inputTagsFromText:))
        return [o_trackWindow isVisible] || [metadataEditor editingSingleTags];
    return YES;
}

@end
