/* XLDController */
// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import <Cocoa/Cocoa.h>
#import "XLDCDDBUtil.h"
#import <sys/param.h>
#import <sys/mount.h>

typedef struct __DASession * DASessionRef;

@interface XLDController : NSObject
{
    IBOutlet id o_decodeButton;
    IBOutlet id o_formatList;
    IBOutlet id o_outputDir;
    IBOutlet id o_outputSelectRadio;
    IBOutlet id o_pregapRadio;
    IBOutlet id o_tableView;
    IBOutlet id o_trackWindow;
	IBOutlet id o_formatOptionButton;
	IBOutlet id o_pluginPrefPane;
	IBOutlet id o_pluginOptionContentView;
	IBOutlet id o_prefPane;
	IBOutlet id o_autoTagging;
	IBOutlet id o_filenameFormat;
	IBOutlet id o_filenameFormatRadio;
	IBOutlet id o_cddbGetTrackMenu;
	IBOutlet id o_cddbServer;
	IBOutlet id o_cddbServerPort;
	IBOutlet id o_cddbServerPath;
	IBOutlet id o_cddbProxyServer;
	IBOutlet id o_cddbProxyUser;
	IBOutlet id o_cddbProxyPassword;
	IBOutlet id o_cddbProxyServerPort;
	IBOutlet id o_cddbProxyEnabled;
	IBOutlet id o_queryResultPane;
	IBOutlet id o_queryResultList;
	IBOutlet id o_cddbUseCache;
	IBOutlet id o_rawFormatView;
	IBOutlet id o_rawBitDepth;
	IBOutlet id o_rawChannels;
	IBOutlet id o_rawSamplerate;
	IBOutlet id o_rawEndian;
	IBOutlet id o_rawFormatPane;
	IBOutlet id o_rawFormatPaneContent;
	IBOutlet id o_correctOffset;
	IBOutlet id o_cuesheetEncodings;
	IBOutlet id o_cddbQueryItem;
	IBOutlet id o_maxThreads;
	IBOutlet id o_cover;
	IBOutlet id o_coverShadow;
	IBOutlet id o_titleText;
	IBOutlet id o_artistText;
	IBOutlet id o_scaleImage;
	IBOutlet id o_scaleType;
	IBOutlet id o_scalePixel;
	IBOutlet id o_compressionQuality;
	IBOutlet id o_saveImageMenu;
	IBOutlet id o_editTags;
	IBOutlet id o_addiTunes;
	IBOutlet id o_libraryType;
	IBOutlet id o_libraryName;
	IBOutlet id o_openCDDA;
	IBOutlet id o_useParanoiaMode;
	IBOutlet id o_maxRetryCount;
	IBOutlet id o_offsetCorrectionValue;
	IBOutlet id o_detectPregapPane;
	IBOutlet id o_detectPregapProgress;
	IBOutlet id o_detectPregapMessage;
	IBOutlet id o_detectPregapPaneButton;
	IBOutlet id o_logWindow;
	IBOutlet id o_logView;
	IBOutlet id o_queryAccurateRip;
	IBOutlet id o_saveLog;
	IBOutlet id o_saveLogType;
	IBOutlet id o_verifySuspiciousSector;
	IBOutlet id o_testBeforeCopy;
	IBOutlet id o_testType;
	IBOutlet id o_cuesheetTypeView;
	IBOutlet id o_cuesheetType;
	IBOutlet id o_arLogControl;
	IBOutlet id o_offsetValue;
	IBOutlet id o_offsetView;
	IBOutlet id o_offsetCorrectionPanel;
	IBOutlet id o_offsetCorrectionPopup;
	IBOutlet id o_scanReplayGain;
	IBOutlet id o_useOldEngine;
	IBOutlet id o_multipleOutputFormatPanel;
	IBOutlet id o_offsetList;
	IBOutlet id o_useC2Pointer;
	IBOutlet id o_autoSetOffsetValue;
	IBOutlet id o_subdirectoryDepth;
	IBOutlet id o_autoMountDisc;
	IBOutlet id o_autoStartRipping;
	IBOutlet id o_ejectWhenDone;
	IBOutlet id o_autoQueryCDDB;
	IBOutlet id o_limitExtension;
	IBOutlet id o_extensionFilter;
	IBOutlet id o_preserveDirectoryStructure;
	IBOutlet id o_dontPromptForCDDB;
	IBOutlet id o_forceReadCuesheet;
	IBOutlet id o_appendBOM;
	IBOutlet id o_existingFile;
	IBOutlet id o_quitWhenDone;
	IBOutlet id o_expandImage;
	IBOutlet id o_autoLoadCoverArt;
	IBOutlet id o_autoLoadCoverArtName;
	IBOutlet id o_autoLoadCoverArtDontOverwrite;
	IBOutlet id o_embedCoverArts;
	IBOutlet id o_preferencesTab;
	IBOutlet id o_dontReadSubchannel;
	IBOutlet id o_moveAfterFinish;
	IBOutlet id o_autoSetCompilation;
	IBOutlet id o_preserveUnknownMetadata;
	IBOutlet id o_keepTimeStamp;
	IBOutlet id o_textGroup_1_1;
	IBOutlet id o_textGroup_1_2;
	IBOutlet id o_textGroup_1_3;
	IBOutlet id o_textGroup_1_4;
	IBOutlet id o_textGroup_1_5;
	id multipleOutputFormatMatrix;
	//id decoder;
	id decoderCenter;
	id defaultOutput;
	id cueParser;
	id player;
	XLDCDDBUtil *util;
	id taskQueue;
	id metadataEditor;
	NSMutableArray *serverList;
	//BOOL decoding;
	NSMutableArray *outputArr;
	BOOL launched;
	//NSString *queuedFile;
	NSMutableArray *queue;
	BOOL firstDrag;
	struct statfs statDisc;
	BOOL ejected;
	NSString *tempOutputDir;
	id updater;
	BOOL driveIsBusy;
	BOOL openingFiles;
	BOOL cancelScan;
	NSTimeInterval launchDate;
	DASessionRef daSession;
}
- (IBAction)beginDecode:(id)sender;
- (IBAction)cancelDecode:(id)sender;
- (IBAction)setOutputDir:(id)sender;
- (IBAction)openFile:(id)sender;
- (IBAction)openRawFile:(id)sender;
- (IBAction)formatChanged:(id)sender;
- (IBAction)showOption:(id)sender;
- (IBAction)hideOption:(id)sender;
- (IBAction)checkSelected:(id)sender;
- (IBAction)uncheckSelected:(id)sender;
- (IBAction)cddbGetTracks:(id)sender;
- (IBAction)closeQueryResult:(id)sender;
- (IBAction)addServerList:(id)sender;
- (IBAction)rawFormatSelected:(id)sender;
- (IBAction)toggleSenderItem:(id)sender;
- (IBAction)saveImage:(id)sender;
- (IBAction)editMetadata:(id)sender;
- (IBAction)statusChanged:(id)sender;
- (IBAction)updateCDDAList:(id)sender;
- (IBAction)saveCuesheet:(id)sender;
- (IBAction)readModeChanged:(id)sender;
- (IBAction)showWindow:(id)sender;
- (IBAction)checkAccurateRip:(id)sender;
- (IBAction)saveOffsetCorrectedFile:(id)sender;
- (IBAction)checkForUpdates:(id)sender;
- (IBAction)stopModal:(id)sender;
- (IBAction)analyzeCache:(id)sendor;
- (IBAction)cancelScan:(id)sender;
- (IBAction)openCoverImage:(id)sender;
- (IBAction)inputTagsFromText:(id)sender;
- (IBAction)donate:(id)sender;
//- (void)finishedDecoding;
//- (void)updateProgress:(double)val restTracks:(int)n;
//- (BOOL)ignoreGap;
//- (BOOL)tagging;
- (id)table;
- (id)decoderCenter;
//- (BOOL)canOverwriteFile;
- (void)processQueue;
- (void)processMultipleFiles;
- (void)processRawFile:(NSString *)filename withFormat:(XLDFormat)fmt endian:(XLDEndian)e;
- (int)offset;
- (int)cddbQueryFlag;
- (NSStringEncoding)encoding;
- (int)maxThreads;
- (void)imageLoadedFromOutside:(BOOL)flag;
- (void)discRippedWithResult:(id)result;
- (void)accurateRipCheckDidFinish:(id)result;
- (NSString *)preferredFilenameForTrack:(id)trk index:(int)idx baseDir:(NSString *)outputDir createSubDir:(BOOL)createSubDir singleImageMode:(BOOL)singleImageMode albumArtist:aartist;
- (void)updateCDDAListAndMount:(NSString *)device;
- (BOOL)canSetCompilationFlag;
- (BOOL)checkUpdateStatus;
- (void)setCheckUpdateStatus:(BOOL)flag;
- (void)tagEditDidFinishForTracks:(NSArray *)tracks albumRanges:(NSArray *)ranges tasks:(NSArray *)tasks;
- (void)tagsUpdated;
- (NSArray *)currentTrackList;
@end
