//
//  XLDCDDBUtil.m
//  XLD
//
//  Created by tmkk on 06/08/25.
//  Copyright 2006 tmkk. All rights reserved.
//

#import "XLDCDDBUtil.h"
#import "XLDTrack.h"
#import "XLDController.h"
#import <openssl/sha.h>
#import <openssl/bio.h>
#import <openssl/evp.h>
#import <openssl/buffer.h>
#import <musicbrainz3/webservice.h>
#import <musicbrainz3/query.h>
#import <musicbrainz3/model.h>

using namespace std;
using namespace MusicBrainz;

static char *base64enc(const unsigned  char *input, int length)
{
	BIO *bmem, *b64;
	BUF_MEM *bptr;
	int i;
	
	b64 = BIO_new(BIO_f_base64());
	bmem = BIO_new(BIO_s_mem());
	b64 = BIO_push(b64, bmem);
	BIO_write(b64, input, length);
	BIO_flush(b64);
	BIO_get_mem_ptr(b64, &bptr);
	
	char *buff = (char *)malloc(bptr->length);
	memcpy(buff, bptr->data, bptr->length-1);
	buff[bptr->length-1] = 0;
	for(i=0;i<bptr->length-1;i++) {
		if(buff[i] == '+') buff[i] = '.';
		else if(buff[i] == '/') buff[i] = '_';
		else if(buff[i] == '=') buff[i] = '-';
	}
	
	BIO_free_all(b64);
	
	return buff;
}

@implementation XLDCDDBUtil

- (id)init
{
	[super init];
	disc = cddb_disc_new();
	conn = cddb_new();
	delegate = nil;
	useProxy = NO;
	trackArr = nil;
	queryResult = [[NSMutableArray alloc] init];
	results = NULL;
	coverImg = nil;
	coverData = nil;
	q = (void *)new Query();
	return self;
}

- (id)initWithDelegate:(id)del
{
	[self init];
	delegate = [del retain];
	return self;
}

- (void)dealloc
{
	if(disc) cddb_disc_destroy(disc);
	if(conn) cddb_destroy(conn);
	if(delegate) [delegate release];
	if(trackArr) [trackArr release];
	if(coverImg) [coverImg release];
	if(coverData) [coverData release];
	if(results) {
		ReleaseResultList::iterator i;
		for (i = ((ReleaseResultList *)results)->begin(); i != ((ReleaseResultList *)results)->end(); i++) {
			delete *i;
		}
		delete (ReleaseResultList *)results;
	}
	delete (Query *)q;
	[queryResult release];
	[super dealloc];
}

- (void)setTracks:(NSArray *)tracks totalFrame:(int)frames
{
	SHA_CTX	sha;
	unsigned char	digest[20];
	char *base64;
	char		tmp[17];
	int i;
	
	int totalAudioFrames = frames;
	totalAudioTrack = [tracks count];
	if((totalAudioTrack > 1) && ![[tracks objectAtIndex:totalAudioTrack-1] enabled]) {
		int tmp1,tmp2;
		tmp1 = [(XLDTrack *)[tracks objectAtIndex:totalAudioTrack-1] index];
		tmp2 = [(XLDTrack *)[tracks objectAtIndex:totalAudioTrack-2] index] + [(XLDTrack *)[tracks objectAtIndex:totalAudioTrack-2] frames];
		if((tmp1 - tmp2) == 11400*588) {
			totalAudioTrack--;
			totalAudioFrames = tmp2;
		}
	}
	
	cddb_disc_set_length(disc, 2+(unsigned int)(frames/44100.0));
	for (i = 0; i < [tracks count]; i++) {
		cddb_track_t *track = cddb_track_new();
		if (track == NULL) {
			fprintf(stderr, "out of memory, unable to create track");
		}
		cddb_track_set_frame_offset(track, (unsigned int)([(XLDTrack *)[tracks objectAtIndex:i] index]*75.0/44100.0)+150);
		cddb_disc_add_track(disc, track);
	}
	
	SHA1_Init(&sha);
	sprintf(tmp, "%02X", 1);
	SHA1_Update(&sha, (unsigned char *) tmp, strlen(tmp));
	sprintf(tmp, "%02X", totalAudioTrack);
	SHA1_Update(&sha, (unsigned char *) tmp, strlen(tmp));
	sprintf(tmp, "%08X", (unsigned int)((totalAudioFrames*75.0/44100.0)+150));
	SHA1_Update(&sha, (unsigned char *) tmp, strlen(tmp));
	for (i = 1; i <= totalAudioTrack; i++) {
		sprintf(tmp, "%08X", (unsigned int)([(XLDTrack *)[tracks objectAtIndex:i-1] index]*75.0/44100.0)+150);
		SHA1_Update(&sha, (unsigned char *) tmp, strlen(tmp));
	}
	for (; i < 100; i++) {
		sprintf(tmp, "%08X", 0);
		SHA1_Update(&sha, (unsigned char *) tmp, strlen(tmp));
	}
	SHA1_Final(digest, &sha);
	base64 = base64enc(digest, sizeof(digest));
	strcpy(discid, base64);
	free(base64);
	//NSLog(@"%s",discid);
	
	trackArr = [tracks retain];
}

- (void)setUseProxy:(BOOL)flag
{
	useProxy = flag;
}

- (void)setUseCache:(BOOL)flag
{
	if(flag) cddb_cache_enable(conn);
	else cddb_cache_disable(conn);
}

- (void)setServer:(NSString *)server port:(int)port path:(NSString *)path
{
	if(!useProxy) cddb_http_enable(conn);
	else cddb_http_proxy_enable(conn);
	cddb_set_server_port(conn, port);
	cddb_set_server_name(conn, [server UTF8String]);
	cddb_set_http_path_query(conn, [path UTF8String]);
}

- (void)setProxyServer:(NSString *)server port:(int)port user:(NSString *)user passwd:(NSString *)passwd
{
	cddb_set_http_proxy_server_name(conn, [server UTF8String]);
	cddb_set_http_proxy_server_port(conn, port);
	if(user && passwd && [user length] && [passwd length]) cddb_set_http_proxy_credentials(conn, [user UTF8String], [passwd UTF8String]);
}

- (int)query
{
	int i;
	int matches = cddb_query(conn, disc);
	try {
		ReleaseFilter f = ReleaseFilter().discId(string(discid));
        results = (void *)new ReleaseResultList(((Query *)q)->getReleases(&f));
	}
	catch (...) {
		NSLog(@"MusicBrainz connection error");
	}
	int matchesMB = results ? (int)(((ReleaseResultList *)results)->size()) : -1;
	//NSLog(@"mb:%d",matchesMB);
	if(matches < 1 && matchesMB < 1) {
		if(matches == -1 && matchesMB == -1) return -1;
		return 0;
	}
	if(matches == -1) matches = 0;
	if(matchesMB == -1) matchesMB = 0;
	
	for(i=0;i<matches;i++) {
		if(cddb_disc_get_artist(disc) && strlen(cddb_disc_get_artist(disc)) > 0 && cddb_disc_get_title(disc) && strlen(cddb_disc_get_title(disc)) > 0) {
			[queryResult addObject:
				[NSArray arrayWithObjects:
					@"FreeDB",
					[NSString stringWithUTF8String:cddb_disc_get_category_str(disc)],
					[NSNumber numberWithUnsignedInt:cddb_disc_get_discid(disc)],
					[NSString stringWithUTF8String:cddb_disc_get_title(disc)],
					[NSString stringWithUTF8String:cddb_disc_get_artist(disc)],
					nil]];
		}
		else if(cddb_disc_get_title(disc) && strlen(cddb_disc_get_title(disc)) > 0) {
			[queryResult addObject:
				[NSArray arrayWithObjects:
					@"FreeDB",
					[NSString stringWithUTF8String:cddb_disc_get_category_str(disc)],
					[NSNumber numberWithUnsignedInt:cddb_disc_get_discid(disc)],
					[NSString stringWithUTF8String:cddb_disc_get_title(disc)],
					nil]];
		}
		else if(cddb_disc_get_artist(disc) && strlen(cddb_disc_get_artist(disc)) > 0) {
			[queryResult addObject:
				[NSArray arrayWithObjects:
					@"FreeDB",
					[NSString stringWithUTF8String:cddb_disc_get_category_str(disc)],
					[NSNumber numberWithUnsignedInt:cddb_disc_get_discid(disc)],
					@"Unknown Title",
					[NSString stringWithUTF8String:cddb_disc_get_artist(disc)],
					nil]];
		}
		else {
			[queryResult addObject:
				[NSArray arrayWithObjects:
					@"FreeDB",
					[NSString stringWithUTF8String:cddb_disc_get_category_str(disc)],
					[NSNumber numberWithUnsignedInt:cddb_disc_get_discid(disc)],
					@"Unknown Title",
					nil]];
		}
		if(i<matches) cddb_query_next(conn,disc);
	}
	
	for(i=0;i<matchesMB;i++) {
		try {
			Release *release = ((ReleaseResultList *)results)->at(i)->getRelease();
			Artist *artist = release->getArtist();
			const char *titleStr = release->getTitle().c_str();
			const char *artistStr = artist->getName().c_str();
		
			if((artistStr && strlen(artistStr) > 0) && (titleStr && strlen(titleStr) > 0)) {
				[queryResult addObject:
					[NSArray arrayWithObjects:
						@"MusicBrainz",
						@"dummy",
						[NSNumber numberWithInt:i],
						[NSString stringWithUTF8String:titleStr],
						[NSString stringWithUTF8String:artistStr],
						nil]];
			}
			else if(titleStr && strlen(titleStr) > 0) {
				[queryResult addObject:
					[NSArray arrayWithObjects:
						@"MusicBrainz",
						@"dummy",
						[NSNumber numberWithInt:i],
						[NSString stringWithUTF8String:titleStr],
						nil]];
			}
			else if(artistStr && strlen(artistStr) > 0) {
				[queryResult addObject:
					[NSArray arrayWithObjects:
						@"MusicBrainz",
						@"dummy",
						[NSNumber numberWithInt:i],
						@"Unknown Title",
						[NSString stringWithUTF8String:artistStr],
						nil]];
			}
			else {
				[queryResult addObject:
					[NSArray arrayWithObjects:
						@"MusicBrainz",
						@"dummy",
						[NSNumber numberWithInt:i],
						@"Unknown Title",
						nil]];
			}
			
		}
		catch (...) {
		}
	}
	//NSLog(@"%x",cddb_disc_get_discid(disc));
	return matches+matchesMB;
}

- (NSArray *)queryResult
{
	return queryResult;
}

- (void)readCDDBWithInfo:(NSArray *)info
{
	int i;
	const char *tmp;
	int flag = [delegate cddbQueryFlag];
	NSString *asin = nil;
	
	if([[info objectAtIndex:0] isEqualToString:@"FreeDB"]) {
		for(i=0;i<[queryResult count];i++) { // check if mb query exists for image download
			if([[[queryResult objectAtIndex:i] objectAtIndex:0] isEqualToString:@"MusicBrainz"]) {
				Release *release = NULL;
				try {
					release = ((Query *)q)->getReleaseById(((ReleaseResultList *)results)->at([[[queryResult objectAtIndex:i] objectAtIndex:2] intValue])->getRelease()->getId(),&ReleaseIncludes().tracks().artist().releaseEvents());
				}
				catch (...) {
					if(release) delete release;
					break;
				}
				tmp = release->getAsin().c_str();
				if(tmp && (strlen(tmp) > 0)) {
#ifdef __ppc__
					asin = [NSString stringWithCString:tmp];
#else
					asin = [NSString stringWithCString:tmp encoding:NSASCIIStringEncoding];
#endif
					//NSLog(asin);
				}
				delete release;
				break;
			}
		}
		cddb_disc_set_category_str(disc,[[info objectAtIndex:1] UTF8String]);
		cddb_disc_set_discid(disc,[[info objectAtIndex:2] unsignedIntValue]);
		cddb_read(conn, disc);
		
		for (i = 0; i < [trackArr count]; i++) {
			XLDTrack *trk = [trackArr objectAtIndex:i];
			cddb_track_t *track = cddb_disc_get_track(disc, i);
			if(flag&XLDCDDBQueryTrackTitleMask) {
				tmp = cddb_track_get_title(track);
				if(tmp && (strlen(tmp) > 0)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_TITLE]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_TITLE];
				}
			}
			if(flag&XLDCDDBQueryArtistMask) {
				tmp = cddb_track_get_artist(track);
				if(tmp && (strlen(tmp) > 0)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_ARTIST]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_ARTIST];
				}
			}
			if(flag&XLDCDDBQueryDiscTitleMask) {
				tmp = cddb_disc_get_title(disc);
				if(tmp && (strlen(tmp) > 0)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_ALBUM]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_ALBUM];
				}
			}
			if(flag&XLDCDDBQueryGenreMask) {
				tmp = cddb_disc_get_genre(disc);
				if(tmp && (strlen(tmp) > 0)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_GENRE]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_GENRE];
				}
			}
			if(flag&XLDCDDBQueryYearMask) {
				int year = cddb_disc_get_year(disc);
				if(year > 0) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_YEAR]))
						[[trk metadata] setObject:[NSNumber numberWithInt:year] forKey:XLD_METADATA_YEAR];
				}
			}
		}
	}
	else {
		Release *release = NULL;
		try {
			release = ((Query *)q)->getReleaseById(((ReleaseResultList *)results)->at([[info objectAtIndex:2] intValue])->getRelease()->getId(),&ReleaseIncludes().tracks().artist().releaseEvents());
		}
		catch (...) {
			if(release) delete release;
			return;
		}
		TrackList::iterator j = release->getTracks().begin();
		for (i=0; j != release->getTracks().end(); j++,i++) {
			XLDTrack *trk = [trackArr objectAtIndex:i];
			Track *mbtrk = *j;
			if(flag&XLDCDDBQueryTrackTitleMask) {
				tmp = mbtrk->getTitle().c_str();
				if(tmp && (strlen(tmp) > 0)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_TITLE]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_TITLE];
				}
			}
			if(flag&XLDCDDBQueryArtistMask) {
				Artist *artist = mbtrk->getArtist();
				if(!artist) artist = release->getArtist();
				tmp = artist->getName().c_str();
				if(tmp && (strlen(tmp) > 0)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_ARTIST]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_ARTIST];
				}
			}
			if(flag&XLDCDDBQueryDiscTitleMask) {
				tmp = release->getTitle().c_str();
				if(tmp && (strlen(tmp) > 0)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_ALBUM]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_ALBUM];
				}
			}
			if(flag&XLDCDDBQueryYearMask) {
				int num = release->getNumReleaseEvents();
				int year;
				if(num) {
					ReleaseEvent *evt = release->getReleaseEvent(0);
					tmp = evt->getDate().c_str();
					year = (tmp && strlen(tmp) > 3) ? atoi(tmp) : 0;
					//NSLog(@"%s,%d",tmp,year);
				}
				if(strlen(tmp)) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_YEAR]))
						[[trk metadata] setObject:[NSString stringWithUTF8String:tmp] forKey:XLD_METADATA_DATE];
				}
				if(year > 0) {
					if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[trk metadata] objectForKey:XLD_METADATA_YEAR]))
						[[trk metadata] setObject:[NSNumber numberWithInt:year] forKey:XLD_METADATA_YEAR];
				}
			}
		}
		tmp = release->getAsin().c_str();
		if(tmp && (strlen(tmp) > 0)) {
#ifdef __ppc__
			asin = [NSString stringWithCString:tmp];
#else
			asin = [NSString stringWithCString:tmp encoding:NSASCIIStringEncoding];
#endif
			//NSLog(asin);
		}
		delete release;
	}
	
	if((flag&XLDCDDBQueryCoverArtMask) && asin) {
		if(!(flag&XLDCDDBQueryEmptyOnlyMask) || ((flag&XLDCDDBQueryEmptyOnlyMask) && ![[[trackArr objectAtIndex:0] metadata] objectForKey:XLD_METADATA_COVER])) {
			NSURL *imageURL = [NSURL URLWithString:[NSString stringWithFormat:@"http://ecx.images-amazon.com/images/P/%@.00._SCRMZZZZZZ_.jpg",asin]];
			coverData = [[NSData alloc] initWithContentsOfURL:imageURL];
			coverImg = [[NSImage alloc] initWithData:coverData];
			if(coverImg && (([coverImg size].width < 170) && ([coverImg size].width < 170))) {
				[coverImg release];
				coverImg = nil;
				[coverData release];
				coverData = nil;
			}
			if(!coverImg) {
				if(coverData) [coverData release];
				imageURL = [NSURL URLWithString:[NSString stringWithFormat:@"http://ecx.images-amazon.com/images/P/%@.00.LZZZZZZZ.jpg",asin]];
				coverData = [[NSData alloc] initWithContentsOfURL:imageURL];
				coverImg = [[NSImage alloc] initWithData:coverData];
				if(coverImg && (([coverImg size].width < 170) && ([coverImg size].width < 170))) {
					[coverImg release];
					coverImg = nil;
					[coverData release];
					coverData = nil;
				}
			}
			//NSLog([imageURL description]);
		}
	}
}

- (NSData *)coverData
{
	return coverData;
}

- (NSImage *)coverImg
{
	return coverImg;
}

@end
