//
//  XLDCDDBUtil.h
//  XLD
//
//  Created by tmkk on 06/08/25.
//  Copyright 2006 tmkk. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <cddb/cddb.h>

enum
{
	XLDCDDBQueryEmptyOnlyMask	= 1,
	XLDCDDBQueryDiscTitleMask	= 2,
	XLDCDDBQueryTrackTitleMask	= 4,
	XLDCDDBQueryArtistMask		= 8,
	XLDCDDBQueryGenreMask		= 16,
	XLDCDDBQueryYearMask		= 32,
	XLDCDDBQueryCoverArtMask	= 64
};

@interface XLDCDDBUtil : NSObject {
	cddb_disc_t *disc;
	cddb_conn_t *conn;
	char discid[100];
	void *results;
	void *q;
	id delegate;
	BOOL useProxy;
	NSArray *trackArr;
	NSMutableArray *queryResult;
	NSImage *coverImg;
	NSData *coverData;
	int totalAudioTrack;
}

- (id)initWithDelegate:(id)del;
- (void)setTracks:(NSArray *)tracks totalFrame:(int)frames;
- (void)setUseProxy:(BOOL)flag;
- (void)setUseCache:(BOOL)flag;
- (void)setServer:(NSString *)server port:(int)port path:(NSString *)path;
- (void)setProxyServer:(NSString *)server port:(int)port user:(NSString *)user passwd:(NSString *)passwd;
- (int)query;
- (NSArray *)queryResult;
- (void)readCDDBWithInfo:(NSArray *)info;
- (NSImage *)coverImg;
- (NSData *)coverData;

@end
