//
//  XLDCDDARipper.m
//  XLD
//
//  Created by tmkk on 08/08/09.
//  Copyright 2008 tmkk. All rights reserved.
//
// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import <sys/fcntl.h>
#import "XLDCDDARipper.h"
#import "XLDAccurateRipDB.h"
#import "cdio_private.h"
#import "cachetest.c"
#import <fcntl.h>
#import <IOKit/storage/IOCDTypes.h>
#import <IOkit/storage/IOCDMediaBSDClient.h>

char *callback_msg[] = {
	"PARANOIA_CB_READ",           
	"PARANOIA_CB_VERIFY",         
	"PARANOIA_CB_FIXUP_EDGE",     
	"PARANOIA_CB_FIXUP_ATOM",     
	"PARANOIA_CB_SCRATCH",        
	"PARANOIA_CB_REPAIR",         
	"PARANOIA_CB_SKIP",           
	"PARANOIA_CB_DRIFT",          
	"PARANOIA_CB_BACKOFF",        
	"PARANOIA_CB_OVERLAP",        
	"PARANOIA_CB_FIXUP_DROPPED",  
	"PARANOIA_CB_FIXUP_DUPED",    
	"PARANOIA_CB_READERR"         
};

static paranoia_cb_mode_t callback_result; 

void paranoia_callback(long int n, paranoia_cb_mode_t ret)
{
	//if((ret != PARANOIA_CB_READ) && (ret != PARANOIA_CB_VERIFY) && (ret != PARANOIA_CB_OVERLAP)) NSLog(@"callback: %d (%s)\n",n,callback_msg[ret]);
	if(ret == PARANOIA_CB_FIXUP_EDGE) callback_result |= 0x1;
	else if(ret == PARANOIA_CB_FIXUP_ATOM) callback_result |= 0x2;
	else if(ret == PARANOIA_CB_SKIP) callback_result |= 0x4;
	else if(ret == PARANOIA_CB_DRIFT) callback_result |= 0x8;
	else if(ret == PARANOIA_CB_FIXUP_DROPPED) callback_result |= 0x10;
	else if(ret == PARANOIA_CB_FIXUP_DUPED) callback_result |= 0x20;
	else if(ret == PARANOIA_CB_READERR) callback_result |= 0x40;
	else if(ret == PARANOIA_CB_CACHEERR) callback_result |= 0x80;
}

@implementation XLDCDDARipper

+ (BOOL)canHandleFile:(char *)path
{
	return YES;
}

+ (BOOL)canLoadThisBundle
{
	return YES;
}

+ (int)analyzeCacheForDrive:(NSString *)device result:(cache_analysis_t *)result_t delegate:(id)delegate
{
	CdIo_t *p_cdio_test = cdio_open_osx((const char *)[device UTF8String]);
	if(!p_cdio_test) return -1;
	
	cdrom_drive_t *p_drive_test = cdio_cddap_identify_cdio(p_cdio_test,0,NULL);
	if(!p_drive_test) {
		cdio_destroy(p_cdio_test);
		return -1;
	}
    cdio_cddap_open(p_drive_test);
	
	short *buf = malloc(2352*5000);
	int ret = analyze_cache(p_drive_test,NULL,NULL,-1,buf,result_t);
	free(buf);
	
	cdio_cddap_close_no_free_cdio(p_drive_test);
	cdio_destroy(p_cdio_test);
	
	//NSLog(@"%d,%d,%d,%d",ret,result_t->have_cache,result_t->cache_sector_size,result_t->backseek_flush_capable);
	return ret;
}

- (id)init
{
	[super init];
	error = NO;
	srcPath = nil;
	p_cdio = NULL;
	p_drive = NULL;
	p_paranoia = NULL;
	retryCount = 1;
	cddaBuffer = (short *)malloc(65536);
	offsetCorrectionValue = 0;
	testMode = NO;
    endian = 0;
	result = NULL;
	negativeSideSample = calloc(4704,sizeof(unsigned int));
	positiveSideSample = calloc(4704,sizeof(unsigned int));
	useOldEngine = NO;
	cancel = NO;
	useC2Pointer = NO;
	burstBuffer = malloc((2352+294)*100);
	startLSN = 999999;
	cacheSectorCount = 0;
	return self;
}

- (BOOL)openFile:(char *)path
{
	//NSLog(@"open");
	unsigned int i, k, value;
	
	//NSLog(@"engine is: %@",useOldEngine ? @"old" : @"new");
	
	p_cdio = cdio_open_osx((const char *)path);
	if(!p_cdio) return NO;
	
	totalLSN = cdio_get_disc_last_lsn(p_cdio) - 150;
	totalFrames = 588*totalLSN;
	
	track_t i_tracks = cdio_get_num_tracks(p_cdio);
	firstAudioFrame = -1;
	for(i=1;i<=i_tracks;i++) {
		if(cdio_get_track_format(p_cdio,i) != TRACK_FORMAT_AUDIO) {
			if(i != 1) {
				if(cdio_get_track_format(p_cdio,i-1) == TRACK_FORMAT_AUDIO) {
					lastAudioFrame -= 11400*588;
				}
			}
			continue;
		}
		if(firstAudioFrame < 0) {
			if(i==1) firstAudioFrame = 0;
			else firstAudioFrame = cdio_get_track_lsn(p_cdio,i)*588;
		}
		lastAudioFrame = 588*(1+cdio_get_track_last_lsn(p_cdio,i));
	}
	
	//NSLog(@"%lld,%d,%d,%d",totalFrames,lastAudioFrame,totalLSN,lastAudioFrame/588);
	
	p_drive = cdio_cddap_identify_cdio(p_cdio,0,NULL);
	if(!p_drive) return NO;
    cdio_cddap_open(p_drive);
	
	//analyze_cache(p_drive,NULL,stderr,-1);
	
	if(useOldEngine) p_paranoia = cdio_paranoia_init_old(p_drive);
	else p_paranoia = cdio_paranoia_init(p_drive);
	if(!p_paranoia) return NO;
	
	//cdio_paranoia_modeset(p_paranoia, PARANOIA_MODE_FULL);
	
	if(srcPath) [srcPath release];
	srcPath = [[NSString alloc] initWithUTF8String:path];
	
	cddaBufferSize = 0;
	currentFrame = 0;
	currentTrack = 1;
	firstRead = YES;
	
	for(i = 0; i < 256; ++i){
		value = i;
		for(k = 0; k < 8; ++k){
			if(value & 1)
				value = 0xEDB88320 ^ (value >> 1);
			else
				value >>= 1;
		}
		crc32Table[i] = value;
	}
    endian = p_drive->bigendianp;
    
    generic_img_private_t *env = p_cdio->env;
	fd = env->fd;
	fcntl(fd,F_NOCACHE,1);
	
	cancel = NO;
	currentLSN = 0;
    
	return YES;
}

- (void)dealloc
{
	//NSLog(@"dealoced");
	if(p_paranoia) cdio_paranoia_free(p_paranoia);
    if(p_drive) cdio_cddap_close_no_free_cdio(p_drive);
    if(p_cdio) cdio_destroy(p_cdio);
	if(srcPath) [srcPath release];
	free(cddaBuffer);
	free(negativeSideSample);
	free(positiveSideSample);
	free(burstBuffer);
	[super dealloc];
}

- (int)samplerate
{
	return 44100;
}

- (int)bytesPerSample
{
	return 2;
}

- (int)channels
{
	return 2;
}

- (xldoffset_t)totalFrames
{
	return totalFrames;
}

- (int)isFloat
{
	return NO;
}

- (BOOL)readSectorWithC2Detection:(short *)buffer;
{
	int i;
	BOOL ret = NO;
	
	if((startLSN > currentLSN) || (startLSN + cacheSectorCount <= currentLSN)) {
		dk_cd_read_t sector;
		memset( &sector, 0, sizeof(sector) );
		cacheSectorCount = (currentLSN + 100 <= lastAudioFrame/588) ? 100 : 1;
		//NSLog(@"read %d sectors from %d (last %d)",cacheSectorCount,currentLSN,lastAudioFrame/588);
		
		sector.sectorArea = kCDSectorAreaUser + kCDSectorAreaErrorFlags;
		sector.sectorType = kCDSectorTypeCDDA;
		sector.bufferLength = (2352+294)*cacheSectorCount;
		sector.buffer = burstBuffer;
		sector.offset = currentLSN * (2352+294);
		ioctl(fd, DKIOCCDREAD, &sector);
		//if(err == -1) NSLog(@"read error");
		startLSN = currentLSN;
	}
	
	int startPoint = (currentLSN - startLSN)*(2352+294);
#ifdef _BIG_ENDIAN
	if(endian == 1) memcpy(buffer,burstBuffer+startPoint,2352);
	else {
		for(i=startPoint;i<startPoint+2352;i+=2) {
			short sample = *((short *)(burstBuffer+i));
			buffer[(i-startPoint)>>1] = ((sample >> 8) & 0xff) | (sample << 8);
		}
	}
#else
	if(endian == 1) {
		for(i=startPoint;i<startPoint+2352;i+=2) {
			short sample = *((short *)(burstBuffer+i));
			buffer[(i-startPoint)>>1] = ((sample >> 8) & 0xff) | (sample << 8);
		}
	}
	else memcpy(buffer,burstBuffer+startPoint,2352);
#endif
	
	for(i=startPoint+2352;i<startPoint+2352+294;i++) {
		if(burstBuffer[i] != 0) {
			ret = YES;
			break;
		}
	}
	
	return ret;
}

- (void)detectOffset:(BOOL)lastFlag
{
	int j,currentOffset;
	//NSLog(@"offset detection begin");
	if(!result) return;
	XLDCDDAResult *obj = result->parent;
	cddaRipResult *previousResult = [obj resultForIndex:currentTrack-1];
	unsigned int *negativeSideSamplePtr,*positiveSideSamplePtr;
	if(currentTrack & 1) {
		negativeSideSamplePtr = negativeSideSample;
		positiveSideSamplePtr = positiveSideSample;
	}
	else {
		negativeSideSamplePtr = positiveSideSample;
		positiveSideSamplePtr = negativeSideSample;
	}
	if(lastFlag) {
		for(j=2352;j<4704;j++) positiveSideSamplePtr[j] = 0;
	}
	for(currentOffset=-2352;currentOffset<=2352;currentOffset++) {
		unsigned int arHash = previousResult->arHash;
		if(currentOffset < 0) {
			arHash = arHash + previousResult->sampleSum*(-currentOffset);
			for(j=0;j<(-currentOffset);j++) {
				arHash += negativeSideSamplePtr[2352+currentOffset+j]*(j+1);
			}
			for(j=0;j<(-currentOffset);j++) {
				arHash -= positiveSideSamplePtr[2352+currentOffset+j]*(obj->actualLengthArr[currentTrack-2]+currentOffset+j+1) + positiveSideSamplePtr[2352+currentOffset+j]*(-currentOffset);
			}
		}
		else if(currentOffset > 0) {
			for(j=0;j<currentOffset;j++) {
				arHash += positiveSideSamplePtr[2352+j]*(obj->actualLengthArr[currentTrack-2]-currentOffset+j+1);
			}
			for(j=0;j<currentOffset;j++) {
				arHash += negativeSideSamplePtr[2352+j]*currentOffset;
			}
			for(j=0;j<currentOffset;j++) {
				arHash -= negativeSideSamplePtr[2352+j]*(j+1);
			}
			arHash = arHash - previousResult->sampleSum*currentOffset;
		}
		
		int queryResult = [[obj accurateRipDB] isAccurateCRC:arHash forTrack:currentTrack-1];
		if(queryResult != -1) {
			//NSLog(@"Track %d: offset: %d (confidence %d)",currentTrack-1,currentOffset,queryResult);
			[obj registerOffset:currentOffset withConfidence:queryResult];
			[previousResult->detectedOffset setObject:[NSNumber numberWithInt:currentOffset] forKey:[NSNumber numberWithUnsignedInt:arHash]];
		}
	}
}

- (int)decodeToBuffer:(int *)buffer frames:(int)count
{
	short *readBuf;
	short burstReadBuf[588*2];
	int i;
	if(firstRead) {
		[self seekToFrame:0];
	}
	
	int framesToCopy = count;
	
	if(cddaBufferSize) {
		if(framesToCopy > cddaBufferSize/4) {
			for(i=0;i<cddaBufferSize/2;i++) {
				buffer[i] = cddaBuffer[i] << 16;
			}
			framesToCopy -= cddaBufferSize/4;
			cddaBufferSize = 0;
		}
		else {
			for(i=0;i<framesToCopy*2;i++) {
				buffer[i] = cddaBuffer[i] << 16;
			}
			framesToCopy = 0;
			memmove(cddaBuffer,cddaBuffer+framesToCopy*2,cddaBufferSize-framesToCopy*4);
			cddaBufferSize = cddaBufferSize-framesToCopy*4;
		}
	}
	
	//NSLog(@"framesToCopy:%d",framesToCopy);
	
	while(framesToCopy) {
		if(cancel) return count;
		if(lastAudioFrame/588 == currentLSN) { // read-out offset
			memset(buffer+(count-framesToCopy)*2,0,framesToCopy*2*4);
			framesToCopy = 0;
		}
		else {
			callback_result = 0;
			if(useC2Pointer) {
				if([self readSectorWithC2Detection:burstReadBuf]) {
					//NSLog(@"c2 error detected");
					cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
					readBuf = cdio_paranoia_read_limited(p_paranoia,(void *)paranoia_callback,retryCount);
				}
				else readBuf = burstReadBuf;
			}
			else readBuf = cdio_paranoia_read_limited(p_paranoia,(void *)paranoia_callback,retryCount);
			
			if(!testMode) {
				if(callback_result & 0x1) result->edgeJitterCount++;
				if(callback_result & 0x2) result->atomJitterCount++;
				if(callback_result & 0x4) result->skipCount++;
				if(callback_result & 0x8) result->driftCount++;
				if(callback_result & 0x10) result->droppedCount++;
				if(callback_result & 0x20) result->duplicatedCount++;
				if(callback_result & 0x40) result->errorCount++;
				if(callback_result & 0x80) result->cacheErrorCount++;
				if(result->parent) {
					XLDCDDAResult *obj = result->parent;
					cddaRipResult *targetResult = [obj resultForIndex:currentTrack];
					if(callback_result & 0x1) targetResult->edgeJitterCount++;
					if(callback_result & 0x2) targetResult->atomJitterCount++;
					if(callback_result & 0x4) targetResult->skipCount++;
					if(callback_result & 0x8) targetResult->driftCount++;
					if(callback_result & 0x10) targetResult->droppedCount++;
					if(callback_result & 0x20) targetResult->duplicatedCount++;
					if(callback_result & 0x40) targetResult->errorCount++;
					if(callback_result & 0x80) targetResult->cacheErrorCount++;
				}
			}
			if(!useC2Pointer && useOldEngine && (callback_result & 0x30)) { //hack
				cdio_paranoia_free(p_paranoia);
				if(useOldEngine) p_paranoia = cdio_paranoia_init_old(p_drive);
				else p_paranoia = cdio_paranoia_init(p_drive);
                cdio_paranoia_modeset(p_paranoia, paranoiaMode);
				cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
				readBuf = cdio_paranoia_read_limited(p_paranoia,NULL,retryCount);
			}
			currentLSN++;
			if(framesToCopy < 588) {
				for(i=0;i<framesToCopy*2;i++) {
					buffer[i+(count-framesToCopy)*2] = readBuf[i] << 16;
				}
				memcpy(cddaBuffer,readBuf+framesToCopy*2,(588-framesToCopy)*4);
				cddaBufferSize = (588-framesToCopy)*4;
				framesToCopy = 0;
			}
			else {
				for(i=0;i<588*2;i++) {
					buffer[i+(count-framesToCopy)*2] = readBuf[i] << 16;
				}
				framesToCopy -= 588;
			}
			if(useOldEngine) {
				if(!testMode && result->checkInconsistency && (callback_result & 0x7f)) {
					short* tmpBuf = malloc(sizeof(short)*2*588);
					memcpy(tmpBuf,readBuf,2352);
					cdio_paranoia_seek(p_paranoia,-1,SEEK_CUR);
					readBuf = cdio_paranoia_read_limited(p_paranoia,NULL,retryCount);
					if(memcmp(tmpBuf,readBuf,2352)) {
						result->inconsistency++;
						[result->suspiciousPosition addObject:[NSNumber numberWithInt:currentLSN]];
						if(result->parent) {
							XLDCDDAResult *obj = result->parent;
							cddaRipResult *targetResult = [obj resultForIndex:currentTrack];
							targetResult->inconsistency++;
							[targetResult->suspiciousPosition addObject:[NSNumber numberWithInt:currentLSN]];
						}
					}
					free(tmpBuf);
				}
				if(!useC2Pointer && paranoiaMode && !(currentLSN & 0xff)) { //hack
					cdio_paranoia_seek(p_paranoia,0,SEEK_SET);
					cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
				}
			}
			else {
				if(callback_result & 0x7f) {
					if(!testMode && result->checkInconsistency) {
						short* tmpBuf = malloc(sizeof(short)*2*588);
						memcpy(tmpBuf,readBuf,2352);
						cdio_paranoia_seek(p_paranoia,-1,SEEK_CUR);
						readBuf = cdio_paranoia_read_limited(p_paranoia,NULL,retryCount);
						if(memcmp(tmpBuf,readBuf,2352)) {
							result->inconsistency++;
							[result->suspiciousPosition addObject:[NSNumber numberWithInt:currentLSN]];
							if(result->parent) {
								XLDCDDAResult *obj = result->parent;
								cddaRipResult *targetResult = [obj resultForIndex:currentTrack];
								targetResult->inconsistency++;
								[targetResult->suspiciousPosition addObject:[NSNumber numberWithInt:currentLSN]];
							}
						}
						free(tmpBuf);
					}
					if(!useC2Pointer) {
						cdio_paranoia_seek(p_paranoia,0,SEEK_SET);
						cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
					}
				}
				else if(!useC2Pointer && paranoiaMode && !(currentLSN & 0xfff)) { //hack
					cdio_paranoia_seek(p_paranoia,0,SEEK_SET);
					cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
				}
			}
		}
	}
	
	if(endian == 1) {
		for(i=0;i<count*2;i++) {
			short sample = (buffer[i] >> 16) & 0xffff;
			sample = (sample << 8) | ((sample >> 8) & 0xff);
			buffer[i] = sample << 16;
		}
	}
	
	if(result->scanReplayGain && !testMode) {
		if(result->parent) {
			XLDCDDAResult *obj = result->parent;
			if(currentTrack <= obj->trackNumber) {
				if(currentFrame+count >= obj->actualLengthArr[currentTrack-1]) {
					cddaRipResult *targetResult = [obj resultForIndex:currentTrack];
					gain_analyze_samples_interleaved_int32(result->rg,buffer,obj->actualLengthArr[currentTrack-1]-currentFrame,2);
					targetResult->trackGain = PINK_REF-gain_get_title(result->rg);
					targetResult->peak = peak_get_title(result->rg);
					gain_analyze_samples_interleaved_int32(result->rg,buffer+2*(obj->actualLengthArr[currentTrack-1]-currentFrame),count+currentFrame-obj->actualLengthArr[currentTrack-1],2);
					//NSLog(@"track %d: gain %.2f, peak %f",currentTrack,targetResult->trackGain,targetResult->peak);
				}
				else gain_analyze_samples_interleaved_int32(result->rg,buffer,count,2);
			}
		}
		else gain_analyze_samples_interleaved_int32(result->rg,buffer,count,2);
	}
	
	for(i=0;i<count;i++) {
		unsigned int sample = ((buffer[i*2] >> 16)&0xffff) | buffer[i*2+1];
		if(result->parent) {
			XLDCDDAResult *obj = result->parent;
			cddaRipResult *targetResult = [obj resultForIndex:currentTrack];
			if(targetResult->gapLength > currentFrame) {
				++currentFrame;
				continue;
			}
			if(!testMode) {
				
				/* offset detection */
				if([obj accurateRipDB]) {
					if(currentTrack & 1) {
						if((currentTrack <= obj->trackNumber) && (currentFrame >= obj->actualLengthArr[currentTrack-1]-2352)) {
							negativeSideSample[2352+currentFrame - obj->actualLengthArr[currentTrack-1]] = sample;
						}
						if(currentFrame < 2352) {
							positiveSideSample[2352+currentFrame] = sample;
						}
					}
					else {
						if((currentTrack <= obj->trackNumber) && (currentFrame >= obj->actualLengthArr[currentTrack-1]-2352)) {
							positiveSideSample[2352+currentFrame - obj->actualLengthArr[currentTrack-1]] = sample;
						}
						if(currentFrame < 2352) {
							negativeSideSample[2352+currentFrame] = sample;
						}
					}
					if((currentTrack > 1) && (currentFrame == 2352)) [self detectOffset:NO];
				}
				
				/* offset detection end */
				
				if(targetResult->startPoint > currentFrame) ++currentFrame;
				else if(targetResult->endPoint && (targetResult->endPoint <= currentFrame)) ++currentFrame;
				else {
					targetResult->arHash += (++currentFrame - targetResult->gapLength) * sample;
					targetResult->sampleSum += sample;
				}
				targetResult->crc32 = (targetResult->crc32 >> 8) ^ crc32Table[(targetResult->crc32 ^ (sample)) & 0xFF];
				targetResult->crc32 = (targetResult->crc32 >> 8) ^ crc32Table[(targetResult->crc32 ^ (sample>>8)) & 0xFF];
				targetResult->crc32 = (targetResult->crc32 >> 8) ^ crc32Table[(targetResult->crc32 ^ (sample>>16)) & 0xFF];
				targetResult->crc32 = (targetResult->crc32 >> 8) ^ crc32Table[(targetResult->crc32 ^ (sample>>24)) & 0xFF];
				if(buffer[i*2] != 0) {
					targetResult->crc32_eac = (targetResult->crc32_eac >> 8) ^ crc32Table[(targetResult->crc32_eac ^ (sample)) & 0xFF];
					targetResult->crc32_eac = (targetResult->crc32_eac >> 8) ^ crc32Table[(targetResult->crc32_eac ^ (sample>>8)) & 0xFF];
				}
				if(buffer[i*2+1] != 0) {
					targetResult->crc32_eac = (targetResult->crc32_eac >> 8) ^ crc32Table[(targetResult->crc32_eac ^ (sample>>16)) & 0xFF];
					targetResult->crc32_eac = (targetResult->crc32_eac >> 8) ^ crc32Table[(targetResult->crc32_eac ^ (sample>>24)) & 0xFF];
				}
			}
			else {
				++currentFrame;
				targetResult->crc32_test = (targetResult->crc32_test >> 8) ^ crc32Table[(targetResult->crc32_test ^ (sample)) & 0xFF];
				targetResult->crc32_test = (targetResult->crc32_test >> 8) ^ crc32Table[(targetResult->crc32_test ^ (sample>>8)) & 0xFF];
				targetResult->crc32_test = (targetResult->crc32_test >> 8) ^ crc32Table[(targetResult->crc32_test ^ (sample>>16)) & 0xFF];
				targetResult->crc32_test = (targetResult->crc32_test >> 8) ^ crc32Table[(targetResult->crc32_test ^ (sample>>24)) & 0xFF];
			}
			if((currentTrack <= obj->trackNumber) && (currentFrame == obj->actualLengthArr[currentTrack-1])) {
				currentTrack++;
				if([obj accurateRipDB]) {
					if(currentTrack > obj->trackNumber) {
						[self detectOffset:YES];
					}
					else if(cdio_get_track_format(p_cdio,currentTrack) != TRACK_FORMAT_AUDIO) {
						[self detectOffset:YES];
					}
				}
				currentFrame = 0;
				//if(useOldEngine) {
					cdio_paranoia_free(p_paranoia);
					cdio_cddap_close_no_free_cdio(p_drive);
					p_drive = cdio_cddap_identify_cdio(p_cdio,0,NULL);
					cdio_cddap_open(p_drive);
					if(useOldEngine) p_paranoia = cdio_paranoia_init_old(p_drive);
					else p_paranoia = cdio_paranoia_init(p_drive);
					cdio_paranoia_modeset(p_paranoia, paranoiaMode);
					cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
				//}
			}
		}
		else {
			if(result->gapLength > currentFrame) {
				++currentFrame;
				continue;
			}
			if(!testMode) {
				if(result->startPoint > currentFrame) ++currentFrame;
				else if(result->endPoint && (result->endPoint <= currentFrame)) ++currentFrame;
				else {
					result->arHash += (++currentFrame - result->gapLength) * sample;
					result->sampleSum += sample;
				}
			}
			else ++currentFrame;
		}
		if(!testMode) {
			result->crc32 = (result->crc32 >> 8) ^ crc32Table[(result->crc32 ^ (sample)) & 0xFF];
			result->crc32 = (result->crc32 >> 8) ^ crc32Table[(result->crc32 ^ (sample>>8)) & 0xFF];
			result->crc32 = (result->crc32 >> 8) ^ crc32Table[(result->crc32 ^ (sample>>16)) & 0xFF];
			result->crc32 = (result->crc32 >> 8) ^ crc32Table[(result->crc32 ^ (sample>>24)) & 0xFF];
			if(buffer[i*2] != 0) {
				result->crc32_eac = (result->crc32_eac >> 8) ^ crc32Table[(result->crc32_eac ^ (sample)) & 0xFF];
				result->crc32_eac = (result->crc32_eac >> 8) ^ crc32Table[(result->crc32_eac ^ (sample>>8)) & 0xFF];
			}
			if(buffer[i*2+1] != 0) {
				result->crc32_eac = (result->crc32_eac >> 8) ^ crc32Table[(result->crc32_eac ^ (sample>>16)) & 0xFF];
				result->crc32_eac = (result->crc32_eac >> 8) ^ crc32Table[(result->crc32_eac ^ (sample>>24)) & 0xFF];
			}
		}
		else {
			result->crc32_test = (result->crc32_test >> 8) ^ crc32Table[(result->crc32_test ^ (sample)) & 0xFF];
			result->crc32_test = (result->crc32_test >> 8) ^ crc32Table[(result->crc32_test ^ (sample>>8)) & 0xFF];
			result->crc32_test = (result->crc32_test >> 8) ^ crc32Table[(result->crc32_test ^ (sample>>16)) & 0xFF];
			result->crc32_test = (result->crc32_test >> 8) ^ crc32Table[(result->crc32_test ^ (sample>>24)) & 0xFF];
		}
	}
	
	return count;
}

- (int)decodeToBufferWithoutReport:(int *)buffer frames:(int)count
{
	short* readBuf;
	short burstReadBuf[588*2];
	int i;
	if(firstRead) {
		[self seekToFrame:0];
	}
	
	int framesToCopy = count;
	
	if(cddaBufferSize) {
		if(framesToCopy > cddaBufferSize/4) {
			for(i=0;i<cddaBufferSize/2;i++) {
				buffer[i] = cddaBuffer[i] << 16;
			}
			framesToCopy -= cddaBufferSize/4;
			cddaBufferSize = 0;
		}
		else {
			for(i=0;i<framesToCopy*2;i++) {
				buffer[i] = cddaBuffer[i] << 16;
			}
			framesToCopy = 0;
			memmove(cddaBuffer,cddaBuffer+framesToCopy*2,cddaBufferSize-framesToCopy*4);
			cddaBufferSize = cddaBufferSize-framesToCopy*4;
		}
	}
	
	//NSLog(@"framesToCopy:%d",framesToCopy);
	
	while(framesToCopy) {
		if(lastAudioFrame/588 == currentLSN) { // read-out offset
			memset(buffer+(count-framesToCopy)*2,0,framesToCopy*2*4);
			framesToCopy = 0;
		}
		else {
			callback_result = 0;
			if(useC2Pointer) {
				if([self readSectorWithC2Detection:burstReadBuf]) {
					//NSLog(@"c2 error detected");
					cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
					readBuf = cdio_paranoia_read_limited(p_paranoia,(void *)paranoia_callback,retryCount);
				}
				else readBuf = burstReadBuf;
			}
			else readBuf = cdio_paranoia_read_limited(p_paranoia,(void *)paranoia_callback,retryCount);
			if(!testMode) {
				if(callback_result & 0x1) result->edgeJitterCount++;
				if(callback_result & 0x2) result->atomJitterCount++;
				if(callback_result & 0x4) result->skipCount++;
				if(callback_result & 0x8) result->driftCount++;
				if(callback_result & 0x10) result->droppedCount++;
				if(callback_result & 0x20) result->duplicatedCount++;
				if(callback_result & 0x40) result->errorCount++;
				if(callback_result & 0x80) result->cacheErrorCount++;
				if(result->parent) {
					XLDCDDAResult *obj = result->parent;
					cddaRipResult *targetResult = [obj resultForIndex:currentTrack];
					if(callback_result & 0x1) targetResult->edgeJitterCount++;
					if(callback_result & 0x2) targetResult->atomJitterCount++;
					if(callback_result & 0x4) targetResult->skipCount++;
					if(callback_result & 0x8) targetResult->driftCount++;
					if(callback_result & 0x10) targetResult->droppedCount++;
					if(callback_result & 0x20) targetResult->duplicatedCount++;
					if(callback_result & 0x40) targetResult->errorCount++;
					if(callback_result & 0x80) targetResult->cacheErrorCount++;
				}
			}
			if(!useC2Pointer && useOldEngine && (callback_result & 0x30)) { //hack
				cdio_paranoia_free(p_paranoia);
				if(useOldEngine) p_paranoia = cdio_paranoia_init_old(p_drive);
				else p_paranoia = cdio_paranoia_init(p_drive);
                cdio_paranoia_modeset(p_paranoia, paranoiaMode);
				cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
				readBuf = cdio_paranoia_read_limited(p_paranoia,NULL,retryCount);
			}
			currentLSN++;
			if(framesToCopy < 588) {
				for(i=0;i<framesToCopy*2;i++) {
					buffer[i+(count-framesToCopy)*2] = readBuf[i] << 16;
				}
				memcpy(cddaBuffer,readBuf+framesToCopy*2,(588-framesToCopy)*4);
				cddaBufferSize = (588-framesToCopy)*4;
				framesToCopy = 0;
			}
			else {
				for(i=0;i<588*2;i++) {
					buffer[i+(count-framesToCopy)*2] = readBuf[i] << 16;
				}
				framesToCopy -= 588;
			}
			
			if(!useC2Pointer) {
				if(useOldEngine) {
					if(paranoiaMode && !(currentLSN & 0xff)) { //hack
						cdio_paranoia_seek(p_paranoia,0,SEEK_SET);
						cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
					}
				}
				else {
					if(callback_result & 0x7f) {
						cdio_paranoia_seek(p_paranoia,0,SEEK_SET);
						cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
					}
					else if(paranoiaMode && !(currentLSN & 0xfff)) { //hack
						cdio_paranoia_seek(p_paranoia,0,SEEK_SET);
						cdio_paranoia_seek(p_paranoia,currentLSN,SEEK_SET);
					}
				}
			}
		}
	}
	
	if(endian == 1) {
		for(i=0;i<count*2;i++) {
			short sample = (buffer[i] >> 16) & 0xffff;
			sample = (sample << 8) | ((sample >> 8) & 0xff);
			buffer[i] = sample << 16;
		}
	}
	
	return count;
}

- (xldoffset_t)seekToFrame:(xldoffset_t)count
{
	firstRead = NO;
	//currentFrame = count;
	int seekFrame = count + offsetCorrectionValue;
	int seekLSN = seekFrame/588;
	
	if(result->parent) {
		XLDCDDAResult *obj = result->parent;
		int i;
		for(i=0;i<obj->trackNumber;i++) {
			if(count<obj->indexArr[i]) break;
			currentTrack = i+1;
		}
	}
	if(seekFrame < firstAudioFrame) {
		cdio_paranoia_seek(p_paranoia,firstAudioFrame/588,SEEK_SET);
		cddaBufferSize = (firstAudioFrame-seekFrame)*2*2;
		memset(cddaBuffer,0,cddaBufferSize);
		currentLSN = firstAudioFrame/588;
	}
	else if(seekFrame >= lastAudioFrame) {
		//cdio_paranoia_seek(p_paranoia,totalLSN,SEEK_SET);
		currentLSN = lastAudioFrame/588;
		cddaBufferSize = 0;
	}
	else {
		currentLSN = seekLSN;
		int restFrame = seekFrame - seekLSN*588;
		if(restFrame) {
			short *buf, burstReadBuf[588*2];
			callback_result = 0;
			if(useC2Pointer) {
				if([self readSectorWithC2Detection:burstReadBuf]) {
					//NSLog(@"c2 error detected");
					cdio_paranoia_seek(p_paranoia,seekLSN,SEEK_SET);
					buf = cdio_paranoia_read_limited(p_paranoia,(void *)paranoia_callback,retryCount);
				}
				else buf = burstReadBuf;
			}
			else {
				cdio_paranoia_seek(p_paranoia,seekLSN,SEEK_SET);
				buf = cdio_paranoia_read_limited(p_paranoia,(void *)paranoia_callback,retryCount);
			}
			if(!testMode) {
				if(callback_result & 0x1) result->edgeJitterCount++;
				if(callback_result & 0x2) result->atomJitterCount++;
				if(callback_result & 0x4) result->skipCount++;
				if(callback_result & 0x8) result->driftCount++;
				if(callback_result & 0x10) result->droppedCount++;
				if(callback_result & 0x20) result->duplicatedCount++;
				if(callback_result & 0x40) result->errorCount++;
				if(callback_result & 0x80) result->cacheErrorCount++;
				if(result->parent) {
					XLDCDDAResult *obj = result->parent;
					cddaRipResult *targetResult = [obj resultForIndex:currentTrack];
					if(callback_result & 0x1) targetResult->edgeJitterCount++;
					if(callback_result & 0x2) targetResult->atomJitterCount++;
					if(callback_result & 0x4) targetResult->skipCount++;
					if(callback_result & 0x8) targetResult->driftCount++;
					if(callback_result & 0x10) targetResult->droppedCount++;
					if(callback_result & 0x20) targetResult->duplicatedCount++;
					if(callback_result & 0x40) targetResult->errorCount++;
					if(callback_result & 0x80) targetResult->cacheErrorCount++;
				}
			}
			currentLSN++;
			memcpy(cddaBuffer,buf+restFrame*2,(588-restFrame)*2*2);
			cddaBufferSize = (588-restFrame)*2*2;
		}
	}
	
	return count;
}

- (void)closeFile
{
	//NSLog(@"closed");
	if(p_paranoia) cdio_paranoia_free(p_paranoia);
    if(p_drive) cdio_cddap_close_no_free_cdio(p_drive);
    if(p_cdio) cdio_destroy(p_cdio);
	p_cdio = NULL;
	p_drive = NULL;
	p_paranoia = NULL;
	if(result) {
		if(result->scanReplayGain && !testMode) {
			if(!result->parent) {
				result->trackGain = PINK_REF-gain_get_title(result->rg);
				result->peak = peak_get_title(result->rg);
			}
		}
	}
	error = NO;
}

- (BOOL)error
{
	return error;
}

- (XLDEmbeddedCueSheetType)hasCueSheet
{
	return XLDNoCueSheet;
}

- (id)cueSheet
{
	return nil;
}

- (id)metadata
{
	return nil;
}

- (NSString *)srcPath
{
	return srcPath;
}

- (void)setParanoiaMode:(int)mode
{
	if(!p_paranoia) return;
	paranoiaMode = mode;
	cdio_paranoia_modeset(p_paranoia, mode);
	//NSLog(@"paranoia: %d",mode);
}

- (void)setOffsetCorrectionValue:(int)value
{
	offsetCorrectionValue = value;
	//NSLog(@"offset: %d",value);
}

- (void)setRetryCount:(int)value
{
	retryCount = value;
	//NSLog(@"retry: %d",value);
}

- (void)setResultStructure:(cddaRipResult *)ptr
{
	result = ptr;
}

- (void)setTestMode
{
	testMode = YES;
}

- (void)setUseOldEngine:(BOOL)flag
{
	useOldEngine = flag;
	//NSLog(@"engine set: %@",useOldEngine ? @"old" : @"new");
}

- (void)cancel
{
	cancel = YES;
}

- (void)setUseC2Pointer:(BOOL)flag
{
	useC2Pointer = flag;
}

@end
