//
//  XLDCDDARipper.h
//  XLD
//
//  Created by tmkk on 08/08/09.
//  Copyright 2008 tmkk. All rights reserved.
//
// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import <Cocoa/Cocoa.h>
#import <cdio/cdio.h>
#import <cdio/cdda.h>
#import <cdio/paranoia.h>
#import "XLDDecoder.h"
#import "XLDCDDAResult.h"

typedef struct
{
	BOOL have_cache;
	int cache_sector_size;
	int backseek_flush_capable;
} cache_analysis_t;

@interface XLDCDDARipper : NSObject <XLDDecoder>
{
	XLDFormat format;
	xldoffset_t totalFrames;
	BOOL error;
	NSString *srcPath;
	CdIo_t *p_cdio;
	cdrom_drive_t* p_drive;
	cdrom_paranoia_t* p_paranoia;
	int offsetCorrectionValue;
	int currentLSN;
	int totalLSN;
	short *cddaBuffer;
	int cddaBufferSize;
	BOOL firstRead;
	int retryCount;
	BOOL unmounted;
	cddaRipResult *result;
	unsigned int currentFrame;
	unsigned int crc32Table[256];
	int currentTrack;
	int paranoiaMode;
	BOOL testMode;
	unsigned int *negativeSideSample;
	unsigned int *positiveSideSample;
	int endian;
	BOOL useOldEngine;
	BOOL cancel;
	int firstAudioFrame;
	int lastAudioFrame;
	int fd;
	BOOL useC2Pointer;
	unsigned char *burstBuffer;
	int cacheSectorCount;
	int startLSN;
}

+ (BOOL)canHandleFile:(char *)path;
+ (BOOL)canLoadThisBundle;
+ (int)analyzeCacheForDrive:(NSString *)device result:(cache_analysis_t *)result_t delegate:(id)delegate;
- (BOOL)openFile:(char *)path;
- (int)samplerate;
- (int)bytesPerSample;
- (int)channels;
- (int)decodeToBuffer:(int *)buffer frames:(int)count;
- (int)decodeToBufferWithoutReport:(int *)buffer frames:(int)count;
- (void)closeFile;
- (xldoffset_t)seekToFrame:(xldoffset_t)count;
- (xldoffset_t)totalFrames;
- (int)isFloat;
- (BOOL)error;
- (XLDEmbeddedCueSheetType)hasCueSheet;
- (id)cueSheet;
- (id)metadata;
- (NSString *)srcPath;
- (void)setParanoiaMode:(int)mode;
- (void)setOffsetCorrectionValue:(int)value;
- (void)setRetryCount:(int)value;
- (void)setResultStructure:(cddaRipResult *)ptr;
- (void)setTestMode;
- (void)setUseOldEngine:(BOOL)flag;
- (void)cancel;
- (void)setUseC2Pointer:(BOOL)flag;
@end
