//
//  XLDCDDAResult.m
//  XLD
//
//  Created by tmkk on 08/08/13.
//  Copyright 2008 tmkk. All rights reserved.
//
// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import "XLDCDDAResult.h"
#import "XLDTrack.h"
#import "XLDAccurateRipDB.h"

static NSString *framesToMSFStr(xldoffset_t frames, int samplerate)
{
	int min = frames/samplerate/60;
	frames -= min*samplerate*60;
	int sec = frames/samplerate;
	frames -= sec*samplerate;
	int f = frames*75/samplerate;
	return [NSString stringWithFormat:@"%02d:%02d:%02d",min,sec,f];
}

static int intSort(id num1, id num2, void *context)
{
    int v1 = [num1 intValue];
    int v2 = [num2 intValue];
	
    if (v1 < v2)
        return NSOrderedDescending;
    else if (v1 > v2)
        return NSOrderedAscending;
    else
        return NSOrderedSame;
}

@implementation XLDCDDAResult

- (id)init
{
	[super init];
	date = nil;
	driveStr = nil;
	deviceStr = nil;
	results = NULL;
	title = nil;
	artist = nil;
	database = nil;
	useAccurateRipDB = NO;
	trustAccurateRipResult = NO;
	useOldEngine = NO;
	detectedOffset = [[NSMutableDictionary alloc] init];
	trackList = [[NSMutableArray alloc] init];
	cuePath = nil;
	cuePathArray = nil;
	rg = (replaygain_t *)malloc(sizeof(replaygain_t));
	gain_init_analysis(rg,44100);
	logFileName = nil;
	logDirectoryArray = [[NSMutableArray alloc] init];
	appendBOM = NO;
	return self;
}

- (id)initWithTrackNumber:(int)t
{
	[self init];
	results = (cddaRipResult *)malloc(sizeof(cddaRipResult)*(t+1));
	indexArr = (xldoffset_t *)malloc(sizeof(xldoffset_t)*t);
	lengthArr = (xldoffset_t *)malloc(sizeof(xldoffset_t)*t);
	actualLengthArr = (xldoffset_t *)malloc(sizeof(xldoffset_t)*t);
	int i;
	for(i=0;i<t+1;i++) {
		results[i].filename = nil;
		results[i].filelist = nil;
		results[i].enabled = NO;
		results[i].finished = NO;
		results[i].cancelled = NO;
		results[i].testEnabled = NO;
		results[i].testFinished = NO;
		results[i].errorCount = 0;
		results[i].skipCount = 0;
		results[i].edgeJitterCount = 0;
		results[i].atomJitterCount = 0;
		results[i].droppedCount = 0;
		results[i].duplicatedCount = 0;
		results[i].driftCount = 0;
		results[i].cacheErrorCount = 0;
		results[i].crc32 = 0xFFFFFFFF;
		results[i].crc32_eac = 0xFFFFFFFF;
		results[i].crc32_test = 0xFFFFFFFF;
		results[i].arHash = 0;
		results[i].gapLength = 0;
		results[i].startPoint = 0;
		results[i].endPoint = 0;
		results[i].inconsistency = 0;
		results[i].sampleSum = 0;
		results[i].suspiciousPosition = [[NSMutableArray alloc] init];
		results[i].checkInconsistency = NO;
		results[i].scanReplayGain = NO;
		results[i].rg = rg;
		results[i].trackGain = 0;
		results[i].peak = 0;
		results[i].detectedOffset = [[NSMutableDictionary alloc] init];
		results[i].parent = nil;
	}
	trackNumber = t;
	return self;
}

- (void)dealloc
{
	int i;
	if(results) {
		for(i=0;i<trackNumber+1;i++) {
			if(results[i].filename) [results[i].filename release];
			if(results[i].filelist) [results[i].filelist release];
			[results[i].suspiciousPosition release];
			[results[i].detectedOffset release];
		}
		free(results);
	}
	if(driveStr) [driveStr release];
	if(deviceStr) [deviceStr release];
	if(date) [date release];
	if(title) [title release];
	if(artist) [artist release];
	if(database) [database release];
	free(indexArr);
	free(lengthArr);
	free(actualLengthArr);
	[detectedOffset release];
	[trackList release];
	if(cuePath) [cuePath release];
	if(cuePathArray) [cuePathArray release];
	if(logFileName) [logFileName release];
	[logDirectoryArray release];
	[super dealloc];
}

- (cddaRipResult *)resultForIndex:(int)idx
{
	return &results[idx];
}

- (void)setDriveStr:(NSString *)str
{
	if(driveStr) [driveStr release];
	driveStr = [str retain];
}

- (void)setDeviceStr:(NSString *)str
{
	if(deviceStr) [deviceStr release];
	deviceStr = [str retain];
}

- (void)setDate:(NSDate *)d
{
	if(date) [date release];
	date = [d retain];
}

- (void)setLogFileName:(NSString *)str
{
	if(logFileName) [logFileName release];
	logFileName = [str retain];
}

- (NSString *)logFileName
{
	return logFileName;
}

- (void)addLogDirectory:(NSString *)str
{
	int i;
	for(i=0;i<[logDirectoryArray count];i++) {
		if([str isEqualToString:[logDirectoryArray objectAtIndex:i]]) return;
	}
	[logDirectoryArray addObject:str];
}

- (BOOL)allTasksFinished
{
	int i;
	if(!results) return YES;
	for(i=0;i<trackNumber+1;i++) {
		if(results[i].enabled && !results[i].finished) return NO;
		if(results[i].testEnabled && !results[i].testFinished) return NO;
	}
	return YES;
}

- (int)numberOfTracks
{
	return trackNumber;
}

- (NSString *)deviceStr
{
	return deviceStr;
}

- (void)setUseParanoia:(BOOL)flag
	  offsetCorrention:(int)o
			retryCount:(int)ret
	  useAccurateRipDB:(BOOL)useDB
	checkInconsistency:(BOOL)checkFlag
		 trustARResult:(BOOL)trustFlag
		scanReplayGain:(BOOL)rgFlag
		  useOldEngine:(BOOL)engineFlag
		  useC2Pointer:(BOOL)C2flag
			 gapStatus:(unsigned int)status
{
	useParanoia = flag;
	offset = o;
	retryCount = ret;
	useAccurateRipDB = useDB;
	trustAccurateRipResult = trustFlag;
	useOldEngine = engineFlag;
	useC2Pointer = C2flag;
	gapStatus = status;
	int i;
	for(i=0;i<trackNumber+1;i++) {
		results[i].checkInconsistency = checkFlag;
		results[i].scanReplayGain = rgFlag;
	}
}

- (NSString *)logStr
{
	if(!results) return nil;
	//if(!useParanoia) return nil;
	isGoodRip = YES;
	BOOL error = NO;
	BOOL inconsistency = NO;
	int i,j;
	NSMutableString *out = [[NSMutableString alloc] init];
	[out appendString:[NSString stringWithFormat:@"X Lossless Decoder version %@ (%@)\n\n",[[[NSBundle mainBundle] infoDictionary] valueForKey:@"CFBundleShortVersionString"],[[[NSBundle mainBundle] infoDictionary] valueForKey:@"CFBundleVersion"]]];
	[out appendString:[NSString stringWithFormat:@"XLD extraction logfile from %@\n\n",[date description]]];
	[out appendString:[NSString stringWithFormat:@"%@ / %@\n\n",artist ? artist : @"",title]];
	[out appendString:[NSString stringWithFormat:@"Used drive : %@\n\n",driveStr]];
	if(useParanoia) {
		[out appendString:[NSString stringWithFormat:@"Use cdparanoia mode     : YES (CDParanoia %@ engine)\n", useOldEngine ? @"III 9.8" : @"III 10.2"]];
		[out appendString:[NSString stringWithFormat:@"Disable audio cache     : OK for the drive with cache less than %dKB\n",useOldEngine ? 370 : 2750]];
	}
	else {
		[out appendString:@"Use cdparanoia mode     : NO\n"];
		[out appendString:@"Disable audio cache     : NO\n"];
	}
	[out appendString:[NSString stringWithFormat:@"Make use of C2 pointers : %@\n",useC2Pointer ? @"YES" : @"NO"]];
	[out appendString:[NSString stringWithFormat:@"Read offset correction  : %d\n",offset]];
	[out appendString:[NSString stringWithFormat:@"Max retry count         : %d\n",retryCount]];
	[out appendString:@"Gap status              : "];
	if(gapStatus >> 16) [out appendString:@"Not analyzed\n\n"];
	else {
		switch(gapStatus & 0xffff) {
			case 0:
				[out appendString:@"Analyzed, Appended\n\n"];
				break;
			case 1:
				[out appendString:@"Analyzed, Not appended\n\n"];
				break;
			case 2:
				[out appendString:@"Analyzed, Appended\n\n"];
				break;
			case 3:
				[out appendString:@"Analyzed, Appended (except HTOA)\n\n"];
				break;
			default:
				[out appendString:@"Unknown\n\n"];
				break;
		}
	}
	
	[out appendString:@"TOC of the extracted CD\n"];
	[out appendString:@"     Track |   Start  |  Length  | Start sector | End sector \n"];
	[out appendString:@"    ---------------------------------------------------------\n"];
	for(i=0;i<trackNumber;i++) {
		[out appendString:[NSString stringWithFormat:@"      % 3d  | %@ | %@ |   % 7lld    |  % 7lld   \n",i+1,framesToMSFStr(indexArr[i],44100),framesToMSFStr(lengthArr[i],44100),indexArr[i]/588,(indexArr[i]+lengthArr[i])/588-1]];
	}
	[out appendString:@"\n"];
	
	if(useAccurateRipDB && [detectedOffset count]) {
		NSArray *confidenceList = [[detectedOffset allValues] sortedArrayUsingFunction:intSort context:NULL];
		NSArray *offsetList = [detectedOffset allKeys];
		int n=1;
		int previousConfidence = -1;
		for(j=0;j<[confidenceList count];j++) {
			int confidence = [[confidenceList objectAtIndex:j] intValue];
			if(confidence == previousConfidence) continue;
			for(i=0;i<[offsetList count];i++) {
				int value = [[detectedOffset objectForKey:[offsetList objectAtIndex:i]] intValue];
				if((value == confidence) && [[offsetList objectAtIndex:i] intValue]) {
					if(n==1) {
						[out appendString:@"List of alternate offset correction values\n"];
						[out appendString:@"        #  | Absolute | Relative | Confidence \n"];
						[out appendString:@"    ------------------------------------------\n"];
					}
					NSString *str = [NSString stringWithFormat:@"       % 2d  |  % 5d   |  % 5d   |    % 3d     \n",n++,offset+[[offsetList objectAtIndex:i] intValue],[[offsetList objectAtIndex:i] intValue],confidence];
					[out appendString:str];
				}
			}
			previousConfidence = confidence;
		}
		[out appendString:@"\n"];
	}
	
	if(results[0].enabled) {
		if(results[0].errorCount || results[0].skipCount) error = YES;
		[out appendString:@"All Tracks\n"];
		if(results[0].filename) [out appendString:[NSString stringWithFormat:@"    Filename : %@\n",results[0].filename]];
		else {
			for(i=0;i<[results[0].filelist count];i++) {
				if(i==0) [out appendString:[NSString stringWithFormat:@"    Filename : %@\n",[results[0].filelist objectAtIndex:i]]];
				else [out appendString:[NSString stringWithFormat:@"               %@\n",[results[0].filelist objectAtIndex:i]]];
			}
		}
		if(results[0].cancelled) {
			[out appendString:@"    (cancelled by user)\n\n"];
			isGoodRip = NO;
		}
		else {
			if(results[0].scanReplayGain) {
				float albumGain = PINK_REF-gain_get_album(rg);
				float albumPeak = peak_get_album(rg);
				for(i=0;i<[trackList count];i++) {
					[[[trackList objectAtIndex:i] metadata] setObject:[NSNumber numberWithFloat:albumGain] forKey:XLD_METADATA_REPLAYGAIN_ALBUM_GAIN];
					[[[trackList objectAtIndex:i] metadata] setObject:[NSNumber numberWithFloat:albumPeak] forKey:XLD_METADATA_REPLAYGAIN_ALBUM_PEAK];
				}
				[out appendString:[NSString stringWithFormat:@"    Album gain             : %.2f dB\n",albumGain]];
				[out appendString:[NSString stringWithFormat:@"    Peak                   : %f\n",albumPeak]];
			}
			if(results[0].testEnabled) {
				[out appendString:[NSString stringWithFormat:@"    CRC32 hash (test run)  : %08X\n",results[0].crc32_test^0xFFFFFFFF]];
			}
			[out appendString:[NSString stringWithFormat:@"    CRC32 hash             : %08X\n",results[0].crc32^0xFFFFFFFF]];
			if(results[0].testEnabled) {
				if(results[0].crc32_test != results[0].crc32) {
					inconsistency = YES;
					[out appendString:@"        ->Rip may not be accurate.\n"];
				}
			}
			[out appendString:[NSString stringWithFormat:@"    CRC32 hash (skip zero) : %08X\n",results[0].crc32_eac^0xFFFFFFFF]];
			if(useParanoia) {
				[out appendString:@"    Statistics\n"];
				[out appendString:[NSString stringWithFormat:@"        Read error                           : %d\n",results[0].errorCount]];
				[out appendString:[NSString stringWithFormat:@"        Skipped (treated as error)           : %d\n",results[0].skipCount]];
				[out appendString:[NSString stringWithFormat:@"        Edge jitter error (maybe fixed)      : %d\n",results[0].edgeJitterCount]];
				[out appendString:[NSString stringWithFormat:@"        Atom jitter error (maybe fixed)      : %d\n",results[0].atomJitterCount]];
				[out appendString:[NSString stringWithFormat:@"        Drift error (maybe fixed)            : %d\n",results[0].driftCount]];
				[out appendString:[NSString stringWithFormat:@"        Dropped bytes error (maybe fixed)    : %d\n",results[0].droppedCount]];
				[out appendString:[NSString stringWithFormat:@"        Duplicated bytes error (maybe fixed) : %d\n",results[0].duplicatedCount]];
				//if(!useOldEngine) [out appendString:[NSString stringWithFormat:@"        Cache error (maybe not a problem)    : %d\n",results[0].cacheErrorCount]];
				if(results[0].checkInconsistency) {
					[out appendString:[NSString stringWithFormat:@"        Inconsistency in error sectors       : %d\n",results[0].inconsistency]];
					if(results[0].inconsistency) {
						inconsistency = YES;
						[out appendString:@"        List of suspicious positions         :\n"];
						for(j=0;j<[results[0].suspiciousPosition count];j++) {
							[out appendString:[NSString stringWithFormat:@"            (%d) %@\n",j+1,framesToMSFStr([[results[0].suspiciousPosition objectAtIndex:j] intValue]*588,44100)]];
						}
					}
				}
			}
			[out appendString:@"\n"];
		}
		for(i=1;i<trackNumber+1;i++) {
			if(results[i].crc32 == 0xFFFFFFFF) continue;
			[out appendString:[NSString stringWithFormat:@"Track %02d\n",i]];
			int gap = [[trackList objectAtIndex:i-1] gap]+((i==1)?88200:0);
			if(gap) [out appendString:[NSString stringWithFormat:@"    Pre-gap length : %@\n",framesToMSFStr(gap,44100)]];
			[out appendString:@"\n"];
			if(!results[0].cancelled && results[i].scanReplayGain) {
				[out appendString:[NSString stringWithFormat:@"    Track gain             : %.2f dB\n",results[i].trackGain]];
				[out appendString:[NSString stringWithFormat:@"    Peak                   : %f\n",results[i].peak]];
				[[[trackList objectAtIndex:i-1] metadata] setObject:[NSNumber numberWithFloat:results[i].trackGain] forKey:XLD_METADATA_REPLAYGAIN_TRACK_GAIN];
				[[[trackList objectAtIndex:i-1] metadata] setObject:[NSNumber numberWithFloat:results[i].peak] forKey:XLD_METADATA_REPLAYGAIN_TRACK_PEAK];
			}
			if(results[i].crc32_test != 0xFFFFFFFF) {
				[out appendString:[NSString stringWithFormat:@"    CRC32 hash (test run)  : %08X\n",results[i].crc32_test^0xFFFFFFFF]];
			}
			[out appendString:[NSString stringWithFormat:@"    CRC32 hash             : %08X\n",results[i].crc32^0xFFFFFFFF]];
			if(results[i].crc32_test != 0xFFFFFFFF) {
				if(results[i].crc32_test != results[i].crc32) [out appendString:@"        ->Rip may not be accurate.\n"];
			}
			[out appendString:[NSString stringWithFormat:@"    CRC32 hash (skip zero) : %08X\n",results[i].crc32_eac^0xFFFFFFFF]];
			if(useAccurateRipDB) {
				[out appendString:[NSString stringWithFormat:@"    AccurateRip signature  : %08X\n",results[i].arHash]];
				if(!database || ![database hasValidDataForTrack:i])
					[out appendString:@"        ->Track not present in AccurateRip database.\n"];
				else {
					int queryResult = [database isAccurateCRC:results[i].arHash forTrack:i];
					if(queryResult != -1)
						[out appendString:[NSString stringWithFormat:@"        ->Accurately ripped! (confidence %d)\n",queryResult]];
					else {
						if([results[i].detectedOffset count]) {
							int confidence = -1;
							unsigned int hash;
							int additionalOffset;
							NSArray *hashArr = [results[i].detectedOffset allKeys];
							for(j=0;j<[hashArr count];j++) {
								queryResult = [database isAccurateCRC:[[hashArr objectAtIndex:j] unsignedIntValue] forTrack:i];
								if(queryResult > confidence) {
									confidence = queryResult;
									hash = [[hashArr objectAtIndex:j] unsignedIntValue];
									additionalOffset = [[results[i].detectedOffset objectForKey:[NSNumber numberWithUnsignedInt:hash]] intValue];
								}
							}
							[out appendString:[NSString stringWithFormat:@"        ->Accurately ripped! (confidence %d)\n",confidence]];
							[out appendString:[NSString stringWithFormat:@"          (matched with the different offset correction value;\n           calculated using an additional offset of %d;\n           the signature after correction is: %08X)\n",additionalOffset,hash]];
						}
						else {
							if(trustAccurateRipResult) inconsistency = YES;
							[out appendString:@"        ->Rip may not be accurate.\n"];
						}
					}
				}
			}
			
			if(!useParanoia) {
				[out appendString:@"\n"];
				continue;
			}
			
			[out appendString:@"    Statistics\n"];
			[out appendString:[NSString stringWithFormat:@"        Read error                           : %d\n",results[i].errorCount]];
			[out appendString:[NSString stringWithFormat:@"        Skipped (treated as error)           : %d\n",results[i].skipCount]];
			[out appendString:[NSString stringWithFormat:@"        Edge jitter error (maybe fixed)      : %d\n",results[i].edgeJitterCount]];
			[out appendString:[NSString stringWithFormat:@"        Atom jitter error (maybe fixed)      : %d\n",results[i].atomJitterCount]];
			[out appendString:[NSString stringWithFormat:@"        Drift error (maybe fixed)            : %d\n",results[i].driftCount]];
			[out appendString:[NSString stringWithFormat:@"        Dropped bytes error (maybe fixed)    : %d\n",results[i].droppedCount]];
			[out appendString:[NSString stringWithFormat:@"        Duplicated bytes error (maybe fixed) : %d\n",results[i].duplicatedCount]];
			//if(!useOldEngine) [out appendString:[NSString stringWithFormat:@"        Cache error (maybe not a problem)    : %d\n",results[i].cacheErrorCount]];
			if(results[i].checkInconsistency) {
				[out appendString:[NSString stringWithFormat:@"        Inconsistency in error sectors       : %d\n",results[i].inconsistency]];
				if(results[i].inconsistency) {
					[out appendString:@"        List of suspicious positions         :\n"];
					for(j=0;j<[results[i].suspiciousPosition count];j++) {
						[out appendString:[NSString stringWithFormat:@"            (%d) %@\n",j+1,framesToMSFStr([[results[i].suspiciousPosition objectAtIndex:j] intValue]*588-indexArr[i-1],44100)]];
					}
				}
			}
			[out appendString:@"\n"];
		}
	}
	else {
		if(results[0].scanReplayGain) {
			for(i=0;i<[trackList count];i++) {
				NSString *trackTitle = [[[trackList objectAtIndex:i] metadata] objectForKey:XLD_METADATA_TITLE];
				if(results[i+1].cancelled || (!results[i+1].enabled && ![trackTitle isEqualToString:LS(@"(Data Track)")])) {
					results[0].scanReplayGain = NO;
					break;
				}
			}
		}
		if(results[0].scanReplayGain) {
			[out appendString:@"All Tracks\n"];
			float albumGain = PINK_REF-gain_get_album(rg);
			float albumPeak = peak_get_album(rg);
			for(i=0;i<[trackList count];i++) {
				[[[trackList objectAtIndex:i] metadata] setObject:[NSNumber numberWithFloat:albumGain] forKey:XLD_METADATA_REPLAYGAIN_ALBUM_GAIN];
				[[[trackList objectAtIndex:i] metadata] setObject:[NSNumber numberWithFloat:albumPeak] forKey:XLD_METADATA_REPLAYGAIN_ALBUM_PEAK];
			}
			[out appendString:[NSString stringWithFormat:@"    Album gain             : %.2f dB\n",albumGain]];
			[out appendString:[NSString stringWithFormat:@"    Peak                   : %f\n\n",albumPeak]];
		}
		for(i=1;i<trackNumber+1;i++) {
			if(!results[i].enabled) continue;
			if(results[i].errorCount || results[i].skipCount) error = YES;
			[out appendString:[NSString stringWithFormat:@"Track %02d\n",i]];
			if(results[i].filename) [out appendString:[NSString stringWithFormat:@"    Filename : %@\n",results[i].filename]];
			else {
				for(j=0;j<[results[i].filelist count];j++) {
					if(j==0) [out appendString:[NSString stringWithFormat:@"    Filename : %@\n",[results[i].filelist objectAtIndex:j]]];
					else [out appendString:[NSString stringWithFormat:@"               %@\n",[results[i].filelist objectAtIndex:j]]];
				}
			}
			if(results[i].cancelled) {
				[out appendString:@"    (cancelled by user)\n\n"];
				isGoodRip = NO;
				continue;
			}
			int gap = [[trackList objectAtIndex:i-1] gap]+((i==1)?88200:0);
			if(gap) [out appendString:[NSString stringWithFormat:@"    Pre-gap length : %@\n",framesToMSFStr(gap,44100)]];
			[out appendString:@"\n"];
			if(results[i].scanReplayGain) {
				[out appendString:[NSString stringWithFormat:@"    Track gain             : %.2f dB\n",results[i].trackGain]];
				[out appendString:[NSString stringWithFormat:@"    Peak                   : %f\n",results[i].peak]];
				[[[trackList objectAtIndex:i-1] metadata] setObject:[NSNumber numberWithFloat:results[i].trackGain] forKey:XLD_METADATA_REPLAYGAIN_TRACK_GAIN];
				[[[trackList objectAtIndex:i-1] metadata] setObject:[NSNumber numberWithFloat:results[i].peak] forKey:XLD_METADATA_REPLAYGAIN_TRACK_PEAK];
			}
			if(results[i].testEnabled) {
				[out appendString:[NSString stringWithFormat:@"    CRC32 hash (test run)  : %08X\n",results[i].crc32_test^0xFFFFFFFF]];
			}
			[out appendString:[NSString stringWithFormat:@"    CRC32 hash             : %08X\n",results[i].crc32^0xFFFFFFFF]];
			if(results[i].testEnabled) {
				if(results[i].crc32_test != results[i].crc32) {
					inconsistency = YES;
					[out appendString:@"        ->Rip may not be accurate.\n"];
				}
			}
			[out appendString:[NSString stringWithFormat:@"    CRC32 hash (skip zero) : %08X\n",results[i].crc32_eac^0xFFFFFFFF]];
			if(useAccurateRipDB) {
				[out appendString:[NSString stringWithFormat:@"    AccurateRip signature  : %08X\n",results[i].arHash]];
				if(!database || ![database hasValidDataForTrack:i])
					[out appendString:@"        ->Track not present in AccurateRip database.\n"];
				else {
					int queryResult = [database isAccurateCRC:results[i].arHash forTrack:i];
					if(queryResult != -1)
						[out appendString:[NSString stringWithFormat:@"        ->Accurately ripped! (confidence %d)\n",queryResult]];
					else {
						if([results[i].detectedOffset count]) {
							int confidence = -1;
							unsigned int hash;
							int additionalOffset;
							NSArray *hashArr = [results[i].detectedOffset allKeys];
							for(j=0;j<[hashArr count];j++) {
								queryResult = [database isAccurateCRC:[[hashArr objectAtIndex:j] unsignedIntValue] forTrack:i];
								if(queryResult > confidence) {
									confidence = queryResult;
									hash = [[hashArr objectAtIndex:j] unsignedIntValue];
									additionalOffset = [[results[i].detectedOffset objectForKey:[NSNumber numberWithUnsignedInt:hash]] intValue];
								}
							}
							[out appendString:[NSString stringWithFormat:@"        ->Accurately ripped! (confidence %d)\n",confidence]];
							[out appendString:[NSString stringWithFormat:@"          (matched with the different offset correction value;\n           calculated using an additional offset of %d;\n           the signature after correction is: %08X)\n",additionalOffset,hash]];
						}
						else {
							if(trustAccurateRipResult) inconsistency = YES;
							[out appendString:@"        ->Rip may not be accurate.\n"];
						}
					}
				}
			}
			
			if(!useParanoia) {
				[out appendString:@"\n"];
				continue;
			}
			
			[out appendString:@"    Statistics\n"];
			[out appendString:[NSString stringWithFormat:@"        Read error                           : %d\n",results[i].errorCount]];
			[out appendString:[NSString stringWithFormat:@"        Skipped (treated as error)           : %d\n",results[i].skipCount]];
			[out appendString:[NSString stringWithFormat:@"        Edge jitter error (maybe fixed)      : %d\n",results[i].edgeJitterCount]];
			[out appendString:[NSString stringWithFormat:@"        Atom jitter error (maybe fixed)      : %d\n",results[i].atomJitterCount]];
			[out appendString:[NSString stringWithFormat:@"        Drift error (maybe fixed)            : %d\n",results[i].driftCount]];
			[out appendString:[NSString stringWithFormat:@"        Dropped bytes error (maybe fixed)    : %d\n",results[i].droppedCount]];
			[out appendString:[NSString stringWithFormat:@"        Duplicated bytes error (maybe fixed) : %d\n",results[i].duplicatedCount]];
			//if(!useOldEngine) [out appendString:[NSString stringWithFormat:@"        Cache error (maybe not a problem)    : %d\n",results[i].cacheErrorCount]];
			if(results[i].checkInconsistency) {
				[out appendString:[NSString stringWithFormat:@"        Inconsistency in error sectors       : %d\n",results[i].inconsistency]];
				if(results[i].inconsistency) {
					inconsistency = YES;
					[out appendString:@"        List of suspicious positions         :\n"];
					for(j=0;j<[results[i].suspiciousPosition count];j++) {
						[out appendString:[NSString stringWithFormat:@"            (%d) %@\n",j+1,framesToMSFStr([[results[i].suspiciousPosition objectAtIndex:j] intValue]*588-indexArr[i-1],44100)]];
					}
				}
			}
			[out appendString:@"\n"];
		}
	}
	
	if(useParanoia) {
		if(!error && !inconsistency) [out appendString:@"No errors occurred\n\n"];
		else if(error) {
			[out appendString:@"Some errors occurred\n\n"];
			isGoodRip = NO;
		}
		else if(inconsistency) {
			[out appendString:@"Some inconsistencies found\n\n"];
			isGoodRip = NO;
		}
	}
	
	[out appendString:@"End of status report\n"];
	
	return [out autorelease];
}

- (BOOL)isGoodRip
{
	return isGoodRip;
}

- (void)saveLog
{
	int i,j;
	NSString *logStr = [self logStr];
	if(logFileName && [logDirectoryArray count] && logStr) {
		for(i=0;i<[logDirectoryArray count];i++) {
			NSString *savePath = [[logDirectoryArray objectAtIndex:i] stringByAppendingPathComponent:logFileName];
			if(processOfExistingFiles != 2) {
				j=1;
				while([[NSFileManager defaultManager] fileExistsAtPath:savePath]) {
					savePath = [[logDirectoryArray objectAtIndex:i] stringByAppendingPathComponent:[[NSString stringWithFormat:@"%@(%d)",[logFileName stringByDeletingPathExtension],j] stringByAppendingPathExtension:@"log"]];
					j++;
				}
			}
			[[logStr dataUsingEncoding:NSUTF8StringEncoding] writeToFile:savePath atomically:YES];
		}
	}
}

- (void)setTOC:(NSArray *)arr
{
	int i;
	for(i=0;i<[arr count];i++) {
		[trackList addObject:[arr objectAtIndex:i]];
		indexArr[i] = [(XLDTrack *)[arr objectAtIndex:i] index];
		if(i == ([arr count]-1)) {
			lengthArr[i] = [(XLDTrack *)[arr objectAtIndex:i] frames];
			if((i==0) && ([(XLDTrack *)[arr objectAtIndex:i] gap] !=0) && includeHTOA) {
				actualLengthArr[i] = [(XLDTrack *)[arr objectAtIndex:i] gap] + [(XLDTrack *)[arr objectAtIndex:i] frames];
				results[1].gapLength = [(XLDTrack *)[arr objectAtIndex:i] gap];
			}
			else
				actualLengthArr[i] = [(XLDTrack *)[arr objectAtIndex:i] frames];
		}
		else {
			lengthArr[i] = [(XLDTrack *)[arr objectAtIndex:i] frames] + [(XLDTrack *)[arr objectAtIndex:i+1] gap];
			if((i==0) && ([(XLDTrack *)[arr objectAtIndex:i] gap] !=0) && includeHTOA) {
				actualLengthArr[i] = [(XLDTrack *)[arr objectAtIndex:i] gap] + [(XLDTrack *)[arr objectAtIndex:i] frames] + [(XLDTrack *)[arr objectAtIndex:i+1] gap];
				results[1].gapLength = [(XLDTrack *)[arr objectAtIndex:i] gap];
			}
			else 
				actualLengthArr[i] = [(XLDTrack *)[arr objectAtIndex:i] frames] + [(XLDTrack *)[arr objectAtIndex:i+1] gap];
		}
		
		if(i==0) results[1].startPoint = results[1].gapLength + 5*588 - 1;
		if(i==([arr count]-1)) results[i+1].endPoint = actualLengthArr[i] - 5*588;
	}
	if([arr count] > 1 && ![(XLDTrack *)[arr objectAtIndex:[arr count]-1] enabled]) {
		int tmp1,tmp2;
		tmp1 = [(XLDTrack *)[arr objectAtIndex:[arr count]-1] index];
		tmp2 = [(XLDTrack *)[arr objectAtIndex:[arr count]-2] index] + [(XLDTrack *)[arr objectAtIndex:[arr count]-2] frames];
		if((tmp1 - tmp2) == 11400*588) {
			results[[arr count]-1].endPoint = actualLengthArr[[arr count]-2] - 5*588;
		}
	}
}

- (void)setTitle:(NSString*)t andArtist:(NSString *)a
{
	if(title) [title release];
	if(artist) [artist release];
	title = [t retain];
	artist = [a retain];
}

- (void)setAccurateRipDB:(id)db
{
	if(database) [database release];
	database = [db retain];
}

- (id)accurateRipDB
{
	return database;
}

- (void)registerOffset:(int)o withConfidence:(int)c
{
	if(!database) return;
	if([detectedOffset objectForKey:[NSNumber numberWithInt:o]]) {
		if(c<[[detectedOffset objectForKey:[NSNumber numberWithInt:o]] intValue]) return;
	}
	[detectedOffset setObject:[NSNumber numberWithInt:c] forKey:[NSNumber numberWithInt:o]];
}

- (NSMutableData *)cueDataForFile:(NSString *)filename;
{
	if(!trackList) return nil;
	int i,n=1;
	int sectorOffset = 0;
	BOOL removeRedundancy = NO;
	NSMutableData *data = [[NSMutableData alloc] init];
	id obj;
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_ALBUM])
		[data appendData:[[NSString stringWithFormat:@"TITLE \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_ALBUMARTIST])
		[data appendData:[[NSString stringWithFormat:@"PERFORMER \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
	else if(![artist isEqualToString:@""] && ![artist isEqualToString:LS(@"Various Artists")]) {
		[data appendData:[[NSString stringWithFormat:@"PERFORMER \"%@\"\n",artist] dataUsingEncoding:NSUTF8StringEncoding]];
		removeRedundancy = YES;
	}
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_CATALOG])
		[data appendData:[[NSString stringWithFormat:@"CATALOG %@\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_GENRE])
		[data appendData:[[NSString stringWithFormat:@"REM GENRE \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_DATE])
		[data appendData:[[NSString stringWithFormat:@"REM DATE \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
	else if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_YEAR])
		[data appendData:[[NSString stringWithFormat:@"REM DATE %d\n",[obj intValue]] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_DISC])
		[data appendData:[[NSString stringWithFormat:@"REM DISCNUMBER %d\n",[obj intValue]] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_TOTALDISCS])
		[data appendData:[[NSString stringWithFormat:@"REM TOTALDISCS %d\n",[obj intValue]] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_FREEDBDISCID])
		[data appendData:[[NSString stringWithFormat:@"REM DISCID %08X\n",[obj unsignedIntValue]] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_REPLAYGAIN_ALBUM_GAIN])
		[data appendData:[[NSString stringWithFormat:@"REM REPLAYGAIN_ALBUM_GAIN %.2f dB\n",[obj floatValue]] dataUsingEncoding:NSUTF8StringEncoding]];
	if(obj=[[[trackList objectAtIndex:0] metadata] objectForKey:XLD_METADATA_REPLAYGAIN_ALBUM_PEAK])
		[data appendData:[[NSString stringWithFormat:@"REM REPLAYGAIN_ALBUM_PEAK %f\n",[obj floatValue]] dataUsingEncoding:NSUTF8StringEncoding]];
	
	[data appendData:[[NSString stringWithFormat:@"FILE \"%@\" WAVE\n",filename] dataUsingEncoding:NSUTF8StringEncoding]];
	for(i=0;i<[trackList count];i++) {
		XLDTrack *track = [trackList objectAtIndex:i];
		if([[[track metadata] objectForKey:XLD_METADATA_TITLE] isEqualToString:LS(@"(Data Track)")]) {
			if(i==0) {
				sectorOffset = [track frames];
				if(i+1 < [trackList count]) sectorOffset += [[trackList objectAtIndex:i+1] gap];
			}
			continue;
		}
		[data appendData:[[NSString stringWithFormat:@"  TRACK %02d AUDIO\n",n] dataUsingEncoding:NSUTF8StringEncoding]];
		if(obj=[[track metadata] objectForKey:XLD_METADATA_TITLE])
			[data appendData:[[NSString stringWithFormat:@"    TITLE \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
		if((obj=[[track metadata] objectForKey:XLD_METADATA_ARTIST]) && !removeRedundancy)
			[data appendData:[[NSString stringWithFormat:@"    PERFORMER \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
		if(obj=[[track metadata] objectForKey:XLD_METADATA_COMPOSER])
			[data appendData:[[NSString stringWithFormat:@"    SONGWRITER \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
		if(obj=[[track metadata] objectForKey:XLD_METADATA_ISRC])
			[data appendData:[[NSString stringWithFormat:@"    ISRC %@\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
		if(obj=[[track metadata] objectForKey:XLD_METADATA_PREEMPHASIS]) {
			if([obj boolValue]) [data appendData:[@"    FLAGS PRE\n" dataUsingEncoding:NSUTF8StringEncoding]];
		}
		/*if(obj=[[track metadata] objectForKey:XLD_METADATA_GENRE])
			[data appendData:[[NSString stringWithFormat:@"    REM GENRE \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
		if(obj=[[track metadata] objectForKey:XLD_METADATA_DATE])
			[data appendData:[[NSString stringWithFormat:@"    REM DATE \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
		else if(obj=[[track metadata] objectForKey:XLD_METADATA_YEAR])
			[data appendData:[[NSString stringWithFormat:@"    REM DATE %d\n",[obj intValue]] dataUsingEncoding:NSUTF8StringEncoding]];*/
		if(obj=[[track metadata] objectForKey:XLD_METADATA_COMMENT])
			[data appendData:[[NSString stringWithFormat:@"    REM COMMENT \"%@\"\n",obj] dataUsingEncoding:NSUTF8StringEncoding]];
		if(obj=[[track metadata] objectForKey:XLD_METADATA_REPLAYGAIN_TRACK_GAIN])
			[data appendData:[[NSString stringWithFormat:@"    REM REPLAYGAIN_TRACK_GAIN %.2f dB\n",[obj floatValue]] dataUsingEncoding:NSUTF8StringEncoding]];
		if(obj=[[track metadata] objectForKey:XLD_METADATA_REPLAYGAIN_TRACK_PEAK])
			[data appendData:[[NSString stringWithFormat:@"    REM REPLAYGAIN_TRACK_PEAK %f\n",[obj floatValue]] dataUsingEncoding:NSUTF8StringEncoding]];
		
		if([track gap] != 0)
			[data appendData:[[NSString stringWithFormat:@"    INDEX 00 %@\n",framesToMSFStr([track index]-[track gap]-sectorOffset,44100)] dataUsingEncoding:NSUTF8StringEncoding]];
		[data appendData:[[NSString stringWithFormat:@"    INDEX 01 %@\n",framesToMSFStr([track index]-sectorOffset,44100)] dataUsingEncoding:NSUTF8StringEncoding]];
		n++;
	}
	return [data autorelease];
}

- (void)setCuePath:(NSString *)path
{
	if(cuePath) [cuePath release];
	cuePath = [path retain];
}

- (void)setCuePathArray:(NSArray *)arr
{
	if(cuePathArray) [cuePathArray release];
	cuePathArray = [arr retain];
}

- (void)saveCuesheetIfNeeded
{
	if(!results[0].scanReplayGain) return;
	if(!cuePath && !cuePathArray) return;
	unsigned char bom[] = {0xEF,0xBB,0xBF};
	if(cuePath) {
		NSMutableData *cueData = [self cueDataForFile:[results[0].filename lastPathComponent]];
		if(appendBOM) [cueData replaceBytesInRange:NSMakeRange(0,0) withBytes:bom length:3];
		[cueData writeToFile:cuePath atomically:YES];
	}
	else {
		int i;
		for(i=0;i<[cuePathArray count];i++) {
			NSMutableData *cueData = [self cueDataForFile:[[results[0].filelist objectAtIndex:i] lastPathComponent]];
			if(appendBOM) [cueData replaceBytesInRange:NSMakeRange(0,0) withBytes:bom length:3];
			[cueData writeToFile:[cuePathArray objectAtIndex:i] atomically:YES];
		}
	}
}

- (void)setProcessOfExistingFiles:(int)value
{
	processOfExistingFiles = value;
}

- (void)setAppendBOM:(BOOL)flag
{
	appendBOM = flag;
}

- (void)setIncludeHTOA:(BOOL)flag
{
	includeHTOA = flag;
}

@end
