//
//  XLDCDDAResult.h
//  XLD
//
//  Created by tmkk on 08/08/13.
//  Copyright 2008 tmkk. All rights reserved.
//
// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import <Cocoa/Cocoa.h>
#import "gain_analysis.h"

typedef struct {
	BOOL enabled;
	BOOL finished;
	BOOL cancelled;
	BOOL testEnabled;
	BOOL testFinished;
	NSString *filename;
	NSMutableArray *filelist;
	int errorCount;
	int skipCount;
	int edgeJitterCount;
	int atomJitterCount;
	int droppedCount;
	int duplicatedCount;
	int driftCount;
	int cacheErrorCount;
	unsigned int crc32;
	unsigned int crc32_eac;
	unsigned int crc32_test;
	unsigned int arHash;
	unsigned int gapLength; /* indicates HTOA length */
	unsigned int startPoint;
	unsigned int endPoint;
	unsigned int inconsistency;
	unsigned int sampleSum;
	NSMutableArray *suspiciousPosition;
	BOOL checkInconsistency;
	BOOL scanReplayGain;
	replaygain_t *rg;
	float trackGain;
	float peak;
	NSMutableDictionary *detectedOffset;
	id parent;
} cddaRipResult;

@interface XLDCDDAResult : NSObject {
	cddaRipResult *results;
	NSString *driveStr;
	NSString *deviceStr;
	NSDate *date;
	NSString *logFileName;
	NSMutableArray *logDirectoryArray;
	BOOL useParanoia;
	int retryCount;
	int offset;
	NSString *title;
	NSString *artist;
	id database;
	BOOL useAccurateRipDB;
	BOOL trustAccurateRipResult;
	BOOL useOldEngine;
	BOOL useC2Pointer;
	xldoffset_t *lengthArr;
	NSMutableDictionary *detectedOffset;
	NSMutableArray *trackList;
	NSString *cuePath;
	NSArray *cuePathArray;
	replaygain_t *rg;
	BOOL isGoodRip;
	BOOL appendBOM;
	int processOfExistingFiles;
	BOOL includeHTOA;
	unsigned int gapStatus;
@public
	xldoffset_t *indexArr;
	xldoffset_t *actualLengthArr; /* used for detecting the track end for single image ripping */
	int trackNumber;
}

- (id)initWithTrackNumber:(int)t;
- (void)setDriveStr:(NSString *)str;
- (void)setDeviceStr:(NSString *)str;
- (void)setDate:(NSDate *)d;
- (cddaRipResult *)resultForIndex:(int)idx;
- (BOOL)allTasksFinished;
- (int)numberOfTracks;
- (NSString *)deviceStr;
- (void)setLogFileName:(NSString *)str;
- (void)addLogDirectory:(NSString *)str;
- (NSString *)logFileName;
- (void)setUseParanoia:(BOOL)flag offsetCorrention:(int)o retryCount:(int)ret useAccurateRipDB:(BOOL)useDB checkInconsistency:(BOOL)checkFlag trustARResult:(BOOL)trustFlag scanReplayGain:(BOOL)rgFlag useOldEngine:(BOOL)engineFlag  useC2Pointer:(BOOL)C2flag gapStatus:(unsigned int)status;
- (NSString *)logStr;
- (void)saveLog;
- (void)setTOC:(NSArray *)arr;
- (void)setTitle:(NSString*)t andArtist:(NSString *)a;
- (void)setAccurateRipDB:(id)db;
- (id)accurateRipDB;
- (void)registerOffset:(int)o withConfidence:(int)c;
- (void)setCuePath:(NSString *)path;
- (void)setCuePathArray:(NSArray *)arr;
- (void)saveCuesheetIfNeeded;
- (BOOL)isGoodRip;
- (void)setAppendBOM:(BOOL)flag;
- (void)setProcessOfExistingFiles:(int)value;
- (void)setIncludeHTOA:(BOOL)flag;
@end
