//
//  XLDAccurateRipDB.m
//  XLD
//
//  Created by tmkk on 08/08/17.
//  Copyright 2008 tmkk. All rights reserved.
//
// Access to AccurateRip is regulated, see  http://www.accuraterip.com/3rdparty-access.htm for details.

#import "XLDAccurateRipDB.h"


@implementation XLDAccurateRipDB

- (id)init
{
	[super init];
	database = [[NSMutableArray alloc] init];
	return self;
}

- (void)dealloc
{
	[database release];
	[super dealloc];
}
	

- (id)initWithData:(NSData *)data
{
	[self init];
	int i,n=0;
	unsigned char *ptr = (unsigned char *)[data bytes];
	
	int trackNum = 0;
	
	while(n<[data length]) {
		trackNum = *(ptr+n);
		for(i=[database count];i<trackNum;i++) {
			NSMutableDictionary *dic = [[NSMutableDictionary alloc] init];
			[dic setObject:[NSNumber numberWithInt:0] forKey:@"MaxConfidence"];
			[database addObject:dic];
			[dic release];
		}
		
		n+=13;
		for(i=0;i<trackNum;i++) {
			int confidence = *(ptr+n);
			n++;
			unsigned int crc32 = *(ptr+n) | *(ptr+n+1)<<8 | *(ptr+n+2)<<16 | *(ptr+n+3)<<24;
			n+=8;
			[[database objectAtIndex:i] setObject:[NSNumber numberWithInt:confidence] forKey:[NSNumber numberWithUnsignedInt:crc32]];
			if([[[database objectAtIndex:i] objectForKey:@"MaxConfidence"] intValue] < confidence) {
				[[database objectAtIndex:i] setObject:[NSNumber numberWithInt:confidence] forKey:@"MaxConfidence"];
			}
		}
	}
	//NSLog([database description]);
	
	return self;
}

- (BOOL)hasValidDataForTrack:(int)track
{
	if(![[[database objectAtIndex:track-1] objectForKey:@"MaxConfidence"] intValue]) return NO;
	else return YES;
}

- (int)isAccurateCRC:(unsigned int)crc forTrack:(int)track
{
	if(track > [database count]) return -1;
	
	id obj = [[database objectAtIndex:track-1] objectForKey:[NSNumber numberWithUnsignedInt:crc]];
	if(obj) return [obj intValue];
	else return -1;
}

@end
