//
//  XLDAccurateRipChecker.h
//  XLD
//
//  Created by tmkk on 08/08/22.
//  Copyright 2008 tmkk. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "gain_analysis.h"

typedef struct {
	unsigned int crc32;
	unsigned int crc32_eac;
	unsigned int arHash;
	xldoffset_t index;
	xldoffset_t length;
	unsigned int sampleSum;
	float trackGain;
	float peak;
	BOOL enabled;
	BOOL cancelled;
	NSMutableDictionary *detectedOffset;
} checkResult;

@interface XLDAccurateRipChecker : NSObject {
	checkResult *results;
	unsigned int crc32_global;
	unsigned int crc32_eac_global;
	IBOutlet id o_panel;
	IBOutlet id o_message;
	IBOutlet id o_progress;
	id database;
	id delegate;
	id decoder;
	int trackNumber;
	BOOL running;
	BOOL stop;
	xldoffset_t totalFrames;
	int currentOffset;
	unsigned int crc32Table[256];
	unsigned int *negativeSideSample;
	unsigned int *positiveSideSample;
	NSMutableDictionary *detectedOffset;
	NSMutableArray *trackList;
	replaygain_t *rg;
	double percent;
}
- (id)initWithTracks:(NSArray *)tracks totalFrames:(xldoffset_t)frame;
- (void)startCheckingForFile:(NSString *)path withDecoder:(id)decoderObj;
- (void)startOffsetCheckingForFile:(NSString *)path withDecoder:(id)decoderObj;
- (void)startReplayGainScanningForFile:(NSString *)path withDecoder:(id)decoderObj;
- (void)setAccurateRipDB:(id)db;
- (void)setDelegate:(id)del;
- (IBAction)cancel:(id)sender;
- (NSString *)logStr;
- (NSString *)logStrForReplayGainScanner;
- (NSDictionary *)detectedOffset;
- (BOOL)cancelled;
@end
