/*
  fileselect.c
  XimpleMOD Tracker Player

A free open-source program, that provides a GUI to play MOD tracker songs in Mac OS X.

*/

/*
FILE SELECT FUNCTION
This function selects the sont to play, prompting the user for the file.
*/

pascal OSStatus xm_select_a_file(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData)
{

/*
We make and run the dialog. Then get the path to the file.
*/
NavDialogRef dialog;
NavDialogCreationOptions programme;
NavGetDefaultDialogCreationOptions(&programme);
programme.optionFlags=0;
programme.parentWindow=window;
programme.windowTitle=CFStringCreateWithCString(kCFAllocatorDefault,"Choose a IT/XM/S3M/MTM/MOD/UMX file",kCFStringEncodingASCII);
NavCreateChooseFileDialog(&programme,NULL,NULL,NULL,NULL,NULL,&dialog);
if (!NavDialogRun(dialog)) {
NavReplyRecord recorde;
if (!NavDialogGetReply(dialog,&recorde)) {
AEKeyword key;
FSRef frefr;
if (!AEGetNthPtr(&recorde.selection,1,typeFSRef,&key,NULL,&frefr,sizeof(frefr),NULL)) {
char musicToLoad[255]="";
char *title="";
FSRefMakePath(&frefr,musicToLoad,255);

// OK. Now we free the current song.
BASSMOD_MusicFree();

/* Now we tell BASSMOD to load the song.
If BASSMOD can load the song... */
if (BASSMOD_MusicLoad(FALSE,musicToLoad,0,0,xm_read_gui_option_flags(1))) {
DWORD length;
length=BASSMOD_MusicGetLength(FALSE);

/* Then we init the GUI position control. */
SetControl32BitMaximum(xm_control_pointer(7),length-1);


/* We write song title to the display. */
title=BASSMOD_MusicGetName();
ControlRef ctrleRef=xm_control_pointer(5);
SetControlData(ctrleRef,kControlEntireControl,kControlStaticTextTextTag,strlen(title),title);
DrawOneControl(ctrleRef);

/* Hmmm... Its nice to display the length of the song :) */
int mycrotime;
char strtime[20];
if (mycrotime=BASSMOD_MusicGetLength(TRUE)) {
mycrotime=mycrotime/176400;
sprintf(strtime," %d:%02d",mycrotime/60,mycrotime%60);
} else {
sprintf(strtime,"--:--");
}
trueplaying=1;
wplaying=0;
ControlRef ctrlqRef=xm_control_pointer(38);
SetControlData(ctrlqRef,kControlEntireControl,kControlStaticTextTextTag,strlen(strtime),strtime);
DrawOneControl(ctrlqRef);

/* And finally we update Channels & Instruments window. */

xm_channel_window_init();
xm_instrument_window_init();


/* If BASSMOD cant load the song then... */
} else {

// We write an error message in button.
SetControlData(xm_control_pointer(5),kControlEntireControl,kControlStaticTextTextTag,strlen("Invalid song format!"),"Invalid song format!");
DrawOneControl(xm_control_pointer(5));

HideWindow ( win_channels );
HideWindow ( win_instruments );

}

// We reset the GUI position control to the start :)
SetControl32BitValue(xm_control_pointer(7),0);

}
NavDisposeReply(&recorde);
}
}
NavDialogDispose(dialog);
return noErr;
}
