/*
  main.c
  XimpleMOD Tracker Player

A free open-source program, that provides a GUI to play MOD tracker songs in Mac OS X.

*/

// We include the needed libs
#include <stdio.h>
#include <Carbon/Carbon.h>
#include <sys/types.h>
#include <dirent.h>
#include "bassmod.h"

// In this version there are four sound options. And their ids are...
#define NUMOPTIONS 3
int stsArray[NUMOPTIONS]={18,19,20};

// The Main Window.
static WindowPtr window;

// The Sound-Options Window
static WindowPtr win_options;

// The Channels window
static WindowPtr win_channels;

// The Instruments Window
static WindowPtr win_instruments;

// The starttime
static int starttime;

static int wplaying;
static int trueplaying;

static short islooping=0;

static int channels;
static int currentChannel;

static int instruments;
static int currInstru[3];

static DWORD sisActive;
static DWORD prevStat;

static short PlayList;

static DIR *PlayListDir;

static struct dirent *PlayListSong;

static char folderPlayList[255];

// Time stuff
#include "microtime.c"

// The GUI functions
#include "gui.c"

// The select-a-file function
#include "fileselect.c"

// Control functions
#include "control.c"

/* Main function... all programs must have one :) */
int main(int argc, char* argv[])
{
wplaying=0;
PlayList=0;
prevStat=BASS_ACTIVE_STOPPED;

starttime=timeGetTime();
    IBNibRef 		nibRef;    
    OSStatus		err;
	
	InitCursor();

if (BASSMOD_GetVersion()!=MAKELONG(2,0)) {
		fprintf(stderr,"BASSMOD version 2.0 was not loaded\n");
		return 0;
}
if (!BASSMOD_Init(-1,44100,BASS_DEVICE_NOSYNC)) {
		fprintf(stderr,"Can't initialize device");
		return 0;
}
	
	
    // Create a Nib reference passing the name of the nib file (without the .nib extension)
    // CreateNibReference only searches into the application bundle.
    err = CreateNibReference(CFSTR("main"), &nibRef);
    require_noerr( err, CantGetNibRef );
    
    // Once the nib reference is created, set the menu bar. "MainMenu" is the name of the menu bar
    // object. This name is set in InterfaceBuilder when the nib is created.
    err = SetMenuBarFromNib(nibRef, CFSTR("MenuBar"));
    require_noerr( err, CantSetMenuBar );
    
    // Then create a window. "MainWindow" is the name of the window object. This name is set in 
    // InterfaceBuilder when the nib is created.
    err = CreateWindowFromNib(nibRef, CFSTR("MainWindow"), &window);
    require_noerr( err, CantCreateWindow );
	
	err = CreateWindowFromNib(nibRef, CFSTR("Options"), &win_options);
	
	err = CreateWindowFromNib(nibRef, CFSTR("ChannelsWin"), &win_channels);
	
	err = CreateWindowFromNib(nibRef, CFSTR("InstruWin"), &win_instruments);


    // We don't need the nib reference anymore.
    DisposeNibReference(nibRef);
    
    // The window was created hidden so show it.
    ShowWindow( window );	
	
	/* Initialising some GUI widgets... */
	
	SetControl32BitMaximum(xm_control_pointer(808),100);
	SetControl32BitValue(xm_control_pointer(808),BASSMOD_GetVolume());

    
    /* EVENTS */

// The select a file button event

xm_event_handle(xm_select_a_file,kEventControlHit,window,809);

/* The options. Used as and array to make things easy when we in a future add more options :)  */

// This array contains the IDs of the GUI object controllers :)

int jfi;
for (jfi=0; jfi < NUMOPTIONS; jfi++ ) {
xm_event_handle(xm_flags,kEventControlValueFieldChanged,win_options,stsArray[jfi]);
}


/* "Some" buttons... well, a lot of buttons :-) */

xm_event_handle(xm_play,kEventControlHit,window,2);
xm_event_handle(xm_stop,kEventControlHit,window,1);
xm_event_handle(xm_loop,kEventControlHit,window,810);
xm_event_handle(xm_show_options,kEventControlHit,window,811);
xm_event_handle(xm_hide_options,kEventControlHit,win_options,888);
xm_event_handle(xm_show_channels,kEventControlHit,window,319);
xm_event_handle(xm_hide_channels,kEventControlHit,win_channels,907);
xm_event_handle(xm_show_instruments,kEventControlHit,window,1111);
xm_event_handle(xm_hide_instruments,kEventControlHit,win_instruments,907);
xm_event_handle(xm_playlist_select_dir,kEventControlHit,window,1997);
xm_event_handle(xm_playlist_on_off,kEventControlHit,window,1998);
xm_event_handle(xm_next_channel,kEventControlHit,win_channels,905);
xm_event_handle(xm_prev_channel,kEventControlHit,win_channels,906);
xm_event_handle(xm_all_channels_on,kEventControlHit,win_channels,1200);
xm_event_handle(xm_all_channels_off,kEventControlHit,win_channels,1201);
xm_event_handle(xm_all_instruments_on,kEventControlHit,win_instruments,1314);
xm_event_handle(xm_all_instruments_off,kEventControlHit,win_instruments,1315);

/* This handles many events on Instruments window... */
int effi=1302;
for ( jfi = 1; jfi <= 3; ++jfi ) {
xm_bahia_handle(jfi,effi,effi+1,1310+jfi);
effi+=2;
}

/* The position control */
SetControlAction(xm_control_pointer(7),NewControlActionUPP(xm_position_handler));

// The volume control
SetControlAction(xm_control_pointer(808),NewControlActionUPP(xm_volume_handler));

// The amplification control
SetControlAction(xm_ocontrol_pointer(889),NewControlActionUPP(xm_amplification_handler));

// The panning control
SetControlAction(xm_ocontrol_pointer(890),NewControlActionUPP(xm_panning_handler));

// The channel volume control
SetControlAction(xm_hcontrol_pointer(904),NewControlActionUPP(xm_channel_volume_handler));


// Timer; it updates the display :)
EventLoopTimerRef Timer;
InstallEventLoopTimer(GetCurrentEventLoop(),kEventDurationNoWait,kEventDurationSecond/10,xm_update_display,0,&Timer);


// The loop :)
RunApplicationEventLoop();

CantCreateWindow:
CantSetMenuBar:
CantGetNibRef:
	return err;


	
		BASSMOD_Free();

if (PlayList == 1) closedir(PlayListDir);

    return 0; 
}
