/*
  gui.c
  XimpleMOD Tracker Player

A free open-source program, that provides a GUI to play MOD tracker songs in Mac OS X.

*/

/*
GUI FILE
These functions read data or events from GUI.
*/

/*
This function returns a pointer to a GUI object.
*/
ControlRef xm_control_by_id(int id,WindowPtr wintana) {
ControlRef param;
ControlID sdcontrol={0,id};
GetControlByID(wintana,&sdcontrol,&param);
return param;
}

/* Shortcuts */

ControlRef xm_control_pointer(int id) {
return xm_control_by_id(id,window);
}

ControlRef xm_ocontrol_pointer(int id) {
return xm_control_by_id(id,win_options);
}

ControlRef xm_hcontrol_pointer(int id) {
return xm_control_by_id(id,win_channels);
}

ControlRef xm_icontrol_pointer(int id) {
return xm_control_by_id(id,win_instruments);
}

/* Events in Instruments window. */

pascal OSStatus xm_bahia_cbuttons(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
if (inUserData == xm_icontrol_pointer(1302)) xm_bahia_modinst(1,currInstru[1]-1);
else if (inUserData == xm_icontrol_pointer(1303)) xm_bahia_modinst(1,currInstru[1]+1);
else if (inUserData == xm_icontrol_pointer(1304)) xm_bahia_modinst(2,currInstru[2]-1);
else if (inUserData == xm_icontrol_pointer(1305)) xm_bahia_modinst(2,currInstru[2]+1);
else if (inUserData == xm_icontrol_pointer(1306)) xm_bahia_modinst(3,currInstru[3]-1);
else if (inUserData == xm_icontrol_pointer(1307)) xm_bahia_modinst(3,currInstru[3]+1);
else if (inUserData == xm_icontrol_pointer(1311)) xm_bahia_onoff(1);
else if (inUserData == xm_icontrol_pointer(1312)) xm_bahia_onoff(2);
else if (inUserData == xm_icontrol_pointer(1313)) xm_bahia_onoff(3);
return noErr;
}

void xm_bahia_onoff(short fbahia) {
int iFooBarBaz[4]={0,1311,1312,1313};
ControlRef ctrlRef;
int Elem,bahia;

for ( bahia=1; bahia <= 3; ++bahia ) {
Elem=BASSMOD_MusicGetVolume(MAKELONG(currInstru[bahia],1));

if (bahia==fbahia) {
if (Elem==0) BASSMOD_MusicSetVolume(MAKELONG(currInstru[bahia],1),100);
else BASSMOD_MusicSetVolume(MAKELONG(currInstru[bahia],1),0);

}
}

for ( bahia=1; bahia <= 3; ++bahia ) {
Elem=BASSMOD_MusicGetVolume(MAKELONG(currInstru[bahia],1));


if (Elem==100) {

ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );

SetControlValue(ctrlRef,1);

DrawOneControl(ctrlRef);

} else {

ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );

SetControlValue(ctrlRef,0);

DrawOneControl(ctrlRef);

}

}

}

/*
This function installs the events to the GUI objects.
*/
void xm_event_handle(EventHandlerProcPtr xproc,DWORD event,WindowPtr wintana,int ID) {
ControlRef ctrlRef;
ctrlRef=xm_control_by_id(ID,wintana);
EventTypeSpec tSpec={kEventClassControl,event};
InstallEventHandler(GetControlEventTarget(ctrlRef),NewEventHandlerUPP(xproc),1,&tSpec,ctrlRef,NULL);
}

/* This installs some events on Instruments window */
void xm_bahia_handle(short bahia,int prev,int next,int turnbutt) {


xm_event_handle(xm_bahia_cbuttons,kEventControlHit,win_instruments,prev);


xm_event_handle(xm_bahia_cbuttons,kEventControlHit,win_instruments,next);


xm_event_handle(xm_bahia_cbuttons,kEventControlHit,win_instruments,turnbutt);

}


/*
This function reads the flags selected in the GUI, and then select the appropiate BASSMOD options.
*/
DWORD xm_read_gui_option_flags(short isFtime) {
DWORD flags;
DWORD Value;

// Initial flags
flags=BASS_MUSIC_POSRESET;

// If is the first we load the song, then we need to calc its length.
if (isFtime == 1) {
flags|=BASS_MUSIC_CALCLEN;
}

/*
Now we select the appropiate BASSMOD options for each GUI value selected.
*/
Value=GetControl32BitValue(xm_ocontrol_pointer(20));

if (Value==1) {
flags|=BASS_MUSIC_NONINTER;
}

Value=GetControl32BitValue(xm_ocontrol_pointer(18));

switch (Value) {
case 2: flags|=BASS_MUSIC_RAMP; break;
case 3: flags|=BASS_MUSIC_RAMPS; break;
}

Value=GetControl32BitValue(xm_ocontrol_pointer(19));

switch (Value) {
case 2: flags|=BASS_MUSIC_SURROUND; break;
case 3: flags|=BASS_MUSIC_SURROUND2; break;
}

return flags;
}

/* This initialise the channels window */

void xm_channel_window_init() {
char digdisplay[4];
channels=0;
ControlRef ctrlRef;
while (BASSMOD_MusicGetVolume(channels)!=-1) ++channels;
sprintf(digdisplay,"%d",channels);

ctrlRef=xm_hcontrol_pointer(902);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);

currentChannel=0;
sprintf(digdisplay,"0");
ctrlRef=xm_hcontrol_pointer(903);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);

ctrlRef=xm_hcontrol_pointer(904);
if (channels > 0 ) SetControl32BitValue(ctrlRef,BASSMOD_MusicGetVolume(0));

}

/* This function sets the current editing instrument for the 'bahia' passed as arg. */
void xm_bahia_modinst(short bahia,int hinstrum) {
int fooBarBaz[4]={0,903,1300,1301};
int iFooBarBaz[4]={0,1311,1312,1313};
ControlRef ctrlRef;

char digdisplay[4];
int Elem;
if ( hinstrum < 0 ) hinstrum=instruments-1;
if ( hinstrum+1 > instruments ) hinstrum=0;
currInstru[bahia]=hinstrum;
ctrlRef = xm_icontrol_pointer(fooBarBaz[bahia]);
sprintf(digdisplay,"%d",hinstrum);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);
Elem=BASSMOD_MusicGetVolume(MAKELONG(hinstrum,1));

if (Elem==100) {

ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );

SetControlValue(ctrlRef,1);
DrawOneControl(ctrlRef);

} else {

ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );

SetControlValue(ctrlRef,0);
DrawOneControl(ctrlRef);

}

}

/* This function inits Instruments window */

void xm_instrument_window_init() {
char digdisplay[4];
instruments=0;
ControlRef ctrlRef;
while (BASSMOD_MusicGetVolume(MAKELONG(instruments,1))!=-1) ++instruments;
sprintf(digdisplay,"%d",instruments);

ctrlRef=xm_icontrol_pointer(902);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);

xm_bahia_modinst(1,0);
xm_bahia_modinst(2,1);
xm_bahia_modinst(3,2);


}
