/*
  fileselect.c
  XimpleMOD Tracker Player

A free open-source program, that provides a GUI to play MOD tracker songs in Mac OS X.

*/

/*

This function loads a song into XimpleMOD using the string "musicToLoad".

*/
void xm_song_load(char *musicToLoad) {
char *title;
ControlRef CtRef;
FSRef tref;
Boolean isAlias;
Boolean dvFld;

/* First, we check if "musicToLoad" is a Mac OS X alias */

FSPathMakeRef( musicToLoad, &tref, NULL );

FSIsAliasFile( &tref, &isAlias, &dvFld );

/* If is an alias, then we need to resolve the alias */
if ( isAlias == TRUE ) {
Boolean wasAliased;
char fusicToLoad[255];

if (FSResolveAliasFile( &tref, TRUE, &dvFld, &wasAliased ) == noErr) {

FSRefMakePath( &tref, fusicToLoad, 255 );
musicToLoad=fusicToLoad;

	} else {
	CtRef=xm_control_pointer(5);
	SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen("Alias read error"),"Alias read error");
	DrawOneControl(CtRef);
				PlayList=0;
			CtRef=xm_control_pointer(1998);
			SetControlValue(CtRef,0);
			DrawOneControl(CtRef);
	return;
	}
}


/* We free the current song. */
BASSMOD_MusicFree();

/* Now we tell BASSMOD to load the song.
If BASSMOD can load the song... */
if (BASSMOD_MusicLoad(FALSE,musicToLoad,0,0,xm_read_gui_option_flags(1))) {
	DWORD length;
	length=BASSMOD_MusicGetLength(FALSE);

	/* Then we init the GUI position control. */
	SetControl32BitMaximum(xm_control_pointer(7),length-1);


	/* We write song title to the display. */
	title=BASSMOD_MusicGetName();
	CtRef=xm_control_pointer(5);
	SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(title),title);
	DrawOneControl(CtRef);

	/* Hmmm... Its nice to display the length of the song :) */
	int mycrotime;
	char strtime[20];
	if (mycrotime=BASSMOD_MusicGetLength(TRUE)) {
		mycrotime=mycrotime/176400;
		sprintf(strtime," %d:%02d",mycrotime/60,mycrotime%60);
	} else {
		sprintf(strtime,"--:--");
	}
	trueplaying=1;
	wplaying=0;
	CtRef=xm_control_pointer(38);
	SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(strtime),strtime);
	DrawOneControl(CtRef);

	/* And finally we update Channels & Instruments window. */

	xm_channel_window_init();
	xm_instrument_window_init();


/* If BASSMOD cant load the song then... */
} else {

	/* We write an error message in button. */
	SetControlData(xm_control_pointer(5),kControlEntireControl,kControlStaticTextTextTag,strlen("Invalid song format!"),"Invalid song format!");
	DrawOneControl(xm_control_pointer(5));

	HideWindow ( win_channels );
	HideWindow ( win_instruments );
				if (PlayList == 1) {
			PlayList=0;
			CtRef=xm_control_pointer(1998);
			SetControlValue(CtRef,0);
			DrawOneControl(CtRef);
			}
}

// We reset the GUI position control to the start :)
SetControl32BitValue(xm_control_pointer(7),0);

return;
}



/*
FILE SELECT FUNCTION
This function selects the sont to play, prompting the user for the file.
*/

pascal OSStatus xm_select_a_file(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData)
{

/*
We make and run the dialog. Then get the path to the file.
*/
NavDialogRef dialog;
NavDialogCreationOptions programme;
NavGetDefaultDialogCreationOptions(&programme);
programme.optionFlags=0;
programme.parentWindow=window;
programme.windowTitle=CFStringCreateWithCString(kCFAllocatorDefault,"Choose a IT/XM/S3M/MTM/MOD/UMX file",kCFStringEncodingASCII);
NavCreateChooseFileDialog(&programme,NULL,NULL,NULL,NULL,NULL,&dialog);
if (!NavDialogRun(dialog)) {
	NavReplyRecord recorde;
	if (!NavDialogGetReply(dialog,&recorde)) {
		AEKeyword key;
		FSRef frefr;
		if (!AEGetNthPtr(&recorde.selection,1,typeFSRef,&key,NULL,&frefr,sizeof(frefr),NULL)) {
			char musicToLoad[255]="";
			FSRefMakePath(&frefr,musicToLoad,255);

			/* Load the song */
			if (PlayList == 1) {
			PlayList=0;
			ControlRef lcref=xm_control_pointer(1998);
			SetControlValue(lcref,0);
			DrawOneControl(lcref);
			}
			xm_song_load(musicToLoad);
			islooping=0;
			SetControlTitleWithCFString(xm_control_pointer(810),CFSTR("Repeat"));

		}
		NavDisposeReply(&recorde);
	}
}
NavDialogDispose(dialog);
return noErr;
}
