/*
  control.c
  XimpleMOD Tracker Player

A free open-source program, that provides a GUI to play MOD tracker songs in Mac OS X.

*/

/*
CONTROL FUNCTIONS
*/

/*
Play the song :)
*/
pascal OSStatus xm_play(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
if (wplaying != 1) {
BASSMOD_MusicPlay();
starttime=timeGetTime();
}
return noErr;
}

/*
Stop (pause) the song...
*/
pascal OSStatus xm_stop(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
BASSMOD_MusicPause();
return noErr;
}

/*
Update BASSMOD flags using the options of controls in GUI :)
*/
pascal OSStatus xm_flags(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
DWORD bflags;
bflags=xm_read_gui_option_flags(0);
BASSMOD_MusicPlayEx(-1,bflags,FALSE);
return noErr;
}

/*
Enable or disable the loop (repeat)
*/

pascal OSStatus xm_loop(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
DWORD bflags;

if (islooping == 0) {
	islooping = 1;
	
SetControlTitleWithCFString(inUserData,CFSTR("No Repeat"));

bflags=xm_read_gui_option_flags(0);
bflags|=BASS_MUSIC_LOOP;
BASSMOD_MusicPlayEx(-1,bflags,FALSE);
return noErr;
} else {
	islooping = 0;
	SetControlTitleWithCFString(inUserData,CFSTR("Repeat"));

bflags=xm_read_gui_option_flags(0);
BASSMOD_MusicPlayEx(-1,bflags,FALSE);
return noErr;
}
}

/* Show or hide options window */

pascal OSStatus xm_show_options(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
ShowWindow ( win_options );
SelectWindow ( win_options );

return noErr;
}

pascal OSStatus xm_hide_options(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
HideWindow ( win_options );
return noErr;
}

/* Channels and instruments window */

pascal OSStatus xm_show_channels(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
DWORD retcode;
BASSMOD_MusicGetName();
retcode=BASSMOD_ErrorGetCode();
if (retcode == BASS_ERROR_NOMUSIC) {
char message[] = "No song is loaded";
ControlRef ctrlRef=xm_control_pointer(5);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(message),message);
DrawOneControl(ctrlRef);
} else {

ShowWindow ( win_channels );

xm_channel_window_init();

SelectWindow ( win_channels );

}


return noErr;
}

pascal OSStatus xm_hide_channels(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
HideWindow ( win_channels );
return noErr;
}

pascal OSStatus xm_show_instruments(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
DWORD retcode;
BASSMOD_MusicGetName();
retcode=BASSMOD_ErrorGetCode();
if (retcode == BASS_ERROR_NOMUSIC) {
char message[] = "No song is loaded";
ControlRef ctrlRef=xm_control_pointer(5);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(message),message);
DrawOneControl(ctrlRef);
} else {

ShowWindow ( win_instruments );

xm_instrument_window_init();

SelectWindow ( win_instruments );

}

return noErr;
}

pascal OSStatus xm_hide_instruments(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
HideWindow ( win_instruments );
return noErr;
}

pascal OSStatus xm_next_channel(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
currentChannel++;
if (currentChannel >= channels) currentChannel=0;
char digdisplay[4];
ControlRef ctrlRef=xm_hcontrol_pointer(904);
SetControl32BitValue(ctrlRef,BASSMOD_MusicGetVolume(currentChannel));
ctrlRef=xm_hcontrol_pointer(903);
sprintf(digdisplay,"%d",currentChannel);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);
return noErr;
}

pascal OSStatus xm_prev_channel(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
currentChannel--;
if (currentChannel < 0) currentChannel = channels-1;
char digdisplay[4];
ControlRef ctrlRef=xm_hcontrol_pointer(904);
SetControl32BitValue(ctrlRef,BASSMOD_MusicGetVolume(currentChannel));
ctrlRef=xm_hcontrol_pointer(903);
sprintf(digdisplay,"%d",currentChannel);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);
return noErr;
}

pascal OSStatus xm_all_channels_on(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY;

for ( IY = 0; IY < channels; ++IY ) BASSMOD_MusicSetVolume(IY,100);

xm_channel_window_init();

return noErr;
}

pascal OSStatus xm_all_channels_off(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY;

for ( IY = 0; IY < channels; ++IY ) BASSMOD_MusicSetVolume(IY,0);

xm_channel_window_init();

return noErr;
}

pascal OSStatus xm_all_instruments_on(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY;

for ( IY = 0; IY < instruments; ++IY ) BASSMOD_MusicSetVolume(MAKELONG(IY,1),100);

xm_instrument_window_init();

return noErr;
}

pascal OSStatus xm_all_instruments_off(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY;

for ( IY = 0; IY < instruments; ++IY ) BASSMOD_MusicSetVolume(MAKELONG(IY,1),0);

xm_instrument_window_init();

return noErr;
}


/*
Update the position of SONG from the GUI
*/
pascal void xm_position_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
sdrrpos=GetControl32BitValue(control);
if (sdrrpos!=LOWORD(BASSMOD_MusicGetPosition())) {
BASSMOD_MusicSetPosition(sdrrpos);
}
}

/*
Update the various volumes of SONG from the GUI
*/
pascal void xm_volume_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
sdrrpos=GetControl32BitValue(control);
BASSMOD_SetVolume(sdrrpos);
}

pascal void xm_amplification_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
sdrrpos=GetControl32BitValue(control);
BASSMOD_MusicSetAmplify(sdrrpos);
}

pascal void xm_panning_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
ControlRef cfRef;
char streng[4];
sdrrpos=GetControl32BitValue(control);
BASSMOD_MusicSetPanSep(sdrrpos);
sprintf(streng,"%d",sdrrpos);
cfRef=xm_ocontrol_pointer(900);
SetControlData(cfRef,kControlEntireControl,kControlStaticTextTextTag,strlen(streng),streng);
DrawOneControl(cfRef);

}

pascal void xm_channel_volume_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
sdrrpos=GetControl32BitValue(control);
BASSMOD_MusicSetVolume(currentChannel,sdrrpos);
}



/*
Update the display
*/
pascal void xm_update_display(EventLoopTimerRef inTimer, void *inUserData)
{
DWORD sisActive=BASSMOD_MusicIsActive();
if (sisActive == BASS_ACTIVE_STOPPED || sisActive == BASS_ACTIVE_PAUSED) {
wplaying=0;
} else {
wplaying=1;
}
char text[12];
int pos;
pos=BASSMOD_MusicGetPosition();
if (pos==-1) {
pos=0;
} else {
SetControl32BitValue(xm_control_pointer(7),LOWORD(pos));
}
sprintf(text,"%.1f%% CPU",BASSMOD_GetCPU());
ControlRef ctrlRef=xm_control_pointer(8);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(text),text);
DrawOneControl(ctrlRef);
int tyme=GETMicroTime();
char tstring[12];
if (wplaying == 1 && trueplaying == 1) {
sprintf(tstring,"%d:%02d",tyme/60,tyme%60);
} else {
sprintf(tstring,"--:--");
}
ControlRef ztrlRef=xm_control_pointer(44);
SetControlData(ztrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(tstring),tstring);
DrawOneControl(ztrlRef);
}
