#!/usr/bin/perl -w
use Getopt::Long;
use FindBin qw($Bin);


sub usage;
sub do_command;
sub cleanup;
sub expand;
use File::Path;
$cs=0;
$should_exit=0;
$isShrunk=0;
$ignore_rv=0;

setpgrp;

$SIG{'TERM'} = 'catch';
$SIG{'INT'} = 'catch';

$result=GetOptions("restore!" => \$restore,
				   "image_dir=s" => \$image_dir,
				   "disk_device=s" => \$disk_device,
				   "mbr_file=s" => \$mbr_file,
				   "ntfstools_dir=s" => \$ntfstools_dir,
				   "test!" => \$test,
				   "v!" => \$verbose,
				   "use_asr!" => \$use_asr,
				   "help!"=> \$help,
				   "h" => \$h,
				   "ntfs_partition=s" => \$ntfs_partition,
				   "no_image!" => \$no_image, 
				   "q!" => \$quiet,
					"image_format=s" => \$image_format,
					"-update_bootini"=>\$update_bootini,
					"-copy_bcd=s"=>\$copy_bcd,
					"-gptrefresh_path=s"=>\$gpt_refresh_path);

if (!$result) { 	cleanup; die "Invalid options" } ;




if (!$image_format) { $image_format="diskimage"};
if (!($image_format eq "diskimage") && !($image_format eq "special") )  {
	print "Invalid image_format.  Should be diskimage or special.\n";
	print "$image_format";
	usage;
	exit (-1);
}
if (!$restore  ) {
	print "you must specify -restore options\n";
	usage;
	exit(-1);
}



if (( $> != 0) and (!$test) ) {
	print "Must be run as root!\n";
	exit(-1);
}
if ($help or $h) {
	usage;
	cleanup;
	exit;
}

	


if (!$image_dir) { $image_dir="./image.winclone" } ;
if (!$ntfs_partition) { $ntfs_partition="/dev/disk0s3" };

if (!$mbr_file) { $mbr_file="$image_dir/boot.mbr" };
if ($test) {$verbose=TRUE };

if (!$disk_device) { $disk_device="/dev/disk0" };
if (!$ntfstools_dir) { $ntfstools_dir="." };
if (!$gpt_refresh_path) { $gpt_refresh_path=$ntfstools_dir };

	
	
if ($image_format eq "special") {
	$image_path="$image_dir/boot.img.gz";
}
else {
	$image_path="$image_dir/Windows";
}
	

$ntfs_partition=~m|dev/(.*)s(\d+)|;
$raw_disk="/dev/r".$1;
$partition_number=$2;
if (!$raw_disk) {
	print"could not get raw disk device\n!";
	cleanup;
	exitWithError(-1);
}


if ($test) {$verbose=TRUE };

printf("restoring.....\n");
if (!$quiet) {
    print "Are you really sure you want to start restoring? THIS MAY CAUSE SERIOUS DATA LOSS!  DO NOT USE THIS ON A MACHINE THAT YOU CANNOT AFFORD TO LOSE ALL DATA ON ALL PARTITIONS.  Continue? (y/n)? ";
    $input=<STDIN>; 
    chomp ($input);
    if ($input ne "y") {	
        cleanup;
        exit;
    }
}
printf("getting fdisk info.....\n");
$fdisk=`/usr/sbin/fdisk -d \"$raw_disk\"`;
@fdisk_array=split("\n",$fdisk);
$val=$fdisk_array[$partition_number-1];
@fdisk_start=split(",",$val);
printf("validating partition type.....\n");
if ( ($fdisk_start[2] ne "0x07" ) and ($fdisk_start[2] ne "0x0B")  and ($fdisk_start[2] ne "0x0C") and ($fdisk_start[2] ne "0x0E")) {
    cleanup; print "Partition $partition_number on device $disk_device is not a MS-DOS Partition!\n";
    exitWithError(-1);
}

$part_size=$fdisk_start[1]/2;
printf("checking image size.....\n");
$filename = $image_dir."/size";
if (-e $filename) {
    printf("image size file exists, opening.....\n");
    open FILE, $filename or die "can't open $filename: $!"; 
    print("reading image file...$filename..\n");
    $image_size = <FILE>; 
    close FILE or die "cannot close $filename: $!"; 
    print("read image file...$filename..\n");		
    $part_size=$fdisk_start[1]*512;
    print("done calculating..\n");
    if ( $part_size < $image_size) {
        print "the partition size of $part_size is smaller than the image size of $image_size\n";
        exitWithError (-1);
    }
    print("done checking size..\n");
}
#$fat32=0;
if (!$no_image) {	

    if (-e "${image_dir}/boot.img.gz") {
        unmount_volume($ntfs_partition);
        do_command("=====restoring image======","/usr/bin/gunzip -c \"${image_dir}/boot.img.gz\"| \"$ntfstools_dir/ntfsclone\" --restore-image --rescue --overwrite \"$ntfs_partition\" - 1>&2");
    }
    elsif (-e "${image_dir}/Windows.dmg") {
        print("checking format of image..\n");
        if ( (formatOfImage("${image_dir}/Windows.dmg") =~ m/FAT/) || $use_asr ) {
            print "restoring using asr\n";
            #unmount_volume($ntfs_partition);
            #do_command("=====restoring image==============","/usr/sbin/asr restore --noverify --puppetstrings -noprompt --source \"${image_dir}/Windows.dmg\" --target \"${ntfs_partition}\" 1>&2");
            do_command("=====restoring image==============","/usr/sbin/asr restore --noverify --puppetstrings -noprompt -erase --source \"${image_dir}/Windows.dmg\" --target \"${ntfs_partition}\" 1>&2");

        }
        else {
            print("We have NTFS..\n");
            unmount_volume($ntfs_partition);
            print("==============mounting disk image============== \n/usr/bin/hdiutil attach  -noverify -nomount \"${image_dir}/Windows.dmg\"\n");
            my $disk_device=`/usr/bin/hdiutil attach  -nomount \"${image_dir}/Windows.dmg\" | grep \'dev/disk\' | awk '{print \$1}'`;
            chomp($disk_device);	
            print "\ndisk device is $disk_device\n";
            do_command("=====restoring image from disk image============="," \"$ntfstools_dir/ntfsclone\" -O \"$ntfs_partition\"  $disk_device 1>&2");
            do_command("=====unmounting disk image==============","/usr/bin/hdiutil detach ${disk_device}");
        }
            
    }
    elsif (-e "${image_dir}/Windows.sparsebundle") {
        unmount_volume($ntfs_partition);
        print("==============mounting sparse image============== \n/usr/bin/hdiutil attach  -nomount \"${image_dir}/Windows.sparsebundle\"\n");
        my $disk_device=`/usr/bin/hdiutil attach  -nomount \"${image_dir}/Windows.sparsebundle\" | awk '{print \$1}'`;
        chomp($disk_device);	
        print "\ndisk device is $disk_device\n";
        do_command("=====restoring image from disk image============="," \"$ntfstools_dir/ntfsclone\"  -O \"$ntfs_partition\"  $disk_device 1>&2");
        do_command("=====unmounting disk image==============","/usr/bin/hdiutil detach ${disk_device}");
        
    }
    else {
        print("NO WINDOWS IMAGE FOUND!");
        cleanup();
        exit(-1);
    }
}
system("/usr/sbin/diskutil mount \"$ntfs_partition\"");
$destination_path=`diskutil info ${ntfs_partition}|grep 'Mount Point'`;
chomp($destination_path);
$destination_path=~ s/.*Mount Point: *(.*)/$1/;
print ("destination_path is $destination_path\n");

$filesystem=`diskutil info ${ntfs_partition}|grep 'File System.*:'`;
chomp ($filesystem);
$filesystem=~ s/.*File System.*: *(.*)/$1/;
if ($copy_bcd && (-e "${destination_path}/Boot/BCD") ) {
    if (-e "$copy_bcd") {
        unmount_volume($ntfs_partition);
        $ignore_rv=1;
        do_command("=======copying BCD file=========","\"$ntfstools_dir/ntfscp\" -f \"$ntfs_partition\" \"$copy_bcd\" /Boot/BCD") ;
    }
    else {printf("Could not find BCD file at $copy_bcd\n")};
}
if ($update_bootini && (-e "${destination_path}/boot.ini") ) {
    system("cat \"${destination_path}/boot.ini\" |sed \"s/partition(.*)/partition(${partition_number})/\" > /tmp/boot.ini ");	
    if ($filesystem =~m/NTFS/i) {
        unmount_volume($ntfs_partition);
        do_command("=======updating boot.ini=========","\"$ntfstools_dir/ntfscp\" -f \"$ntfs_partition\" /tmp/boot.ini /boot.ini") ;
    }
    else {
        do_command("=======copying old boot.ini file=========","cp \"${destination_path}/boot.ini\" \"${destination_path}/boot.ini.old\"");
        do_command("=======removing old boot.ini file=========","rm -f \"${destination_path}/boot.ini\"");
        do_command("=======copying new boot.ini file=========","cp /tmp/boot.ini \"${destination_path}/boot.ini\"") ;
    }
}


unmount_volume($ntfs_partition);
@args=("-f","-w","-m \"$mbr_file\"","-a ${partition_number}","-u");
if (-e "$image_dir/partitionid") {
    open (FPTR,"${image_dir}/partitionid") || die "can't open partitionid file";
    @partition_id_array=<FPTR>;
    $code=$partition_id_array[0];
    chomp($code);
    push(@args,"-i ${code}");
}

push(@args,"\"${disk_device}\"");

$arg_string=join(" ",@args);
do_command("=====Syncing GPT with MBR Partition Table, setting partition to bootable, and restoring boot sector==============","\"$gpt_refresh_path/gptrefresh\" ${arg_string}");

if ($filesystem =~m/NTFS/i) {
    unmount_volume($ntfs_partition);
    expand;
}

if ($verbose) {print "=============Complete===========\n"};

cleanup;


sub usage {
	print "Usage: winclone.perl <options>\n";
	print "Options:\n";
	print "-restore								Restore Image\n";
	print "-image_dir=<path>					Folder to either save image or restore image from.  Default: ./image.winclone\n";
	print "-disk_device=<path>					Path to device that contains the partition table.  Default: /dev/disk0\n";
	print "-ntfstools_dir=<path>				Path to ntfstools.  Default: \".\"\n";
    print "-gptrefresh_path=<path>				Path to gptrefres.  Default: path specified in ntfstools_dir\n";
	print "-ntfs_partition=<path>				Path to partition to ntfs partition.  Default: /dev/disk0s3\n";
	print "-shrink_device=<device>				shrink NTFS fileysstem at <device>.  \n";
	print "-create								Create Image\n";
	print "-q									Quiet.  Suppress any warnings.\n";
	print "-update_bootini						Update boot.ini (XP)\n";
	print "-copy_bcd=<path>						copy generic BCD (Vista) to destination from <path>\n";
	print "-no_image							Don't create image.\n";
	print "-self-extract						Use resources within the image bundle to clone\n";
	print "-image_format=<diskimage|special>	Specify image format.  sparse can be mounted in the Finder but are slower and larger than special.\n";
	print "-diskimagetype=<sparse|compressed>	Specify image type.  Only applies if -image_format=diskimage\n";
	print "-use_asr								Use ASR when restoring instead of ntfsclone.  Only valid with -restore.\n";


}
sub do_command {
	my $descr=shift(@_);
	my $command = shift(@_);
	if ($verbose) {
		print $descr . "\n";
	}
	if ($test) {
		print "TEST:";
	}
	if ($verbose) {print "\n" . $command . "\n"};

	if (!$test) {
		$output=`$command`;
		$rv=`echo $?`;
		if ($verbose) {
			print "return value of $command is $rv\n";
		}
		if ($verbose) { print $output} ;
		if ($ignore_rv==0 && $rv != 0 ) {
			printf "$command did not complete successfully\n";
			cleanup;
			exitWithError($rv);
		}
		$ignore_rv=0;		
	}
}
sub unmount_volume {
	my $volume=shift(@_);
	for ($i=0;$i<10;$i++) {
		if ($verbose) {
			print "Unmounting $volume\n";
		}	
		$output =`/usr/sbin/diskutil unmount \"$volume\" 2>&1`;
		$rv=`echo $?`;
		if ($verbose) {
            print "/usr/sbin/diskutil unmount \"$volume\"";
			print "return value of unmount is $rv\n";
		}
		if ($rv == 0) {
			last;
		}
        print "output is $output\n";
        if ($output =~ m/was already .*mounted/i) {
            $ignore_rv=1;
            last ;   
        }
	}

	if ($ignore_rv==0 && $rv != 0 ) {
		printf "unmount_volume did not complete successfully\n";
		cleanup;
		exitWithError($rv);
	}
	$ignore_rv=0;	
}
sub expand {
	
	do_command("=====expanding=====","\"$ntfstools_dir/ntfsresize\" -f -f \"$ntfs_partition\"") ;	
	
}
sub getfilesystemsize{
	my $device=shift(@_);
	
	my $size=`/bin/df |grep "${device}"|awk '{print $3}'`;
	chomp($size);
	if (!$size) {
		printf("mounting image to get size\n");
		system("/usr/bin/hdiutil attach -nobrowse ${device}");
		$size=`/bin/df |grep "${device}"|awk '{print \$3}'`;
		printf("got size of ${size}\n");
		chomp($size);
	}
	return $size;
}
sub getpartitionsize{
	my $device=shift(@_);
	my $size=`diskutil info /dev/disk0s4|grep 'Total Size'|sed "s/.*(\\(.*\\) B.*) (.*locks)\$/\\1/"`;
	chomp($size);

	return $size;
	
}
sub cleanup {
	if ($isShrunk) { 
		print "Expanding back filesystem\n";
		$cs=1;
		expand;
		$isShrunk=0;
		$cs=0;
	}
	if ($win_partition && !($win_partition eq "") ) {
		print "cleaning up: Ejecting $win_partition\n";
		system("/usr/sbin/diskutil eject \"${win_partition}\"");
	}
	print "cleaning up: Mounting Disk\n";
	system("/usr/sbin/diskutil mount \"$ntfs_partition\"");
}

sub exitWithError {
	my $err=shift(@_);
	system ("echo \"$err\" > /tmp/winclone.exit");
	exit ($err);
	
}
sub formatOfImage {
	
	my $path=shift(@_);
	$hdi_info=`/usr/bin/hdiutil imageinfo  \"$path\" |grep partition-hint|awk '{print \$2}' `;

	return $hdi_info;
	
	
}
sub getfilesystem{
	my $device=shift(@_);
	my $filesystem=`diskutil info ${device}|grep 'File System.*:'`;
	$filesystem=~ s/.*File System.*: *(.*)/$1/;
	chomp ($filesystem);
	return $filesystem;
}
sub catch {
	if ($cs == 1 ) {
		print "caught signal to quit, delaying..\n";
		$should_exit=1;
	}
	else {
		printf("caught signal, dying\n");
		kill TERM => -$$;
		if ($isShrunk==1) {
			$cs=1;
			#			sleep 1;
			expand;
			$cs=0;
		}
		cleanup;
		exit(-1);
	}
}
