unit VNCPatches;

interface

	uses
		Cache, SysEqu, Timer, Traps, MyMixedMode;

	const
		gestaltVncExtensionVersion = 'VNCv';
		kVncExtensionVersion = $102;
{    kVncServerVersion = $03040005;}
		gestaltVncGlobals = 'VNCg';

		kDoMostBasicTest = false;

		kNoMungeKeys = false;
		kNoSyncLMKeys = false;
		kNoMungeLMKeys = false;
		kNoMungeShiftKey = true;
		kServerDoesKeys = true;
		kServerDoesCtrlOpt = true;
		kServerDoesCursor = true;
		kServerDoesSplitting = false;

		kDoInFront = true;
		kNoWNEPatch = true;
		kNoSetCursorPatch = false;
		kNoWaitMouseMovedPatch = true;
		kNoDragPatch = false;
		kNoButtonPatch = false;
		kNoPostEventPatch = true;
		kNoPPostEventPatch = true;
		kNoTickCountPatch = true;
		kNoCursorDevicePatch = true;
		kNoTMTask = false;

{A flag to disable calling of other vnc entry points (apart from vncInvalGlobalRect and vncSystemTask) }
		kCallVNCRoutines = false;

{ A flag to disable the special vnc entry points (vncInvalGlobalRect and vncSystemTask) from within JShieldCursor }
		kCallFromJShieldCursor = true;

		rOKIcon = 128;
		rBadIcon = 129;

{ The maximum number of rects that we are allowed to fill up to }
		kMaxRcts = 60;
{ The actual rects that can fit in the buffer - should be at least 2 more than above so that cursor updates can always fit }
		kMaxRcts2 = 65;

{ This is the gap in ticks required for the alpha 3/4 server to start sending updates }
		kUpdateGapTicks = 10;
		kFastUpdateGapTicks = 10;
		kSlowUpdateGapTicks = 20;
		kMaxUpdateGapTicks = 30;

{ The patch identifiers }
		kStatGetKeys = 1;
		kStatSetCursor = 2;
		kStatSetCCursor = 3;
		kStatCopyBits = 4;
		kStatScrollRect = 5;
		kStatSystemTask = 6;
		kStatPutScrap = 7;
		kStatGetMouse = 8;
		kStatButton = 9;
		kStatStillDown = 10;
		kStatWaitMouseUp = 11;
		kStatJShieldCursor = 12;
{ These ones are not actually used by the alpha 3-5 server, but I do make use of some slots for debugging below }
		kStatPaintRgn = 13;
		kStatFrameRgn = 14;
		kStatEraseRgn = 15;
		kStatInvalRgn = 16;
		kStatPaintRect = 17;
		kStatFrameRect = 18;
		kStatEraseRect = 19;
		kStatInvalRect = 20;
		kStatPlotIcon = 21;
		kStatDrawPicture = 22;
{ These are spare ones - I will use some of these below, but I include them so it looks like the 'official' release }
		kStatSpare1 = 23;
		kStatSpare2 = 24;
		kStatSpare3 = 25;
		kStatSpare4 = 26;
		kStatSpare5 = 27;
		kStatSpare6 = 28;
		kStatSpare7 = 29;
		kStatSpare8 = 30;
		kStatSpare9 = 31;
		kStatSpare10 = 32;
{ Several other patches that I'm adding - these use 'spare' slots in the alpha 3/4 release }
		kStatDragDispatch = 23;
		kStatPostEvent = 24;  { This one is obsolete }
		kStatPPostEvent = 25;
		kStatTickCount = 26;
		kStatCursorDevice = 27;
		kStatWNE = 28;
{ Here are some more counters for debugging purposes - these use the unused Quickdraw }
{ slots to avoid treading on toes of any of the spare ones that may be used in the future }
		kStatGotMsEvt = 13;
		kStatIncreasedMsEvtTime = 14;
		kStatDecreasedMsEvtTime = 15;
		kStatMouseDown = 16;
		kStatMouseUp = 17;
		kStatTMTask = 18;
		kStatMovedMouse = 19;
{ This is the maximum for the alpha 3/4/5 TridiaVNC Server  }
		PATCHED_CALLS_MAX = 32;

{ These are for the VNC server entry points }
		kStatVNCInvalGlobalRect = 1;
		kStatVNCGetKeys = 2;
		kStatVNCCopyBits = 3;
		kStatVNCSystemTask = 4;
		kStatVNCScrollRect = 5;
		kStatVNCPutScrap = 6;
{ Some unused slots }
		kStatVNCSpare1 = 7;
		kStatVNCSpare2 = 8;
{ This is the maximum for the alpha 3/4/5 server }
		VNC_CALLS_MAX = 8;

		kErrBadErr = 1;
		kErrBadCount = 2;
		kErrNeg1FSR = 3;
		kErrBig1FSR = 4;
		kErrBad1FSR = 5;
		kErrNeg2FSR = 6;
		kErrBig2FSR = 7;
		kErrNeg3FSR = 8;
		kErrBig3FSR = 9;
		kErrNeg1AAR = 10;
		kErrBig1AAR = 11;
		kErrBad1AAR = 12;
		kErrBad2AAR = 13;
		kErrNeg2AAR = 14;
		kErrBig2AAR = 15;
		kErrNegACR = 16;
		kErrBigACR = 17;
		kErrNeg1VST = 18;
		kErrBig1VST = 19;
		kErrNeg2VST = 20;
		kErrBig2VST = 21;
		kErrNeg3VST = 22;
		kErrBig3VST = 23;
		kErrNeg4VST = 24;
		kErrBig4VST = 25;
		kErrNeg5VST = 26;
		kErrBig5VST = 27;
		kErrInPatch = 28;
		kErrReenterShield = 29;

		kMaxErr = 30;

	type
		KeyMapPtr = ^KeyMap;

{ Each buffered rect is stored, along with its size and the time (in ticks) it was stored }
		RectInfo = record
				r: Rect;
				sz: LongInt;
				time: LongInt;
				when: Integer;
			end;

{ We want a list of buffered rects - note that there are a few extra (beyond kMaxRcts) to allow for }
{ the last and current cursor rects to be invalidated }
		RectList = record
				num: Integer;
				rcts: array[1..kMaxRcts2] of RectInfo;
			end;
		RectListPtr = ^RectList;

{ We make as many variables as possible into 'globals' }
{ This is to help reduce use of the stack during the patches - because we don't know which application's }
{ environment we will be running in, so we don't know how much stack space will be available }

{ 'Globals' record for the BufferRect procedure }
		BufferRectRec = record
				r1: Rect;
				r2: Rect;
				r3: Rect;
				r4: Rect;
				r5: Rect;
				r6: Rect;
				r7: Rect;
				r8: Rect;
				h: Integer;
				w: Integer;
				a: LongInt;
			end;

{ 'Globals' record for the AddARect procedure }
		AddARectRec = record
				ii: Integer;
				jj: Integer;
				jj2: Integer;
				nrcts: Integer;
				minur2: Rect;
				rr2: Rect;
				xr3: Rect;
				xr4: Rect;
				rrsz: LongInt;
				xr3sz: LongInt;
				xr4sz: LongInt;
				rr2sz: LongInt;
				minur2sz: LongInt;
			end;

{ 'Globals' record for the FindSectRect procedure }
		FindSectRectRec = record
				ii: Integer;
				ur: Rect;
				sr: Rect;
				cr: Rect;
				minur: Rect;
				xr1: Rect;
				xr2: Rect;
				ursz: LongInt;
				srsz: LongInt;
				crsz: LongInt;
				minursz: LongInt;
				xr1sz: LongInt;
				xr2sz: LongInt;
				mini: Integer;
				nrcts: Integer;
				pass1: Boolean;
				clipped: Boolean;
			end;

{ 'Globals' record for the VNCSystemTask procedure }
		VNCSystemTaskRec = record
				doTime: LongInt;
				earliest: LongInt;
				sofar: LongInt;
				rr: Rect;
				lastcur: Rect;
				newcur: Rect;
				tmpr: Rect;
				ii: Integer;
				jj: Integer;
				kk: Integer;
				earlyone: Integer;
				tmpri: RectInfo;
				carryon: Boolean;
				docursor: Boolean;
				gVNCA5: LongInt;
				gOldA5: LongInt;
				gOldCA5: Ptr;
			end;

{ Various other 'globals' that are used mainly in the patches }
		MiscellaneousRec = record
				gCanSend: Boolean;
				gAnIntRet: Integer;
				vncSystemTaskRD: RoutineDescriptorPtr;
				vncInvalGlobalRectRD: RoutineDescriptorPtr;
				vncGetKeysRD: RoutineDescriptorPtr;
				gNowTime: LongInt;
				gALongRet: LongInt;
				gLastPt: Point;
				gCurPt: Point;
				gCurApp: Str31;
				gARect: Rect;
			end;

		GlobalsPtr = ^GlobalsRec;
		MyTMInfo = record
				store: GlobalsPtr;
				gotVNC: Boolean;
				patchOK: Boolean;
				moved: Boolean;
				waitTime: LongInt;
				lastMouse: Point;
				lastOK: Point;
				cntr: Integer;
				dirn: Integer;
				addon: Integer;
			end;
		MyTMTaskPtr = ^MyTMTask;
		MyTMTask = record
				theTask: TMTask;
				info: MyTMInfo;
			end;
		MyTMInfoPtr = ^MyTMInfo;

		PatchInfo = record
				savedTrap: ProcPtr;
				callCount: LongInt;
			end;

		VncCallInfo = record
				entryPoint: ProcPtr;
				callCount: LongInt;
			end;

		GlobalsRec = record
				theCursor: CCrsr;
				homeFile: FSSpec;
				vncA5World: LongInt;
{ The old patch locations }
				patches: packed array[1..PATCHED_CALLS_MAX] of PatchInfo;
{ The VNC entry points }
				vncCalls: packed array[1..VNC_CALLS_MAX] of VncCallInfo;
{ This is where the TridiaVNC Server (alpha 3) normally finishes its patchGlobals }
{ Anything after this is added by me... }

{ This is where I would like the server to put the time to wait after drawing before sending rects }
				updateGapTicks: Integer;
				maxTimeoutTicks: Integer;
				maxSendGap: Integer;
				maxSendTime: LongInt;
{ A pointer to the vncPatches' buffered rectangles }
				patchRects: RectListPtr;
{ Just to make sure that JShieldCursor will not be re-entered }
				inshield: Boolean;
{ Just to make sure that none of the VNC stuff will be re-entered from the patches }
				using: Boolean;
				inVNC: Boolean;
{ A flag so that the vncPatches knows when the gestalt has been requested (i.e. the server has started) }
				gotGestalt: Boolean;
{ Another flag so that the vncPatches knows when the server entry points have been set }
				gotProcs: Boolean;
{ The last cursor position when update rects were sent }
				lastCurPt: Point;
{ The time (in ticks) when the cursor was at lastCurPt }
				lastCurTime: LongInt;
{ The last time (in ticks) that a rectangle was buffered via JShieldCursor - i.e. a screen update }
				lastBufferTime: LongInt;
{ The last time (in ticks) that the update rects were actually sent to the server }
				lastVNCInvalRectTime: LongInt;
{ The last time (in ticks) that there was a break (of two ticks for alpha 3) between catching updates }
{ This is effectively the last time that the server sent anything to the client using routine SendUpdates }
				lastClearTime: LongInt;
{ Some sanity checking to see if any out-of-bounds errors occur on the rect buffering list - should always be zero really! }
				errors: array[1..kMaxErr] of Integer;
{ Now we make space for the other 'globals' records... }
				gBR: BufferRectRec;
				gAAR: AddARectRec;
				gFSRR: FindSectRectRec;
				gDRBR: VNCSystemTaskRec;
				gMisc: MiscellaneousRec;
				mapper: array[0..127] of Integer;
				nullKeys: KeyMap;
				lastKeys: KeyMap;
				lastKeyTime: LongInt;
				lastMsEvtTime: LongInt;
				inVNCST: Boolean;
				didVNCST: Boolean;
				myTask: MyTMTask;
			end;

{ Obsolete header for resource }
		CodeHeader = record
				branch: Integer;
				zero: Integer;
				name: OSType;
				rsrcID: Integer;
				store: GlobalsPtr;
			end;


	procedure Main;


implementation

{ These provide the inline code for calling the original trap location }
{ They are all the same [ MOVE.L (A7)+,A0  JSR(A0)  ], but they have to be defined differently because of the parameters }
	procedure CallProcOnePtr (p: Ptr; theProc: ProcPtr);
	inline
		$205F, $4E90;
	procedure CallProcCopyBits (src, dst: Ptr; srcrct, dstrct: Rect; mode: Integer; mask: RgnHandle; theProc: ProcPtr);
	inline
		$205F, $4E90;
	function CallFuncZeroParam (theProc: ProcPtr): Integer;
	inline
		$205F, $4E90;
	function CallFuncOnePoint (p: Point; theProc: ProcPtr): Integer;
	inline
		$205F, $4E90;
	procedure CallProcScrollRect (r: Rect; dh, dv: Integer; updateRgn: RgnHandle; theProc: ProcPtr);
	inline
		$205F, $4E90;
	function CallFuncPutScrap (length: LongInt; theType: ResType; src: Ptr; theProc: ProcPtr): LongInt;
	inline
		$205F, $4E90;
	procedure CallProcGetMouse (var p: Point; theProc: ProcPtr);
	inline
		$205F, $4E90;
	procedure CallProcFourInt (a, b, c, d: Integer; theProc: ProcPtr);
	inline
		$205F, $4E90;
	function CallFuncWNE (mask: Integer; var event: EventRecord; sleep: LongInt; msRgn: RgnHandle; theProc: ProcPtr): Boolean;
	inline
		$205F, $4E90;

{ Now we have the inline codes that are called to enter the C-stack-based VNC server routines -hence the extra stack correction }
	procedure CallCProcOneRect (r: Rect; theProc: ProcPtr);
	inline
		$205F, $4E90, $584F; {  $584F = ADDQ.W #4,A7    - i.e. correct the stack by four bytes }
	procedure CallCProcGetKeys (theKeys: KeyMapPtr; theProc: ProcPtr);
	inline
		$205F, $4E90, $584F;
{ Note that C reverses the order of parameters on the stack... }
	procedure CallCProcPutScrap (src: Ptr; theType: ResType; length: LongInt; theProc: ProcPtr);
	inline
		$205F, $4E90, $584F, $584F, $584F;  { ok, ok - I couldn't be bothered to work out the code for ADDQ.W #8,A7 }
	procedure CallCProcCopyBits (mask: RgnHandle; mode: Integer; dstrct, srcrct: Rect; dst, src: Ptr; theProc: ProcPtr);
	inline
		$205F, $4E90, $584F, $584F, $584F, $584F, $584F;  {WARNING - Needs to add an extra 2 to A7 }
	procedure CallCProcScrollRect (updateRgn: RgnHandle; dv, dh: Integer; r: Rect; theProc: ProcPtr);
	inline
		$205F, $4E90, $584F, $584F, $584F;
{ Note that, since vncSystemTask is 'parameterless', and defined as Pascal, this does not need to correct the stack }
	procedure CallProcZeroParam (theProc: ProcPtr);
	inline
		$205F, $4E90;

{ This is a complete and utter hack to get some storage that we can pinpoint from any of the other routines... }
	function GetMyGlobals: GlobalsPtr;
	begin
{ This value will be changed by GlobalsHack - it will be replaced by the value of the Globals pointer }
		GetMyGlobals := GlobalsPtr($24683579);
	end;

	function GetMyTaskPtr: MyTMTaskPtr;
	inline
		$2E89;  { MOVE.L A1,(A7) }

	procedure MyTask;
		var
			taskPtr: MyTMTaskPtr;
			p: Point;
			theDelay: LongInt;
			patchGlobals: GlobalsPtr;
			myErr: OSErr;
	begin
		taskPtr := GetMyTaskPtr;
		with taskPtr^.info do
			begin
				patchGlobals := store;
				patchGlobals^.patches[kStatTMTask].callCount := patchGlobals^.patches[kStatTMTask].callCount + 1;
				theDelay := 300;
				if gotVNC then
					if patchOK then
						begin
							patchOK := false;
							p := LMGetMouseLocation;
							if moved then
								begin
									moved := false;
									if p.v = lastMouse.v then
										if p.h = lastMouse.h then
											begin
												p := lastOK;
												patchGlobals^.patches[kStatMovedMouse].callCount := patchGlobals^.patches[kStatMovedMouse].callCount + 1;
{ put the cursor back to its original location - that is, wherever it was before the last move }
												LMSetTempMouseLocation(p);
												LMSetRawMouseLocation(p);
												LMSetCrsrNew(LMGetCrsrCouple);
											end;
								end;
							lastMouse := p;
							lastOK := p;
							dirn := 0;
							cntr := 0;
							addon := 0;
						end
					else
						begin
							p := LMGetMouseLocation;
							if p.v <> lastMouse.v then
								begin
									lastMouse := p;
									lastOK := p;
									dirn := 0;
									moved := false;
									addon := -abs(addon);
								end
							else if p.h <> lastMouse.h then
								begin
									lastMouse := p;
									lastOK := p;
									dirn := 0;
									moved := false;
									addon := -abs(addon);
								end
							else if Ptr(MBState)^ <> -128 then
								if not patchGlobals^.inVNCST then
									begin
{ We want to check much sooner if something has happened to get out of this situation }
										theDelay := 30;
										cntr := cntr + 1;
{ Set back to one pixel movement on the first check, or if we're about to do real cursor movement (after 90 checks) }
										if (cntr = 1) or (cntr = 100) then
											addon := -1;
										addon := -addon;
										if dirn = 0 then
											dirn := 1;

										if dirn = 1 then
											begin
												if p.h > 10 then
													p.h := p.h - addon
												else
													dirn := 2;
											end;
										if dirn = 2 then
											begin
												if p.v > 10 then
													p.v := p.v - addon
												else
													dirn := 3;
											end;
										if dirn = 3 then
											begin
												p.h := p.h + addon;
												p.v := p.v + addon;
											end;

										if cntr < 100 then
											begin
{ just "twitch" the cursor }
{ Twitch by three pixels if we're still waiting after 30 checks (~1sec) }
												if cntr = 30 then
													addon := addon * 3;
												LMSetMouseLocation(p);
												LMSetTempMouseLocation(lastMouse);
												LMSetRawMouseLocation(lastMouse);
											end
										else
											begin
{ a bit more drastic after 100 checks - move the cursor to a new location }
{ Move by three pixels if we're still waiting after 200 checks (~6sec) }
												if cntr = 200 then
													addon := addon * 3;
												LMSetTempMouseLocation(p);
												LMSetRawMouseLocation(p);
												LMSetCrsrNew(LMGetCrsrCouple);
												lastMouse := p;
												moved := true;
												if cntr > 600 then
													begin
{ extremely drastic after more than 600 checks (~18sec) - put a mouse up in the event queue }
														myErr := PostEvent(mouseUp, 0);
													end
												else if cntr > 300 then
													begin
{ very drastic after more than 300 checks (~9sec) - reset the button state lowmem global }
														Ptr(MBState)^ := -128;
{    LMSetMouseButtonState(0);}
													end;
											end;

										patchGlobals^.patches[kStatMovedMouse].callCount := patchGlobals^.patches[kStatMovedMouse].callCount + 1;
									end;
						end;
			end;
		with taskPtr^.theTask do
			begin
{    tmAddr := @MyTask;}
				tmWakeUp := 0;
				tmReserved := 0;
			end;
		PrimeTime(QElemPtr(taskPtr), theDelay);
	end;

	procedure StartTMTask (var patchGlobals: GlobalsRec; theDelay: LongInt; execute: Boolean);
	begin
		with patchGlobals.myTask.theTask do
			begin
				qLink := nil;
				tmAddr := @MyTask;
				tmWakeUp := 0;
				tmReserved := 0;
			end;
		with patchGlobals.myTask.info do
			begin
				store := @patchGlobals;
				gotVNC := true;
				patchOK := false;
				moved := false;
				waitTime := theDelay;
				lastMouse := LMGetMouseLocation;
				lastOK := lastMouse;
				cntr := 0;
				dirn := 0;
				addon := 0;
			end;
		if execute then
			begin
				InsXTime(QElemPtr(@patchGlobals.myTask.theTask));
				PrimeTime(QElemPtr(@patchGlobals.myTask.theTask), theDelay);
			end;
	end;

	procedure HaltTMTask (var patchGlobals: GlobalsRec);
	begin
		with patchGlobals.myTask.info do
			begin
				gotVNC := false;
				patchOK := false;
			end;
		RmvTime(QElemPtr(@patchGlobals.myTask.theTask));
	end;


	function MySectRect (r1, r2: Rect; var sr: Rect): Boolean;
{ My own (guaranteed interrupt safe!) version of SectRect }
	begin
		if r1.left > r2.left then
			sr.left := r1.left
		else
			sr.left := r2.left;

		if r1.top > r2.top then
			sr.top := r1.top
		else
			sr.top := r2.top;

		if r1.right > r2.right then
			sr.right := r2.right
		else
			sr.right := r1.right;

		if r1.bottom > r2.bottom then
			sr.bottom := r2.bottom
		else
			sr.bottom := r1.bottom;

		MySectRect := true;

		if sr.right <= sr.left then
			begin
				sr.right := 0;
				sr.left := 0;
				MySectRect := false;
			end;

		if sr.bottom <= sr.top then
			begin
				sr.bottom := 0;
				sr.top := 0;
				MySectRect := false;
			end;
	end;

	procedure MyUnionRect (r1, r2: Rect; var ur: Rect);
{ My own (guaranteed interrupt safe!) version of UnionRect }
	begin
		if r1.left < r2.left then
			ur.left := r1.left
		else
			ur.left := r2.left;

		if r1.top < r2.top then
			ur.top := r1.top
		else
			ur.top := r2.top;

		if r1.right < r2.right then
			ur.right := r2.right
		else
			ur.right := r1.right;

		if r1.bottom < r2.bottom then
			ur.bottom := r2.bottom
		else
			ur.bottom := r1.bottom;
	end;

	procedure IncreaseCounter (number: Integer; var patchGlobals: GlobalsRec);
{ Increases the times_called counter array for the specified patch }
	begin
		patchGlobals.patches[number].callCount := patchGlobals.patches[number].callCount + 1;
	end;

	procedure IncreaseVNCCounter (number: Integer; var patchGlobals: GlobalsRec);
{ Increases the times_called counter array for the specified patch }
	begin
		patchGlobals.vncCalls[number].callCount := patchGlobals.vncCalls[number].callCount + 1;
	end;

	procedure IncreaseError (number: Integer; var patchGlobals: GlobalsRec);
{ Unnecessary error counter - really only for debugging purposes... }
	begin
		if (patchGlobals.errors[number] < 32000) and (patchGlobals.errors[number] >= 0) then
			begin
				patchGlobals.errors[number] := patchGlobals.errors[number] + 1;
			end
		else
			begin
				patchGlobals.errors[kErrBadErr] := patchGlobals.errors[kErrBadErr] + 1;
				patchGlobals.errors[number] := 1;
			end;
	end;

	function SetUpRoutineDescriptors (var patchGlobals: GlobalsRec): Boolean;
{ Make sure that the RoutineDescriptors are set as expected }
	begin
		SetUpRoutineDescriptors := true;

		with patchGlobals.gMisc do
			begin
				vncSystemTaskRD := RoutineDescriptorPtr(patchGlobals.vncCalls[kStatVNCSystemTask].entryPoint);

				if vncSystemTaskRD^.trap <> _MixedModeTrap then
					begin
{ Simply get out if it is not a RoutineDescriptor - probably means it is genuine 68k all the way... }
						Exit(SetUpRoutineDescriptors);
					end
				else if vncSystemTaskRD^.rr1.info = kPascalStackBased then
					begin
{ If it was pascal stack based then make sure it is pascal stack based... ummmm.... right, ok... }
						vncSystemTaskRD^.rr1.info := kPascalStackBased;
{    sysbeep(10);}
					end
				else
					begin
{ Bit odd that! - maybe we should really ignore it and just assume everything is OK - and watch a spectacular crash... }
						sysbeep(10);
						sysbeep(10);
						sysbeep(10);
						patchGlobals.vncCalls[kStatVNCInvalGlobalRect].entryPoint := nil;
						patchGlobals.vncCalls[kStatVNCSystemTask].entryPoint := nil;
						SetUpRoutineDescriptors := false;
						Exit(SetUpRoutineDescriptors);
					end;

				vncInvalGlobalRectRD := RoutineDescriptorPtr(patchGlobals.vncCalls[kStatVNCInvalGlobalRect].entryPoint);
				if vncInvalGlobalRectRD^.trap <> _MixedModeTrap then
					begin
{ Simply get out if it is not a RoutineDescriptor - probably means it is genuine 68k all the way... }
{ Mind you, what on earth does it mean if the vncSystemTask one *is* a RD and this isn't? }
						Exit(SetUpRoutineDescriptors);
					end
				else if BAnd(vncInvalGlobalRectRD^.rr1.info, kCStackBased) = kCStackBased then
					begin
{ If it was C stack based then keep it C stack based... ummmm again... }
						vncInvalGlobalRectRD^.rr1.info := kCStackBased + BSL(kFourByteParam, kParam1Shift);
{    sysbeep(10);}
					end
				else
					begin
{ Bit odd that! - well, I'm assuming something's up here and bailing out... }
						sysbeep(10);
						sysbeep(10);
						sysbeep(10);
						sysbeep(10);
						patchGlobals.vncCalls[kStatVNCInvalGlobalRect].entryPoint := nil;
						patchGlobals.vncCalls[kStatVNCSystemTask].entryPoint := nil;
						SetUpRoutineDescriptors := false;
						Exit(SetUpRoutineDescriptors);
					end;

			end;
	end;

	function WhenRect (r: Rect; updateGap: Integer): Integer;
		var
			w, h: Integer;
			sz: LongInt;
	begin
		w := r.right - r.left;
		if w < 8 then
			w := 8;
		h := r.bottom - r.top;
		if h < 8 then
			h := 8;
		sz := LongInt(w) * LongInt(h);
		sz := (((sz div 100) + 100) * updateGap) div 100;
		WhenRect := sz;
	end;

	procedure FindSectRect (r: Rect; rsz: LongInt; nosplit: Boolean; var patchGlobals: GlobalsRec);
{ takes a new rect and looks to see how it intersects the currently buffered rects }
		label
			5, 9;
	begin

{ We're going to use the FindSectRect globals record instead of local vars (for minimum stack impact) }
		with patchGlobals.gFSRR do
			begin

{ First time through we don't want it to split the new rect - just try and clip the sides off instead }
				pass1 := true;

{ very large initial union rect }
				mini := 1;
				minursz := 2000000000;
				minur.left := -10000;
				minur.top := -10000;
				minur.right := 12000;
				minur.bottom := 12000;

				if rsz = 0 then
					rsz := LongInt(r.right - r.left) * LongInt(r.bottom - r.top);

{ First rect starts off equal to the new rect to be added }
				xr1 := r;
				xr1sz := rsz;
{ No second rect yet, since we have not split the new rect }
				xr2sz := 0;

5:
				repeat

					clipped := false;
					nrcts := patchGlobals.patchRects^.num;

{ Perform a sanity check on the number of buffered rects - should not be necessary to do this... }
					if nrcts < 0 then
						begin
							nrcts := 0;
							patchGlobals.patchRects^.num := 0;
							IncreaseError(kErrNeg1FSR, patchGlobals);
						end
					else if nrcts > kMaxRcts then
						begin
							nrcts := kMaxRcts;
							patchGlobals.patchRects^.num := kMaxRcts;
							IncreaseError(kErrBig1FSR, patchGlobals);
						end;

					ii := 0;

					while (ii < nrcts) and (nrcts > 0) and (ii < kMaxRcts) do
						begin
{ Get the next buffered rect }
							ii := ii + 1;
							cr := patchGlobals.patchRects^.rcts[ii].r;
							crsz := patchGlobals.patchRects^.rcts[ii].sz;

{ See how big the union is... }
							MyUnionRect(r, cr, ur);
							ursz := LongInt(ur.right - ur.left) * LongInt(ur.bottom - ur.top);

{ START OF SANITY CHECKS ! }
{ Perform a sanity check on the buffered rect list position - should not be necessary to do this... }
							if (ii <= 0) or (ii > kMaxRcts) then
								begin
									ii := nrcts;
									IncreaseError(kErrBad1FSR, patchGlobals);
{ Perform a sanity check on the number of buffered rects - should not be necessary to do this... }
									if nrcts < 0 then
										begin
											nrcts := 0;
											IncreaseError(kErrNeg2FSR, patchGlobals);
											patchGlobals.patchRects^.num := 0;
											xr1 := r;
											xr1sz := rsz;
											xr2sz := 0;
											Exit(FindSectRect);
										end
									else if nrcts > kMaxRcts then
										begin
											ii := kMaxRcts;
											nrcts := kMaxRcts;
											patchGlobals.patchRects^.num := kMaxRcts;
											IncreaseError(kErrBig2FSR, patchGlobals);
											xr1 := r;
											xr1sz := rsz;
											xr2sz := 0;
											Exit(FindSectRect);
										end;
									goto 9;
								end;
{ END OF SANITY CHECKS ! }

{ Does the buffered rect intersect the new rect to be added? }
							if MySectRect(r, cr, sr) then
								begin
{ Work out the size of the intersect }
									srsz := LongInt(sr.right - sr.left) * LongInt(sr.bottom - sr.top);

									if srsz = rsz then
										begin
{ Well, we've found that the rect to be added is inside the buffered rect, so there's no point adding it }
											xr1sz := 0;
											xr2sz := 0;
											Exit(FindSectRect);
										end
									else if srsz = crsz then
										begin
{ OK, the buffered rect is inside the rect to be added... }
											if (ursz < crsz + 1000) then
												begin
{ But the union is not much bigger than the buffered rect, so just extend the buffered rect to cover it }
													patchGlobals.patchRects^.rcts[ii].r := ur;
													patchGlobals.patchRects^.rcts[ii].sz := ursz;
													patchGlobals.patchRects^.rcts[ii].when := WhenRect(ur, patchGlobals.maxSendGap);
													xr1sz := 0;
													xr2sz := 0;
													mini := ii;
													minur := ur;
													minursz := ursz;
													Exit(FindSectRect)
												end;
{ Perform a sanity check on the number of buffered rects - should not be necessary to do this... }
											if (nrcts > 0) and (nrcts <= kMaxRcts) then
												begin
{ Since the buffered rect is inside the rect to be added, we might as well get rid of the buffered rect }
													patchGlobals.patchRects^.rcts[ii] := patchGlobals.patchRects^.rcts[nrcts];
													nrcts := nrcts - 1;
													ii := ii - 1;
{ This does mean that a smaller buffered rect might not get sent for quite a while if the new rect is }
{ significantly larger, but never mind about that for now... }
												end
{ ! START OF SANITY CHECKS ! }
											else if nrcts < 0 then
												begin
{ hmmm....? }
													nrcts := 0;
													IncreaseError(kErrNeg3FSR, patchGlobals);
													patchGlobals.patchRects^.num := 0;
													xr1 := r;
													xr1sz := rsz;
													xr2sz := 0;
													Exit(FindSectRect);
												end
											else if nrcts > kMaxRcts then
												begin
{ hmmm again....? }
													nrcts := kMaxRcts;
													patchGlobals.patchRects^.num := kMaxRcts;
													IncreaseError(kErrBig3FSR, patchGlobals);
												end;
{ ! END OF SANITY CHECKS ! }
{ Make sure the number of rects is correctly updated, and get to the end of the 'while' loop }
											patchGlobals.patchRects^.num := nrcts;
											goto 9;
										end;

									if (ursz < minursz) then
										begin
{ This is the smallest union rect so far, and we might need to use it if the rect buffer list is full... }
											mini := ii;
											minursz := ursz;
											minur := ur;
{ There's a reason why this is done after the above checks - because we don't want to make a note of a }
{ smallest union rect earlier in case it gets replaced or removed - that could lead to a union rect replacing }
{ the wrong rect if the list becomes full }
										end;

									if ursz + srsz < rsz + crsz + 1000 then
										begin
{ In fact, the union of the buffered rect and the new rect is hardly any bigger than the two rects }
{ So we might as well join them into one! }
											patchGlobals.patchRects^.rcts[ii].r := ur;
											patchGlobals.patchRects^.rcts[ii].sz := ursz;
											patchGlobals.patchRects^.rcts[ii].when := WhenRect(ur, patchGlobals.maxSendGap);
											xr1sz := 0;
											xr2sz := 0;
											mini := ii;
											minur := ur;
											minursz := ursz;
											Exit(FindSectRect)
										end;

									if (sr.left = r.left) and (sr.right = r.right) then
										begin
											if r.top = sr.top then
												begin
{ The top of the new rect is contained within the buffered rect, so we can clip off the top of the new rect }
													r.top := sr.bottom;
													rsz := LongInt(r.right - r.left) * LongInt(r.bottom - r.top);
{ Since we've started clipping again, we don't want to allow splitting until we're sure there's no more clipping }
													pass1 := true;
													clipped := true;
													goto 9;
												end
											else if r.bottom = sr.bottom then
												begin
{ The bottom of the new rect is contained within the buffered rect, so we can clip off the bottom of the new rect }
													r.bottom := sr.top;
													rsz := LongInt(r.right - r.left) * LongInt(r.bottom - r.top);
{ Since we've started clipping again, we don't want to allow splitting until we're sure there's no more clipping }
													pass1 := true;
													clipped := true;
													goto 9;
												end
											else if not pass1 then
												begin
{ The new rect crosses right over the buffered rect, so take out middle intersect and return with the top and bottom }
													xr1 := r;
													xr2 := r;
													xr1.bottom := sr.top;
													xr2.top := sr.bottom;
													xr1sz := LongInt(xr1.right - xr1.left) * LongInt(xr1.bottom - xr1.top);
													xr2sz := LongInt(xr2.right - xr2.left) * LongInt(xr2.bottom - xr2.top);
													Exit(FindSectRect);
												end;
											rsz := LongInt(r.right - r.left) * LongInt(r.bottom - r.top);
										end
									else if (sr.top = r.top) and (sr.bottom = r.bottom) then
										begin
											if r.left = sr.left then
{ The left of the new rect is contained within the buffered rect, so we can clip off the left of the new rect }
												begin
													r.left := sr.right;
													rsz := LongInt(r.right - r.left) * LongInt(r.bottom - r.top);
{ Since we've started clipping again, we don't want to allow splitting until we're sure there's no more clipping }
													pass1 := true;
													clipped := true;
													goto 9;
												end
											else if r.right = sr.right then
												begin
{ The right of the new rect is contained within the buffered rect, so we can clip off the right of the new rect }
													r.right := sr.left;
													rsz := LongInt(r.right - r.left) * LongInt(r.bottom - r.top);
{ Since we've started clipping again, we don't want to allow splitting until we're sure there's no more clipping }
													pass1 := true;
													clipped := true;
													goto 9;
												end
											else if not pass1 then
												begin
{ Should not really get here as it is exactly the same as the last cross-over above... }
													xr1 := r;
													xr2 := r;
													xr1.left := sr.right;
													xr2.right := sr.left;
													xr1sz := LongInt(xr1.right - xr1.left) * LongInt(xr1.bottom - xr1.top);
													xr2sz := LongInt(xr2.right - xr2.left) * LongInt(xr2.bottom - xr2.top);
													Exit(FindSectRect);
												end;
										end
									else if (sr.left = cr.left) and (sr.right = cr.right) then
										begin
											if cr.top = sr.top then
												begin
{ The top of the buffered rect is entirely within the new rect, so we can clip the top of the buffered rect }
													cr.top := sr.bottom;
													crsz := LongInt(cr.right - cr.left) * LongInt(cr.bottom - cr.top);
													patchGlobals.patchRects^.rcts[ii].r := cr;
													patchGlobals.patchRects^.rcts[ii].sz := crsz;
													goto 9;
												end
											else if cr.bottom = sr.bottom then
												begin
{ The bottom of the buffered rect is entirely within the new rect, so we can clip the bottom of the buffered rect }
													cr.bottom := sr.top;
													crsz := LongInt(cr.right - cr.left) * LongInt(cr.bottom - cr.top);
													patchGlobals.patchRects^.rcts[ii].r := cr;
													patchGlobals.patchRects^.rcts[ii].sz := crsz;
													patchGlobals.patchRects^.rcts[ii].when := WhenRect(cr, patchGlobals.maxSendGap);
													goto 9;
												end;
										end
									else if (sr.top = cr.top) and (sr.bottom = cr.bottom) then
										begin
											if cr.left = sr.left then
												begin
{ The left of the buffered rect is entirely within the new rect, so we can clip the left of the buffered rect }
													cr.left := sr.right;
													crsz := LongInt(cr.right - cr.left) * LongInt(cr.bottom - cr.top);
													patchGlobals.patchRects^.rcts[ii].r := cr;
													patchGlobals.patchRects^.rcts[ii].sz := crsz;
													patchGlobals.patchRects^.rcts[ii].when := WhenRect(cr, patchGlobals.maxSendGap);
													goto 9;
												end
											else if cr.right = sr.right then
												begin
{ The right of the buffered rect is entirely within the new rect, so we can clip the right of the buffered rect }
													cr.right := sr.left;
													crsz := LongInt(cr.right - cr.left) * LongInt(cr.bottom - cr.top);
													patchGlobals.patchRects^.rcts[ii].r := cr;
													patchGlobals.patchRects^.rcts[ii].sz := crsz;
													patchGlobals.patchRects^.rcts[ii].when := WhenRect(cr, patchGlobals.maxSendGap);
													goto 9;
												end;
										end;

{ If we are still checking for sections to clip off (i.e. sides of new rect contained in buffered rects) }
{ or if the intersect size is too small to bother with, then we want to move on to the next buffered rect }
									if not pass1 and not clipped and (srsz > 1000) then
										begin
{ otherwise, we split up the new rect into two rects that don't intersect the buffered rect... }
											xr1 := r;
											xr2 := r;
											if r.top < cr.top then
												begin
													xr1.bottom := sr.top;
													xr2.top := sr.top;
													if r.left < cr.left then
														xr2.right := sr.left
													else
														xr2.left := sr.right;
												end
											else
												begin
													xr1.top := sr.bottom;
													xr2.bottom := sr.bottom;
													if r.right > cr.right then
														xr2.left := sr.right
													else
														xr2.right := sr.left;
												end;
{ ...and then work out the sizes and get out }
											xr1sz := LongInt(xr1.right - xr1.left) * LongInt(xr1.bottom - xr1.top);
											xr2sz := LongInt(xr2.right - xr2.left) * LongInt(xr2.bottom - xr2.top);
											Exit(FindSectRect);
										end;

9:
								end
							else if (ursz < minursz) then
								begin
{ This is the smallest union rect so far, and we might need to use it if the rect buffer list is full... }
									mini := ii;
									minursz := ursz;
									minur := ur;
								end;

						end;

{ We want to make sure we have covered every possible clip before allowing splitting of the new rect }
				until not clipped;

				if pass1 and not nosplit then
					begin
{ Go back and find a buffered rect that intersects - and this time allow it to split the new rect }
						pass1 := false;
						goto 5;
					end;

{ Return the single rect }
				xr1 := r;
				xr1sz := rsz;

			end;

	end;


	procedure AddARect (r: Rect; stagger: Integer; var patchGlobals: GlobalsRec);
		label
			5, 10, 15;
	begin

{ We're going to use the AddARect globals record instead of local vars (for minimum stack impact) }
		with patchGlobals.gAAR do
			begin

{ We will also be accessing stuff from FindSectRect using its globals record... }
				patchGlobals.gFSRR.xr1sz := 0;
				patchGlobals.gFSRR.xr2sz := 0;

				rrsz := 0;
5:
				patchGlobals.gFSRR.mini := 0;

{ Go off and find out how this new rect interacts with the buffered rects }
				FindSectRect(r, rrsz, false, patchGlobals);
				jj := patchGlobals.gFSRR.mini;
{ New rect was contained entirely in the buffered rects - nice! }
				if patchGlobals.gFSRR.xr1sz = 0 then
					Exit(AddARect);

				nrcts := patchGlobals.patchRects^.num;

{ ! START OF SANITY CHECKS ! }
{ Sanity check on the number of buffered rects - should not be necessary... }
				if nrcts < 0 then
					begin
						nrcts := 0;
						patchGlobals.patchRects^.num := 0;
						IncreaseError(kErrNeg1AAR, patchGlobals);
					end
				else if nrcts > kMaxRcts then
					begin
						nrcts := kMaxRcts;
						patchGlobals.patchRects^.num := kMaxRcts;
						IncreaseError(kErrBig1AAR, patchGlobals);
					end;
{ ! END OF SANITY CHECKS ! }

				if patchGlobals.gFSRR.xr2sz = 0 then
					begin
{ Returned from FindSectRect without splitting the new rect }
						r := patchGlobals.gFSRR.xr1;
						rrsz := patchGlobals.gFSRR.xr1sz;
{ Must check if we have filled up all the available space for buffered rects before adding another... }
						if (nrcts >= kMaxRcts) then
							begin
{ Sanity check on the position of the smallest union rect - should not be necessary... }
								if (jj > 0) and (jj <= nrcts) and (jj <= kMaxRcts) then
									begin
{ OK, just replace a buffered rect with the smallest union rect found by FindSectRect instead }
										patchGlobals.patchRects^.rcts[jj].r := patchGlobals.gFSRR.minur;
										patchGlobals.patchRects^.rcts[jj].sz := patchGlobals.gFSRR.minursz;
										patchGlobals.patchRects^.rcts[jj].when := WhenRect(patchGlobals.gFSRR.minur, patchGlobals.maxSendGap);
									end
{ ! START OF SANITY CHECKS ! }
								else
									IncreaseError(kErrBad1AAR, patchGlobals);
{ ! END OF SANITY CHECKS ! }
								Exit(AddARect);
							end;
						goto 15;
					end;

{    if (nrcts = kMaxRcts) then}
{ Make sure we have enough space to add two extra rects, if not just use the smallest union rect again }
				if (nrcts + 2 > kMaxRcts) then
					begin
						if (jj > 0) and (jj <= nrcts) and (jj <= kMaxRcts) then
							begin
								patchGlobals.patchRects^.rcts[jj].r := patchGlobals.gFSRR.minur;
								patchGlobals.patchRects^.rcts[jj].sz := patchGlobals.gFSRR.minursz;
								patchGlobals.patchRects^.rcts[jj].when := WhenRect(patchGlobals.gFSRR.minur, patchGlobals.maxSendGap);
							end
{ ! START OF SANITY CHECKS ! }
						else
							IncreaseError(kErrBad2AAR, patchGlobals);
{ ! END OF SANITY CHECKS ! }
						Exit(AddARect);
					end;

{ Set up the two rects to be added }
				r := patchGlobals.gFSRR.xr1;
				rrsz := patchGlobals.gFSRR.xr1sz;
				rr2 := patchGlobals.gFSRR.xr2;
				rr2sz := patchGlobals.gFSRR.xr2sz;

{ Add the first rect }
				nrcts := nrcts + 1;
				patchGlobals.patchRects^.rcts[nrcts].r := r;
				patchGlobals.patchRects^.rcts[nrcts].sz := rrsz;
				patchGlobals.patchRects^.rcts[nrcts].time := patchGlobals.gMisc.gNowTime + stagger;
				patchGlobals.patchRects^.rcts[nrcts].when := WhenRect(r, patchGlobals.maxSendGap);
{Set up the second ready to add after label 15 }
				r := rr2;
				rrsz := rr2sz;
				goto 15;

{ From here on is yet more splitting - but not yet activated }
10:
				FindSectRect(rr2, rr2sz, true, patchGlobals);
				xr3sz := patchGlobals.gFSRR.xr1sz;
				xr4sz := patchGlobals.gFSRR.xr2sz;
				minur2 := patchGlobals.gFSRR.minur;
				minur2sz := patchGlobals.gFSRR.minursz;
				jj2 := patchGlobals.gFSRR.mini;

				FindSectRect(r, rrsz, true, patchGlobals);
				jj := patchGlobals.gFSRR.mini;

				nrcts := patchGlobals.patchRects^.num;
				if patchGlobals.gFSRR.xr1sz + xr3sz = 0 then
					Exit(AddARect);

				if patchGlobals.gFSRR.xr1sz + patchGlobals.gFSRR.xr2sz + xr4sz = 0 then
					begin
						r := xr3;
						rrsz := xr3sz;
						goto 15;
					end;

				if patchGlobals.gFSRR.xr2sz + xr3sz + xr4sz = 0 then
					begin
						r := patchGlobals.gFSRR.xr1;
						rrsz := patchGlobals.gFSRR.xr1sz;
						goto 15;
					end;

				if nrcts + 1 = kMaxRcts then
					begin
						patchGlobals.gFSRR.xr2sz := 0;
						xr4sz := 0;
						xr3 := r;
						patchGlobals.gFSRR.xr1 := rr2;
					end;

				if patchGlobals.gFSRR.xr2sz + xr4sz = 0 then
					begin
						if nrcts + 1 >= kMaxRcts then
							if patchGlobals.gFSRR.minursz < minur2sz then
								begin
									patchGlobals.patchRects^.rcts[jj].r := patchGlobals.gFSRR.minur;
									patchGlobals.patchRects^.rcts[jj].sz := patchGlobals.gFSRR.minursz;
									patchGlobals.patchRects^.rcts[jj].when := WhenRect(patchGlobals.gFSRR.minur, patchGlobals.maxSendGap);
									r := xr3;
									rrsz := xr3sz;
									goto 15;
								end
							else
								begin
									patchGlobals.patchRects^.rcts[jj2].r := minur2;
									patchGlobals.patchRects^.rcts[jj2].sz := minur2sz;
									patchGlobals.patchRects^.rcts[jj2].when := WhenRect(minur2, patchGlobals.maxSendGap);
									r := patchGlobals.gFSRR.xr1;
									rrsz := patchGlobals.gFSRR.xr1sz;
									goto 15;
								end;
					end;

				if nrcts + 2 = kMaxRcts then
					begin
						if patchGlobals.gFSRR.xr2sz = 0 then
							begin
								r := patchGlobals.gFSRR.xr1;
								rrsz := patchGlobals.gFSRR.xr1sz;
							end
						else if xr4sz = 0 then
							begin
								r := xr3;
								rrsz := xr3sz;
							end;
						nrcts := nrcts + 1;
						patchGlobals.patchRects^.rcts[nrcts].r := r;
						patchGlobals.patchRects^.rcts[nrcts].sz := rrsz;
						patchGlobals.patchRects^.rcts[nrcts].time := patchGlobals.gMisc.gNowTime + stagger;
						patchGlobals.patchRects^.rcts[nrcts].when := WhenRect(r, patchGlobals.maxSendGap);
						r := rr2;
						rrsz := rr2sz;
						goto 15;
					end;

				nrcts := nrcts + 1;
				patchGlobals.patchRects^.rcts[nrcts].r := patchGlobals.gFSRR.xr1;
				patchGlobals.patchRects^.rcts[nrcts].sz := patchGlobals.gFSRR.xr1sz;
				patchGlobals.patchRects^.rcts[nrcts].time := patchGlobals.gMisc.gNowTime + stagger;
				patchGlobals.patchRects^.rcts[nrcts].when := WhenRect(patchGlobals.gFSRR.xr1, patchGlobals.maxSendGap);
				nrcts := nrcts + 1;
				patchGlobals.patchRects^.rcts[nrcts].r := xr3;
				patchGlobals.patchRects^.rcts[nrcts].sz := xr3sz;
				patchGlobals.patchRects^.rcts[nrcts].time := patchGlobals.gMisc.gNowTime + stagger;
				patchGlobals.patchRects^.rcts[nrcts].when := WhenRect(xr3, patchGlobals.maxSendGap);

				if patchGlobals.gFSRR.xr2sz = 0 then
					begin
						r := xr4;
						rrsz := xr4sz;
						goto 15;
					end
				else if xr4sz = 0 then
					begin
						r := patchGlobals.gFSRR.xr2;
						rrsz := patchGlobals.gFSRR.xr2sz;
						goto 15;
					end;

				if (nrcts + 2 >= kMaxRcts) then
					begin
						r := patchGlobals.gFSRR.xr2;
						rrsz := patchGlobals.gFSRR.xr2sz;
						rr2 := xr4;
						rr2sz := xr4sz;
						goto 10;
					end;

				if nrcts < 0 then
					begin
						sysbeep(10);
						nrcts := 0;
					end;
				nrcts := nrcts + 1;
				patchGlobals.patchRects^.rcts[nrcts].r := patchGlobals.gFSRR.xr2;
				patchGlobals.patchRects^.rcts[nrcts].sz := patchGlobals.gFSRR.xr2sz;
				patchGlobals.patchRects^.rcts[nrcts].time := patchGlobals.gMisc.gNowTime + stagger;
				patchGlobals.patchRects^.rcts[nrcts].when := WhenRect(patchGlobals.gFSRR.xr2, patchGlobals.maxSendGap);
				r := xr4;
				rrsz := xr4sz;

15:
{ ! START OF SANITY CHECKS ! }
{ Sanity check on the number of rects }
				if nrcts < 0 then
					begin
						IncreaseError(kErrNeg2AAR, patchGlobals);
						nrcts := 0;
					end
				else if nrcts > kMaxRcts then
					begin
						nrcts := kMaxRcts;
						patchGlobals.patchRects^.num := nrcts;
						IncreaseError(kErrBig2AAR, patchGlobals);
						Exit(AddARect);
					end;
{ ! END OF SANITY CHECKS ! }

{ Add the rect into the list, along with its time }
				nrcts := nrcts + 1;
				patchGlobals.patchRects^.rcts[nrcts].r := r;
				patchGlobals.patchRects^.rcts[nrcts].sz := rrsz;
				patchGlobals.patchRects^.rcts[nrcts].time := patchGlobals.gMisc.gNowTime + stagger;
				patchGlobals.patchRects^.rcts[nrcts].when := WhenRect(r, patchGlobals.maxSendGap);

				patchGlobals.patchRects^.num := nrcts;

			end;

	end;


	procedure AddCrsrRect (r: Rect; var patchGlobals: GlobalsRec);
	begin
{ ! START OF SANITY CHECKS ! }
{ Sanity check on number of rects }
		if patchGlobals.patchRects^.num < 0 then
			begin
				IncreaseError(kErrNegACR, patchGlobals);
				patchGlobals.patchRects^.num := 0;
			end
		else if patchGlobals.patchRects^.num > kMaxRcts + 1 then
			begin
				IncreaseError(kErrBigACR, patchGlobals);
				patchGlobals.patchRects^.num := kMaxRcts + 2;
				Exit(AddCrsrRect);
			end;
{ ! END OF SANITY CHECKS ! }

{ Add the cursor rect into the list }
		patchGlobals.patchRects^.num := patchGlobals.patchRects^.num + 1;
		patchGlobals.patchRects^.rcts[patchGlobals.patchRects^.num].r := r;
		patchGlobals.patchRects^.rcts[patchGlobals.patchRects^.num].sz := 1600;
		patchGlobals.patchRects^.rcts[patchGlobals.patchRects^.num].time := 0;
		patchGlobals.patchRects^.rcts[patchGlobals.patchRects^.num].when := 0;
	end;


	procedure InvalidateRect (var patchGlobals: GlobalsRec);
		var
			gap: Integer;
	begin

		patchGlobals.gMisc.gNowTime := LMGetTicks;
		gap := patchGlobals.maxSendGap div 2;

{ We're going to use the InvalidateRect globals record instead of local vars (for minimum stack impact) }
		with patchGlobals.gBR do
			begin

				h := patchGlobals.gMisc.gARect.bottom - patchGlobals.gMisc.gARect.top;
				w := patchGlobals.gMisc.gARect.right - patchGlobals.gMisc.gARect.left;
				a := LongInt(h) * LongInt(w);

				if kServerDoesSplitting then
					begin
{ The server does its own rect splitting, so add straight on to the list }
						AddARect(patchGlobals.gMisc.gARect, 0, patchGlobals);
					end
				else if a > 200000 then
					begin
						if h > w then
							begin
{ This is a very big rect that is higher than it is wide }
{ So we split it into eight rects: 2 across by 4 down }
								w := w div 2;
								h := h div 4;
								r1 := patchGlobals.gMisc.gARect;
								r1.right := patchGlobals.gMisc.gARect.left + w;
								r1.bottom := patchGlobals.gMisc.gARect.top + h;
								r2 := patchGlobals.gMisc.gARect;
								r2.left := r1.right;
								r2.bottom := r1.bottom;
								r3 := r1;
								r4 := r2;
								OffsetRect(r3, 0, h);
								OffsetRect(r4, 0, h);
								r5 := r3;
								r6 := r4;
								OffsetRect(r5, 0, h);
								OffsetRect(r6, 0, h);
								r7 := r5;
								r8 := r6;
								OffsetRect(r7, 0, h);
								OffsetRect(r8, 0, h);
								r7.bottom := patchGlobals.gMisc.gARect.bottom;
								r8.bottom := patchGlobals.gMisc.gARect.bottom;
							end
						else
							begin
{ This is a very big rect that is wider than it is higher }
{ So we split it into eight rects: 4 across by 2 down }
								w := w div 4;
								h := h div 2;
								r1 := patchGlobals.gMisc.gARect;
								r1.bottom := patchGlobals.gMisc.gARect.top + h;
								r1.right := patchGlobals.gMisc.gARect.left + w;
								r5 := patchGlobals.gMisc.gARect;
								r5.top := r1.bottom;
								r5.right := r1.right;
								r2 := r1;
								r6 := r5;
								OffsetRect(r2, w, 0);
								OffsetRect(r6, w, 0);
								r3 := r2;
								r7 := r6;
								OffsetRect(r3, w, 0);
								OffsetRect(r7, w, 0);
								r4 := r2;
								r8 := r7;
								OffsetRect(r4, w, 0);
								OffsetRect(r8, w, 0);
								r4.right := patchGlobals.gMisc.gARect.right;
								r8.right := patchGlobals.gMisc.gARect.right;
							end;
{ Now we've worked out the rects, we add them on to the rect buffer list and stagger their times }
						AddARect(r1, gap, patchGlobals);
						AddARect(r2, gap * 2, patchGlobals);
						AddARect(r3, gap * 3, patchGlobals);
						AddARect(r4, gap * 4, patchGlobals);
						AddARect(r5, gap * 5, patchGlobals);
						AddARect(r6, gap * 6, patchGlobals);
						AddARect(r7, gap * 7, patchGlobals);
						AddARect(r8, gap * 8, patchGlobals);
					end
				else if a > 80000 then
					begin
{ This will be split into four rects - 2 by 2 }
						w := w div 2;
						h := h div 2;
						r1 := patchGlobals.gMisc.gARect;
						r1.right := patchGlobals.gMisc.gARect.left + w;
						r1.bottom := patchGlobals.gMisc.gARect.top + h;
						r2 := patchGlobals.gMisc.gARect;
						r2.left := r1.right;
						r2.bottom := r1.bottom;
						r3 := r1;
						r4 := r2;
						OffsetRect(r3, 0, h);
						OffsetRect(r4, 0, h);
						r3.bottom := patchGlobals.gMisc.gARect.bottom;
						r4.bottom := patchGlobals.gMisc.gARect.bottom;
						AddARect(r1, gap, patchGlobals);
						AddARect(r2, gap * 2, patchGlobals);
						AddARect(r3, gap * 3, patchGlobals);
						AddARect(r4, gap * 4, patchGlobals);
					end
				else if a > 30000 then
					begin
						if h > w then
							begin
{ Split into two rects - one on top of the other }
								h := h div 2;
								r1 := patchGlobals.gMisc.gARect;
								r1.bottom := patchGlobals.gMisc.gARect.top + h;
								r2 := patchGlobals.gMisc.gARect;
								r2.top := r1.bottom;
							end
						else
							begin
{ Split into two rects - side by side }
								w := w div 2;
								r1 := patchGlobals.gMisc.gARect;
								r1.right := patchGlobals.gMisc.gARect.left + w;
								r2 := patchGlobals.gMisc.gARect;
								r2.left := r1.right;
							end;
						AddARect(r1, gap, patchGlobals);
						AddARect(r2, gap * 2, patchGlobals);
					end
				else
					begin
{ The rect is small enough to add straight on to the list }
						AddARect(patchGlobals.gMisc.gARect, 0, patchGlobals);
					end;
			end;

	end;


	procedure SetUpVNCA5 (var patchGlobals: GlobalsRec);
	begin
		if patchGlobals.vncA5World <> 0 then
			if patchGlobals.vncA5World <> -1 then
				with patchGlobals.gDRBR do
					begin
						gOldCA5 := LMGetCurrentA5;
						LMSetCurrentA5(Ptr(patchGlobals.vncA5World));
						gOldA5 := SetA5(patchGlobals.vncA5World);
					end;
	end;

	procedure RestoreOldA5 (var patchGlobals: GlobalsRec);
	begin
		if patchGlobals.vncA5World <> 0 then
			if patchGlobals.vncA5World <> -1 then
				begin
					patchGlobals.gDRBR.gVNCA5 := SetA5(patchGlobals.gDRBR.gOldA5);
					LMSetCurrentA5(patchGlobals.gDRBR.gOldCA5);
				end;
	end;

	procedure DoRectBuffering (var patchGlobals: GlobalsRec);
		var
			p, q: Point;
			i, diffTime: Integer;
			startTime, nowTime: LongInt;
		label
			10;
	begin

{    if pos('VNC Server', LMGetCurApName) > 1 then}
{    Exit(DoRectBuffering);}

		if (patchGlobals.vncA5World = 0) then
			Exit(DoRectBuffering);
		if (patchGlobals.vncCalls[kStatvncSystemTask].entryPoint = nil) then
			Exit(DoRectBuffering);
		if (patchGlobals.vncCalls[kStatvncInvalGlobalRect].entryPoint = nil) then
			Exit(DoRectBuffering);
		if not patchGlobals.gotProcs then
			Exit(DoRectBuffering);

{    if LMGetTicks < patchGlobals.lastVNCInvalRectTime + 2 then}
{    Exit(DoRectBuffering);}

		if patchGlobals.using then
			Exit(DoRectBuffering);

		patchGlobals.gMisc.gNowTime := LMGetTicks;

		if patchGlobals.gMisc.gNowTime < patchGlobals.lastVNCInvalRectTime + (patchGlobals.updateGapTicks div 2) then
			if (pos('VNC Server', LMGetCurApName) < 2) or (Ptr(MBState)^ <> -128) or kDoInFront then
				begin
					patchGlobals.using := true;
{    q := LMGetMouseLocation;}
{    p.v := -32000;}
{    p.h := -32000;}
					i := 0;
					while (i < 3) do
						begin
							i := i + 1;
{    p := q;}
							patchGlobals.inVNCST := true;
							HideCursor;
							SetUpVNCA5(patchGlobals);
							startTime := patchGlobals.gMisc.gNowTime;
							CallProcZeroParam(patchGlobals.vncCalls[kStatvncSystemTask].entryPoint);
							nowTime := LMGetTicks;
							RestoreOldA5(patchGlobals);
							ShowCursor;
							startTime := nowTime - startTime;
							diffTime := startTime;
							if diffTime <= patchGlobals.maxSendGap then
								begin
									if nowTime > patchGlobals.maxSendTime + 120 then
										if patchGlobals.maxSendGap > 1 then
											patchGlobals.maxSendGap := patchGlobals.maxSendGap - 1;
								end
							else if diffTime < patchGlobals.maxSendGap * 2 then
								begin
									patchGlobals.maxSendGap := diffTime;
									patchGlobals.maxSendTime := nowTime;
								end;
							if nowTime > patchGlobals.lastVNCInvalRectTime + patchGlobals.updateGapTicks - 2 then
								i := 30000;
							patchGlobals.inVNCST := false;
							patchglobals.myTask.info.patchOK := true;
{    q := LMGetMouseLocation;}
							patchGlobals.didVNCST := true;
						end;
					IncreaseVNCCounter(kStatvncSystemTask, patchGlobals);
					patchGlobals.using := false;
					Exit(DoRectBuffering);
				end
			else
				Exit(DoRectBuffering);

{    if patchGlobals.gMisc.gNowTime < patchGlobals.lastBufferTime + (patchGlobals.updateGapTicks div 2) then}
{    Exit(DoRectBuffering);}

		patchGlobals.lastBufferTime := patchGlobals.gMisc.gNowTime;

		if false then
			if Ptr(CrsrNew)^ <> 0 then
				begin
					HideCursor;
					PointPtr($830)^ := PointPtr($82C)^;
					Ptr(CrsrNew)^ := 0;
					ShowCursor;
				end;

		if kDoMostBasicTest then
			if (pos('VNC Server', LMGetCurApName) < 2) or (Ptr(MBState)^ <> -128) or kDoInFront then
				begin
					patchGlobals.using := true;
					patchGlobals.inVNCST := true;
					HideCursor;
					SetUpVNCA5(patchGlobals);
					CallProcZeroParam(patchGlobals.vncCalls[kStatvncSystemTask].entryPoint);
					RestoreOldA5(patchGlobals);
					ShowCursor;
					patchGlobals.inVNCST := false;
					patchGlobals.didVNCST := true;
					patchglobals.myTask.info.patchOK := true;
					patchGlobals.using := false;
					Exit(DoRectBuffering);
				end
			else
				Exit(DoRectBuffering);

		patchGlobals.using := true;

{ Oh dear - a rect has timed out, and we have not allowed the gap for the server to send updates to the client }
{ Prevent further sending of rects... }
		if patchGlobals.gMisc.gNowTime > patchGlobals.lastClearTime + patchGlobals.maxTimeoutTicks then
			begin
				patchGlobals.gMisc.gCanSend := false;
			end;

{ We're going to use the DoRectBuffering globals record instead of local vars (for minimum stack impact) }
		with patchGlobals.gDRBR do
			begin

{Start at the last buffered rect }
				jj := patchGlobals.patchRects^.num;

{ ! START OF SANITY CHECKS ! }
{ Sanity check - should not be necessary... }
				if jj < 0 then
					begin
						jj := 0;
						patchGlobals.patchRects^.num := 0;
						IncreaseError(kErrNeg1VST, patchGlobals);
					end
				else if jj > kMaxRcts then
					begin
						jj := kMaxRcts;
						patchGlobals.patchRects^.num := kMaxRcts;
						IncreaseError(kErrBig1VST, patchGlobals);
					end;
{ ! END OF SANITY CHECKS ! }

{ We want to get out immediately if we are waiting for the server to notice an update }
				if not patchGlobals.gMisc.gCanSend then
					begin
						docursor := false;
						goto 10;
					end;

				docursor := true;
				carryon := true;
				sofar := 0;

{ Go through the buffered rects looking for those that have gone past their send time (based on their size) }
{ If found, they are moved to the top of the list }
				ii := 1;
				while (ii <= jj) and (jj > 0) and (ii <= kMaxRcts) do
					begin
						tmpri := patchGlobals.patchRects^.rcts[ii];

{ Work out when this rect has to be sent by, according to its size }
						doTime := tmpri.time + tmpri.when;

						if (patchGlobals.gMisc.gNowTime > doTime) then
							begin
{ This rect has to be sent ASAP, so put it towards the end (we fill down the list from the end) }
								patchGlobals.patchRects^.rcts[ii] := patchGlobals.patchRects^.rcts[jj];
								patchGlobals.patchRects^.rcts[jj] := tmpri;
								jj := jj - 1;
{ We definitely want to have a send gap ASAP, so that the server actually starts sending updates to the client }
								patchGlobals.gMisc.gCanSend := false;
								sofar := sofar + tmpri.sz;
								if carryon then
									if (sofar > (400000 div (patchGlobals.maxSendGap + 2))) or (jj <= 0) then
										begin
{ Since we've got too much to send already then we don't want to send any rects other than those that have to be }
											carryon := false;
										end;
							end
						else
							begin
								ii := ii + 1;
							end;
					end;

{ Make a note of where we got to, for future reference }
				kk := jj;

{ If the rcts that have to be sent (i.e. timed out) did not cover too much area (<=20000 pixels) }
{ Then we go through and add on the rects in the order they have to go }
{ Note that the rects to go are filled in from the end of the list going down }
				if jj > 0 then
					while carryon do
						begin
							ii := 0;
{ This will ensure we find something! }
							earliest := patchGlobals.gMisc.gNowTime + 18000;
							earlyone := 1;
{ Find the next earliest rect to go }
							while (ii < jj) do
								begin
									ii := ii + 1;
									tmpri := patchGlobals.patchRects^.rcts[ii];
									doTime := tmpri.time + tmpri.when;
									if doTime < earliest then
										begin
											earliest := doTime;
											earlyone := ii;
										end;
								end;
							tmpri := patchGlobals.patchRects^.rcts[earlyone];
							patchGlobals.patchRects^.rcts[earlyone] := patchGlobals.patchRects^.rcts[jj];
							patchGlobals.patchRects^.rcts[jj] := tmpri;
							jj := jj - 1;
							sofar := sofar + tmpri.sz;
{ Have we got enough to send, or have we got all of the rects? }
							if (sofar > (600000 div (patchGlobals.maxSendGap + 2))) or (jj <= 0) then
								carryon := false;
						end;

				if kk > jj then
					begin
{ We have some rects that do not *have* to be sent - but we *will* hand them to the server and we need to make sure }
{ that the server will, at the right time, get a gap between updates (of 2 ticks) for it to actually send them to the client }
						tmpri := patchGlobals.patchRects^.rcts[kk];
						earliest := tmpri.time + tmpri.when;
						if patchGlobals.lastClearTime + patchGlobals.maxTimeoutTicks > earliest then
							patchGlobals.lastClearTime := earliest - patchGlobals.maxTimeoutTicks;
					end;

{ ! START OF SANITY CHECKS ! }
{ Some unnecessary sanity checking... }
				if patchGlobals.patchRects^.num < 0 then
					begin
						patchGlobals.patchRects^.num := 0;
						IncreaseError(kErrNeg2VST, patchGlobals);
					end
				else if patchGlobals.patchRects^.num > kMaxRcts then
					begin
						patchGlobals.patchRects^.num := kMaxRcts;
						IncreaseError(kErrBig2VST, patchGlobals);
					end;

				if jj < 0 then
					begin
						IncreaseError(kErrNeg3VST, patchGlobals);
						jj := 0;
					end
				else if jj > patchGlobals.patchRects^.num then
					begin
						jj := patchGlobals.patchRects^.num;
						IncreaseError(kErrBig3VST, patchGlobals);
					end;
{ ! END OF SANITY CHECKS ! }

				if kServerDoesCursor then
					docursor := false
				else if jj < patchGlobals.patchRects^.num then
					begin
{ We are actually sending some rects, so we should check if the cursor rects need to be included }
						docursor := false;
						patchGlobals.gMisc.gCurPt := LMGetMouseLocation;
						patchGlobals.gMisc.gLastPt := patchGlobals.lastCurPt;
{ But we only need to bother if the cursor has moved - will need to add case of it changing shape here too }
						if (patchGlobals.gMisc.gCurPt.h <> patchGlobals.gMisc.gLastPt.h) or (patchGlobals.gMisc.gCurPt.v <> patchGlobals.gMisc.gLastPt.v) then
							begin
{ There are two cursor rects to invalidate - the old position and the new position }
								lastcur.top := patchGlobals.gMisc.gLastPt.v - 20;
								lastcur.left := patchGlobals.gMisc.gLastPt.h - 20;
								lastcur.bottom := lastcur.top + 40;
								lastcur.right := lastcur.left + 40;
								newcur.top := patchGlobals.gMisc.gCurPt.v - 20;
								newcur.left := patchGlobals.gMisc.gCurPt.h - 20;
								newcur.bottom := newcur.top + 40;
								newcur.right := newcur.left + 40;
								if patchGlobals.gMisc.gNowTime > patchGlobals.lastCurTime + 5 then
									begin
{ Since it is 5 ticks since the last cursor update we add the rects anyway }
										docursor := true;
										goto 10;
									end;
{ Go through the rects to be sent, checking if any intersect the cursor rects }
								ii := jj;
								while ii < patchGlobals.patchRects^.num do
									begin
										ii := ii + 1;
										rr := patchGlobals.patchRects^.rcts[ii].r;
										if MySectRect(lastcur, rr, tmpr) then
											begin
												docursor := true;
												goto 10;
											end
										else if MySectRect(newcur, rr, tmpr) then
											begin
												docursor := true;
												goto 10;
											end;
									end;
							end;
					end
				else if docursor then
					begin
{ No rects are being sent, but we should update the cursor periodically anyway, if it has moved much }
						docursor := false;
						if patchGlobals.gMisc.gNowTime > patchGlobals.lastCurTime + 5 then
							begin
								patchGlobals.gMisc.gCurPt := LMGetMouseLocation;
								patchGlobals.gMisc.gLastPt := patchGlobals.lastCurPt;
								if (abs(patchGlobals.gMisc.gCurPt.h - patchGlobals.gMisc.gLastPt.h) > 2) or (abs(patchGlobals.gMisc.gCurPt.v - patchGlobals.gMisc.gLastPt.v) > 2) then
									begin
										docursor := true;
										lastcur.top := patchGlobals.gMisc.gLastPt.v - 20;
										lastcur.left := patchGlobals.gMisc.gLastPt.h - 20;
										lastcur.bottom := lastcur.top + 40;
										lastcur.right := lastcur.left + 40;
										newcur.top := patchGlobals.gMisc.gCurPt.v - 20;
										newcur.left := patchGlobals.gMisc.gCurPt.h - 20;
										newcur.bottom := newcur.top + 40;
										newcur.right := newcur.left + 40;
									end;
							end;
					end;

{ This is where to jump to if we want to skip all of the rect reordering and just start sending stuff }
10:

{ ! START OF SANITY CHECKS ! }
{ Yet more unnecessary sanity checking... }
				if patchGlobals.patchRects^.num < 0 then
					begin
						patchGlobals.patchRects^.num := 0;
						IncreaseError(kErrNeg4VST, patchGlobals);
					end
				else if patchGlobals.patchRects^.num > kMaxRcts then
					begin
						patchGlobals.patchRects^.num := kMaxRcts;
						IncreaseError(kErrBig4VST, patchGlobals);
					end;

				if jj < 0 then
					begin
						IncreaseError(kErrNeg5VST, patchGlobals);
						jj := 0;
					end
				else if jj > patchGlobals.patchRects^.num then
					begin
						jj := patchGlobals.patchRects^.num;
						IncreaseError(kErrBig5VST, patchGlobals);
					end;
{ ! END OF SANITY CHECKS ! }

{ docursor will be false if we are currently waiting for the server to start sending updates (gCanSend is false) }
{ or if there is no need to invalidate the cursor rects (has not moved, or was done very recently) }
				if docursor then
					begin
{ Add the two cursor rects - note that there should always be extra space available on the rect buffer list }
{ because we only fill it up to kMaxRcts, but it is actually of size kMaxRcts2 which should be at least 2 more }
						AddCrsrRect(lastcur, patchGlobals);
						AddCrsrRect(newcur, patchGlobals);
						patchGlobals.lastCurTime := patchGlobals.gMisc.gNowTime;
						patchGlobals.lastCurPt := patchGlobals.gMisc.gCurPt;
					end;

{ At this point jj is the position of the last rect that will *stay* in the buffer }
{ i.e. rects 1 to jj will stay, and jj+1 to nrcts are the rects that must be sent }

{ ! START OF SANITY CHECKS ! }
				if (jj > kMaxRcts) and (patchGlobals.patchRects^.num > kMaxRcts) then
					begin
						jj := kMaxRcts;
						patchGlobals.patchRects^.num := kMaxRcts;
						IncreaseError(kErrInPatch, patchGlobals);
					end
				else if jj < 0 then
					begin
						jj := 0;
						IncreaseError(kErrInPatch, patchGlobals);
					end;
{ ! END OF SANITY CHECKS ! }

				if (jj < patchGlobals.patchRects^.num) then
					begin
						SetUpVNCA5(patchGlobals);
						ii := jj;
						while ii < patchGlobals.patchRects^.num do
							begin
								ii := ii + 1;
								CallCProcOneRect(patchGlobals.patchRects^.rcts[ii].r, patchGlobals.vncCalls[kStatvncInvalGlobalRect].entryPoint);
							end;
						patchGlobals.lastVNCInvalRectTime := LMGetTicks;
						patchGlobals.patchRects^.num := jj;

						IncreaseVNCCounter(kStatvncInvalGlobalRect, patchGlobals);

						if (pos('VNC Server', LMGetCurApName) < 2) or (Ptr(MBState)^ <> -128) or kDoInFront then
							begin
								patchGlobals.inVNCST := true;
								HideCursor;
								startTime := patchGlobals.gMisc.gNowTime;
								CallProcZeroParam(patchGlobals.vncCalls[kStatvncSystemTask].entryPoint);
								nowTime := LMGetTicks;
								ShowCursor;
								startTime := nowTime - startTime;
								diffTime := startTime;
								if diffTime <= patchGlobals.maxSendGap then
									begin
										if nowTime > patchGlobals.maxSendTime + 120 then
											if patchGlobals.maxSendGap > 1 then
												patchGlobals.maxSendGap := patchGlobals.maxSendGap - 1;
									end
								else if diffTime < patchGlobals.maxSendGap * 2 then
									begin
										patchGlobals.maxSendGap := diffTime;
										patchGlobals.maxSendTime := nowTime;
									end;
								patchGlobals.inVNCST := false;
								patchGlobals.didVNCST := true;
								patchglobals.myTask.info.patchOK := true;
								IncreaseVNCCounter(kStatvncSystemTask, patchGlobals);
							end;
						RestoreOldA5(patchGlobals);
						patchGlobals.lastBufferTime := nowTime;

					end
				else if (pos('VNC Server', LMGetCurApName) < 2) or (Ptr(MBState)^ <> -128) or kDoInFront then
					begin
						patchGlobals.inVNCST := true;
						HideCursor;
						SetUpVNCA5(patchGlobals);
						startTime := patchGlobals.gMisc.gNowTime;
						CallProcZeroParam(patchGlobals.vncCalls[kStatvncSystemTask].entryPoint);
						nowTime := LMGetTicks;
						RestoreOldA5(patchGlobals);
						ShowCursor;
						startTime := nowTime - startTime;
						diffTime := startTime;
						if diffTime <= patchGlobals.maxSendGap then
							begin
								if nowTime > patchGlobals.maxSendTime + 120 then
									if patchGlobals.maxSendGap > 1 then
										patchGlobals.maxSendGap := patchGlobals.maxSendGap - 1;
							end
						else if diffTime < patchGlobals.maxSendGap * 2 then
							begin
								patchGlobals.maxSendGap := diffTime;
								patchGlobals.maxSendTime := nowTime;
							end;
						patchGlobals.inVNCST := false;
						patchGlobals.didVNCST := true;

						patchglobals.myTask.info.patchOK := true;
						patchGlobals.lastBufferTime := nowTime;

						IncreaseVNCCounter(kStatvncSystemTask, patchGlobals);

{ If there has been a gap of more than 10 ticks (for alpha 4/5) since we last sent rects to the server, then the server }
{ will have started sending them to the client - this is the lastClearTime }
						if (patchGlobals.gMisc.gNowTime > patchGlobals.lastVNCInvalRectTime + patchGlobals.updateGapTicks) then
							begin
								patchGlobals.lastClearTime := nowTime;
								patchGlobals.gMisc.gCanSend := true;
							end;
					end;

			end;

		patchGlobals.using := false;

	end;


	procedure CheckVNCKeys (var patchglobals: GlobalsRec; theKeys: KeyMapPtr);
		var
			vncKeys: KeyMap;
			i: Integer;
	begin
{    if pos('VNC Server', LMGetCurApName) > 1 then}
{    Exit(CheckVNCKeys);}

		if kNoMungeKeys then
			Exit(CheckVNCKeys);

		if kNoMungeLMKeys then
			if LongInt(theKeys) = KeyMapLM then
				Exit(CheckVNCKeys);

		with patchGlobals do
			begin
				if gotProcs then
					if vncA5World <> 0 then
						if vncCalls[kStatvncGetKeys].entryPoint <> nil then
							if not using then
								if didVNCST then
									if LMGetTicks > lastKeyTime + 1 then
										begin
											using := true;
											didVNCST := false;
											vncKeys := nullKeys;
{ Get the keys from the server }
											SetUpVNCA5(patchGlobals);
											CallCProcGetKeys(@vncKeys, vncCalls[kStatvncGetKeys].entryPoint);
											RestoreOldA5(patchGlobals);
											if not kServerDoesKeys then
												if not vncKeys[55] then
													if vncKeys[58] and vncKeys[59] then
														begin
															if not kServerDoesCtrlOpt then
																begin
																	vncKeys[55] := true;
																	vncKeys[58] := false;
																	vncKeys[59] := false;
																end;
														end
													else if vncKeys[56] and not kNoMungeShiftKey then
														begin
															if vncKeys[58] or vncKeys[59] then
																begin
																	vncKeys[55] := true;
																	vncKeys[56] := false;
																	vncKeys[58] := false;
																	vncKeys[59] := false;
																end;
														end;

{ We should be able to munge this much quicker now that there is no mapping, just by using a BOr command }
{ Will sort this out later... }
											if kServerDoesKeys then
												begin
													for i := 0 to 127 do
														begin
															if vncKeys[i] then
																begin
																	theKeys^[i] := true;
																end
															else if lastKeys[i] then
																begin
																	theKeys^[i] := false;
																end;
														end;
												end
											else
												for i := 0 to 127 do
													begin
														if vncKeys[i] then
															begin
																theKeys^[i] := true;
															end
														else if lastKeys[i] then
															begin
																theKeys^[i] := false;
															end;
													end;

											lastKeys := vncKeys;
											lastKeyTime := LMGetTicks;
											using := false;
										end;
			end;
	end;


	procedure Patched_GetKeys (theKeysPtr: KeyMapPtr);
		var
			patchGlobals: GlobalsPtr;
			vncKeys: KeyMap;
			i: Integer;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		IncreaseCounter(kStatGetKeys, patchGlobals^);
		if (patchGlobals^.patches[kStatGetKeys].savedTrap <> nil) then
			CallProcOnePtr(Ptr(theKeysPtr), patchGlobals^.patches[kStatGetKeys].savedTrap);
		patchGlobals^.using := oldusing;

		with patchGlobals^ do
{ First check that we have passed all the tests, and the server has started up }
			if gotProcs then
{ We have to check that the server has not disabled things (i.e. it's quitting) before we go ahead... }
				if (vncA5World <> 0) then
					begin

{ Now do all the usual stuff with the rect buffering and sending... }
						DoRectBuffering(patchGlobals^);

{    if kCallVNCRoutines then}
						if (vncCalls[kStatvncGetKeys].entryPoint <> nil) then
							begin
								lastKeyTime := 0;
								CheckVNCKeys(patchGlobals^, theKeysPtr);
{ Make sure that the LowMem version is set correctly, too... }
								if not kNoSyncLMKeys then
									KeyMapPtr(KeyMapLM)^ := theKeysPtr^;
							end;

					end;

	end;


	procedure Patched_CopyBits (src, dst: Ptr; srcrct, dstrct: Rect; mode: Integer; mask: RgnHandle);
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		IncreaseCounter(kStatCopyBits, patchGlobals^);
		if (patchGlobals^.patches[kStatCopyBits].savedTrap <> nil) then
			CallProcCopyBits(src, dst, srcrct, dstrct, mode, mask, patchGlobals^.patches[kStatCopyBits].savedTrap);
		patchGlobals^.using := oldusing;

		if (patchGlobals^.vncA5World <> 0) then
			if patchGlobals^.gotProcs then
				begin

					if kCallVNCRoutines then
						if (patchGlobals^.vncCalls[kStatvncCopyBits].entryPoint <> nil) then
							begin
{ Send the CopyBits to the server }
								SetUpVNCA5(patchGlobals^);
								CallCProcCopyBits(mask, mode, dstrct, srcrct, dst, src, patchGlobals^.vncCalls[kStatvncCopyBits].entryPoint);
								RestoreOldA5(patchGlobals^);
							end;

{ Now do all the usual stuff with the rect buffering and sending... }
					DoRectBuffering(patchGlobals^);
				end;

	end;


	procedure Patched_ScrollRect (r: Rect; dh, dv: Integer; updateRgn: RgnHandle);
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		IncreaseCounter(kStatScrollrect, patchGlobals^);
		if (patchGlobals^.patches[kStatScrollRect].savedTrap <> nil) then
			CallProcScrollRect(r, dh, dv, updateRgn, patchGlobals^.patches[kStatScrollRect].savedTrap);
		patchGlobals^.using := oldusing;

		if (patchGlobals^.vncA5World <> 0) then
			if patchGlobals^.gotProcs then
				begin

					if kCallVNCRoutines then
						if (patchGlobals^.vncCalls[kStatVNCScrollRect].entryPoint <> nil) then
							begin
{ Send the scroll to the server }
								SetUpVNCA5(patchGlobals^);
								CallCProcScrollRect(updateRgn, dv, dh, r, patchGlobals^.vncCalls[kStatVNCScrollRect].entryPoint);
								RestoreOldA5(patchGlobals^);
							end;

{ Now do all the usual stuff with the rect buffering and sending... }
					DoRectBuffering(patchGlobals^);
				end;

	end;


	function Patched_PutScrap (length: LongInt; theType: ResType; src: Ptr): LongInt;
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		patchGlobals^.gMisc.gALongRet := 0;
		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		IncreaseCounter(kStatPutScrap, patchGlobals^);
		if (patchGlobals^.patches[kStatPutScrap].savedTrap <> nil) then
			patchGlobals^.gMisc.gALongRet := CallFuncPutScrap(length, thetype, src, patchGlobals^.patches[kStatPutScrap].savedTrap);
		patchGlobals^.using := oldusing;

		if (patchGlobals^.vncA5World <> 0) then
			if patchGlobals^.gotProcs then
				begin

					if kCallVNCRoutines then
						if patchGlobals^.vncCalls[kStatVNCPutScrap].entryPoint <> nil then
							begin
								SetUpVNCA5(patchGlobals^);
								CallCProcPutScrap(src, theType, length, patchGlobals^.vncCalls[kStatVNCPutScrap].entryPoint);
								RestoreOldA5(patchGlobals^);
								IncreaseVNCCounter(kStatVNCPutScrap, patchGlobals^);
							end;

{ Now do all the usual stuff with the rect buffering and sending... }
					DoRectBuffering(patchGlobals^);
				end;

		Patched_PutScrap := patchGlobals^.gMisc.gALongRet;
	end;


	procedure Patched_GetMouse (var p: Point);
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatGetMouse, patchGlobals^);

{ Now do all the usual stuff with the rect buffering and sending... }
		DoRectBuffering(patchGlobals^);
		CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));

		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		if (patchGlobals^.patches[kStatGetMouse].savedTrap <> nil) then
			CallProcGetMouse(p, patchGlobals^.patches[kStatGetMouse].savedTrap);
		patchGlobals^.using := oldusing;
	end;


	function Patched_Button: Integer;
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		patchGlobals^.gMisc.gAnIntRet := 0;
		IncreaseCounter(kStatButton, patchGlobals^);

{ Now do all the usual stuff with the rect buffering and sending... }
		DoRectBuffering(patchGlobals^);
		CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));

		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		if (patchGlobals^.patches[kStatButton].savedTrap <> nil) then
			patchGlobals^.gMisc.gAnIntRet := CallFuncZeroParam(patchGlobals^.patches[kStatButton].savedTrap);
		patchGlobals^.using := oldusing;
		Patched_Button := patchGlobals^.gMisc.gAnIntRet;
	end;


	function Patched_StillDown: Integer;
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		patchGlobals^.gMisc.gAnIntRet := 0;
		IncreaseCounter(kStatStillDown, patchGlobals^);

{ Now do all the usual stuff with the rect buffering and sending... }
		DoRectBuffering(patchGlobals^);
		CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));

		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		if (patchGlobals^.patches[kStatStillDown].savedTrap <> nil) then
			patchGlobals^.gMisc.gAnIntRet := CallFuncZeroParam(patchGlobals^.patches[kStatStillDown].savedTrap);
		patchGlobals^.using := oldusing;
		Patched_StillDown := patchGlobals^.gMisc.gAnIntRet;
	end;


	function Patched_WaitMouseUp: Integer;
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		patchGlobals^.gMisc.gAnIntRet := 0;
		IncreaseCounter(kStatWaitMouseUp, patchGlobals^);

{ Now do all the usual stuff with the rect buffering and sending... }
		DoRectBuffering(patchGlobals^);
		CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));

		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		if (patchGlobals^.patches[kStatWaitMouseUp].savedTrap <> nil) then
			patchGlobals^.gMisc.gAnIntRet := CallFuncZeroParam(patchGlobals^.patches[kStatWaitMouseUp].savedTrap);
		patchGlobals^.using := oldusing;
		Patched_WaitMouseUp := patchGlobals^.gMisc.gAnIntRet;
	end;


	function Patched_WNE (mask: Integer; var event: EventRecord; sleep: LongInt; msRgn: RgnHandle): Boolean;
		var
			oldusing: Boolean;
			patchGlobals: GlobalsPtr;
	begin
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatWNE, patchGlobals^);

{ Now do all the usual stuff with the rect buffering and sending... }
		DoRectBuffering(patchGlobals^);
		CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));

		if pos('VNC Server', LMGetCurApName) > 1 then
			patchGlobals^.inVNC := false;
		if (patchGlobals^.patches[kStatWNE].savedTrap <> nil) then
			Patched_WNE := CallFuncWNE(mask, event, sleep, msRgn, patchGlobals^.patches[kStatWNE].savedTrap);
		if pos('VNC Server', LMGetCurApName) > 1 then
			patchGlobals^.inVNC := true;
	end;

	procedure Patched_SystemTask;
		var
			oldusing: Boolean;
			patchGlobals: GlobalsPtr;
	begin
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatSystemTask, patchGlobals^);

{ Only do anything if the Gestalt has been called }
		if patchGlobals^.gotGestalt then
			if not patchGlobals^.gotProcs then
				begin
{    sysbeep(10);}
					if patchGlobals^.vncCalls[kStatVNCSystemTask].entrypoint <> nil then
						if patchGlobals^.vncCalls[kStatVNCInvalGlobalRect].entrypoint <> nil then
							with patchGlobals^ do
								begin
									if vncA5World = 0 then
										begin
{    sysbeep(10);}
											vncA5World := -1;
										end;
									if SetUpRoutineDescriptors(patchGlobals^) then
										begin
{ Yes - we managed to figure out that there were valid RoutineDescriptors, or that it is pure 68k }
											lastCurTime := 0;
											lastCurPt.v := 15000;
											lastCurPt.h := 15000;
											lastVNCInvalRectTime := LMGetTicks;
											lastClearTime := LMGetTicks;
											lastBufferTime := LMGetTicks;
											lastKeyTime := 0;
											lastMsEvtTime := 0;
											patchRects^.num := 0;
											gMisc.gCanSend := false;
											inVNCST := false;
											inVNC := true;
											if updateGapTicks = 0 then
												begin
													updateGapTicks := kUpdateGapTicks;
												end;
											maxTimeoutTicks := updateGapTicks * 30;
											if updateGapTicks = kSlowUpdateGapTicks then
												maxSendGap := 3
											else if updateGapTicks = kFastUpdateGapTicks then
												maxSendGap := 1
											else
												maxSendGap := 10;
											maxSendTime := LMGetTicks;
											gotProcs := true;
{ Put the last flag in place that says we have everything! }
											if not kNoTMTask then
												StartTMTask(patchGlobals^, 300, true);
{    sysbeep(10);}
										end
									else
										begin
{ Failed to figure out the RoutineDescriptors  - just give up }
											gotGestalt := false;
											vncA5World := 0;
{    sysbeep(10);}
{    sysbeep(10);}
										end;
								end;
				end
			else if (patchGlobals^.vncA5World = 0) or (patchGlobals^.vncCalls[kStatVNCSystemTask].entrypoint = nil) or (patchGlobals^.vncCalls[kStatVNCInvalGlobalRect].entrypoint = nil) then
				begin
{ But we did have final confirmation, so that means the server has been and come and gone... }
{    sysbeep(10);}
					if not kNoTMTask then
						HaltTMTask(patchGlobals^);
					patchGlobals^.gotGestalt := false;
					patchGlobals^.gotProcs := false;
					patchGlobals^.vncA5World := 0;
{    patchGlobals^.updateGapTicks := 0;}
{    sysbeep(10);}
				end
			else
				begin
					DoRectBuffering(patchGlobals^);
					CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));
				end;

		oldusing := patchGlobals^.using;
{    patchGlobals^.using := true;}
		if (patchGlobals^.patches[kStatSystemTask].savedTrap <> nil) then
			CallProcZeroParam(patchGlobals^.patches[kStatSystemTask].savedTrap);
{    patchGlobals^.using := oldusing;}
	end;


	procedure Patched_JShieldCursor (a, b, c, d: Integer);
		var
			patchGlobals: GlobalsPtr;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;

		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		IncreaseCounter(kStatJShieldCursor, patchGlobals^);
		if (patchGlobals^.patches[kStatJShieldCursor].savedTrap <> nil) then
			CallProcFourInt(a, b, c, d, patchGlobals^.patches[kStatJShieldCursor].savedTrap);

		patchGlobals^.using := true;

		with patchGlobals^.gMisc do
			if (patchGlobals^.vncA5World <> 0) then
				if patchGlobals^.gotProcs then
					begin

{ Invalidate this rect }
						gARect.top := b;
						gARect.left := a;
						gARect.bottom := d;
						gARect.right := c;

						if kDoMostBasicTest then
							begin
								if patchGlobals^.vncCalls[kStatVNCInvalGlobalRect].entryPoint <> nil then
									begin
										SetUpVNCA5(patchGlobals^);
										CallCProcOneRect(gARect, patchGlobals^.vncCalls[kStatvncInvalGlobalRect].entryPoint);
										RestoreOldA5(patchGlobals^);
									end;
							end
						else
							InvalidateRect(patchGlobals^);

{ This is in case we want to prevent buffering/sending from within JShieldCursor}
						if kCallFromJShieldCursor then
							if not oldusing then
								begin
{ Note that DoRectBuffering returns immediately if using is true - so make sure it isn't }
									patchGlobals^.using := false;
{ Now do all the usual stuff with the rect buffering and sending... }
									DoRectBuffering(patchGlobals^);
									CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));
								end;

{    patchGlobals^.lastShieldTime := gNowTime;}
					end;

		patchGlobals^.using := oldusing;
	end;

{ Assembly to get and restore the D0 register }
	function GetD0_L: LongInt;
	inline
		$2E80;  {  MOVE.L D0,(A7)   note: *not* MOVE.L D0,-(A7)  -  space is made on the stack for the function result before being called }
	procedure SetD0_L (theD0: LongInt);
	inline
		$201F;  {  MOVE.L (A7)+,D0  }
{ Assembly to get and restore the A0 register }
	function GetA0_L: LongInt;
	inline
		$2E88;  {  MOVE.L A0,(A7)   note: *not* MOVE.L A0,-(A7)  -  space is made on the stack for the function result before being called }
	procedure SetA0_L (theA0: LongInt);
	inline
		$205F;  {  MOVE.L (A7)+,A0  }
{ This procedure is usually used in conjunction with GetA0_L to pop a 4-byte value off the top of the stack }
	procedure PopA0_L;
	inline
		$205F;   {  MOVE.L (A7)+,A0 }

{ This will *jump* to the specified address - it does the UNLK A6 beforehand (which balances the LINK A6,#NNNN put }
{ in by the Think Pascal compiler at the beginning of a routine), but the rest of the stack must have been sorted out }
{ by the user before calling this, otherwise there will  be trouble... }
	procedure JumpProc (theProc: ProcPtr);
	inline
		$205F, $4E5E, $4ED0;   {  MOVEA.L (A7)+,A0  /  UNLK A6  /  JMP(A0)  }

	function Patched_WaitMouseMoved (pt: Point): Integer;
		var
			patchGlobals: GlobalsPtr;
			oldD0: LongInt;
	begin
		oldD0 := GetD0_L;
		patchGlobals := GetMyGlobals;
		SetD0_L(oldD0);
		Patched_WaitMouseMoved := CallFuncOnePoint(pt, patchGlobals^.patches[kStatDragDispatch].savedTrap);
		sysbeep(10);
		SetD0_L(oldD0);
	end;

	function DoDragDispatch: ProcPtr;
		var
			patchGlobals: GlobalsPtr;
			oldD0: LongInt;
	begin
{ First thing we do is make sure we have the original D0 register }
		oldD0 := GetD0_L;
		DoDragDispatch := nil;
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatDragDispatch, patchGlobals^);

{ Now do all the usual stuff with the rect buffering and sending... }
		DoRectBuffering(patchGlobals^);
		CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));

{ Well, if saveDrawPicture is nil we'll have some pretty bad things happening anyway since the stack will be messed up... }
		if (oldD0 = $23) and not kNoWaitMouseMovedPatch then
			DoDragDispatch := @Patched_WaitMouseMoved
		else
			DoDragDispatch := patchGlobals^.patches[kStatDragDispatch].savedTrap;
{ Put back the original D0 register }
		SetD0_L(oldD0);
	end;

{ NOTE: this procedure does as little as possible - if it does anything else the compiler will start saving registers on}
{ the stack - this would cause a bad crash when a drag is started! If there's anything else to do during a drag, it }
{ should be done in DoDragDispatch *NOT HERE* }
	procedure Patched_DragDispatch;
{ Note that if we did something like:   theProc := DoDragDispatch;    followed by  JumpProc(theProc); the compiler }
{ probably would use a register for theProc, which it would then have to save and restore from the stack -ouch! }
	begin
{ All we do is jump straight to the original trap address which is returned by function DoDragDispatch... }
		JumpProc(DoDragDispatch);
	end;


	procedure CallProcD0A0 (d0, a0: LongInt; p: ProcPtr);
	inline
		$225F, $205F, $201F, $4E91;  {  MOVE.L (A7)+,A1  /  MOVE.L (A7)+,A0  /  MOVE.L (A7)+,D0  /  JSR (A1)   }

	procedure Patched_PostEvent;
{ This routine is obsolete - since PostEvent seems to go through PPostEvent the event is caught and changed there... }
		var
			patchGlobals: GlobalsPtr;
			saveD0, saveA0: LongInt;
			ps: QHdrPtr;
			pp: EvQElPtr;
	begin
		saveD0 := GetD0_L;
		saveA0 := GetA0_L;
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatPostEvent, patchGlobals^);
		CallProcD0A0(saveD0, saveA0, patchGlobals^.patches[kStatPostEvent].savedTrap);
		saveD0 := GetD0_L;
		saveA0 := GetA0_L;
{ Look for the last entry in the queue, then fiddle with it if it's a mouse event... }
		if (saveD0 = 0) then
			begin
				ps := GetEvQHdr;
			end;
		SetA0_L(saveA0);
		SetD0_L(saveD0);
	end;

	procedure Patched_PPostEvent;
		var
			pp: EvQElPtr;
			patchGlobals: GlobalsPtr;
			saveD0, saveA0, whenTime: LongInt;
	begin
		saveD0 := GetD0_L;
		saveA0 := GetA0_L;
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatPPostEvent, patchGlobals^);
		CallProcD0A0(saveD0, saveA0, patchGlobals^.patches[kStatPPostEvent].savedTrap);
		saveD0 := GetD0_L;
		saveA0 := GetA0_L;
{ Fiddle here with the event entry (pointed to by A0) if it's a mouse event... }
		if patchGlobals^.vncA5World <> 0 then
			if patchGlobals^.gotProcs then
				if patchGlobals^.inVNCST then
					if (saveD0 = 0) and (saveA0 <> 0) then
						begin
							pp := EvQElPtr(saveA0);
							if (pp^.evtQwhat = mouseDown) or (pp^.evtQwhat = mouseUp) then
								begin
									IncreaseCounter(kStatGotMsEvt, patchGlobals^);
									whenTime := pp^.evtQwhen;
									if whenTime < patchGlobals^.lastMsEvtTime + 7 then
										begin
											IncreaseCounter(kStatIncreasedMsEvtTime, patchGlobals^);
											pp^.evtQwhen := patchGlobals^.lastMsEvtTime + 7;
										end
									else if whenTime > patchGlobals^.lastMsEvtTime + 90 then
										begin
											pp^.evtQwhen := whenTime - 3;
											if pp^.evtQwhat = mouseDown then
												Handle(MBTicks)^ := Ptr(pp^.evtQwhen);
										end
									else if whenTime > patchGlobals^.lastMsEvtTime + 20 then
										begin
											IncreaseCounter(kStatDecreasedMsEvtTime, patchGlobals^);
											pp^.evtQwhen := patchGlobals^.lastMsEvtTime + 15;
											if pp^.evtQwhat = mouseDown then
												Handle(MBTicks)^ := Ptr(pp^.evtQwhen);
										end;
									patchGlobals^.lastMsEvtTime := pp^.evtQwhen;
								end;
						end;
		SetA0_L(saveA0);
		SetD0_L(saveD0);
	end;


	function DoTickCount: ProcPtr;
		var
			patchGlobals: GlobalsPtr;
	begin
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatTickCount, patchGlobals^);

{ Now do all the usual stuff with the rect buffering and sending... }
		DoRectBuffering(patchGlobals^);
		CheckVNCKeys(patchGlobals^, KeyMapPtr(KeyMapLM));

		DoTickCount := patchGlobals^.patches[kStatTickCount].savedTrap;
	end;

	procedure Patched_TickCount_old;
	begin
		JumpProc(DoTickCount);
	end;

	function Patched_TickCount: LongInt;
	begin
		Patched_TickCount := LMGetTicks;
	end;


	procedure Patched_CursorDeviceButtons (m: Ptr; b: Integer);
		var
			patchGlobals: GlobalsPtr;
			myErr: OSErr;
			oldD0: LongInt;
	begin
		oldD0 := GetD0_L;
		patchGlobals := GetMyGlobals;
		if Ptr(MBState)^ <> -128 then
			begin
				if b = 0 then
					begin
						IncreaseCounter(kStatMouseUp, patchGlobals^);
						myErr := PostEvent(mouseUp, 0);
						Ptr(MBState)^ := -128;
					end;
			end
		else if b <> 0 then
			begin
				IncreaseCounter(kStatMouseDown, patchGlobals^);
				myErr := PostEvent(mouseDown, 0);
				Ptr(MBState)^ := 0;
				Handle(MBTicks)^ := Ptr(LMGetTicks);
			end;
		SetD0_L(oldD0);
	end;

	function DoCursorDevice: ProcPtr;
		var
			patchGlobals: GlobalsPtr;
			oldD0: LongInt;
	begin
		oldD0 := GetD0_L;
		DoCursorDevice := nil;
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatCursorDevice, patchGlobals^);

{ Well, if savePaintRect is nil we'll have some pretty bad things happening anyway since the stack will be messed up... }
		DoCursorDevice := patchGlobals^.patches[kStatCursorDevice].savedTrap;

		if oldD0 = 3 then
			if patchGlobals^.vncA5World <> 0 then
				if patchGlobals^.gotProcs then
					if patchGlobals^.inVNCST then
						begin
							DoCursorDevice := @Patched_CursorDeviceButtons
						end;

{ Put back the original D0 register }
		SetD0_L(oldD0);
	end;

	procedure Patched_CursorDevice;
	begin
		JumpProc(DoCursorDevice);
	end;


	procedure Patched_SetCursor (curs: CursPtr);
		var
			patchGlobals: GlobalsPtr;
			i: Integer;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatSetCursor, patchGlobals^);
		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		if patchGlobals^.patches[kStatSetCursor].savedTrap <> nil then
			CallProcOnePtr(Ptr(curs), patchGlobals^.patches[kStatSetCursor].savedTrap);

{    if patchGlobals^.patches[kStatSetCursor].callCount < 2 then}
{    if patchGlobals^.patches[kStatSetCCursor].callCount < 2 then}
		if curs <> nil then
			with patchGlobals^.theCursor do
				begin
					crsrType := $8000;
					crsrMap := nil;
					crsrData := nil;
					crsrXData := nil;
					crsrXValid := 0;
					crsrXHandle := nil;
					crsrXTable := 0;
					crsrID := 0;
					crsrHotSpot := curs^.hotspot;
					crsrMask := curs^.mask;
					crsr1Data := curs^.data;
{    for i := 1 to 16 do}
{    crsrMask[i] := curs^.mask[i];}
{    for i := 1 to 16 do}
{    crsr1Data[i] := curs^.data[i];}
				end;
		patchGlobals^.using := oldusing;
	end;


	procedure Patched_SetCCursor (curs: CCrsrHandle);
		var
			patchGlobals: GlobalsPtr;
			i: Integer;
			oldusing: Boolean;
	begin
		patchGlobals := GetMyGlobals;
		IncreaseCounter(kStatSetCCursor, patchGlobals^);
		oldusing := patchGlobals^.using;
		patchGlobals^.using := true;
		if patchGlobals^.patches[kStatSetCCursor].savedTrap <> nil then
			CallProcOnePtr(Ptr(curs), patchGlobals^.patches[kStatSetCCursor].savedTrap);

{    if patchGlobals^.patches[kStatSetCursor].callCount < 2 then}
{    if patchGlobals^.patches[kStatSetCCursor].callCount < 2 then}
		if curs <> nil then
			if curs^ <> nil then
				with patchGlobals^.theCursor do
					begin
						crsrType := curs^^.crsrType;
						crsrMap := curs^^.crsrMap;
						crsrData := curs^^.crsrData;
						crsrXData := curs^^.crsrXData;
						crsrXValid := curs^^.crsrXValid;
						crsrXHandle := curs^^.crsrXHandle;
						crsrXTable := curs^^.crsrXTable;
						crsrID := curs^^.crsrID;
						crsrHotSpot := curs^^.crsrHotspot;
						crsrMask := curs^^.crsrMask;
						crsr1Data := curs^^.crsr1Data;
{    for i := 1 to 16 do}
{    crsrMask[i] := curs^^.crsrMask[i];}
{    for i := 1 to 16 do}
{    crsr1Data[i] := curs^^.crsr1Data[i];}
					end;
		patchGlobals^.using := oldusing;
	end;


	function VersionGestalt (gestaltSelector: OSType; var gestaltResponse: LongInt): OSErr;
	begin
		gestaltResponse := kVncExtensionVersion;
		VersionGestalt := noErr;
	end;

	function GlobalsGestalt (gestaltSelector: OSType; var gestaltResponse: LongInt): OSErr;
		var
			patchGlobals: GlobalsPtr;
	begin
		patchGlobals := GetMyGlobals;
		gestaltResponse := LongInt(patchGlobals);
		GlobalsGestalt := noErr;
		patchGlobals^.gotGestalt := true;
	end;


	function ApplyTrapPatch (trap: Integer; patchPtr: ProcPtr): ProcPtr;
		var
			trapPtr: LongInt;
			tType: TrapType;
	begin
		ApplyTrapPatch := nil;
		if (patchPtr <> nil) and (trap <> 0) then
			begin
				if BAnd(trap, $800) = $800 then
					tType := ToolTrap
				else
					tType := OSTrap;
				trapPtr := NGetTrapAddress(trap, tType);
				if trapPtr = NGetTrapAddress(_Unimplemented, ToolTrap) then
					trapPtr := 0
				else
					NSetTrapAddress(LongInt(patchPtr), trap, tType);
				ApplyTrapPatch := ProcPtr(trapPtr);
			end;
	end;

	procedure MyApplyTrapPatch (trap: Integer; var patchGlobals: GlobalsRec; which: Integer; patchPtr: ProcPtr);
	begin
		patchGlobals.patches[which].savedTrap := ApplyTrapPatch(trap, patchPtr);
	end;

	function AddGestalts: Boolean;
		var
			myErr: OSErr;
	begin
		AddGestalts := false;
		myErr := NewGestalt(gestaltVncExtensionVersion, @VersionGestalt);
		if myErr = noErr then
			myErr := NewGestalt(gestaltVncGlobals, @GlobalsGestalt);
		if myErr = noErr then
			AddGestalts := true;
	end;


	function GlobalsHack: GlobalsPtr;
		var
			store: Ptr;
			i: Handle;
			j: Integer;
	begin
{ This routine is only called once from Main to actually allocate a non-relocatable block of memory. }
		store := nil;
		store := NewPtrSys(sizeof(GlobalsRec));

		if store <> nil then
			begin
{ Start at the beginning of routine MyGetGlobals... }
				j := 0;
				i := Handle(@GetMyGlobals);
				while (j < 50) do
					begin
{ ...and search for the occurrance of this (hopefully unique!) value }
						if i^ = Ptr($24683579) then
							begin
								j := 1000;
{ Here we have the hack - the value of the globals ptr is written directly into the }
{ appropriate location in routine MyGetGlobals }
								i^ := store;
							end
						else
							begin
{ Did not find it, so move on a couple of bytes - not sure about alignment here, but at least }
{ we will definitely find it by moving only 2 bytes instead of 4! }
								i := Handle(ord4(i) + 2);
							end;
						j := j + 2;
					end;

				if j > 999 then
					begin
{ We found it, so now make sure that the main memory contains the same as the cache }
{ This is probably not important for any processors except 68040 which has this problem sometimes... }
						FlushInstructionCache;
						FlushDataCache;
					end
				else
					begin
{ Ok, didn't find it... odd!  Never mind - just fail... }
						DisposePtr(store);
						store := nil;
					end;
			end;

		GlobalsHack := GlobalsPtr(store);
	end;


	procedure SetUpKeyMapping (patchGlobals: GlobalsPtr);
		var
			i: Integer;
	begin
		with patchGlobals^ do
			begin
				mapper[0] := 7;
				mapper[1] := 6;
				mapper[2] := 5;
				mapper[3] := 4;
				mapper[4] := 3;
				mapper[5] := 2;
				mapper[6] := 1;
				mapper[7] := 0;
				mapper[8] := 15;
				mapper[9] := 14;
				mapper[10] := 13;
				mapper[11] := 12;
				mapper[12] := 11;
				mapper[13] := 10;
				mapper[14] := 9;
				mapper[15] := 8;
				mapper[16] := 23;
				mapper[17] := 22;
				mapper[18] := 21;
				mapper[19] := 20;
				mapper[20] := 19;
				mapper[21] := 18;
				mapper[22] := 17;
				mapper[23] := 16;
				mapper[24] := 31;
				mapper[25] := 30;
				mapper[26] := 29;
				mapper[27] := 28;
				mapper[28] := 27;
				mapper[29] := 26;
				mapper[30] := 25;
				mapper[31] := 24;
				mapper[32] := 39;
				mapper[33] := 38;
				mapper[34] := 37;
				mapper[35] := 36;
				mapper[36] := 35;
				mapper[37] := 34;
				mapper[38] := 33;
				mapper[39] := 32;
				mapper[40] := 47;
				mapper[41] := 46;
				mapper[42] := 45;
				mapper[43] := 44;
				mapper[44] := 43;
				mapper[45] := 42;
				mapper[46] := 41;
				mapper[47] := 40;
				mapper[48] := 55;
				mapper[49] := 54;
				mapper[50] := 53;
				mapper[51] := 52;
				mapper[52] := 51;
				mapper[53] := 50;
				mapper[54] := 49;
				mapper[55] := 48;
				mapper[56] := 63;
				mapper[57] := 62;
				mapper[58] := 61;
				mapper[59] := 60;
				mapper[60] := 59;
				mapper[61] := 58;
				mapper[62] := 57;
				mapper[63] := 56;

				for i := 64 to 127 do
					mapper[i] := -1;

				mapper[65] := 123;
				mapper[69] := 124;
				mapper[74] := 126;
				mapper[79] := 125;

				for i := 1 to 127 do
					begin
						mapper[i] := i;
					end;

			end
	end;


	procedure Main;
{ Allocates storage, registers the Gestalts, does the globals hack, and patches the traps }
		var
			store: GlobalsPtr;
			success: Boolean;
			response: LongInt;
			myErr: OSErr;
			k: Integer;
			hackpos: Handle;
	begin
		success := true;

		if (success) then
			begin
{ Must have at least System 7 to run this }
				myErr := Gestalt(gestaltSystemVersion, response);
				if (myErr <> noErr) or (response < $700) then
					success := false;
			end;

		if (success) then
			begin
{ Check that the VNC version Gestalt does not already exist }
				myErr := Gestalt(gestaltVncExtensionVersion, response);
				if (myErr = noErr) then
					success := false;
			end;

		if success then
			begin
{ OK, let's get the dirty business out of the way... }
				store := nil;
				store := GlobalsHack;
				if (store = nil) then
					success := false;
			end;

		if success then
			begin
{ allocate storage for the rect buffer list }
				store^.patchRects := nil;
				store^.patchRects := RectListPtr(NewPtrSys(sizeof(RectList)));
				if store^.patchRects = nil then
					success := false;
			end;

{ Add the Gestalts - as if this bit of code wasn't obvious! }
		if (success) then
			success := AddGestalts;

		if (success) then
			begin
				myErr := Gestalt('cput', response);
				if myErr = noErr then
					begin
						if (response <= 4) and (response >= 0) then
							begin
								store^.updateGapTicks := kSlowUpdateGapTicks;
							end
						else
							begin
								store^.updateGapTicks := kFastUpdateGapTicks;
							end;
					end
				else
					begin
						store^.updateGapTicks := kMaxUpdateGapTicks;
					end;
				for k := 1 to PATCHED_CALLS_MAX do
					begin
						store^.patches[k].savedTrap := nil;
						store^.patches[k].callCount := 0;
					end;
				MyApplyTrapPatch(_GetKeys, store^, kStatGetKeys, @Patched_GetKeys);
				MyApplyTrapPatch(_SystemTask, store^, kStatSystemTask, @Patched_SystemTask);
				MyApplyTrapPatch(_CopyBits, store^, kStatCopyBits, @Patched_CopyBits);
				MyApplyTrapPatch(_ScrollRect, store^, kStatScrollRect, @Patched_ScrollRect);
				MyApplyTrapPatch(_PutScrap, store^, kStatPutScrap, @Patched_PutScrap);
				MyApplyTrapPatch(_GetMouse, store^, kStatGetMouse, @Patched_GetMouse);
				if not kNoButtonPatch then
					MyApplyTrapPatch(_Button, store^, kStatButton, @Patched_Button);
				MyApplyTrapPatch(_StillDown, store^, kStatStillDown, @Patched_StillDown);
				MyApplyTrapPatch(_WaitMouseUp, store^, kStatWaitMouseUp, @Patched_WaitMouseUp);
				if not kNoDragPatch then
					MyApplyTrapPatch(_DragDispatch, store^, kStatDragDispatch, @Patched_DragDispatch);
				if not kNoPostEventPatch then
					MyApplyTrapPatch(_PostEvent, store^, kStatPostEvent, @Patched_PostEvent);
				if not kNoPPostEventPatch then
					MyApplyTrapPatch(_PPostEvent, store^, kStatPPostEvent, @Patched_PPostEvent);
{ This is the magic one that does all the *real* work... }
				store^.patches[kStatJShieldCursor].savedTrap := LMGetJShieldCursor;
				LMSetJShieldCursor(@Patched_JShieldCursor);
				if not kNoTickCountPatch then
					MyApplyTrapPatch(_TickCount, store^, kStatTickCount, @Patched_TickCount);
				if not kNoCursorDevicePatch then
					MyApplyTrapPatch(_CursorDeviceDispatch, store^, kStatCursorDevice, @Patched_CursorDevice);
				if not kNoWNEPatch then
					MyApplyTrapPatch(_WaitNextEvent, store^, kStatWNE, @Patched_WNE);

				if kNoSetCursorPatch then
					begin
						with store^.theCursor do
							begin
								crsrType := $8000;
								crsrMap := nil;
								crsrData := nil;
								crsrXData := nil;
								crsrXValid := 0;
								crsrXHandle := nil;
								crsrXTable := 0;
								crsrID := 0;
{    crsrHotSpot := curs^.hotspot;}
{    crsrMask := curs^.mask;}
{    crsr1Data := curs^.data;}
{    for i := 1 to 16 do}
{    crsrMask[i] := curs^.mask[i];}
{    for i := 1 to 16 do}
{    crsr1Data[i] := curs^.data[i];}
							end;
					end
				else
					begin
						MyApplyTrapPatch(_SetCursor, store^, kStatSetCursor, @Patched_SetCursor);
						MyApplyTrapPatch(_SetCCursor, store^, kStatSetCCursor, @Patched_SetCCursor);
					end;

				with store^ do
					begin
{ Set up stuff for the VNC Server side of things }
						vncA5World := 0;
						for k := 1 to VNC_CALLS_MAX do
							begin
								vncCalls[k].entryPoint := nil;
								vncCalls[k].callCount := 0;
							end;
{    updateGapTicks := 0;}
{ Don't know what homefile is for, but it's not actually used in any code I can find... }
						homeFile.vRefNum := 0;
						homeFile.parID := 0;
						homeFile.name := '';
{ initialise the re-entry flags }
						inshield := false;
						using := false;
						inVNC := true;
{ initialise the flags that let the patches know when the server has started }
						gotGestalt := false;
						gotProcs := false;
{ initialise the unnecessary error counters }
						for k := 1 to kMaxErr do
							errors[k] := 0;
						for k := 0 to 127 do
							nullKeys[k] := false;
						didVNCST := true;
						inVNCST := false;
					end;
			end;

{Check that the hack worked }
		if success then
			begin
				if GetMyGlobals <> store then
					success := false;
			end;

{ Just so we can tell if we failed... }
		if (not success) then
			begin
				sysbeep(10);
				sysbeep(10);
			end
		else
			SetUpKeyMapping(store);

	end;

end.