#include <math.h>
#include <stdint.h>
#include "mac_sound.h"


#ifndef M_PI
#define M_PI 3.1415926536
#endif

struct mac_sound_ctx g_sound;


pascal void MyDoubleBackProc(SndChannelPtr ch, SndDoubleBufferPtr db);
pascal void MyDoubleBackProc(SndChannelPtr ch, SndDoubleBufferPtr db) {
	mac_demo_music_play((void *)db->dbSoundData, MAC_SOUND_BUFFER_STEREO_S16_FRAMES);
	/* mark as ready to be played */
	db->dbNumFrames = MAC_SOUND_BUFFER_STEREO_S16_FRAMES;
	db->dbFlags |= dbBufferReady;
	/* if no more samples / we are done signal this was last buffer to be filled */
	/* db->dbFlags |= dbLastBuffer; */
}

void mac_sound_init(void) {
	NumVersion v = SndSoundManagerVersion();
	int v31_ok = v.majorRev > 3 || (v.majorRev == 3 && v.minorAndBugRev >= 1);
	OSErr err;
	long gestalt;
	
	if (!v31_ok) {
		printf("SoundManager %d.%d\n", v.majorRev, v.minorAndBugRev);
		printf("need SoundManager >= 3.1\n");
		exit(1);
	}
	
	err = Gestalt(gestaltSoundAttr, &gestalt);
	if (err != noErr) {
		printf("Gestalt failed\n");
		exit(1);
	}

	{
		int stereo = gestalt & (1<<gestaltStereoCapability);
		int stereo_mix = gestalt & (1<<gestaltStereoMixing);
		int audio16 = gestalt & (1<<gestalt16BitSoundIO);
#ifdef MAC_SOUND_DEBUG
		printf("stereo: %d mix: %d 16bit: %d\n", stereo > 0, stereo_mix > 0, audio16 > 0);
#endif
	}

	{
		err = SndNewChannel(&g_sound.ch, sampledSynth, initStereo, NULL);
		if (err != noErr) {
			printf("SndNewChannel failed\n");
			exit(1);
		}
		
		g_sound.h.dbhNumChannels = 2;
		g_sound.h.dbhSampleSize = 16;
		g_sound.h.dbhCompressionID = 0;
		g_sound.h.dbhPacketSize = 0;
		g_sound.h.dbhSampleRate = MAC_SOUND_SAMPLE_RATE << 16;
		g_sound.h.dbhDoubleBack = NewSndDoubleBackProc(&MyDoubleBackProc); 
	}	
	{
		int i;
		for (i = 0; i < 2; i++) {
			SndDoubleBufferPtr db = (SndDoubleBufferPtr)NewPtrClear(sizeof (SndDoubleBuffer) + MAC_SOUND_BUFFER_SIZE);
			if (!db) {
				printf("failed create SoundDoubleBuffer\n");
				exit(1);
			}
			db->dbNumFrames = 0;
			db->dbFlags = 0;
			db->dbUserInfo[0] = 0;
			db->dbUserInfo[1] = 0;
			g_sound.h.dbhBufferPtr[i] = db;
		}
	}

	MyDoubleBackProc(g_sound.ch, g_sound.h.dbhBufferPtr[0]);
	MyDoubleBackProc(g_sound.ch, g_sound.h.dbhBufferPtr[1]);
	
	err = SndPlayDoubleBuffer(g_sound.ch, &g_sound.h);
	if (err != noErr) {
		printf("SndPlayDoubleBuffer failed\n");
		exit(1);
	}
}

void mac_sound_cleanup(void) {
	int i;
	int flush_and_quiet = true;
	SndDisposeChannel(g_sound.ch, flush_and_quiet);
	DisposeRoutineDescriptor(g_sound.h.dbhDoubleBack);
	for (i = 0; i < 2; ++i) {
		DisposePtr((Ptr)g_sound.h.dbhBufferPtr[i]);
	}
}
