@ECHO OFF
REM Drag and Drop unpack/decode .mar/.mac files
REM Version 0.1 for Windows
REM Author(s): fogWraith
REM URL: http://macintoshgarden.org
IF "%~1"=="" ECHO Drag and drop your .mar or .mac files onto this batch file.&PAUSE&EXIT
SETLOCAL ENABLEDELAYEDEXPANSION
SET "params=!cmdcmdline:~0,-1!"
SET "params=!params:*" =!"
SET count=0

FOR %%G IN (!params!) DO (
  SET /A count+=1
  SET "name_!count!=%%~nG"
  SET "ext_!count!=%%~xG"
  SET "fullfile_!count!=%%~G"
)

FOR /L %%n IN (1,1,!count!) DO (
  IF "!ext_%%n!" == ".mar" (
    ECHO Unpacking "!name_%%n!!ext_%%n!"
    %~dp0mar.exe -xvf "!fullfile_%%n!"
  ) ELSE (
      IF "!ext_%%n!" == ".mac" (
        ECHO Decoding "!name_%%n!!ext_%%n!"
        %~dp0mar.exe -xdf "!fullfile_%%n!"
      ) ELSE (
          ECHO File not supported.
          ECHO This tool will only accept files with the .mac and .mar extension.
        )
      )
    )
  )
)
PAUSE
EXIT