
/*
 * The aedStaticRTF class
 * This widget draws a simple RTF document on screen
 * Initial design by Sam Lantinga <slouken@libsdl.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef AEDSTATICRTF_H
#define AEDSTATICRTF_H

#include "dllmacros.h"
#include "aedWidget.h"

typedef struct _RTF_Context RTF_Context;

class DLLEXPORT aedStaticRTF:public aedWidget
{
  public:
    aedStaticRTF();
    virtual ~ aedStaticRTF();
    bool setDocument(char *text, int textlen);
    int getDocumentHeight(int width);
    void setDocumentOffset(float offset);       // 0.0 - 1.0
    virtual void render(void);

  private:
      RTF_Context * m_doc;
    float m_docOffset;

};

#if defined(_MSC_VER)
DLLEXTERN template DLLEXPORT aedFunctor1Arg < stub, aedStaticRTF >;
#endif

#endif
