/*
 * XimpleMOD --- module player for Mac OS X
 * preferences.c
 *
 * 2005 by Marco Trillo <toad@arsystel.com>
 *
 * This program is free software; under Public Domain. You can use it as you want.
 * You can redistribute and modify it, even with commercial intentions.
 *
 * This software is provided "as is", WITHOUT ANY WARRANTY,
 * either expressed or implied, including but not limited to the implied
 * warranties of merchantability and/or fitness for a particular purpose.
 * The author shall NOT be held liable for ANY damage to you, your
 * computer, or to anyone or anything else, that may result from its use,
 * or misuse. Basically, you use it at YOUR OWN RISK.
 */

struct pref_struct {
	DWORD surround;
	DWORD ramping;
	DWORD interpolation;
	DWORD amplification;
	DWORD pansep;
	Boolean eForceStop;
};

struct pref_struct xm_preferences_readgui() {
	struct pref_struct soundopts;
	
	soundopts.interpolation=GetControl32BitValue(xm_ocontrol_pointer(20));
	soundopts.ramping=GetControl32BitValue(xm_ocontrol_pointer(18));
	soundopts.surround=GetControl32BitValue(xm_ocontrol_pointer(19));
	soundopts.amplification=GetControl32BitValue(xm_ocontrol_pointer(889));
	soundopts.pansep=GetControl32BitValue(xm_ocontrol_pointer(890));
	soundopts.eForceStop=MultiParts;

	return soundopts;
}

void xm_preferences_writegui(struct pref_struct *soundopts) {
	char digdisplay[4];
	
	SetControl32BitValue(xm_ocontrol_pointer(20),soundopts->interpolation);
	DrawOneControl(xm_ocontrol_pointer(20));
	SetControl32BitValue(xm_ocontrol_pointer(18),soundopts->ramping);
	DrawOneControl(xm_ocontrol_pointer(18));
	SetControl32BitValue(xm_ocontrol_pointer(19),soundopts->surround);
	DrawOneControl(xm_ocontrol_pointer(19));
	SetControl32BitValue(xm_ocontrol_pointer(889),soundopts->amplification);
	DrawOneControl(xm_ocontrol_pointer(889));
	BASSMOD_MusicSetAttribute(BASS_MUSIC_ATTRIB_AMPLIFY,soundopts->amplification);
	SetControl32BitValue(xm_ocontrol_pointer(890),soundopts->pansep);
	DrawOneControl(xm_ocontrol_pointer(890));
	BASSMOD_MusicSetAttribute(BASS_MUSIC_ATTRIB_PANSEP,soundopts->pansep);
	sprintf(digdisplay,"%d",soundopts->pansep);
	SetControlData(xm_ocontrol_pointer(900),kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
	DrawOneControl(xm_ocontrol_pointer(900));
	MultiParts=soundopts->eForceStop;
	if ( MultiParts == TRUE ) SetControl32BitValue(xm_ocontrol_pointer(1889),1);
	else SetControl32BitValue(xm_ocontrol_pointer(1889),0);
	if ( wplaying == 1 && trueplaying == 1 ) BASSMOD_MusicPlayEx(-1,xm_read_gui_option_flags(0),FALSE);

	return;
}

int xm_save_options() {
	int fd;
	struct pref_struct preferences;
	char *path;
	char *homedir;
	
	homedir=getenv("HOME");
	path=(char*)malloc(strlen(homedir)+strlen("/.ximplemod.cnf")+1);
	
	sprintf(path,"%s/.ximplemod.cnf",homedir);
	preferences=xm_preferences_readgui();
	fd=open(path,O_WRONLY|O_TRUNC|O_CREAT,0600);
	free( path );
	if ( fd == -1 ) {
		return -1;
	}
	if ( xm_writefile( fd, (char*)&preferences, sizeof(preferences) ) == -1) { close( fd ); return -1; }
	close( fd );
	
	return 0;
}

pascal OSStatus xm_default_options(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	char digdisplay[3]={'5','0','\0'};
	
	SetControl32BitValue(xm_ocontrol_pointer(20),2);
	DrawOneControl(xm_ocontrol_pointer(20));
	SetControl32BitValue(xm_ocontrol_pointer(18),3);
	DrawOneControl(xm_ocontrol_pointer(18));
	SetControl32BitValue(xm_ocontrol_pointer(19),2);
	DrawOneControl(xm_ocontrol_pointer(19));
	SetControl32BitValue(xm_ocontrol_pointer(889),50);
	DrawOneControl(xm_ocontrol_pointer(889));
	SetControl32BitValue(xm_ocontrol_pointer(890),50);
	DrawOneControl(xm_ocontrol_pointer(890));
	SetControlData(xm_ocontrol_pointer(900),kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
	DrawOneControl(xm_ocontrol_pointer(900));

	return noErr;
}

pascal OSStatus xm_cancel_options(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	HideWindow( win_options );
	xm_fetch_options();
	return noErr;
}

int xm_fetch_options() {
	int fd;
	struct pref_struct preferences;
	char *path;
	char *homedir;
	
	homedir=getenv("HOME");
	path=(char*)malloc(strlen(homedir)+strlen("/.ximplemod.cnf")+1);
	
	sprintf(path,"%s/.ximplemod.cnf",homedir);
	fd=open(path,O_RDONLY);
	free( path );
	if ( fd == -1 ) return -1;
	if ( xm_readfile( fd, (char*)&preferences, sizeof(preferences) ) == -1) { close( fd ); return -1; }
	close( fd );
	xm_preferences_writegui( &preferences );
	
	return 0;
}
