/*
 * XimpleMOD --- module player for Mac OS X
 * gui.c
 *
 * 2005 by Marco Trillo <toad@arsystel.com>
 *
 * This program is free software; under Public Domain. You can use it as you want.
 * You can redistribute and modify it, even with commercial intentions.
 *
 * This software is provided "as is", WITHOUT ANY WARRANTY,
 * either expressed or implied, including but not limited to the implied
 * warranties of merchantability and/or fitness for a particular purpose.
 * The author shall NOT be held liable for ANY damage to you, your
 * computer, or to anyone or anything else, that may result from its use,
 * or misuse. Basically, you use it at YOUR OWN RISK.
 */

/*
gui.c
These functions read data or events from GUI.
*/

/*
This function returns a pointer to a GUI object.
*/

ControlRef xm_control_by_id(int id,WindowPtr wintana) {
	ControlRef param;
	ControlID sdcontrol={0,id};
	GetControlByID(wintana,&sdcontrol,&param);
	return param;
}

/* Shortcuts */

ControlRef xm_control_pointer(int id) {
	return xm_control_by_id(id,window);
}

ControlRef xm_ocontrol_pointer(int id) {
	return xm_control_by_id(id,win_options);
}

ControlRef xm_hcontrol_pointer(int id) {
	return xm_control_by_id(id,win_channels);
}

ControlRef xm_icontrol_pointer(int id) {
	return xm_control_by_id(id,win_instruments);
}

/* This function sets the current editing instrument for the 'bahia' passed as arg. */

void xm_bahia_modinst(short bahia,int hinstrum) {
	int Elem;
	int iFooBarBaz[7];
	for ( Elem=1; Elem<=6; ++Elem ) iFooBarBaz[Elem]=1310+Elem;
	ControlRef ctrlRef;
	char* displayer;
	Boolean usecusname=FALSE;
	if ( hinstrum < 0 ) hinstrum=instruments-1;
	if ( hinstrum+1 > instruments ) hinstrum=0;
	if ( hinstrum < 0 ) hinstrum=0;
	
	if ( instruments > 0 && curModNeedFree == TRUE) {
		displayer = return_instrument_name( &curMod, hinstrum );
		if ( *displayer == 0 ) {
			free(displayer);
			usecusname=TRUE;
		}
	} else usecusname=TRUE;

	if ( usecusname==TRUE ) {
		displayer=(char*)malloc(sizeof("Instrument #AAAAAAAAAA"));
		sprintf(displayer,"Instrument #%d",hinstrum);
	}
	currInstru[bahia]=hinstrum;
	ctrlRef = xm_icontrol_pointer(bahia);
	SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(displayer),displayer);
	DrawOneControl(ctrlRef);
	free(displayer);
	Elem=BASSMOD_MusicGetVolume(MAKELONG(hinstrum,1));
	if (Elem==100) {
		ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );
		SetControlValue(ctrlRef,1);
		DrawOneControl(ctrlRef);
	} else {
		ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );
		SetControlValue(ctrlRef,0);
		DrawOneControl(ctrlRef);
	}
}

/* Events in Instruments window. */

void xm_bahia_onoff(short fbahia) {
	int iFooBarBaz[7];
	int Elem;
	for ( Elem=1; Elem<=6; ++Elem ) iFooBarBaz[Elem]=1310+Elem;
	ControlRef ctrlRef;
	int bahia;

	for ( bahia=1; bahia <= 6; ++bahia ) {
		Elem=BASSMOD_MusicGetVolume(MAKELONG(currInstru[bahia],1));

		if (bahia==fbahia) {
			if (Elem==0) BASSMOD_MusicSetVolume(MAKELONG(currInstru[bahia],1),100);
			else BASSMOD_MusicSetVolume(MAKELONG(currInstru[bahia],1),0);

		}

	}

	for ( bahia=1; bahia <= 6; ++bahia ) {
		Elem=BASSMOD_MusicGetVolume(MAKELONG(currInstru[bahia],1));

		if (Elem==100) {
			ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );
			SetControlValue(ctrlRef,1);
			DrawOneControl(ctrlRef);
		} else {
			ctrlRef = xm_icontrol_pointer( iFooBarBaz[bahia] );
			SetControlValue(ctrlRef,0);
			DrawOneControl(ctrlRef);

		}

	}

}

pascal OSStatus xm_bahia_cbuttons(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	int R;
	if (inUserData == xm_icontrol_pointer(99)) {
		for ( R=1; R<=6; ++R ) xm_bahia_modinst(R,currInstru[R]-1);
	}
	if (inUserData == xm_icontrol_pointer(100)) {
		for ( R=1; R<=6; ++R ) xm_bahia_modinst(R,currInstru[R]+1);
	}
	
	for ( R=1;R<=6;++R ) {
		if ( inUserData == xm_icontrol_pointer(1310+R) ) {
			xm_bahia_onoff(R);
		}
	}
	return noErr;
}

/*
This function installs the events to the GUI objects.
*/

void xm_event_handle(EventHandlerProcPtr xproc,DWORD event,WindowPtr wintana,int ID) {
	ControlRef ctrlRef;
	ctrlRef=xm_control_by_id(ID,wintana);
	EventTypeSpec tSpec={kEventClassControl,event};
	InstallEventHandler(GetControlEventTarget(ctrlRef),NewEventHandlerUPP(xproc),1,&tSpec,ctrlRef,NULL);
}

/* This installs some events on Instruments window */

void xm_bahia_handle(int turnbutt) {
	xm_event_handle(xm_bahia_cbuttons,kEventControlHit,win_instruments,turnbutt);
}

/*
This function reads the flags selected in the GUI, and then select the appropiate BASSMOD options.
*/
DWORD xm_read_gui_option_flags(short isFtime) {
	DWORD flags;
	DWORD Value;
	flags=BASS_MUSIC_POSRESET;

	if (isFtime == 1) {
		flags|=BASS_MUSIC_CALCLEN;
	}
	
	if ( islooping == 1 ) {
		flags|=BASS_MUSIC_LOOP;
	} else if ( MultiParts == TRUE && PlayList != 1 ) {
		flags|=BASS_MUSIC_STOPBACK;
	}

	Value=GetControl32BitValue(xm_ocontrol_pointer(20));

	if (Value==1) {
		flags|=BASS_MUSIC_NONINTER;
	}

	Value=GetControl32BitValue(xm_ocontrol_pointer(18));

	switch (Value) {
		case 2: flags|=BASS_MUSIC_RAMP; break;
		case 3: flags|=BASS_MUSIC_RAMPS; break;
	}

	Value=GetControl32BitValue(xm_ocontrol_pointer(19));

	switch (Value) {
		case 2: flags|=BASS_MUSIC_SURROUND; break;
		case 3: flags|=BASS_MUSIC_SURROUND2; break;
	}

	return flags;
}

/* This initialise the channels window */

void xm_channel_window_init() {
	char digdisplay[4];
	short rr;
	short hcontrol[3]={903,1899,1903};
	channels=0;
	ControlRef ctrlRef;
	while (BASSMOD_MusicGetVolume(channels)!=-1) ++channels;
	sprintf(digdisplay,"%d",channels);

	ctrlRef=xm_hcontrol_pointer(902);
	SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
	DrawOneControl(ctrlRef);

	for (rr=0;rr<3;++rr) {
		if ( channels > rr ) { currentChannel[rr]=rr; rackActive[rr]=TRUE;
			sprintf(digdisplay,"%d",rr);
			ctrlRef=xm_hcontrol_pointer(hcontrol[rr]);
			SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
			DrawOneControl(ctrlRef);
			ctrlRef=xm_hcontrol_pointer(hcontrol[rr]+1);
			SetControl32BitValue(ctrlRef,BASSMOD_MusicGetVolume(rr));
		} else {
			rackActive[rr]=FALSE;
			ctrlRef=xm_hcontrol_pointer(hcontrol[rr]);
			SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen("-"),"-");
			DrawOneControl(ctrlRef);
			ctrlRef=xm_hcontrol_pointer(hcontrol[rr]+1);
			SetControl32BitValue(ctrlRef,0);
		}
	}

}


/* This function inits Instruments window */

void xm_instrument_window_init() {
	int T;
	
	if ( curModNeedFree == TRUE ) {
		instruments=number_instruments( &curMod );
	} else {
		instruments=0;
		while (BASSMOD_MusicGetVolume(MAKELONG(instruments,1))!=-1) ++instruments;
	}
	
	for ( T=1;T<=6;++T ) xm_bahia_modinst(T,T-1);

}

/* Finder custom-icons stuff */

int xm_is_file_icon(char *filenam) {
if (strlen(filenam) > 3) {
	if (filenam[0]=='I' && filenam[1]=='c' && filenam[2]=='o' && filenam[3]=='n' && strlen(filenam)<6) return 1;
}
return 0;
}
