/*
 * XimpleMOD --- module player for Mac OS X
 * events.c
 *
 * 2005 by Marco Trillo <toad@arsystel.com>
 *
 * This program is free software; under Public Domain. You can use it as you want.
 * You can redistribute and modify it, even with commercial intentions.
 *
 * This software is provided "as is", WITHOUT ANY WARRANTY,
 * either expressed or implied, including but not limited to the implied
 * warranties of merchantability and/or fitness for a particular purpose.
 * The author shall NOT be held liable for ANY damage to you, your
 * computer, or to anyone or anything else, that may result from its use,
 * or misuse. Basically, you use it at YOUR OWN RISK.
 */


/* This file contains the simple actions/events attached to GUI objects. */

/* Open-document event */
static pascal OSErr	xm_open_document(const AppleEvent *inputEvent,AppleEvent *outputEvent,SInt32 handlerRefCon) {
		AEDescList docList;
		FSRef fileRef;
		AEKeyword keywd;
		DescType returnedType;
		Size theSize;
		char musicToLoad[255];
		long index=1;
		
		AEGetParamDesc( inputEvent, keyDirectObject, typeAEList, &docList);
		
		AEGetNthPtr( &docList, index, typeFSRef, &keywd, &returnedType,
						(Ptr)(&fileRef), sizeof( fileRef ), &theSize );
		FSRefMakePath( &fileRef, musicToLoad, 255 );
		
		if ( PlayList == 1 ) {
			closedir( PlayListDir );
			PlayList=0;
			ControlRef lcref=xm_control_pointer(1998);
			SetControlValue(lcref,0);
			DrawOneControl(lcref);
		}
		islooping=GetControl32BitValue(xm_control_pointer(810));
		SetControl32BitValue(xm_control_pointer(3810),0);
		xm_song_load( musicToLoad );
		starttime=timeGetTime();
		BASSMOD_MusicPlay();
		
		return noErr;
}

/*
Play the song :)
*/
pascal OSStatus xm_play(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
if (wplaying != 1) {
BASSMOD_MusicPlay();
starttime=timeGetTime();
}
return noErr;
}

/*
Stop (pause) the song...
*/
pascal OSStatus xm_stop(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
BASSMOD_MusicPause();
return noErr;
}

/*
Update BASSMOD flags using the options of controls in GUI :)
*/
pascal OSStatus xm_flags(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
DWORD bflags;
bflags=xm_read_gui_option_flags(0);
BASSMOD_MusicPlayEx(-1,bflags,FALSE);
return noErr;
}

/* Show or hide options window */

pascal OSStatus xm_show_options(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
ShowWindow ( win_options );
SelectWindow ( win_options );

return noErr;
}

pascal OSStatus xm_hide_options(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
xm_save_options();
HideWindow ( win_options );
return noErr;
}

/* Channels and instruments window */

pascal OSStatus xm_show_channels(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
DWORD retcode;
BASSMOD_MusicGetName();
retcode=BASSMOD_ErrorGetCode();
if (retcode == BASS_ERROR_NOMUSIC) {
char message[] = "No song is loaded";
ControlRef ctrlRef=xm_control_pointer(5);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(message),message);
DrawOneControl(ctrlRef);
} else {

SetDrawerParent ( win_channels, window );

SetDrawerPreferredEdge( win_channels, kWindowEdgeBottom );

SetDrawerOffsets( win_channels,78.0,78.0 );

xm_channel_window_init();

ToggleDrawer ( win_channels );


}


return noErr;
}

pascal OSStatus xm_hide_channels(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
HideWindow ( win_channels );
return noErr;
}

pascal OSStatus xm_show_about(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
ShowWindow ( win_about );
SelectWindow ( win_about );
return noErr;
}

pascal OSStatus xm_hide_about(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
HideWindow ( win_about );
return noErr;
}

pascal OSStatus xm_show_instruments(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
DWORD retcode;
BASSMOD_MusicGetName();
retcode=BASSMOD_ErrorGetCode();
if (retcode == BASS_ERROR_NOMUSIC) {
char message[] = "No song is loaded";
ControlRef ctrlRef=xm_control_pointer(5);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(message),message);
DrawOneControl(ctrlRef);
} else {

SetDrawerParent ( win_instruments, window );

SetDrawerPreferredEdge( win_instruments, kWindowEdgeRight );

xm_instrument_window_init();

ToggleDrawer ( win_instruments );

}

return noErr;
}

pascal OSStatus xm_next_channel(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
short rack;
short oldchannel;
short hcontrol[3]={905,1901,1905};
short rr;
for ( rr=0; rr<3; ++rr ) {
	if ( inUserData == xm_hcontrol_pointer(hcontrol[rr]) ) rack=rr;
}

if (rackActive[rack] == FALSE) return noErr;

oldchannel=currentChannel[rack];
currentChannel[rack]++;
if (currentChannel[rack] >= channels) currentChannel[rack]=0;
for (rr=0;rr<3;++rr) {
if (rack != rr && currentChannel[rr]==currentChannel[rack]) currentChannel[rack]=oldchannel;
}
char digdisplay[4];
ControlRef ctrlRef=xm_hcontrol_pointer(hcontrol[rack]-1);
SetControl32BitValue(ctrlRef,BASSMOD_MusicGetVolume(currentChannel[rack]));
ctrlRef=xm_hcontrol_pointer(hcontrol[rack]-2);
sprintf(digdisplay,"%d",currentChannel[rack]);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);
return noErr;
}

pascal OSStatus xm_prev_channel(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
short rack;
short oldchannel;
short hcontrol[3]={905,1901,1905};
short rr;
for ( rr=0; rr<3; ++rr ) {
	if ( inUserData == xm_hcontrol_pointer(hcontrol[rr]+1) ) rack=rr;
}

if (rackActive[rack] == FALSE) return noErr;

oldchannel=currentChannel[rack];
currentChannel[rack]--;
if (currentChannel[rack] < 0) currentChannel[rack] = channels-1;
for (rr=0;rr<3;++rr) {
if (rack != rr && currentChannel[rr]==currentChannel[rack]) currentChannel[rack]=oldchannel;
}
char digdisplay[4];
ControlRef ctrlRef=xm_hcontrol_pointer(hcontrol[rack]-1);
SetControl32BitValue(ctrlRef,BASSMOD_MusicGetVolume(currentChannel[rack]));
ctrlRef=xm_hcontrol_pointer(hcontrol[rack]-2);
sprintf(digdisplay,"%d",currentChannel[rack]);
SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(digdisplay),digdisplay);
DrawOneControl(ctrlRef);
return noErr;
}

pascal OSStatus xm_all_channels_on(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY;

for ( IY = 0; IY < channels; ++IY ) BASSMOD_MusicSetVolume(IY,100);

xm_channel_window_init();

return noErr;
}

pascal OSStatus xm_all_channels_off(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY;

for ( IY = 0; IY < channels; ++IY ) BASSMOD_MusicSetVolume(IY,0);

xm_channel_window_init();

return noErr;
}

pascal OSStatus xm_all_instruments_on(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY,Elem;
ControlRef ctrlRef;

for ( IY = 0; IY < instruments; ++IY ) BASSMOD_MusicSetVolume(MAKELONG(IY,1),100);

	for ( IY=1; IY <= 6; ++IY ) {
		Elem=BASSMOD_MusicGetVolume(MAKELONG(currInstru[IY],1));

		if (Elem==100) {
			ctrlRef = xm_icontrol_pointer( 1310+IY );
			SetControlValue(ctrlRef,1);
			DrawOneControl(ctrlRef);
		} else {
			ctrlRef = xm_icontrol_pointer( 1310+IY );
			SetControlValue(ctrlRef,0);
			DrawOneControl(ctrlRef);

		}

	}
	
return noErr;
}

pascal OSStatus xm_all_instruments_off(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
int IY,Elem;
ControlRef ctrlRef;

for ( IY = 0; IY < instruments; ++IY ) BASSMOD_MusicSetVolume(MAKELONG(IY,1),0);

	for ( IY=1; IY <= 6; ++IY ) {
		Elem=BASSMOD_MusicGetVolume(MAKELONG(currInstru[IY],1));

		if (Elem==100) {
			ctrlRef = xm_icontrol_pointer( 1310+IY );
			SetControlValue(ctrlRef,1);
			DrawOneControl(ctrlRef);
		} else {
			ctrlRef = xm_icontrol_pointer( 1310+IY );
			SetControlValue(ctrlRef,0);
			DrawOneControl(ctrlRef);

		}

	}
	
return noErr;
}

/*
Update the position of SONG from the GUI
*/

pascal void xm_position_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
short BPOS;
sdrrpos=GetControl32BitValue(control);
if (sdrrpos!=LOWORD(BASSMOD_MusicGetPosition())) {
lastplayed=-2;
for ( BPOS=0; BPOS < 256; ++BPOS ) OrderPlayed[BPOS]=FALSE;
BASSMOD_MusicSetPosition(sdrrpos);
lastplayed=sdrrpos;
}
}

/*
Update the various volumes of SONG from the GUI
*/

pascal void xm_volume_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
sdrrpos=GetControl32BitValue(control);
BASSMOD_SetVolume(sdrrpos);
}

pascal void xm_amplification_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
sdrrpos=GetControl32BitValue(control);
BASSMOD_MusicSetAttribute(BASS_MUSIC_ATTRIB_AMPLIFY,sdrrpos);
}

pascal void xm_panning_handler(ControlHandle control, SInt16 part){
DWORD sdrrpos;
ControlRef cfRef;
char streng[4];
sdrrpos=GetControl32BitValue(control);
BASSMOD_MusicSetAttribute(BASS_MUSIC_ATTRIB_PANSEP,sdrrpos);
sprintf(streng,"%d",sdrrpos);
cfRef=xm_ocontrol_pointer(900);
SetControlData(cfRef,kControlEntireControl,kControlStaticTextTextTag,strlen(streng),streng);
DrawOneControl(cfRef);

}

pascal void xm_channel_volume_handler(ControlHandle control, SInt16 part) {
DWORD sdrrpos;
short hcontrol[3]={904,1900,1904};
short rr;
short rack;
for ( rr=0; rr<3; ++rr ) {
	if ( (ControlRef)control == xm_hcontrol_pointer(hcontrol[rr]) ) rack=rr;
}
if ( rackActive[rack] == FALSE ) return;
sdrrpos=GetControl32BitValue(control);
BASSMOD_MusicSetVolume(currentChannel[rack],sdrrpos);
}

/*
Turns playlist ON or OFF
*/

pascal OSStatus xm_playlist_on_off(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
if (PlayList == 1) {

closedir(PlayListDir);
PlayList=0;
ControlRef qctrlRef=xm_control_pointer(1998);
SetControlValue(qctrlRef,0);
DrawOneControl(qctrlRef);
islooping=GetControl32BitValue(xm_control_pointer(810));
SetControl32BitValue(xm_control_pointer(3810),0);
return noErr;

} else {
return xm_playlist_select_dir(NULL,NULL,NULL);
}

}

/*
Next song in playlist
*/

pascal OSStatus xm_skip_song(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
if ( PlayList == 1 && wplaying == 1 && trueplaying == 1 ) {
	numHidParts=0;
	curHidPart=0;
	BASSMOD_MusicStop();
	SetControl32BitValue(xm_control_pointer(7),0);
	BASSMOD_MusicSetPosition(0);
}
return noErr;
}

/*
Rewinds the playlist
*/

pascal OSStatus xm_rewind_playlist(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	short F;
	if ( PlayList == 1 && wplaying == 1 && trueplaying == 1 ) {
		rewinddir( PlayListDir );
		PlayListPos=0;
		for ( F=0; F<256; ++F ) OrderPlayed[F]=TRUE;
		numHidParts=0;
		return xm_skip_song(NULL,NULL,NULL);
	}
return noErr;
}

pascal OSStatus xm_multiparts_onoff(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	if ( GetControl32BitValue(inUserData) == 0 ) MultiParts=FALSE;
	else MultiParts=TRUE;
	BASSMOD_MusicPlayEx(-1,xm_read_gui_option_flags(0),FALSE);
	return noErr;
}

pascal OSStatus xm_next_subsong(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
		if ( numHidParts > 0 ) {
			BASSMOD_MusicPlayEx(hidParts[curHidPart],xm_read_gui_option_flags(0),TRUE);
			wplaying=1;
			sisActive=BASS_ACTIVE_PLAYING;
			curHidPart++;
			numHidParts--;
		}
	return noErr;
}

pascal OSStatus xm_first_subsong(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
			BASSMOD_MusicPlayEx(0,xm_read_gui_option_flags(0),TRUE);
			wplaying=1;
			sisActive=BASS_ACTIVE_PLAYING;
			numHidParts+=curHidPart;
			curHidPart=0;
	return noErr;
}

pascal OSStatus xm_get_info(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	ControlRef CtRef;
	if ( curModNeedFree == TRUE ) {
		char* textpattern;
		short modtype;
		unsigned short udata,Q;
		unsigned long textlen,patternLen,qbytes,wbytes;
		TXNObject textobject;
		
		textpattern=module_name( &curMod );
		CtRef=xm_control_by_id(1,win_info);
		SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(textpattern),textpattern);
		DrawOneControl(CtRef);
		
		modtype=module_type( &curMod );
		switch ( modtype ) {
			case TYPE_SCREAM_3:
				textpattern=(char*)malloc(strlen("Scream Tracker 3")+1);
				strcpy(textpattern,"Scream Tracker 3");
				break;
			case TYPE_IMPULSE:
				textpattern=(char*)malloc(strlen("Impulse Tracker")+1);
				strcpy(textpattern,"Impulse Tracker");
				break;
			case TYPE_AMIGA_MOD:
				textpattern=(char*)malloc(strlen("Sound/Pro/Noise Tracker")+1);
				strcpy(textpattern,"Sound/Pro/Noise Tracker");
				break;
			case TYPE_FT2:
				textpattern=(char*)malloc(strlen("FastTracker II")+1);
				strcpy(textpattern,"FastTracker II");
				break;
		}
		
		CtRef=xm_control_by_id(2,win_info);
		SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(textpattern),textpattern);
		DrawOneControl(CtRef);
		
		udata=number_orders( &curMod );
		sprintf(textpattern,"%d",udata);
		CtRef=xm_control_by_id(4,win_info);
		SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(textpattern),textpattern);
		DrawOneControl(CtRef);
		
		udata=(unsigned short)number_instruments( &curMod );
		sprintf(textpattern,"%d",udata);
		CtRef=xm_control_by_id(5,win_info);
		SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(textpattern),textpattern);
		DrawOneControl(CtRef);
		
		free( textpattern );
		
		textpattern=retrieve_message( &curMod, &textlen );
		
		CtRef=xm_control_by_id(6,win_info);
		
		TXNInitTextension( NULL,0,kTXNAlwaysUseQuickDrawTextMask );

		textobject=HITextViewGetTXNObject((HIViewRef)CtRef);

		if ( textpattern==NULL ) {
		
			textpattern=(char*)malloc(strlen("Instrument names / ASCII message: "));
			CtRef=xm_control_by_id(9,win_info);
			strcpy(textpattern,"Instrument names / ASCII message:");
			SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(textpattern),textpattern);
			DrawOneControl(CtRef);
			free( textpattern );
			wbytes=TextPatternLayout;
			qbytes=0;
			for ( Q=0; Q<udata; ++Q ) {
				textpattern=return_instrument_name( &curMod, Q );
				patternLen=strlen( textpattern );
				textpattern[patternLen]='\n';
				TXNSetData( textobject, kTXNTextData, textpattern, (ByteCount)(patternLen+1), qbytes, wbytes );
				free( textpattern );
				qbytes+=patternLen+1;
				wbytes=qbytes;
			}
			TextPatternLayout=qbytes;
		} else {

			TXNSetData( textobject, kTXNTextData, textpattern, (ByteCount)textlen, 0, TextPatternLayout );
		
			TextPatternLayout=textlen;

			if ( textlen < strlen("Author Comments: ")) {
				free( textpattern );
				textpattern=(char*)malloc(strlen("Author Comments: "));
			}
			
			CtRef=xm_control_by_id(9,win_info);
			strcpy(textpattern,"Author Comments:");
			SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(textpattern),textpattern);
			DrawOneControl(CtRef);
			
			free( textpattern );
			
			
		}
			
		
		ShowWindow ( win_info );
		SelectWindow ( win_info );
		
		
	} else {
			CtRef=xm_control_pointer(5);
			SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen("Info not available"),"Info not available");
			DrawOneControl(CtRef);
			HideWindow( win_info );
	}
	return noErr;
}

pascal OSStatus xm_hide_info(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	HideWindow ( win_info );
	return noErr;
}

pascal OSStatus xm_playlist_drawer(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	if ( SongNamesNeedFree == TRUE ) {
		OSStatus    status = noErr;
		UInt32      i;
		ControlRef  dbControl;
		DataBrowserCallbacks  dbCallbacks;
		dbControl=xm_control_by_id(1,songs_drawer);
		dbCallbacks.version = kDataBrowserLatestCallbacks; 
		InitDataBrowserCallbacks (&dbCallbacks); 
		dbCallbacks.u.v1.itemDataCallback = NewDataBrowserItemDataUPP((DataBrowserItemDataProcPtr)MyDataBrowserItemDataCallback);
		dbCallbacks.u.v1.itemNotificationCallback = NewDataBrowserItemNotificationUPP((DataBrowserItemNotificationProcPtr)MyDataBrowserItemNotificationCallback);
		SetDataBrowserCallbacks(dbControl, &dbCallbacks);
	
		SetAutomaticControlDragTrackingEnabledForWindow (songs_drawer, true);

		status = RemoveDataBrowserItems (dbControl, kDataBrowserNoItem, 0, NULL, kDataBrowserItemNoProperty );

		status = AddDataBrowserItems (dbControl, kDataBrowserNoItem, numrows, NULL, kDataBrowserItemNoProperty );
		
		SetDrawerParent( songs_drawer, window );
		SetDrawerPreferredEdge( songs_drawer, kWindowEdgeLeft );
		ToggleDrawer( songs_drawer );

		return status;
	} else return noErr;
}

