/*
 * XimpleMOD --- module player for Mac OS X
 * control.c
 *
 * 2005 by Marco Trillo <toad@arsystel.com>
 *
 * This program is free software; under Public Domain. You can use it as you want.
 * You can redistribute and modify it, even with commercial intentions.
 *
 * This software is provided "as is", WITHOUT ANY WARRANTY,
 * either expressed or implied, including but not limited to the implied
 * warranties of merchantability and/or fitness for a particular purpose.
 * The author shall NOT be held liable for ANY damage to you, your
 * computer, or to anyone or anything else, that may result from its use,
 * or misuse. Basically, you use it at YOUR OWN RISK.
 */

#define XM_MAIN_SONG -1
#define XM_NEW_SUBSONG -2

void xm_playlist_drawer_filldata(char *pdirname) {
	MODULE eMod;
	struct dirent *eSong;
	char *cname;
	int i;
	FSRef tref;
	Boolean dvFld,wasAliased,isAlias;
	
	songnames=(char**)malloc(sizeof(char*));
	
	i=1;
	for (;;) {
	
		do {
			eSong=readdir( PlayListDir );
		} while (eSong != NULL && (eSong->d_name[0] == '.' || xm_is_file_icon(eSong->d_name) == 1));
		
		if ( eSong == NULL ) break;
		
		songnames=(char**)realloc((void*)songnames,i*sizeof(char*));
		songnames[i-1]=(char*)malloc(strlen(pdirname)+strlen(eSong->d_name)+2);
		
		sprintf(songnames[i-1],"%s/%s",pdirname,eSong->d_name);
		
		FSPathMakeRef( songnames[i-1], &tref, NULL );
		FSIsAliasFile( &tref, &isAlias, &dvFld );

		if ( isAlias == TRUE ) {
				if (FSResolveAliasFile( &tref, TRUE, &dvFld, &wasAliased ) == noErr) {
					FSRefMakePath( &tref, songnames[i-1], strlen(pdirname)+strlen(eSong->d_name)+2 );
				} else {
					strcpy(songnames[i-1],"?");
				}
		}

		
		if ( load_module( &eMod, songnames[i-1], USE_FILENAME ) == -1 ) {
			module_free( &eMod );
			songnames[i-1]=(char*)realloc((void*)songnames[i-1],strlen(eSong->d_name)+1);
			strcpy(songnames[i-1],eSong->d_name);
		} else {
			cname=module_name( &eMod );
			songnames[i-1]=(char*)realloc((void*)songnames[i-1],strlen(cname)+1);
			strcpy(songnames[i-1],cname);
		}
		
		module_free( &eMod );
		++i;

	}
	
	rewinddir( PlayListDir );
	numrows=(i-1);
	SongNamesNeedFree=TRUE;

}

OSStatus MyDataBrowserItemDataCallback(ControlRef browser,DataBrowserItemID itemID,DataBrowserPropertyID property,DataBrowserItemDataRef itemData,
 Boolean changeValue) {  
 
	OSStatus status = noErr;
	char popa[10];
	
	if (!changeValue) {
		switch (property) {
			case 'TITL':
				status = SetDataBrowserItemDataText (itemData,CFStringCreateWithCString(kCFAllocatorDefault,songnames[itemID-1],kCFStringEncodingASCII));
				break;        

			case 'ID  ':
				sprintf(popa,"%d",itemID);
				status = SetDataBrowserItemDataText(itemData,CFStringCreateWithCString(kCFAllocatorDefault,popa,kCFStringEncodingASCII));
				break;

			default:
				status = errDataBrowserPropertyNotSupported;
				break;
		}

    } else status=errDataBrowserPropertyNotSupported;
	
	return status;
}

void MyDataBrowserItemNotificationCallback (ControlRef browser,DataBrowserItemID item,DataBrowserItemNotification message) {
int i;
if ( message == kDataBrowserItemDoubleClicked && PlayList == 1 && wplaying == 1 && trueplaying == 1 ) {
	numHidParts=0;
	curHidPart=0;
	rewinddir( PlayListDir );
	for (i=1;i<item;++i) {
		do {
			PlayListSong=readdir( PlayListDir );
		} while (PlayListSong != NULL && (PlayListSong->d_name[0] == '.' || xm_is_file_icon(PlayListSong->d_name) == 1));
	}
	PlayListPos=item-1;
	BASSMOD_MusicStop();
	SetControl32BitValue(xm_control_pointer(7),0);
	BASSMOD_MusicSetPosition(0);
}
}


/*
==========================
Subsong detection system.
Thanks to Ian Luck.
==========================
*/

void CALLBACK xm_hiddenpart_scanner(HSYNC handle,DWORD data,DWORD user) {
	if ( LOWORD(data) != curOrder ) {
		if (OrderPlayed[LOWORD(data)] == TRUE) {
			Looped=TRUE;
		} else {
			if ( curOrder==XM_NEW_SUBSONG ) {
				numHidParts++;
				hidParts=(int*)realloc(hidParts,sizeof(int)*numHidParts);
				hidParts[numHidParts-1]=LOWORD(data);
				Looped=FALSE;
			}
			curOrder=LOWORD(data);
			OrderPlayed[curOrder]=TRUE;
		}
	}
}

/*
Loads a song into XimpleMOD.
*/

void xm_song_load(char *musicToLoad) {
	char *title;
	ControlRef CtRef;
	FSRef tref;
	Boolean isAlias;
	Boolean dvFld;
	short BPOS;
	BOOL canPlay;

	/* First, we check if "musicToLoad" is a Mac OS X alias */
	FSPathMakeRef( musicToLoad, &tref, NULL );
	FSIsAliasFile( &tref, &isAlias, &dvFld );

	if ( isAlias == TRUE ) {
		Boolean wasAliased;
		char fusicToLoad[255];

		if (FSResolveAliasFile( &tref, TRUE, &dvFld, &wasAliased ) == noErr) {
			FSRefMakePath( &tref, fusicToLoad, 255 );
			musicToLoad=fusicToLoad;
		} else {
			CtRef=xm_control_pointer(5);
			SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen("Alias read error"),"Alias read error");
			DrawOneControl(CtRef);
			if (PlayList == 1) {
				closedir( PlayListDir );
				PlayList=0;
				CtRef=xm_control_pointer(1998);
				SetControlValue(CtRef,0);
				DrawOneControl(CtRef);
			}
			return;
		}
	}
	
	BASSMOD_MusicFree();
	
	if ( curModNeedFree == TRUE ) {
		module_free( &curMod );
		curModNeedFree=FALSE;
	}
	
	if ( bufferFreeNeeded != NULL ) {
		free( bufferFreeNeeded );
		bufferFreeNeeded=NULL;
	}

	canPlay=TRUE;
	dvFld=FALSE;
	
	char *buffer;
	int bufsize;
	/* Special requirements needed for MO3 */
	if ( xm_song_is_mo3(musicToLoad) == TRUE ) {
		char *progline;
		progline=xm_unmo3_get(musicToLoad);
		if ( progline==NULL ) {
			canPlay=FALSE;
		} else {
			buffer=xm_exec( progline, &bufsize );
			
			free( progline );
			if ( buffer==NULL ) {
				canPlay=FALSE;
			} else {
				dvFld=TRUE;
			}
		}
	} else {
		dvFld=FALSE;
	}
	
	/*
	Multiparts scanner!
	*/
	if ( canPlay == TRUE ) {
		CoreDisabled=TRUE;
		char mybuffer[1000];
		int RR;
		HSYNC mysync;
		
		oldvol=BASSMOD_GetVolume();
		
		BASSMOD_Free();
		BASSMOD_Init(-3,1000,BASS_DEVICE_MONO|BASS_DEVICE_8BITS);
		if ( dvFld==TRUE ) canPlay=BASSMOD_MusicLoad(TRUE,buffer,0,bufsize,BASS_MUSIC_NOSAMPLE);
		else canPlay=BASSMOD_MusicLoad(FALSE,musicToLoad,0,0,BASS_MUSIC_NOSAMPLE);
		if ( canPlay==TRUE ) {
		
			for ( RR=0; RR<256; ++RR ) OrderPlayed[RR]=FALSE;
		
			mysync=BASSMOD_MusicSetSync(BASS_SYNC_POS,-1,xm_hiddenpart_scanner,-1);

			if (NeedToFreeSpace == TRUE) free(hidParts);

			numHidParts=0;
			hidParts=malloc(sizeof(int));
			Looped=FALSE;
			
			int KONTROLL;
			
			for (RR=0;1;++RR) {
				/* Find the next unplayed order */
				while (OrderPlayed[RR] == TRUE) ++RR;
				if (BASSMOD_MusicSetPosition(RR) == FALSE) break;
				if ( RR > 0 ) curOrder=XM_NEW_SUBSONG;
				else curOrder=XM_MAIN_SONG;
				/* LOOP!! */
				for ( KONTROLL=0;KONTROLL<6000;++KONTROLL ) {
					if ( BASSMOD_MusicDecode(mybuffer,1000) == -1 ) break;
					if ( Looped==TRUE ) break;
				}
			}
			
			NeedToFreeSpace=TRUE;
			
			BASSMOD_MusicRemoveSync( mysync );
		
			BASSMOD_Free();
		
			BASSMOD_Init(-1,44100,BASS_DEVICE_NOSYNC);
			
			BASSMOD_SetVolume(oldvol);
		
		}
	}
	
	CoreDisabled=FALSE;
	
	if (canPlay == TRUE) {
	
		if ( dvFld==TRUE ) {
			canPlay=BASSMOD_MusicLoad(TRUE,buffer,0,bufsize,xm_read_gui_option_flags(1));
			if (load_module( &curMod, buffer, bufsize ) == -1) {
				free( buffer );
				bufferFreeNeeded=NULL;
				module_free( &curMod );
				curModNeedFree=FALSE;
				HideWindow( win_info );
			} else {
				bufferFreeNeeded=(void*)buffer;
				curModNeedFree=TRUE;
			}
		} else {
			canPlay=BASSMOD_MusicLoad(FALSE,musicToLoad,0,0,xm_read_gui_option_flags(1));
			if (load_module( &curMod, musicToLoad, USE_FILENAME ) == -1) {
				module_free( &curMod );
				curModNeedFree=FALSE;
				HideWindow( win_info );
			} else {
				curModNeedFree=TRUE;
			}
			bufferFreeNeeded=NULL;
		}
	
		DWORD length;
		length=BASSMOD_MusicGetLength(FALSE);

		SetControl32BitMaximum(xm_control_pointer(7),length-1);

		/* We write song title to the display. */
		title=BASSMOD_MusicGetName();
		CtRef=xm_control_pointer(5);
		SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(title),title);
		DrawOneControl(CtRef);

		int mycrotime;
		char strtime[20];
		if (mycrotime=BASSMOD_MusicGetLength(TRUE)) {
			mycrotime=mycrotime/176400;
			sprintf(strtime," %d:%02d",mycrotime/60,mycrotime%60);
		} else {
			sprintf(strtime,"--:--");
		}
		trueplaying=1;
		wplaying=0;
		CtRef=xm_control_pointer(38);
		SetControlData(CtRef,kControlEntireControl,kControlStaticTextTextTag,strlen(strtime),strtime);
		DrawOneControl(CtRef);

		/* We update Channels & Instruments window. */
		xm_channel_window_init();
		xm_instrument_window_init();
		
		dofade=0;
		lastplayed=0;
		curHidPart=0;
		
		/* We reset the OrderPlayer's Booleans to FALSE */
		for ( BPOS=0; BPOS<256; ++BPOS ) OrderPlayed[BPOS]=FALSE;

	} else {
	
		if ( dvFld == TRUE ) free( buffer );

		SetControlData(xm_control_pointer(5),kControlEntireControl,kControlStaticTextTextTag,strlen("Invalid song format!"),"Invalid song format!");
		DrawOneControl(xm_control_pointer(5));

		CloseDrawer ( win_channels, TRUE );
		CloseDrawer ( win_instruments, TRUE );
		HideWindow ( win_info );
		if (PlayList == 1) {
			closedir( PlayListDir );
			PlayList=0;
			CtRef=xm_control_pointer(1998);
			SetControlValue(CtRef,0);
			DrawOneControl(CtRef);
		}
	}

	SetControl32BitValue(xm_control_pointer(7),0);
	return;
}


/*
Selects the song to play, prompting the user for the file.
*/

pascal OSStatus xm_select_a_file(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	NavDialogRef dialog;
	NavDialogCreationOptions programme;
	NavGetDefaultDialogCreationOptions(&programme);
	programme.optionFlags=0;
	programme.parentWindow=window;
	programme.windowTitle=CFStringCreateWithCString(kCFAllocatorDefault,"Choose a IT/XM/S3M/MTM/MOD/UMX/MO3 file",kCFStringEncodingASCII);
	NavCreateChooseFileDialog(&programme,NULL,NULL,NULL,NULL,NULL,&dialog);
	if (!NavDialogRun(dialog)) {
		NavReplyRecord recorde;
		if (!NavDialogGetReply(dialog,&recorde)) {
			AEKeyword key;
			FSRef frefr;
			if (!AEGetNthPtr(&recorde.selection,1,typeFSRef,&key,NULL,&frefr,sizeof(frefr),NULL)) {
				char musicToLoad[255];
				FSRefMakePath(&frefr,musicToLoad,255);
	
				/* Load the song */
				if (PlayList == 1) {
					closedir( PlayListDir );
					PlayList=0;
					ControlRef lcref=xm_control_pointer(1998);
					SetControlValue(lcref,0);
					DrawOneControl(lcref);
				}
				islooping=GetControl32BitValue(xm_control_pointer(810));
				SetControl32BitValue(xm_control_pointer(3810),0);
				xm_song_load(musicToLoad);
			}
			NavDisposeReply(&recorde);
		}
	}
	NavDialogDispose(dialog);
	return noErr;
}


/*
Enable or disable the loop (repeat)
*/

pascal OSStatus xm_loop(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	DWORD bflags;
	if (inUserData==xm_control_pointer(810)) {
		islooping = GetControl32BitValue(inUserData);
		if (islooping == 0 && GetControl32BitValue(xm_control_pointer(3810)) == 1) islooping=2;

		bflags=xm_read_gui_option_flags(0);
		BASSMOD_MusicPlayEx(-1,bflags,FALSE);
		return noErr;
	} else if (inUserData==xm_control_pointer(3810) && PlayList == 1) {
		if (GetControl32BitValue(inUserData) == 1) {
			if ( islooping==0 ) islooping=2;
		} else {
			islooping=GetControl32BitValue(xm_control_pointer(810));
		}

		bflags=xm_read_gui_option_flags(0);
		BASSMOD_MusicPlayEx(-1,bflags,FALSE);
		return noErr;
	} else {
		SetControl32BitValue(inUserData,0);
	}
}

/*
Update the display
*/

pascal void xm_update_display(EventLoopTimerRef inTimer, void *inUserData) {
	prevStat=sisActive;
	sisActive=BASSMOD_MusicIsActive();
	if ( CoreDisabled == TRUE ) return;
	
	if (sisActive == BASS_ACTIVE_STOPPED || sisActive == BASS_ACTIVE_PAUSED) {
		wplaying=0;
		
		if ( sisActive == BASS_ACTIVE_STOPPED && prevStat == BASS_ACTIVE_PLAYING && numHidParts > 0 ) {
			BASSMOD_MusicPlayEx(hidParts[curHidPart],xm_read_gui_option_flags(0),TRUE);
			wplaying=1;
			sisActive=BASS_ACTIVE_PLAYING;
			curHidPart++;
			numHidParts--;
		}
		
		if (PlayList == 1 && sisActive == BASS_ACTIVE_STOPPED && prevStat == BASS_ACTIVE_PLAYING) {
		/*  Song has finished, so we need to select the next song in playlist... */
			do {
				PlayListSong=readdir( PlayListDir );
			} while (PlayListSong != NULL && (PlayListSong->d_name[0] == '.' || xm_is_file_icon(PlayListSong->d_name) == 1));

			if (PlayListSong == NULL) {
				if (islooping == 2) {
					rewinddir(PlayListDir);
					PlayListPos=0;
					sisActive=BASS_ACTIVE_PLAYING;
				} else {
					closedir(PlayListDir);
					PlayList=0;
					ControlRef qctrlRef=xm_control_pointer(1998);
					SetControlValue(qctrlRef,0);
					DrawOneControl(qctrlRef);
					islooping=GetControl32BitValue(xm_control_pointer(810));
					SetControl32BitValue(xm_control_pointer(3810),0);
				}
			} else {
				PlayListPos++;
				char *songFullPath;
				songFullPath=(char*)malloc(strlen(folderPlayList)+strlen(PlayListSong->d_name)+2);
				sprintf(songFullPath,"%s/%s",folderPlayList,PlayListSong->d_name);
				xm_song_load(songFullPath);
				free(songFullPath);
				starttime=timeGetTime();
				BASSMOD_MusicPlay();
			}
		}
	
	} else {
		wplaying=1;
	}
	char text[9];
	int pos;
	ControlRef ctrlRef;
	pos=BASSMOD_MusicGetPosition();
	if (pos==-1) {
		pos=0;
	} else {
	
	/* Fade -- idea by Alexander Matchugovsky */
		if ( lastplayed != -2 && wplaying == 1 && trueplaying == 1 && PlayList == 1 && islooping != 1 && dofade != 1 ) {
			if ( OrderPlayed[LOWORD(pos)] == TRUE && lastplayed != LOWORD(pos) ) {
				oldvol=BASSMOD_GetVolume();
				dofade=1;
			} else {
				OrderPlayed[LOWORD(pos)]=TRUE;
			}
		}
		SetControl32BitValue(xm_control_pointer(7),LOWORD(pos));
	}
	sprintf(text,"%d",LOWORD(pos));
	ctrlRef=xm_control_pointer(2038);
	SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(text),text);
	DrawOneControl(ctrlRef);
	
	sprintf(text,"%d",numHidParts+curHidPart);
	ctrlRef=xm_control_pointer(3300);
	SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(text),text);
	DrawOneControl(ctrlRef);
	
	sprintf(text,"%d",curHidPart);
	ctrlRef=xm_control_pointer(3002);
	SetControlData(ctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(text),text);
	DrawOneControl(ctrlRef);
	
	if ( lastplayed != -2 ) lastplayed=LOWORD(pos);
	if ( dofade == 1 ) {
		pos=BASSMOD_GetVolume();
		if ( pos > 3 ) {
			BASSMOD_SetVolume(pos-1);
		} else {
			BASSMOD_MusicStop();
			BASSMOD_SetVolume(oldvol);
			dofade=0;
		}
	}

	int tyme=getMicroTime(starttime);
	char tstring[12];
	if (wplaying == 1 && trueplaying == 1) {
		sprintf(tstring,"%d:%02d",tyme/60,tyme%60);
	} else {
		sprintf(tstring,"--:--");
	}
	ControlRef ztrlRef=xm_control_pointer(44);
	SetControlData(ztrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(tstring),tstring);
	DrawOneControl(ztrlRef);
	
	if ( PlayList == 1 ) {
		sprintf(tstring,"%d",(PlayListPos == 0 ? 1 : PlayListPos));
	} else {
		strcpy(tstring,"-");
	}
	ztrlRef=xm_control_pointer( 2002 );
	SetControlData(ztrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen(tstring),tstring);
	DrawOneControl(ztrlRef);
	
	if ( PlayList == 0 && SongNamesNeedFree == TRUE ) {
		int J;
		for ( J=0;J<numrows;++J ) free( songnames[J] );
		free( songnames );
		SongNamesNeedFree=FALSE;
		CloseDrawer( songs_drawer, TRUE );
	}
		
}

/* Select a playlist dir... */

pascal OSStatus xm_playlist_select_dir(EventHandlerCallRef inHandlerRef, EventRef inEvent, void *inUserData) {
	NavDialogRef dialog;
	NavDialogCreationOptions programme;
	NavGetDefaultDialogCreationOptions(&programme);
	programme.optionFlags=0;
	programme.parentWindow=window;
	programme.windowTitle=CFStringCreateWithCString(kCFAllocatorDefault,"Choose a folder with only IT/XM/S3M/MTM/MOD/UMX/MO3",kCFStringEncodingASCII);

	NavCreateChooseFolderDialog(&programme,NULL,NULL,NULL,&dialog);

	if (!NavDialogRun(dialog)) {
		NavReplyRecord recorde;
		if (!NavDialogGetReply(dialog,&recorde)) {
			AEKeyword key;
			FSRef frefr;
			if (!AEGetNthPtr(&recorde.selection,1,typeFSRef,&key,NULL,&frefr,sizeof(frefr),NULL)) {

				FSRefMakePath(&frefr,folderPlayList,255);

				if (PlayList == 1) closedir(PlayListDir);
				
				if ( BASSMOD_MusicIsActive() == BASS_ACTIVE_PLAYING ) {
					BASSMOD_MusicPause();
					sisActive=BASS_ACTIVE_PAUSED;
				}
				
				PlayList=1;
				PlayListDir=opendir(folderPlayList);
				if (PlayListDir == NULL) {
					PlayList=0;
					ControlRef ctrleeRef=xm_control_pointer(5);
					SetControlData(ctrleeRef,kControlEntireControl,kControlStaticTextTextTag,strlen("Folder read error"),"Folder read error");
					DrawOneControl(ctrleeRef);
				} else {
			
					ControlRef qctrlRef = xm_control_pointer( 1998 );

					SetControlValue(qctrlRef,1);

					DrawOneControl(qctrlRef);
					
					if ( SongNamesNeedFree == TRUE ) {
						int J;
						for ( J=0;J<numrows;++J ) free( songnames[J] );
						free( songnames );
						SongNamesNeedFree=FALSE;
					}
					
					xm_playlist_drawer_filldata(folderPlayList);
					
					CloseDrawer(songs_drawer,TRUE);
								
					do {
						PlayListSong=readdir( PlayListDir );
					} while (PlayListSong != NULL && (PlayListSong->d_name[0] == '.' || xm_is_file_icon(PlayListSong->d_name) == 1));
			
					if (PlayListSong == NULL) {
						PlayList=0;
						closedir(PlayListDir);
						SetControlValue(qctrlRef,0);
						DrawOneControl(qctrlRef);
						qctrlRef=xm_control_pointer(5);
						SetControlData(qctrlRef,kControlEntireControl,kControlStaticTextTextTag,strlen("Folder read error"),"Folder read error");
						DrawOneControl(qctrlRef);
				
					} else {
						PlayListPos=1;
						char *songFullPath;
						
						songFullPath=(char*)malloc(strlen(folderPlayList)+strlen(PlayListSong->d_name)+2);
			
						sprintf(songFullPath,"%s/%s",folderPlayList,PlayListSong->d_name);
															
						xm_song_load(songFullPath);
						
						free(songFullPath);
			
			
					}
				}

			}
			NavDisposeReply(&recorde);
		}
	}
	NavDialogDispose(dialog);


return noErr;
}

