/*
 * XimpleMOD --- module player for Mac OS X
 * main.c
 *
 * 2005 by Marco Trillo <toad@arsystel.com>
 *
 * This program is free software; under Public Domain. You can use it as you want.
 * You can redistribute and modify it, even with commercial intentions.
 *
 * This software is provided "as is", WITHOUT ANY WARRANTY,
 * either expressed or implied, including but not limited to the implied
 * warranties of merchantability and/or fitness for a particular purpose.
 * The author shall NOT be held liable for ANY damage to you, your
 * computer, or to anyone or anything else, that may result from its use,
 * or misuse. Basically, you use it at YOUR OWN RISK.
 */

#define DEFAULT_VOLUME 75

#include <stdio.h>
#include <stdlib.h>
#include <Carbon/Carbon.h>
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <fcntl.h>
#include "bassmod.h"
#include "libmodinfo.h"
#include "deprecated.h"
#include "microtime.h"
#include "libio.h"

#define NUMOPTIONS 3
int stsArray[NUMOPTIONS]={18,19,20};
static WindowPtr window;
static WindowPtr win_options;
static WindowPtr win_channels;
static WindowPtr win_instruments;
static WindowPtr win_about;
static WindowPtr win_info;
static WindowPtr songs_drawer;
static MODULE curMod;
static Boolean curModNeedFree=FALSE;
static void* bufferFreeNeeded=NULL;
static long TextPatternLayout=0;
static int starttime;
static int wplaying;
static int trueplaying;
static short islooping=0;
static int channels;
static int currentChannel[3];
static Boolean rackActive[3];
static int instruments;
static int currInstru[7];
static DWORD sisActive;
static DWORD prevStat;
static short PlayList;
static DIR *PlayListDir;
static struct dirent *PlayListSong;
static char folderPlayList[255];
static int PlayListPos;
static Boolean OrderPlayed[256];
static int dofade;
static int oldvol;
static short lastplayed;
static Boolean MultiParts;
static Boolean CoreDisabled;
static Boolean NeedToFreeSpace;
static int numHidParts;
static int* hidParts;
static int curHidPart;
static short curOrder;
static Boolean Looped;
static char **songnames=NULL;
static Boolean SongNamesNeedFree=FALSE;
static SInt32 numrows;

#include "gui.c"
#include "mo3.c"
#include "control.c"
#include "events.c"
#include "preferences.c"

int main(int argc, char* argv[]) {
	wplaying=0;
	PlayList=0;
	MultiParts=FALSE;
	CoreDisabled=FALSE;
	NeedToFreeSpace=FALSE;
	numHidParts=0;
	curHidPart=0;
	prevStat=BASS_ACTIVE_STOPPED;

	starttime=timeGetTime();
	IBNibRef nibRef;    
	OSStatus err;
	
	InitCursor();

	if (BASSMOD_GetVersion()!=MAKELONG(2,1)) {
		fprintf(stderr,"BASSMOD version 2.1 was not loaded\n");
		return 0;
	}
	if (!BASSMOD_Init(-1,44100,BASS_DEVICE_NOSYNC)) {
		fprintf(stderr,"Can't initialize device");
		return 0;
	}
	
    err = CreateNibReference(CFSTR("main"), &nibRef);
    require_noerr( err, CantGetNibRef );
    err = SetMenuBarFromNib(nibRef, CFSTR("MenuBar"));
    require_noerr( err, CantSetMenuBar );
    err = CreateWindowFromNib(nibRef, CFSTR("MainWindow"), &window);
    require_noerr( err, CantCreateWindow );
	
	err = CreateWindowFromNib(nibRef, CFSTR("Options"), &win_options);
	err = CreateWindowFromNib(nibRef, CFSTR("ChannelsWin"), &win_channels);
	err = CreateWindowFromNib(nibRef, CFSTR("InsDrawer"), &win_instruments);
	err = CreateWindowFromNib(nibRef, CFSTR("About"), &win_about);
	err = CreateWindowFromNib(nibRef, CFSTR("InfoWindow"), &win_info);
	err = CreateWindowFromNib(nibRef, CFSTR("PlsWindow"), &songs_drawer);

    DisposeNibReference(nibRef);
	
	xm_fetch_options();
	
	ShowWindow( window );	
		
	SetControl32BitMaximum(xm_control_pointer(808),100);
	BASSMOD_SetVolume( DEFAULT_VOLUME );
	SetControl32BitValue(xm_control_pointer(808),BASSMOD_GetVolume());
	
	/* Open document event (ie, when some doc. is draged to the Dock icon ) */
	AEInstallEventHandler(kCoreEventClass, kAEOpenDocuments, NewAEEventHandlerUPP(xm_open_document), 0, false);
	
    xm_event_handle(xm_select_a_file,kEventControlHit,window,809);

	int jfi;
	for (jfi=0; jfi < NUMOPTIONS; jfi++ ) {
		xm_event_handle(xm_flags,kEventControlValueFieldChanged,win_options,stsArray[jfi]);
	}

	xm_event_handle(xm_play,kEventControlHit,window,2);
	xm_event_handle(xm_stop,kEventControlHit,window,1);
	xm_event_handle(xm_loop,kEventControlHit,window,810);
	xm_event_handle(xm_loop,kEventControlHit,window,3810);
	xm_event_handle(xm_show_options,kEventControlHit,window,811);
	xm_event_handle(xm_hide_options,kEventControlHit,win_options,888);
	xm_event_handle(xm_multiparts_onoff,kEventControlHit,win_options,1889);
	xm_event_handle(xm_show_channels,kEventControlHit,window,319);
	xm_event_handle(xm_get_info,kEventControlHit,window,412);
	xm_event_handle(xm_hide_info,kEventControlHit,win_info,7);
	/*xm_event_handle(xm_hide_channels,kEventControlHit,win_channels,907);*/
	xm_event_handle(xm_show_instruments,kEventControlHit,window,1111);
	/*xm_event_handle(xm_hide_instruments,kEventControlHit,win_instruments,907);*/
	xm_event_handle(xm_show_about,kEventControlHit,window,2039);
	xm_event_handle(xm_next_subsong,kEventControlHit,window,2999);
	xm_event_handle(xm_first_subsong,kEventControlHit,window,3001);
	xm_event_handle(xm_hide_about,kEventControlHit,win_about,1);
	xm_event_handle(xm_default_options,kEventControlHit,win_options,2011);
	xm_event_handle(xm_cancel_options,kEventControlHit,win_options,1890);
	xm_event_handle(xm_playlist_select_dir,kEventControlHit,window,1997);
	xm_event_handle(xm_playlist_on_off,kEventControlHit,window,1998);
	xm_event_handle(xm_skip_song,kEventControlHit,window,1999);
	xm_event_handle(xm_rewind_playlist,kEventControlHit,window,2001);
	xm_event_handle(xm_all_channels_on,kEventControlHit,win_channels,1200);
	xm_event_handle(xm_all_channels_off,kEventControlHit,win_channels,1201);
	xm_event_handle(xm_all_instruments_on,kEventControlHit,win_instruments,102);
	xm_event_handle(xm_all_instruments_off,kEventControlHit,win_instruments,101);
	xm_event_handle(xm_playlist_drawer,kEventControlHit,window,5959);


	xm_event_handle(xm_next_channel,kEventControlHit,win_channels,905);
	xm_event_handle(xm_prev_channel,kEventControlHit,win_channels,906);
	
	xm_event_handle(xm_next_channel,kEventControlHit,win_channels,1901);
	xm_event_handle(xm_prev_channel,kEventControlHit,win_channels,1902);
	
	xm_event_handle(xm_next_channel,kEventControlHit,win_channels,1905);
	xm_event_handle(xm_prev_channel,kEventControlHit,win_channels,1906);
	
	xm_event_handle(xm_bahia_cbuttons,kEventControlHit,win_instruments,99);
	xm_event_handle(xm_bahia_cbuttons,kEventControlHit,win_instruments,100);
	
	for ( jfi = 1; jfi <= 6; ++jfi ) {
		xm_event_handle(xm_bahia_cbuttons,kEventControlHit,win_instruments,1310+jfi);
	}

	SetControlAction(xm_control_pointer(7),NewControlActionUPP(xm_position_handler));
	SetControlAction(xm_control_pointer(808),NewControlActionUPP(xm_volume_handler));
	SetControlAction(xm_ocontrol_pointer(889),NewControlActionUPP(xm_amplification_handler));
	SetControlAction(xm_ocontrol_pointer(890),NewControlActionUPP(xm_panning_handler));
	SetControlAction(xm_hcontrol_pointer(904),NewControlActionUPP(xm_channel_volume_handler));
	SetControlAction(xm_hcontrol_pointer(1900),NewControlActionUPP(xm_channel_volume_handler));
	SetControlAction(xm_hcontrol_pointer(1904),NewControlActionUPP(xm_channel_volume_handler));
	
	EventLoopTimerRef Timer;
	InstallEventLoopTimer(GetCurrentEventLoop(),kEventDurationNoWait,kEventDurationSecond/10,xm_update_display,0,&Timer);

	RunApplicationEventLoop();

	CantCreateWindow:
	CantSetMenuBar:
	CantGetNibRef:
		return err;

	BASSMOD_Free();

	if (PlayList == 1) closedir(PlayListDir);
	if ( curModNeedFree == TRUE ) module_free( &curMod );
	if ( bufferFreeNeeded != NULL ) free( bufferFreeNeeded );
	
	return 0; 
}
