/*
 * XimpleMOD --- module player for Mac OS X
 * libio.c
 *
 * 2005 by Marco Trillo <toad@arsystel.com>
 *
 * This program is free software; under Public Domain. You can use it as you want.
 * You can redistribute and modify it, even with commercial intentions.
 *
 * This software is provided "as is", WITHOUT ANY WARRANTY,
 * either expressed or implied, including but not limited to the implied
 * warranties of merchantability and/or fitness for a particular purpose.
 * The author shall NOT be held liable for ANY damage to you, your
 * computer, or to anyone or anything else, that may result from its use,
 * or misuse. Basically, you use it at YOUR OWN RISK.
 */
 
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>

int xm_writefile(int fd,char *buf,int buflen) {
	int bytes_out = buflen, bytes_in;
	
	while (bytes_out > 0) {
		bytes_in = write(fd,buf,bytes_out);
		if (bytes_in == -1 || bytes_in == 0) {
			return(-1);
		}
		bytes_out -= bytes_in;
		buf += bytes_in;
		
	}
	return (buflen - bytes_out);
}

int xm_readfile(int fd,char *buf,int buflen) {
	int bytes_out = buflen, bytes_in;
	
	while (bytes_out > 0) {
		bytes_in = read(fd,buf,bytes_out);
		if (bytes_in == -1 || bytes_in == 0) {
			return(-1);
		}
		bytes_out -= bytes_in;
		buf += bytes_in;
		
	}
	return (buflen - bytes_out);
}

char* xm_exec(char* program,int* len) {
	FILE* foo;
	int bytes_in,bytes_out;
	char* buffer;
	
	bytes_in=0;
	foo=popen(program,"r");
	if ( !foo ) return NULL;
	
	buffer=(char*)malloc(1024);
	while ((bytes_out=fread(buffer+bytes_in,1,1024,foo)) > 0) {
		bytes_in+=bytes_out;
		buffer=(char*)realloc(buffer,bytes_in+1024);
		if ( buffer==NULL ) return NULL;
	}
	if (pclose(foo) == -1) return NULL;
	buffer=(char*)realloc(buffer,bytes_in);
	if ( buffer==NULL ) return NULL;
	
	*len=bytes_in;
	return buffer;
}
