/*
 * L I B
 *
 *    #            #
 *    ##############
 *           #######
 *      ########
 *       #####
 *    #       #### 
 *    ##############
 *    #            #
 *         ####
 *      ##########
 *    ##          # 
 *    #            #
 *    #            #
 *     ###      ###
 *       ########
 *    #            #
 *    ##############
 *    #            #
 *    #            #
 *    #           ##
 *     ####    ####
 *       ########
 *                  I N F O v1.1 beta
 *
 * Retrieve useful info. data from MOD, IT, S3M & XM files.
 *
 * Please take a look to the included documentation ;) 
 *
 * -= Coded by Marco Trillo <toad@arsystel.com> on 2005 =-
 * -= Parts of code were inspired on LibModPlug`s load_it.cpp file, thanks to its authors =-
 * 
 * All of this code is under Public Domain. Please feel free to use it in your distribution; sell it;
 * modify & remodify it; or just drop it to the trash =) in both source & binary forms.
 *
 * If you have a bugfix or an improvement you can send it to the author: thx =) 
 *
 * *** DISCLAIMER ***
 * This software is provided "as is", WITHOUT ANY WARRANTY,
 * either expressed or implied, including but not limited to the implied
 * warranties of merchantability and/or fitness for a particular purpose.
 * The author shall NOT be held liable for ANY damage to you, your
 * computer, or to anyone or anything else, that may result from its use,
 * or misuse. Basically, you use it at YOUR OWN RISK.
 *
 * But for any problem using this software you can contact the author, and we`ll try to fix it ;) 
 * 
 */

#ifndef _LIBMODINFO_H_
#define _LIBMODINFO_H_

#define TYPE_SCREAM_3 3
#define TYPE_IMPULSE 2
#define TYPE_AMIGA_MOD 4
#define TYPE_FT2 7
#define TYPE_UNKNOWN 1

#define USE_FILENAME -2

/* Module struct */
struct str_modfile {
	char* buf;
	int buflen;
	short type;
	short live;
};

typedef struct str_modfile MODULE;

unsigned char number_instruments(MODULE* modfile);

unsigned short number_orders(MODULE* modfile);

int load_module(MODULE* modfile,char* obuffer,int obuflen);

char* return_instrument_name(MODULE* mod,int numinst);

char* retrieve_message(MODULE* modfile,unsigned long* length);

char* module_name(MODULE* modfile);

short module_type(MODULE* modfile);

void module_free(MODULE* modfile);

#endif

