/*
 * Name: OGRegularExpressionEnumerator.h
 * Project: OgreKit
 *
 * Creation Date: Sep 03 2003
 * Author: Isao Sonobe <sonobe@gauge.scphys.kyoto-u.ac.jp>
 * Copyright: Copyright (c) 2003 Isao Sonobe, All rights reserved.
 * License: OgreKit License
 *
 * Encoding: UTF8
 * Tabsize: 4
 */

#import <Foundation/Foundation.h>

@class OGRegularExpression;

// Exception
extern NSString	* const OgreEnumeratorException;

@interface OGRegularExpressionEnumerator : NSEnumerator <NSCopying, NSCoding>
{
	OGRegularExpression	*_regex;							// K\IuWFNg
	NSString			*_swappedTargetString;				// ΏەB\ւĂ()̂Œ
	unsigned char		*_utf8SwappedTargetString;			// UTF8ł̌Ώە
	unsigned			_utf8lengthOfSwappedTargetString;	// strlen([_swappedTargetString UTF8String])
	NSRange				_searchRange;						// ͈
	unsigned			_searchOptions;						// IvV
	int					_utf8TerminalOfLastMatch;			// OɃ}b`̏I[ʒu  (_region->end[0])
	unsigned			_startLocation;						// }b`Jnʒu
	unsigned			_utf8StartLocation;					// UTF8ł̃}b`Jnʒu
	BOOL				_isLastMatchEmpty;					// Õ}b`󕶎񂾂ǂ
	
	unsigned			_numberOfMatches;					// }b`
}

// S}b`ʂzŕԂB
- (NSArray*)allObjects;
// ̃}b`ʂԂB
- (id)nextObject;

// description
- (NSString*)description;

@end
