/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class Terminator
extends JLabel {
    public static SunRiseSet srs = new SunRiseSet();
    public static Sun sun = new Sun();
    public static AstroFunctions astro = new AstroFunctions();
    public static ImageOps ops = new ImageOps();
    public static int scaleX = 360;
    public static int scaleY = 180;
    public static double scaleval;
    public static Image day;
    public static Image night;
    public static Image imgSun;
    public static boolean isgray;

    public Terminator() {
        this.setOpaque(false);
        this.setBounds(0, 0, scaleX, scaleY);
        this.setVisible(true);
        imgSun = ImageOps.loadWorkableImage("SunImage.png");
    }

    public void paintTerminator(int scaleX, int scaleY, boolean isgray, Image day, Image night) {
        Terminator.scaleX = scaleX;
        Terminator.scaleY = scaleY;
        Terminator.isgray = isgray;
        Terminator.day = day;
        Terminator.night = night;
        scaleval = 180.0 / ((double)scaleX * 1.0 / 2.0);
        Ellipse2D.Double point = new Ellipse2D.Double();
        Line2D.Double line = new Line2D.Double();
        BufferedImage bimage = new BufferedImage(scaleX, scaleY, 6);
        Graphics2D g2 = bimage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        double[] utc = astro.currentUTC();
        Point2D.Double sunpos = Sun.getSunPosition(utc[0], utc[1], utc[2], utc[3], utc[4], 0.0, 0.0);
        double x = sunpos.getX() / scaleval + (double)(scaleX / 2);
        double y = (90.0 - sunpos.getY()) / scaleval;
        for (double lat = 90.0; lat > -91.0; lat -= scaleval) {
            double linelat;
            double dayofyear = (double)astro.dayOfYear() * 1.0;
            double hoursinday = Sun.dayLengthAtLatitude(lat, dayofyear) * 15.0;
            double lineX1 = x - hoursinday / scaleval / 2.0;
            double lineX2 = x + hoursinday / scaleval / 2.0;
            if (hoursinday != 0.0) {
                linelat = (90.0 - lat) / scaleval;
                line.setLine(lineX1, linelat, lineX2, linelat);
                g2.draw(line);
            } else {
                boolean isday = this.sunUpAllDay(lat, 0.0, 0.0, utc[1], utc[2], utc[0]);
                if (isday) {
                    linelat = (90.0 - lat) / scaleval;
                    line.setLine(-1.0, linelat, scaleX, linelat);
                    g2.draw(line);
                }
            }
            if (lineX1 < 0.0) {
                g2 = this.drawLineRight(g2, Math.abs(lineX1), lat);
            }
            if (!(lineX2 > (double)scaleX)) continue;
            g2 = this.drawLineLeft(g2, Math.abs(lineX2), lat);
        }
        Image blackimg = ImageOps.toImage(bimage);
        int[] pix = ImageOps.getImagePixels(blackimg, scaleX, scaleY);
        int[] epix = ImageOps.getImagePixels(day, scaleX, scaleY);
        this.overlayImage(pix, epix, sunpos.getX(), sunpos.getY());
        bimage.flush();
        g2.dispose();
    }

    private void overlayImage(int[] blackpixels, int[] earthpixels, double sunX, double sunY) {
        Ellipse2D.Double solarpoint = new Ellipse2D.Double();
        BufferedImage bufferedimage = new BufferedImage(scaleX, scaleY, 6);
        Graphics2D g = bufferedimage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int z = 10;
        Color r = Color.red;
        for (int x = 0; x < scaleX; ++x) {
            for (int y = 0; y < scaleY; ++y) {
                int index = x + y * scaleX;
                if (blackpixels[index] == 0) continue;
                bufferedimage.setRGB(x, y, earthpixels[index]);
            }
        }
        int xx = (int)(sunX / scaleval + (double)(scaleX / 2));
        int yy = (int)((90.0 - sunY) / scaleval);
        g.drawImage(imgSun, xx - 25, yy - 25, null);
        Image imgDay = Terminator.toImage(bufferedimage);
        Image scaleimg = ImageOps.combineImages(night, imgDay, scaleX, scaleY);
        this.setIcon(new ImageIcon(scaleimg));
        bufferedimage.flush();
        g.dispose();
    }

    protected Graphics2D drawLineRight(Graphics2D g, double LineLen, double Lat) {
        Line2D.Double L2D = new Line2D.Double();
        double lineY = (90.0 - Lat) / scaleval;
        L2D.setLine((double)scaleX - LineLen, lineY, scaleX, lineY);
        g.draw(L2D);
        return g;
    }

    protected Graphics2D drawLineLeft(Graphics2D g, double LineLen, double Lat) {
        double len = LineLen - (double)scaleX;
        Line2D.Double L2D = new Line2D.Double();
        double lineY = (90.0 - Lat) / scaleval;
        L2D.setLine(0.0, lineY, len, lineY);
        g.draw(L2D);
        return g;
    }

    protected boolean sunUpAllDay(double Lat, double Lon, double TmZone, double Month, double Day, double Year) {
        double[] ret = SunRiseSet.SunEvents(Lat, Lon, TmZone, Month, Day, Year);
        return ret[0] == -2.0;
    }

    public static Image toImage(BufferedImage bufferedImage) {
        Image img = Toolkit.getDefaultToolkit().createImage(bufferedImage.getSource());
        while (img.getWidth(null) < 0) {
        }
        return img;
    }

    static {
        isgray = false;
    }
}

