/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Array;
import java.text.DecimalFormat;

public class SunRiseSet {
    public static double[] SunEvents(double Lat, double Lon, double TmZone, double Month, double Day, double Year) {
        double Ax;
        double S;
        double[] events = new double[]{};
        double[] a = new double[3];
        double[] D = new double[3];
        String BuildStr = "";
        double J3 = 0.0;
        double V2 = 0.0;
        double V0 = 0.0;
        double P1 = 3.14159265358979;
        double P2 = 2.0 * P1;
        double DR = P1 / 180.0;
        double K1 = 15.0 * DR * 1.0027379;
        double B5 = Lat;
        double L5 = Lon;
        double H = -TmZone;
        L5 /= 360.0;
        double Z0 = H / 24.0;
        double G = 1.0;
        if (Year < 1582.0) {
            G = 0.0;
        }
        double D1 = SunRiseSet.Int(Day);
        double F = Day - D1 - 0.5;
        double J = -SunRiseSet.Int(7.0 * (SunRiseSet.Int((Month + 9.0) / 12.0) + Year) / 4.0);
        if (G != 0.0) {
            S = SunRiseSet.Sgn(Month - 9.0);
            Ax = SunRiseSet.Abs(Month - 9.0);
            J3 = SunRiseSet.Int(Year + S * SunRiseSet.Int(Ax / 7.0));
            J3 = -SunRiseSet.Int((SunRiseSet.Int(J3 / 100.0) + 1.0) * 3.0 / 4.0);
        }
        J = J + SunRiseSet.Int(275.0 * Month / 9.0) + D1 + G * J3;
        J = J + 1721027.0 + 2.0 * G + 367.0 * Year;
        if (F < 0.0) {
            F += 1.0;
            J -= 1.0;
        }
        double T = J - 2451545.0 + F;
        double TT = T / 36525.0 + 1.0;
        double T0 = T / 36525.0;
        S = 24110.5 + 8640184.813 * T0;
        S = S + 86636.6 * Z0 + 86400.0 * L5;
        S /= 86400.0;
        S -= SunRiseSet.Int(S);
        T0 = S * 360.0 * DR;
        double l = 0.779072 + 0.00273790931 * (T += Z0);
        G = 0.993126 + 0.0027377785 * T;
        l -= SunRiseSet.Int(l);
        G -= SunRiseSet.Int(G);
        double v = 0.39785 * SunRiseSet.Sin(l *= P2);
        v -= 0.01 * SunRiseSet.Sin(l - (G *= P2));
        v += 0.00333 * SunRiseSet.Sin(l + G);
        v -= 2.1E-4 * TT * SunRiseSet.Sin(l);
        double U = 1.0 - 0.03349 * SunRiseSet.Cos(G);
        U -= 1.4E-4 * SunRiseSet.Cos(2.0 * l);
        double w = -1.0E-4 - 0.04129 * SunRiseSet.Sin(2.0 * l);
        w += 0.03211 * SunRiseSet.Sin(G);
        w += 0.00104 * SunRiseSet.Sin(2.0 * l - G);
        w -= 3.5E-4 * SunRiseSet.Sin(2.0 * l + G);
        S = (w -= 8.0E-5 * TT * SunRiseSet.Sin(G)) / SunRiseSet.Sqr((U += 8.0E-5 * SunRiseSet.Cos(l)) - v * v);
        double A5 = l + SunRiseSet.Atn(S / SunRiseSet.Sqr(1.0 - S * S));
        S = v / SunRiseSet.Sqr(U);
        double D5 = SunRiseSet.Atn(S / SunRiseSet.Sqr(1.0 - S * S));
        double R5 = 1.00021 * SunRiseSet.Sqr(U);
        a[1] = A5;
        D[1] = D5;
        l = 0.779072 + 0.00273790931 * (T += 1.0);
        G = 0.993126 + 0.0027377785 * T;
        l -= SunRiseSet.Int(l);
        G -= SunRiseSet.Int(G);
        v = 0.39785 * SunRiseSet.Sin(l *= P2);
        v -= 0.01 * SunRiseSet.Sin(l - (G *= P2));
        v += 0.00333 * SunRiseSet.Sin(l + G);
        v -= 2.1E-4 * TT * SunRiseSet.Sin(l);
        U = 1.0 - 0.03349 * SunRiseSet.Cos(G);
        U -= 1.4E-4 * SunRiseSet.Cos(2.0 * l);
        w = -1.0E-4 - 0.04129 * SunRiseSet.Sin(2.0 * l);
        w += 0.03211 * SunRiseSet.Sin(G);
        w += 0.00104 * SunRiseSet.Sin(2.0 * l - G);
        w -= 3.5E-4 * SunRiseSet.Sin(2.0 * l + G);
        S = (w -= 8.0E-5 * TT * SunRiseSet.Sin(G)) / SunRiseSet.Sqr((U += 8.0E-5 * SunRiseSet.Cos(l)) - v * v);
        A5 = l + SunRiseSet.Atn(S / SunRiseSet.Sqr(1.0 - S * S));
        S = v / SunRiseSet.Sqr(U);
        D5 = SunRiseSet.Atn(S / SunRiseSet.Sqr(1.0 - S * S));
        R5 = 1.00021 * SunRiseSet.Sqr(U);
        a[2] = A5;
        D[2] = D5;
        if (a[2] < a[1]) {
            a[2] = a[2] + P2;
        }
        double Z1 = DR * 90.833;
        S = SunRiseSet.Sin(B5 * DR);
        double C = SunRiseSet.Cos(B5 * DR);
        double z = SunRiseSet.Cos(Z1);
        double M8 = 0.0;
        double W8 = 0.0;
        double A0 = a[1];
        double D0 = D[1];
        double Da = a[2] - a[1];
        double DD = D[2] - D[1];
        for (double C0 = 0.0; C0 <= 23.0; C0 += 1.0) {
            double V1;
            double B;
            double Dz;
            double P = (C0 + 1.0) / 24.0;
            double A2 = a[1] + P * Da;
            double D2 = D[1] + P * DD;
            double L0 = T0 + C0 * K1;
            double L2 = L0 + K1;
            double H0 = L0 - A0;
            double H2 = L2 - A2;
            double H1 = (H2 + H0) / 2.0;
            D1 = (D2 + D0) / 2.0;
            if (C0 <= 0.0) {
                V0 = S * SunRiseSet.Sin(D0) + C * SunRiseSet.Cos(D0) * SunRiseSet.Cos(H0) - z;
            }
            V2 = S * SunRiseSet.Sin(D2) + C * SunRiseSet.Cos(D2) * SunRiseSet.Cos(H2) - z;
            if (SunRiseSet.Sgn(V0) != SunRiseSet.Sgn(V2) && (Dz = (B = 4.0 * (V1 = S * SunRiseSet.Sin(D1) + C * SunRiseSet.Cos(D1) * SunRiseSet.Cos(H1) - z) - 3.0 * V0 - V2) * B - 4.0 * (Ax = 2.0 * V2 - 4.0 * V1 + 2.0 * V0) * V0) >= 0.0) {
                double E;
                Dz = SunRiseSet.Sqr(Dz);
                if (!(V0 < 0.0) || V2 > 0.0) {
                    // empty if block
                }
                if (V0 < 0.0 && V2 > 0.0) {
                    M8 = 1.0;
                }
                if (!(V0 > 0.0) || V2 < 0.0) {
                    // empty if block
                }
                if (V0 > 0.0 && V2 < 0.0) {
                    W8 = 1.0;
                }
                if ((E = (-B + Dz) / (2.0 * Ax)) > 1.0 || E < 0.0) {
                    E = (-B - Dz) / (2.0 * Ax);
                }
                double T3 = C0 + E + 0.0;
                double H3 = SunRiseSet.Int(T3);
                double M3 = SunRiseSet.Int((T3 - H3) * 60.0);
                events = SunRiseSet.addEventTime(events, T3);
            }
            A0 = A2;
            D0 = D2;
            V0 = V2;
        }
        if (M8 == 0.0 && W8 == 0.0) {
            if (V2 < 0.0) {
                events = SunRiseSet.addEventTime(events, -1.0);
            }
            if (V2 > 0.0) {
                events = SunRiseSet.addEventTime(events, -2.0);
            }
        } else {
            if (M8 == 0.0) {
                events = SunRiseSet.addEventTime(events, -3.0);
            }
            if (W8 == 0.0) {
                events = SunRiseSet.addEventTime(events, -4.0);
            }
        }
        return events;
    }

    public static double[] addEventTime(double[] darray, double tmval) {
        darray = (double[])SunRiseSet.arrayExpand(darray);
        darray[darray.length - 1] = tmval;
        return darray;
    }

    public static String Format(double x, String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(x);
    }

    public static double Sin(double x) {
        return Math.sin(x);
    }

    public static double Abs(double x) {
        return Math.abs(x);
    }

    public static double Atn(double x) {
        return Math.atan(x);
    }

    public static double Cos(double x) {
        return Math.cos(x);
    }

    public static double Int(double x) {
        return Math.floor(x);
    }

    public static double Sqr(double x) {
        return Math.sqrt(x);
    }

    public static double Round(double num, int dp) {
        return (double)Math.round(num * Math.pow(10.0, dp)) / Math.pow(10.0, dp);
    }

    public static double Arcsin(double X) {
        double arc = Math.atan(X / Math.sqrt(-X * X + 1.0));
        return arc;
    }

    public static double Sgn(double x) {
        if (x < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static Object arrayExpand(Object a) {
        Class<?> cl = a.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int length = Array.getLength(a);
        int newLength = length + 1;
        Class<?> componentType = a.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newLength);
        System.arraycopy(a, 0, newArray, 0, length);
        return newArray;
    }
}

