/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.Point2D;

public class Sun {
    public static double pi = 3.14159265358979;
    public static double tpi;
    public static double twopi;
    public static double Degs;
    public static double Rads;

    public static Point2D.Double getSunPosition(double y, double m, double day, double h, double mins, double glat, double glong) {
        glat *= Rads;
        glong *= Rads;
        double D = Sun.FNday(y, m, day, h += mins / 60.0);
        double lambda = Sun.FNsun(D);
        double obliq = 23.439 * Rads - 4.0E-7 * Rads * D;
        double alpha = Sun.FNatn2(Math.cos(obliq) * Math.sin(lambda), Math.cos(lambda));
        double delta = Sun.FNasin(Math.sin(obliq) * Math.sin(lambda));
        double G = Sun.FNrange(357.528 * Rads + 0.9856003 * Rads * D);
        double r = 1.00014 - 0.01671 * Math.cos(G) - 1.4E-4 * Math.cos(2.0 * G);
        double L = 0.0;
        double equation = (L - alpha) * Degs * 4.0;
        double LMST = Sun.FNrange((280.46061837 + 360.98564736629 * D) * Rads + glong);
        double hasun = Sun.FNrange(LMST - alpha);
        double sinalt = Math.sin(delta) * Math.sin(glat) + Math.cos(delta) * Math.cos(glat) * Math.cos(hasun);
        double altsun = Sun.FNasin(sinalt);
        double yy = -Math.cos(delta) * Math.cos(glat) * Math.sin(hasun);
        double xx = Math.sin(delta) - Math.sin(glat) * sinalt;
        double AzSun = Sun.FNatn2(yy, xx);
        double sunlat = delta * Degs;
        double lon = hasun * Degs;
        double sunlon = 0.0;
        sunlon = lon > 180.0 ? 360.0 - lon : 180.0 - (lon + 180.0);
        return new Point2D.Double(sunlon, sunlat);
    }

    private static double FNday(double y, double m, double d, double h) {
        double b;
        double greg = y * 10000.0 + m * 100.0 + d;
        if (m == 1.0 || m == 2.0) {
            y -= 1.0;
            m += 12.0;
        }
        if (greg > 1.5821004E7) {
            double a = Math.floor(y / 100.0);
            b = 2.0 - a + Math.floor(a / 4.0);
        } else {
            b = 0.0;
        }
        double c = Math.floor(365.25 * y);
        double d1 = Math.floor(30.6001 * (m + 1.0));
        return b + c + d1 - 730550.5 + d + h / 24.0;
    }

    private static double FNacos(double x) {
        double S = Math.sqrt(1.0 - x * x);
        return Math.atan(S / x);
    }

    private static double FNasin(double x) {
        double C = Math.sqrt(1.0 - x * x);
        return Math.atan(x / C);
    }

    private static double FNatn2(double y, double x) {
        double A = Math.atan(y / x);
        if (x < 0.0) {
            A += pi;
        }
        if (y < 0.0 && x > 0.0) {
            A += tpi;
        }
        return A;
    }

    private static double FNipart(double x) {
        if (x < 0.0) {
            return -1.0 * Math.floor(Math.abs(x));
        }
        return 1.0 * Math.floor(Math.abs(x));
    }

    private static double FNrange(double x) {
        double B = x / tpi;
        double A = tpi * (B - Sun.FNipart(B));
        if (A < 0.0) {
            A = tpi + A;
        }
        return A;
    }

    private static double FNsun(double D) {
        double L = Sun.FNrange(280.461 * Rads + 0.9856474 * Rads * D);
        double G = Sun.FNrange(357.528 * Rads + 0.9856003 * Rads * D);
        return Sun.FNrange(L + 1.915 * Rads * Math.sin(G) + 0.02 * Rads * Math.sin(2.0 * G));
    }

    public static double dayLengthAtLatitude(double L, double J) {
        double D2;
        double P = Sun.asin(0.39795 * Sun.cos(0.2163108 + 2.0 * Sun.atan(0.9671396 * Sun.tan(0.0086 * (J - 186.0)))));
        double D1 = Sun.sin(0.004654269516293279) + Sun.sin(L * Math.PI / 180.0) * Sun.sin(P);
        double D = 24.0 - 7.639437268410976 * Sun.acos(D1 / (D2 = Sun.cos(L * Math.PI / 180.0) * Sun.cos(P)));
        if (Double.isNaN(D)) {
            D = 0.0;
        }
        return D;
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double tan(double x) {
        return Math.tan(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static double atan(double x) {
        return Math.atan(x);
    }

    static {
        twopi = tpi = 2.0 * pi;
        Degs = 180.0 / pi;
        Rads = pi / 180.0;
    }
}

